/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.jsfext.layout;

import com.sun.enterprise.tools.jsfext.component.ComponentUtil;
import com.sun.enterprise.tools.jsfext.layout.LayoutDefinitionManager;
import com.sun.enterprise.tools.jsfext.layout.descriptor.LayoutComponent;
import com.sun.enterprise.tools.jsfext.layout.descriptor.LayoutDefinition;
import com.sun.enterprise.tools.jsfext.layout.descriptor.LayoutElement;
import com.sun.enterprise.tools.jsfext.util.LogUtil;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;

public class LayoutViewRoot
extends UIViewRoot {
    private String _ldmKey = null;
    private transient LayoutDefinition _layoutDefinition = null;

    public void processDecodes(FacesContext context) {
        ExternalContext extCtx = context.getExternalContext();
        String targetId = (String)extCtx.getRequestParameterMap().get("lavaChannel");
        if (targetId != null && !targetId.equals("")) {
            UIComponent target = this.findComponent(":" + targetId);
            if (target == null) {
                LayoutDefinition def = this.getLayoutDefinition(context);
                if (def != null) {
                    def.decode(context, (UIComponent)this);
                }
                super.processDecodes(context);
                return;
            }
            extCtx.getRequestMap().put("_lavaChannelTarget", target);
            target.processDecodes(context);
            this.processApplication(context);
            context.renderResponse();
        } else {
            LayoutDefinition def = this.getLayoutDefinition(context);
            if (def != null) {
                def.decode(context, (UIComponent)this);
            }
            super.processDecodes(context);
        }
    }

    public UIComponent getChild(FacesContext context, String id) {
        if (id == null || id.trim().equals("")) {
            return null;
        }
        UIComponent childComponent = ComponentUtil.findChild((UIComponent)this, id, id);
        if (childComponent != null) {
            return childComponent;
        }
        LayoutDefinition ld = this.getLayoutDefinition(context);
        if (ld == null) {
            return null;
        }
        LayoutElement elt = LayoutDefinition.getChildLayoutElementById(context, id, ld, (UIComponent)this);
        return this.getChild(context, (LayoutComponent)elt);
    }

    public UIComponent getChild(FacesContext context, LayoutComponent descriptor) {
        UIComponent childComponent = null;
        if (descriptor == null) {
            throw new IllegalArgumentException("The LayoutComponent is null!");
        }
        String id = descriptor.getId(context, (UIComponent)this);
        if (id != null && !id.trim().equals("") && (childComponent = ComponentUtil.findChild((UIComponent)this, id, id)) != null) {
            return childComponent;
        }
        descriptor.beforeCreate(context, (UIComponent)this);
        childComponent = ComponentUtil.createChildComponent(context, descriptor, (UIComponent)this);
        descriptor.afterCreate(context, childComponent);
        return childComponent;
    }

    public LayoutDefinition getLayoutDefinition(FacesContext context) {
        block4: {
            if (this._layoutDefinition != null) {
                return this._layoutDefinition;
            }
            String key = this.getLayoutDefinitionKey();
            if (key == null) {
                return null;
            }
            LayoutDefinitionManager ldm = LayoutDefinitionManager.getManager(context);
            try {
                this._layoutDefinition = ldm.getLayoutDefinition(key);
            }
            catch (IOException ex) {
                if (!LogUtil.configEnabled((Object)this)) break block4;
                LogUtil.config("Unable to get LayoutDefinition for '" + key + "'.");
            }
        }
        return this._layoutDefinition;
    }

    public String getLayoutDefinitionKey() {
        return this._ldmKey;
    }

    public void setLayoutDefinitionKey(String key) {
        this._ldmKey = key;
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this._ldmKey};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this._ldmKey = (String)values[1];
    }
}

