/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.common;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.sun.web.ui.common.CCDebug;
import com.sun.web.ui.common.CCI18NFileIO;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.servlet.Servlet;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.jsp.PageContext;

public class CCI18N {
    public static final String TAGS_BUNDLE_ID = "com.sun.web.ui";
    public static final String TAGS_BUNDLE = "com.sun.web.ui.resources.Resources";
    public static final String BUNDLE_REQUEST_KEY_PREFIX = "com.sun.web.ui.common.CCI18N.Bundle:";
    public static final String BASE_REQUEST_KEY_PREFIX = "com.sun.web.ui.common.CCI18N.Base:";
    public static final String ISO_ENCODING = "ISO-8859-1";
    public static final String UTF8_ENCODING = "UTF-8";
    protected ResourceBundle bundle = null;
    protected String bundleID = null;
    protected ServletRequest request = null;
    public static final String LOCALE_SESSION_KEY_PREFIX = "com.sun.web.ui.common.CCI18N.Locale:";

    public CCI18N(ServletRequest request, String bundleID) {
        if (request == null) {
            throw new IllegalArgumentException("request cannot be null.");
        }
        this.request = request;
        this.bundleID = bundleID;
    }

    public CCI18N(ServletRequest request, ServletResponse response, String baseName, String bundleID, Locale locale) {
        this(request, response, baseName, bundleID, locale, null);
    }

    public CCI18N(ServletRequest request, ServletResponse response, String baseName, String bundleID, Locale locale, ClassLoader classLoader) {
        this(request, bundleID);
        if (bundleID != null) {
            CCI18N.setResourceBundle(request, response, baseName, bundleID, locale, classLoader);
        } else {
            CCI18N.initContentType(request, response);
            this.setResourceBundle(CCI18N.findResourceBundle(request, baseName, locale != null ? locale : CCI18N.getTagsLocale(request), classLoader));
        }
    }

    public String getBaseName(ServletRequest request, String bundleID) {
        if (request == null) {
            throw new IllegalArgumentException("request cannot be null.");
        }
        if (bundleID == null) {
            throw new IllegalArgumentException("bundleID cannot be null.");
        }
        return (String)request.getAttribute(BASE_REQUEST_KEY_PREFIX + bundleID);
    }

    public String getMessage(String key) {
        if (key == null) {
            return null;
        }
        ResourceBundle bundle = this.getResourceBundle();
        try {
            if (bundle == null) {
                bundle = CCI18N.getResourceBundle(this.request, this.bundleID);
            }
            key = bundle.getString(key);
        }
        catch (MissingResourceException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return key;
    }

    public String getMessage(String key, Object[] args) {
        if (key == null) {
            return null;
        }
        if (args == null) {
            return this.getMessage(key);
        }
        String pattern = this.getMessage(key);
        MessageFormat mf = new MessageFormat(pattern);
        Object[] mfArgs = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            mfArgs[i] = this.getMessage(args[i].toString());
        }
        try {
            key = mf.format(mfArgs);
        }
        catch (NullPointerException e) {
            CCDebug.trace3("Unmatched message args in pattern: " + pattern);
        }
        return key;
    }

    public Locale getLocale() {
        return this.bundle != null ? this.bundle.getLocale() : null;
    }

    public ResourceBundle getResourceBundle() {
        return this.bundle;
    }

    public static ResourceBundle getResourceBundle(ServletRequest request, String bundleID) {
        if (request == null) {
            throw new IllegalArgumentException("pageContext cannot be null.");
        }
        if (bundleID == null) {
            throw new IllegalArgumentException("bundleID cannot be null.");
        }
        return (ResourceBundle)request.getAttribute(BUNDLE_REQUEST_KEY_PREFIX + bundleID);
    }

    public void setResourceBundle(ResourceBundle bundle) {
        this.bundle = bundle;
    }

    public static void setResourceBundle(ServletRequest request, ResourceBundle bundle, String bundleID) {
        if (request == null) {
            throw new IllegalArgumentException("request cannot be null.");
        }
        if (bundleID == null) {
            throw new IllegalArgumentException("bundleID cannot be null.");
        }
        request.setAttribute(BUNDLE_REQUEST_KEY_PREFIX + bundleID, (Object)bundle);
    }

    public static boolean setResourceBundle(ServletRequest request, ServletResponse response, String baseName, String bundleID, Locale locale) {
        return CCI18N.setResourceBundle(request, response, baseName, bundleID, locale, null);
    }

    public static boolean setResourceBundle(ServletRequest request, ServletResponse response, String baseName, String bundleID, Locale locale, ClassLoader classLoader) {
        CCI18N.initContentType(request, response);
        ResourceBundle bundle = CCI18N.findResourceBundle(request, baseName, locale != null ? locale : CCI18N.getTagsLocale(request), classLoader);
        if (bundle == null) {
            CCDebug.trace3("The resource bundle could not be found.");
            return false;
        }
        CCI18N.setResourceBundle(request, bundle, bundleID);
        CCI18N.setBaseName(request, baseName, bundleID);
        return true;
    }

    private static ResourceBundle findResourceBundle(ServletRequest request, String baseName, Locale locale, ClassLoader classLoader) {
        Locale l;
        if (request == null) {
            throw new IllegalArgumentException("request cannot be null.");
        }
        ResourceBundle bundle = null;
        ArrayList<Object> locales = new ArrayList<Locale>();
        if (locale != null) {
            locales.add(locale);
        } else {
            locales = Collections.list(request.getLocales());
        }
        for (int i = 0; i < locales.size() && (!(l = (Locale)locales.get(i)).getLanguage().equals(Locale.ENGLISH.getLanguage()) || !l.getCountry().equals(Locale.US.getCountry()) && l.getCountry().length() != 0); ++i) {
            bundle = CCI18N.loadResourceBundle(request, baseName, l, classLoader);
            if (bundle == null) continue;
            if (bundle.getLocale() == null || bundle.getLocale().getLanguage().length() > 0) break;
            CCDebug.trace3("Locale not available: " + l);
        }
        if (bundle == null || bundle.getLocale() == null || bundle.getLocale().getLanguage().length() == 0) {
            bundle = CCI18N.loadResourceBundle(request, baseName, new Locale(""), classLoader);
        }
        return bundle;
    }

    private static ResourceBundle loadResourceBundle(ServletRequest request, String baseName, Locale locale, ClassLoader classLoader) {
        if (baseName == null) {
            throw new IllegalArgumentException("baseName cannot be null.");
        }
        ResourceBundle bundle = null;
        try {
            ClassLoader cl;
            ClassLoader classLoader2 = cl = classLoader != null ? classLoader : CCI18N.getClassLoader();
            bundle = cl != null ? ResourceBundle.getBundle(baseName, locale, cl) : ResourceBundle.getBundle(baseName, locale);
        }
        catch (MissingResourceException e) {
            try {
                bundle = ResourceBundle.getBundle(baseName);
            }
            catch (MissingResourceException ex) {
                // empty catch block
            }
        }
        return bundle;
    }

    private static ClassLoader getClassLoader() {
        Servlet o = RequestManager.getHandlingServlet();
        return o != null ? o.getClass().getClassLoader() : null;
    }

    private static void setBaseName(ServletRequest request, String baseName, String bundleID) {
        request.setAttribute(BASE_REQUEST_KEY_PREFIX + bundleID, (Object)baseName);
    }

    public static void initContentType(ServletRequest request, ServletResponse response) {
        CCI18N.setContentType(response, CCI18N.getTagsLocale(request));
    }

    public static void setTagsLocale(ServletRequest request, Locale locale) {
        ResourceBundle bundle = CCI18N.findResourceBundle(request, TAGS_BUNDLE, locale, null);
        CCI18N.setResourceBundle(request, bundle, TAGS_BUNDLE_ID);
    }

    public static Locale getTagsLocale(ServletRequest request) {
        Locale locale;
        ResourceBundle bundle = CCI18N.getResourceBundle(request, TAGS_BUNDLE_ID);
        if (bundle == null) {
            bundle = CCI18N.findResourceBundle(request, TAGS_BUNDLE, null, null);
            CCI18N.setResourceBundle(request, bundle, TAGS_BUNDLE_ID);
        }
        Locale locale2 = locale = bundle != null ? bundle.getLocale() : null;
        if (locale == null || locale.getLanguage().length() == 0) {
            locale = Locale.ENGLISH;
        }
        return locale;
    }

    private static void setContentType(ServletResponse response, Locale locale) {
        if (response == null) {
            throw new IllegalArgumentException("response cannot be null.");
        }
        if (!response.getLocale().equals(locale)) {
            response.setLocale(locale);
        }
        response.setContentType("text/html; charset=UTF-8");
    }

    public CCI18N(PageContext pageContext, String bundleID) {
        this(pageContext.getRequest(), bundleID);
    }

    public CCI18N(PageContext pageContext, String baseName, String bundleID, Locale locale) {
        this(pageContext.getRequest(), pageContext.getResponse(), baseName, bundleID, locale);
    }

    public CCI18N(PageContext pageContext, String baseName, String bundleID, Locale locale, String appRoot, String jarName) {
        this(pageContext.getRequest(), pageContext.getResponse(), baseName, bundleID, locale, appRoot, jarName);
    }

    public CCI18N(RequestContext requestContext, String baseName) {
        this((ServletRequest)requestContext.getRequest(), (ServletResponse)requestContext.getResponse(), baseName, null, null);
    }

    public CCI18N(RequestContext requestContext, String baseName, String appRoot, String jarName) {
        this((ServletRequest)requestContext.getRequest(), (ServletResponse)requestContext.getResponse(), baseName, null, null, appRoot, jarName);
    }

    public CCI18N(ServletRequest request, ServletResponse response, String baseName, String bundleID, Locale locale, String appRoot, String jarName) {
        this(request, bundleID);
        CCI18NFileIO i18n = new CCI18NFileIO(request, response, baseName, bundleID, locale, appRoot, jarName);
        this.setResourceBundle(i18n.getResourceBundle());
    }

    public static Locale getLocale(PageContext pageContext, String baseName) {
        if (pageContext == null) {
            throw new IllegalArgumentException("pageContext cannot be null.");
        }
        if (baseName == null) {
            throw new IllegalArgumentException("baseName cannot be null.");
        }
        return (Locale)pageContext.getRequest().getAttribute(LOCALE_SESSION_KEY_PREFIX + baseName);
    }

    public static void setLocale(PageContext pageContext, String baseName, Locale locale) {
        if (pageContext == null) {
            throw new IllegalArgumentException("pageContext cannot be null.");
        }
        if (baseName == null) {
            throw new IllegalArgumentException("baseName cannot be null.");
        }
        pageContext.getRequest().setAttribute(LOCALE_SESSION_KEY_PREFIX + baseName, (Object)locale);
    }

    public String getBaseName(PageContext pageContext, String bundleID) {
        return this.getBaseName(pageContext.getRequest(), bundleID);
    }

    public static ResourceBundle getResourceBundle(PageContext pageContext, String bundleID) {
        if (pageContext == null) {
            throw new IllegalArgumentException("pageContext cannot be null.");
        }
        return CCI18N.getResourceBundle(pageContext.getRequest(), bundleID);
    }

    public static void setResourceBundle(PageContext pageContext, ResourceBundle bundle, String bundleID) {
        if (pageContext == null) {
            throw new IllegalArgumentException("pageContext cannot be null.");
        }
        CCI18N.setResourceBundle(pageContext.getRequest(), bundle, bundleID);
    }

    public static boolean setResourceBundle(PageContext pageContext, String baseName, String bundleID, Locale locale) {
        return CCI18N.setResourceBundle(pageContext, baseName, bundleID, locale, null, null);
    }

    public static boolean setResourceBundle(PageContext pageContext, String baseName, String bundleID, Locale locale, String appRoot, String jarName) {
        if (pageContext == null) {
            throw new IllegalArgumentException("pageContext cannot be null.");
        }
        return CCI18N.setResourceBundle(pageContext.getRequest(), pageContext.getResponse(), baseName, bundleID, locale, appRoot, jarName);
    }

    public static boolean setResourceBundle(ServletRequest request, ServletResponse response, String baseName, String bundleID, Locale locale, String appRoot, String jarName) {
        return CCI18NFileIO.setResourceBundle(request, response, baseName, bundleID, locale, appRoot, jarName);
    }

    public static void setContentType(Locale locale, PageContext pageContext, RequestContext requestContext) {
        try {
            ServletResponse response = pageContext != null ? pageContext.getResponse() : requestContext.getResponse();
            CCI18N.setContentType(response, locale);
        }
        catch (NullPointerException e) {
            CCDebug.trace3("Cannot obtain ServletResponse object" + e.getMessage());
        }
    }

    public static String getUTF8String(String s) {
        if (s == null) {
            return null;
        }
        String utf8String = s;
        try {
            byte[] bytes = utf8String.getBytes(ISO_ENCODING);
            utf8String = new String(bytes, UTF8_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            utf8String = s;
        }
        return utf8String;
    }
}

