/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.model;

import com.sun.web.ui.common.CCDebug;
import com.sun.web.ui.common.CCSystem;
import com.sun.web.ui.model.CCTopologyModelInterface;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.servlet.ServletContext;

public class CCTopologyIconSet
implements CCTopologyModelInterface.IconSet {
    private final Object context;
    private final Map icons = new HashMap();

    public CCTopologyIconSet() {
        this.icons.put(new Integer(0), null);
        this.context = null;
    }

    public CCTopologyIconSet(Class context) {
        this.icons.put(new Integer(0), null);
        if (context == null) {
            throw new IllegalArgumentException("context == null");
        }
        this.context = context;
    }

    public CCTopologyIconSet(ServletContext context) {
        this.icons.put(new Integer(0), null);
        if (context == null) {
            throw new IllegalArgumentException("context == null");
        }
        this.context = context;
    }

    public final void addIcon(int icon, String location) {
        if (icon == 0) {
            throw new IllegalArgumentException("icon == NONE (0)");
        }
        this.icons.put(new Integer(icon), location);
    }

    public final void validateImage(int icon) throws IOException, NoClassDefFoundError {
        if (!this.isValid(icon)) {
            throw new IllegalArgumentException("Invalid icon");
        }
        if (icon != 0 && this.getImage(icon) == null) {
            String location = (String)this.icons.get(new Integer(icon));
            if (location == null) {
                return;
            }
            if (this.context == null) {
                ImageLoader.getImage(location);
            } else if (this.context instanceof Class) {
                ImageLoader.getImage((Class)this.context, location);
            } else {
                ImageLoader.getImage((ServletContext)this.context, location);
            }
        }
    }

    public final void clearImageCache() {
        if (this.context == null) {
            ImageLoader.flushCachedImages();
        } else if (this.context instanceof Class) {
            ImageLoader.flushCachedImages((Class)this.context);
        } else {
            ImageLoader.flushCachedImages((ServletContext)this.context);
            ImageLoader.flushCachedImages();
        }
    }

    public void finalize() {
        this.clearImageCache();
    }

    public final int[] getValidIds() {
        Integer[] keys = this.icons.keySet().toArray(new Integer[0]);
        int[] ids = new int[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            ids[i] = keys[i];
        }
        return ids;
    }

    public final boolean isValid(int icon) {
        return this.icons.containsKey(new Integer(icon));
    }

    public Image getImage(int icon) {
        String location = (String)this.icons.get(new Integer(icon));
        return location == null ? null : (this.context == null ? ImageLoader.getCachedImage(location) : (this.context instanceof Class ? ImageLoader.getCachedImage((Class)this.context, location) : ImageLoader.getCachedImage((ServletContext)this.context, location)));
    }

    public static final class ImageLoader {
        private static final String NULL_IMAGE = "0";
        private static final Map staticCache = new HashMap();

        private ImageLoader() {
        }

        public static Image getCachedImage(String imageURL) {
            Image image;
            String key;
            block7: {
                if (imageURL == null) {
                    return null;
                }
                key = ImageLoader.getKey("URL", imageURL);
                Object cachedImage = staticCache.get(key);
                if (cachedImage instanceof Image) {
                    return (Image)cachedImage;
                }
                if (NULL_IMAGE.equals(cachedImage)) {
                    return null;
                }
                image = null;
                try {
                    image = ImageLoader.getImage(imageURL);
                }
                catch (NoClassDefFoundError ncdfe) {
                    if (CCDebug.isOn()) {
                        CCDebug.trace1("could not load image from URL: " + imageURL, ncdfe);
                    }
                }
                catch (IOException ioe) {
                    if (!CCDebug.isOn()) break block7;
                    CCDebug.trace1("could not load image from URL: " + imageURL, ioe);
                }
            }
            staticCache.put(key, image != null ? image : NULL_IMAGE);
            return image;
        }

        public static Image getCachedImage(Class clazz, String location) {
            Image image;
            String key;
            block7: {
                if (clazz == null || location == null) {
                    return null;
                }
                key = ImageLoader.getKey(clazz.getName(), location);
                Object cachedImage = staticCache.get(key);
                if (cachedImage instanceof Image) {
                    return (Image)cachedImage;
                }
                if (NULL_IMAGE.equals(cachedImage)) {
                    return null;
                }
                image = null;
                try {
                    image = ImageLoader.getImage(clazz, location);
                }
                catch (NoClassDefFoundError ncdfe) {
                    if (CCDebug.isOn()) {
                        CCDebug.trace1("could not load image from class resources: " + clazz.getName() + ": " + location, ncdfe);
                    }
                }
                catch (IOException ioe) {
                    if (!CCDebug.isOn()) break block7;
                    CCDebug.trace1("could not load image from class resources: " + clazz.getName() + ": " + location, ioe);
                }
            }
            staticCache.put(key, image != null ? image : NULL_IMAGE);
            return image;
        }

        public static Image getCachedImage(ServletContext context, String location) {
            Image image;
            String key;
            block8: {
                if (context == null || location == null) {
                    return null;
                }
                key = ImageLoader.getKey("com.sun.web.ui.model.CCTopologyIconSet.ImageLoader", location);
                Object cachedImage = context.getAttribute(key);
                if (cachedImage instanceof Image) {
                    return (Image)cachedImage;
                }
                if (NULL_IMAGE.equals(cachedImage)) {
                    return null;
                }
                image = CCSystem.getResourceImage(location);
                if (image != null) {
                    return image;
                }
                try {
                    image = ImageLoader.getImage(context, location);
                }
                catch (NoClassDefFoundError ncdfe) {
                    if (CCDebug.isOn()) {
                        CCDebug.trace1("could not load image from ServletContext resources: " + location, ncdfe);
                    }
                }
                catch (IOException ioe) {
                    if (!CCDebug.isOn()) break block8;
                    CCDebug.trace1("could not load image from ServletContext resources: " + location, ioe);
                }
            }
            context.setAttribute(key, image != null ? image : NULL_IMAGE);
            return image;
        }

        private static String getKey(String className, String location) {
            return className + '|' + location;
        }

        public static void flushCachedImages() {
            ImageLoader.flushCachedImages((Class)null);
        }

        public static void flushCachedImages(Class clazz) {
            String key = clazz == null ? null : ImageLoader.getKey(clazz.getName(), "");
            Iterator keyIter = staticCache.keySet().iterator();
            while (keyIter.hasNext()) {
                String aKey = (String)keyIter.next();
                if (key != null && !aKey.startsWith(key)) continue;
                Object cachedImage = staticCache.get(aKey);
                if (cachedImage instanceof Image) {
                    ((Image)cachedImage).flush();
                }
                keyIter.remove();
            }
        }

        public static void flushCachedImages(ServletContext context) {
            if (context == null) {
                return;
            }
            String key = ImageLoader.getKey("com.sun.web.ui.model.CCTopologyIconSet.ImageLoader", "");
            ArrayList<String> ripKeys = new ArrayList<String>();
            Enumeration attrEnum = context.getAttributeNames();
            while (attrEnum.hasMoreElements()) {
                String aKey = (String)attrEnum.nextElement();
                if (!aKey.startsWith(key)) continue;
                ripKeys.add(aKey);
            }
            Iterator keyIter = ripKeys.iterator();
            while (keyIter.hasNext()) {
                String aKey = (String)keyIter.next();
                Object cachedImage = context.getAttribute(aKey);
                if (cachedImage instanceof Image) {
                    ((Image)cachedImage).flush();
                }
                context.removeAttribute(aKey);
            }
        }

        public static Image getImage(String imageURL) throws IOException, NoClassDefFoundError {
            if (imageURL == null) {
                return null;
            }
            return ImageIO.read(new URL(imageURL));
        }

        public static Image getImage(Class clazz, String location) throws IOException, NoClassDefFoundError {
            if (clazz == null || location == null) {
                return null;
            }
            InputStream imageStream = null;
            try {
                imageStream = clazz.getResourceAsStream(location);
                if (imageStream != null) {
                    BufferedImage bufferedImage = ImageIO.read(imageStream);
                    return bufferedImage;
                }
                throw new IOException("Resource not found: " + clazz.getName() + ": " + location);
            }
            finally {
                if (imageStream != null) {
                    imageStream.close();
                }
            }
        }

        public static Image getImage(ServletContext context, String location) throws IOException, NoClassDefFoundError {
            if (context == null || location == null) {
                return null;
            }
            InputStream imageStream = null;
            try {
                imageStream = context.getResourceAsStream(location);
                if (imageStream != null) {
                    BufferedImage bufferedImage = ImageIO.read(imageStream);
                    return bufferedImage;
                }
                throw new IOException("Resource not found: ServletContext: " + location);
            }
            finally {
                if (imageStream != null) {
                    imageStream.close();
                }
            }
        }

        public static Image getImage(byte[] bytes) throws IOException, NoClassDefFoundError {
            if (bytes == null) {
                return null;
            }
            ByteArrayInputStream imageStream = null;
            try {
                imageStream = new ByteArrayInputStream(bytes);
                if (imageStream != null) {
                    BufferedImage bufferedImage = ImageIO.read(imageStream);
                    return bufferedImage;
                }
                throw new IOException("Image byte[] not valid");
            }
            finally {
                if (imageStream != null) {
                    ((InputStream)imageStream).close();
                }
            }
        }
    }
}

