/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.servlet.help2;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBeanBase;
import com.iplanet.jato.view.event.ChildContentDisplayEvent;
import com.iplanet.jato.view.event.ChildDisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.web.ui.common.CCClientSniffer;
import com.sun.web.ui.common.CCDebug;
import com.sun.web.ui.common.CCImage;
import com.sun.web.ui.common.CCStateData;
import com.sun.web.ui.common.CCSystem;
import com.sun.web.ui.model.CCNavNode;
import com.sun.web.ui.model.CCNavNodeInterface;
import com.sun.web.ui.model.CCTabsModel;
import com.sun.web.ui.model.CCTreeModel;
import com.sun.web.ui.servlet.help2.Help2Utils;
import com.sun.web.ui.servlet.help2.SearchResultsTiledView;
import com.sun.web.ui.view.html.CCButton;
import com.sun.web.ui.view.html.CCHiddenField;
import com.sun.web.ui.view.html.CCHref;
import com.sun.web.ui.view.html.CCStaticTextField;
import com.sun.web.ui.view.html.CCTextField;
import com.sun.web.ui.view.tabs.CCNodeEventHandlerInterface;
import com.sun.web.ui.view.tabs.CCTabs;
import com.sun.web.ui.view.tree.CCClientSideTree;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.help.ServletHelpBroker;
import javax.help.TreeItem;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class NavigatorViewBean
extends ViewBeanBase
implements CCNodeEventHandlerInterface,
CCStateData {
    public static final String PAGE_NAME = "Navigator";
    public static final String DEFAULT_DISPLAY_URL = CCSystem.getURLPrefix() + "/jsp/help2/Navigator.jsp";
    public static final String CHILD_BROWSERTYPE = "BrowserType";
    public static final String CHILD_INDEXTREE = "IndexTree";
    public static final String CHILD_SEARCHBUTTON = "SearchButton";
    public static final String CHILD_SEARCHFIELD = "SearchField";
    public static final String CHILD_TABS = "Tabs";
    public static final String CHILD_TIPSHREF = "TipsHref";
    public static final String CHILD_TIPSTEXT = "TipsText";
    public static final String CHILD_TOCTREE = "TOCTree";
    public static final String CHILD_SEARCHRESULTSTILEDVIEW = "SearchResultsTiledView";
    private static final String SUN_NAV4_CLIENT = "sunnav4";
    public static final String TOC_VIEW_NAME = "TOC";
    public static final String INDEX_VIEW_NAME = "Index";
    public static final String SEARCH_VIEW_NAME = "Search";
    public static final int TOC_TAB_INDEX = 1;
    public static final int INDEX_TAB_INDEX = 2;
    public static final int SEARCH_TAB_INDEX = 3;
    private CCTabsModel tabsModel = null;
    private boolean showTOC = true;
    private boolean showIndex = false;
    private boolean showSearch = false;
    private boolean showSearchResults = false;
    private ServletHelpBroker helpBroker = null;
    private String id = null;
    private boolean merge = true;
    private String loadURL;
    private int loadID = 0;
    private String appName = null;
    private String pathPrefix = null;
    private String helpFile = null;
    private String searchFieldValue = null;
    private boolean searchButtonClicked = false;
    private String hsPath = null;
    private final String STATE_DATA = this.getQualifiedName() + ".stateData";
    private static final String SEARCH_FIELD_VALUE = "SearchFieldValue";
    private Help2Utils utils = null;

    public NavigatorViewBean(RequestContext requestContext) {
        super(PAGE_NAME);
        this.setRequestContext(requestContext);
        this.setDefaultDisplayURL(DEFAULT_DISPLAY_URL);
        this.deserializePageAttributes();
        RequestContext reqContext = RequestManager.getRequestContext();
        HttpServletRequest request = reqContext.getRequest();
        this.appName = request.getParameter("appName");
        if (this.appName == null) {
            this.appName = (String)this.getPageSessionAttribute("appName");
            if (this.appName != null) {
                this.setPageSessionAttribute("appName", (Serializable)((Object)this.appName));
            }
        } else {
            this.setPageSessionAttribute("appName", (Serializable)((Object)this.appName));
        }
        this.pathPrefix = request.getParameter("pathPrefix");
        if (this.pathPrefix == null) {
            this.pathPrefix = (String)this.getPageSessionAttribute("pathPrefix");
            if (this.pathPrefix != null) {
                this.setPageSessionAttribute("pathPrefix", (Serializable)((Object)this.pathPrefix));
            }
        } else {
            this.setPageSessionAttribute("pathPrefix", (Serializable)((Object)this.pathPrefix));
        }
        if (this.appName == null || this.appName.trim().equals("")) {
            this.appName = request.getContextPath();
            if (this.appName == null) {
                CCDebug.trace1("Unable to obtain app name from request.");
                this.appName = "";
            } else if (this.appName.startsWith("/")) {
                this.appName = this.appName.substring(1);
            }
        }
        this.helpFile = request.getParameter("helpFile");
        this.utils = new Help2Utils(reqContext.getRequest(), this.appName, this.pathPrefix);
        this.createTabsModel();
        this.registerChildren();
    }

    private void createTabsModel() {
        CCNavNode contentTab = new CCNavNode(1, "help2.contentsTab", "help2.contentsTabTooltip", "help2.contentsTabStatus");
        CCNavNode indexTab = new CCNavNode(2, "help2.indexTab", "help2.indexTabTooltip", "help2.indexTabStatus");
        CCNavNode searchTab = new CCNavNode(3, "help2.searchTab", "help2.searchTabTooltip", "help2.searchTabStatus");
        this.tabsModel = new CCTabsModel();
        this.tabsModel.addNode(contentTab);
        this.tabsModel.addNode(indexTab);
        this.tabsModel.addNode(searchTab);
        this.tabsModel.setSelectedNode(1);
    }

    private CCTreeModel createTreeModel(String treeName, HttpServletRequest request, ArrayList treeList) {
        if (treeList == null) {
            CCDebug.trace3("treeList is null");
            return null;
        }
        if (treeName.equals(CHILD_TOCTREE)) {
            this.setLoadURL(request);
        }
        CCTreeModel treeModel = new CCTreeModel();
        treeModel.setSpacerWidth("10");
        int id = -1;
        HashMap<String, String> nodeIDMap = new HashMap<String, String>();
        int nTreeNodes = treeList.size();
        for (int i = 0; i < nTreeNodes; ++i) {
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)treeList.get(i);
            if (treeNode == null) {
                CCDebug.trace3("treeNode is null.");
                continue;
            }
            TreeItem item = (TreeItem)treeNode.getUserObject();
            if (item == null) {
                CCDebug.trace3("item is null.");
                continue;
            }
            String nodeID = this.utils.getID(treeNode);
            nodeIDMap.put(nodeID, Integer.toString(++id));
            TreeNode parentTreeNode = treeNode.getParent();
            String parentID = this.utils.getID(parentTreeNode);
            int pid = -1;
            try {
                pid = Integer.valueOf((String)nodeIDMap.get(parentID));
            }
            catch (NumberFormatException nfex) {
                CCDebug.trace3("Could not obtain parent ID for child node " + item.getName());
            }
            String label = item.getName();
            CCNavNode navNode = new CCNavNode(id, label, label, null, false);
            navNode.setValue(this.utils.getExternalContentURL(item, request));
            navNode.setImage(CCImage.DOT);
            navNode.setImageWidth(1);
            CCNavNodeInterface parentNavNode = treeModel.getNodeById(pid);
            if (parentNavNode != null) {
                parentNavNode.setAcceptsChildren(true);
                parentNavNode.addChild(navNode);
                parentNavNode.setExpanded(true);
                if (treeName.equals(CHILD_INDEXTREE)) {
                    ((CCNavNode)parentNavNode).setNotClickable(true);
                }
            } else {
                treeModel.addNode(navNode);
            }
            if (!treeName.equals(CHILD_TOCTREE) || this.loadURL == null || !navNode.getValue().equals(this.loadURL)) continue;
            this.loadID = id;
        }
        return treeModel;
    }

    private void setLoadURL(HttpServletRequest request) {
        if (this.helpFile == null) {
            return;
        }
        try {
            int anchorIndex = this.helpFile.indexOf("#");
            String url = anchorIndex != -1 ? this.helpFile.substring(0, anchorIndex) : this.helpFile;
            String path = new URL(url).getPath();
            path = path.replaceAll("//*", "/");
            this.loadURL = new URL(request.getScheme(), request.getServerName(), request.getServerPort(), path).toString();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public Help2Utils getUtils() {
        return this.utils;
    }

    protected void registerChildren() {
        this.registerChild(CHILD_BROWSERTYPE, CCHiddenField.class);
        this.registerChild(CHILD_INDEXTREE, CCClientSideTree.class);
        this.registerChild(CHILD_SEARCHBUTTON, CCButton.class);
        this.registerChild(CHILD_SEARCHFIELD, CCTextField.class);
        this.registerChild(CHILD_TABS, CCTabs.class);
        this.registerChild(CHILD_TIPSHREF, CCHref.class);
        this.registerChild(CHILD_TIPSTEXT, CCStaticTextField.class);
        this.registerChild(CHILD_TOCTREE, CCClientSideTree.class);
        this.registerChild(CHILD_SEARCHRESULTSTILEDVIEW, SearchResultsTiledView.class);
    }

    protected View createChild(String name) {
        if (name.equals(CHILD_BROWSERTYPE)) {
            CCClientSniffer sniffer = new CCClientSniffer(this.getRequestContext().getRequest());
            CCHiddenField child = sniffer.isNav4() && sniffer.isSun() ? new CCHiddenField((ContainerView)this, name, SUN_NAV4_CLIENT) : new CCHiddenField((ContainerView)this, name, "");
            return child;
        }
        if (name.equals(CHILD_SEARCHBUTTON)) {
            CCButton child = new CCButton((ContainerView)this, name, null);
            return child;
        }
        if (name.equals(CHILD_SEARCHFIELD)) {
            CCTextField child = new CCTextField((ContainerView)this, name, null);
            child.setTitle("help2.searchFieldTitle");
            return child;
        }
        if (name.equals(CHILD_TABS)) {
            CCTabs child = new CCTabs((View)this, this.tabsModel, name);
            return child;
        }
        if (name.equals(CHILD_TIPSHREF)) {
            CCHref child = new CCHref((ContainerView)this, name, null);
            child.setTitle("help2.tips");
            child.setExtraHtml("onClick=\"javascript: window.parent.frames['contentFrame'].location = '" + this.utils.getTipsOnSearchingPath(this.getRequestContext().getServletContext()) + "'; return false;\"");
            return child;
        }
        if (name.equals(CHILD_TIPSTEXT)) {
            CCStaticTextField child = new CCStaticTextField((ContainerView)this, name, null);
            return child;
        }
        if (name.equals(CHILD_TOCTREE) || name.equals(CHILD_INDEXTREE)) {
            HttpServletRequest request = this.getRequestContext().getRequest();
            ArrayList treeList = name.equals(CHILD_TOCTREE) ? this.utils.getTOCTreeList() : this.utils.getIndexTreeList();
            CCTreeModel treeModel = this.createTreeModel(name, request, treeList);
            CCClientSideTree child = new CCClientSideTree((ContainerView)this, name, treeModel);
            return child;
        }
        if (name.equals(CHILD_SEARCHRESULTSTILEDVIEW)) {
            return new SearchResultsTiledView((View)this, name);
        }
        throw new IllegalArgumentException("Invalid child name [" + name + "]");
    }

    public String getDisplayURL() {
        NonSyncStringBuffer params = new NonSyncStringBuffer();
        String value = this.getRequestContext().getRequest().getParameter("helpFile");
        if (value != null) {
            params.append(params.length() == 0 ? "?" : "&").append("helpFile=").append(value);
        }
        return DEFAULT_DISPLAY_URL + params.toString();
    }

    public String endChildDisplay(ChildContentDisplayEvent event) throws ModelControlException {
        if (!event.getChildName().equals(CHILD_TOCTREE)) {
            return super.endChildDisplay(event);
        }
        String firstLoad = this.getRequestContext().getRequest().getParameter("firstLoad");
        if (firstLoad != null && firstLoad.equals("true")) {
            NonSyncStringBuffer buf = new NonSyncStringBuffer(super.endChildDisplay(event)).append("<script type=\"text/javascript\">").append("Navigator_TOCTree.yokeToAndLoad(").append(this.loadID).append(");</script>");
            return buf.toString();
        }
        return super.endChildDisplay(event);
    }

    public Map getStateData() {
        HashMap<String, String> map = new HashMap<String, String>(2);
        map.put("appName", this.appName);
        map.put("pathPrefix", this.pathPrefix);
        map.put(SEARCH_FIELD_VALUE, this.searchFieldValue);
        return map;
    }

    public void setStateData(Map map) {
        this.resetStateData();
    }

    public void resetStateData() {
        this.getParentViewBean().setPageSessionAttribute(this.STATE_DATA, null);
    }

    public void restoreStateData() {
        Map map = (Map)this.getParentViewBean().getPageSessionAttribute(this.STATE_DATA);
        if (map != null) {
            this.appName = (String)map.get("appName");
            this.pathPrefix = (String)map.get("pathPrefix");
            this.searchFieldValue = (String)map.get(SEARCH_FIELD_VALUE);
            if (this.searchFieldValue == null || this.searchButtonClicked) {
                this.searchFieldValue = this.getDisplayFieldStringValue(CHILD_SEARCHFIELD);
            }
        } else {
            this.searchFieldValue = this.getDisplayFieldStringValue(CHILD_SEARCHFIELD);
            this.getParentViewBean().setPageSessionAttribute(this.STATE_DATA, (Serializable)((HashMap)this.getStateData()));
        }
        CCTabs tabs = (CCTabs)this.getChild(CHILD_TABS);
        tabs.restoreStateData();
        this.tabsModel = (CCTabsModel)tabs.getCCTabsModel();
        int id = this.tabsModel.getSelectedNode().getId();
        this.setTabContentDisplay(id);
        if (id == 3 && this.searchFieldValue != null && !this.searchFieldValue.trim().equals("")) {
            ((CCTextField)this.getDisplayField(CHILD_SEARCHFIELD)).setValue(this.searchFieldValue);
            this.showSearchResults = true;
        }
    }

    public void nodeClicked(RequestInvocationEvent event, int id) {
        this.restoreStateData();
        this.getParentViewBean().setPageSessionAttribute(this.STATE_DATA, (Serializable)((HashMap)this.getStateData()));
        this.forwardTo(this.getRequestContext());
    }

    public void setTabContentDisplay(int id) {
        if (id == 1) {
            this.showTOC = true;
            this.showIndex = false;
            this.showSearch = false;
        } else if (id == 2) {
            this.showTOC = false;
            this.showIndex = true;
            this.showSearch = false;
        } else if (id == 3) {
            this.showTOC = false;
            this.showIndex = false;
            this.showSearch = true;
        }
    }

    public void handleSearchButtonRequest(RequestInvocationEvent event) throws ServletException, IOException {
        this.searchButtonClicked = true;
        this.restoreStateData();
        this.showSearchResults = true;
        this.searchFieldValue = this.getDisplayFieldStringValue(CHILD_SEARCHFIELD);
        this.getParentViewBean().setPageSessionAttribute(this.STATE_DATA, (Serializable)((HashMap)this.getStateData()));
        this.forwardTo(this.getRequestContext());
    }

    public void handleTipsHrefRequest(RequestInvocationEvent event) throws ServletException, IOException {
        this.restoreStateData();
        HttpServletRequest request = this.getRequestContext().getRequest();
        URL url = null;
        try {
            String host = CCSystem.getUnsecureServerName();
            int port = -1;
            try {
                port = Integer.parseInt(CCSystem.getUnsecurePort());
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (host == null || port < 1) {
                host = request.getServerName();
                port = request.getServerPort();
            }
            url = new URL("http", host, port, this.utils.getTipsOnSearchingPath(this.getRequestContext().getServletContext()));
        }
        catch (MalformedURLException mex) {
            CCDebug.trace3("url is null");
        }
        this.utils.setCurrentHelpPage(url);
        this.getParentViewBean().setPageSessionAttribute(this.STATE_DATA, (Serializable)((HashMap)this.getStateData()));
        this.forwardTo(this.getRequestContext());
    }

    public boolean beginTocDisplay(ChildDisplayEvent event) {
        return this.showTOC;
    }

    public boolean beginIndexDisplay(ChildDisplayEvent event) {
        return this.showIndex;
    }

    public boolean beginSearchDisplay(ChildDisplayEvent event) {
        return this.showSearch;
    }

    public boolean beginSearchResultsDisplay(ChildDisplayEvent event) {
        return this.showSearchResults;
    }
}

