/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.sql.concurrency;

import com.sun.jdo.spi.persistence.support.sqlstore.SQLStateManager;
import com.sun.jdo.spi.persistence.support.sqlstore.UpdateObjectDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.FieldDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.LocalFieldDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.concurrency.ConcurrencyDBNative;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.QueryTable;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.Statement;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.UpdateQueryPlan;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import org.netbeans.modules.dbschema.ColumnElement;

public class ConcurrencyCheckDirty
extends ConcurrencyDBNative {
    public void commit(UpdateObjectDesc updateDesc, SQLStateManager beforeImage, SQLStateManager afterImage, int logReason) {
        this.beforeImage = beforeImage;
        this.afterImage = afterImage;
    }

    public void update(UpdateQueryPlan plan) {
        boolean debug = logger.isLoggable();
        if (debug) {
            logger.fine("sqlstore.sql.concurrency.concurrencychkdirty", this.beforeImage);
        }
        if (this.beforeImage != null) {
            ArrayList fields = plan.getConfig().fields;
            BitSet verifyGroupMask = this.prepareVerifyGroupMask(plan);
            for (int i = 0; i < 2; ++i) {
                if (i == 0) {
                    fields = plan.getConfig().fields;
                } else if (i == 1) {
                    fields = plan.getConfig().hiddenFields;
                }
                if (fields == null) continue;
                for (int j = 0; j < fields.size(); ++j) {
                    FieldDesc f = (FieldDesc)fields.get(j);
                    if (!(f instanceof LocalFieldDesc)) continue;
                    LocalFieldDesc lf = (LocalFieldDesc)f;
                    if ((lf.sqlProperties & 1) <= 0 || (lf.sqlProperties & 0x40) != 0 || !this.beforeImage.getPresenceMaskBit(lf.absoluteID) || !this.isFieldVerificationRequired(lf, verifyGroupMask)) continue;
                    Object val = null;
                    val = lf.getValue(this.beforeImage);
                    ConcurrencyCheckDirty.addConstraint(plan, lf, val);
                }
            }
        }
        if (debug) {
            logger.fine("sqlstore.sql.concurrency.concurrencychkdirty.exit");
        }
    }

    protected BitSet prepareVerifyGroupMask(UpdateQueryPlan plan) {
        return null;
    }

    protected boolean isFieldVerificationRequired(LocalFieldDesc lf, BitSet verifyGroupMask) {
        return true;
    }

    private static void addConstraint(UpdateQueryPlan plan, LocalFieldDesc lf, Object val) {
        Iterator iter = lf.getColumnElements();
        while (iter.hasNext()) {
            ColumnElement c = (ColumnElement)iter.next();
            for (int i = 0; i < plan.statements.size(); ++i) {
                Statement s = (Statement)plan.statements.get(i);
                for (int j = 0; j < s.tableList.size(); ++j) {
                    QueryTable t = (QueryTable)s.tableList.get(j);
                    if (t.getTableDesc().getTableElement() != c.getDeclaringTable()) continue;
                    s.addConstraint(lf, val);
                }
            }
        }
    }

    public Object clone() {
        return new ConcurrencyCheckDirty();
    }
}

