/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.jmx.remote.notification;

import com.sun.enterprise.admin.jmx.remote.comm.HttpConnectorAddress;
import com.sun.enterprise.admin.jmx.remote.notification.ListenerInfo;
import com.sun.enterprise.admin.jmx.remote.notification.NotificationReceiver;
import com.sun.enterprise.admin.jmx.remote.notification.NotificationWrapper;
import com.sun.enterprise.admin.jmx.remote.notification.SimpleQueue;
import java.io.IOException;
import java.net.InetAddress;
import java.rmi.server.UID;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class ClientNotificationManager
implements Runnable {
    private Map env = null;
    private HashMap listenerMap = null;
    private String mgrId = null;
    private SimpleQueue que = null;
    private NotificationReceiver receiver = null;
    private Thread eventThread = null;
    private boolean exit = false;
    private static final Logger logger = Logger.getLogger("com.sun.logging.enterprise.system.admin.jmx.connector");

    public ClientNotificationManager(HttpConnectorAddress ad, Map env) throws IOException {
        this.env = env;
        this.que = new SimpleQueue();
        this.listenerMap = new HashMap();
        String hname = "null";
        try {
            hname = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.mgrId = new UID().toString() + ":" + hname;
        this.eventThread = new Thread(this);
        this.eventThread.start();
        this.receiver = new NotificationReceiver(ad, this);
    }

    public String getId() {
        return this.mgrId;
    }

    public boolean reinit() throws IOException {
        return this.receiver.reinit();
    }

    public String addNotificationListener(ObjectName objname, NotificationListener listener, NotificationFilter filter, Object handback) {
        ListenerInfo info = new ListenerInfo();
        info.listener = listener;
        info.filter = filter;
        info.handback = handback;
        info.id = info.computeId();
        ArrayList<ListenerInfo> list = (ArrayList<ListenerInfo>)this.listenerMap.get(objname);
        if (list == null) {
            list = new ArrayList<ListenerInfo>();
        }
        list.add(info);
        this.listenerMap.put(objname, list);
        return info.id;
    }

    public String[] removeNotificationListener(ObjectName mbean, NotificationListener listener) {
        String[] strs = this.removeNotificationListener(mbean, listener, null, null, true);
        return strs;
    }

    public String[] removeNotificationListener(ObjectName mbean, NotificationListener listener, NotificationFilter filter, Object handback) {
        String[] strs = this.removeNotificationListener(mbean, listener, filter, handback, false);
        return strs;
    }

    private String[] removeNotificationListener(ObjectName mbean, NotificationListener listener, NotificationFilter filter, Object handback, boolean listenerOnly) {
        ArrayList<String> idlist = new ArrayList<String>();
        ArrayList list = (ArrayList)this.listenerMap.get(mbean);
        if (list == null) {
            return new String[0];
        }
        ListenerInfo info1 = new ListenerInfo();
        info1.listener = listener;
        info1.filter = filter;
        info1.handback = handback;
        info1.id = info1.computeId();
        Iterator itr = list.iterator();
        ArrayList list1 = (ArrayList)list.clone();
        while (itr.hasNext()) {
            ListenerInfo info = (ListenerInfo)itr.next();
            if (!listenerOnly && info.id.equals(info1.id)) {
                list1.remove(list1.indexOf(info));
                idlist.add(info.id);
                continue;
            }
            if (!listenerOnly || info.listener != listener) continue;
            list1.remove(list1.indexOf(info));
            idlist.add(info.id);
        }
        this.listenerMap.put(mbean, list1);
        String[] ids = new String[idlist.size()];
        ids = idlist.toArray(ids);
        return ids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void raiseEvent(NotificationWrapper wrapr) {
        SimpleQueue simpleQueue = this.que;
        synchronized (simpleQueue) {
            this.que.add(wrapr);
            this.que.notify();
        }
    }

    private boolean isExiting() {
        return this.exit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws Exception {
        this.exit = true;
        try {
            this.receiver.exit();
        }
        finally {
            SimpleQueue simpleQueue = this.que;
            synchronized (simpleQueue) {
                this.que.notify();
            }
            this.eventThread.join();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.isExiting()) {
            SimpleQueue simpleQueue = this.que;
            synchronized (simpleQueue) {
                while (this.que.isEmpty() && !this.isExiting()) {
                    try {
                        this.que.wait();
                    }
                    catch (InterruptedException intre) {}
                }
            }
            if (this.isExiting()) break;
            while (!this.que.isEmpty() && !this.isExiting()) {
                NotificationWrapper wrapr = (NotificationWrapper)this.que.remove();
                ObjectName source = wrapr.getSource();
                Notification notif = wrapr.getNotification();
                ArrayList listeners = (ArrayList)this.listenerMap.get(source);
                Iterator itr = listeners.iterator();
                while (itr.hasNext() && !this.isExiting()) {
                    ListenerInfo info = (ListenerInfo)itr.next();
                    boolean callListener = true;
                    if (info.filter != null) {
                        callListener = info.filter.isNotificationEnabled(notif);
                    }
                    if (!callListener) continue;
                    info.listener.handleNotification(notif, info.handback);
                }
            }
        }
    }
}

