/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.jmx.remote.notification;

import com.sun.enterprise.admin.jmx.remote.comm.HttpConnectorAddress;
import com.sun.enterprise.admin.jmx.remote.notification.ClientNotificationManager;
import com.sun.enterprise.admin.jmx.remote.notification.NotificationWrapper;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.HttpURLConnection;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URLConnection;
import java.nio.channels.ClosedChannelException;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.util.logging.Logger;

class NotificationReceiver
implements Runnable {
    private ClientNotificationManager mgr = null;
    private String notifMgrUri = null;
    private HttpConnectorAddress ad = null;
    private URLConnection mConnection = null;
    private ObjectInputStream objIn = null;
    private InputStream in = null;
    private boolean exit = false;
    private boolean connected = false;
    private boolean timedout = false;
    private int nReconnected = 0;
    private Thread receiveThr = null;
    private static final Logger logger = Logger.getLogger("com.sun.logging.enterprise.system.admin.jmx.connector");

    public NotificationReceiver(HttpConnectorAddress ad, ClientNotificationManager mgr) throws IOException {
        this.mgr = mgr;
        this.ad = ad;
        this.notifMgrUri = this.getNotifMgrURI();
        this.connect();
        this.receiveThr = new Thread(this);
        this.receiveThr.start();
    }

    private String getNotifMgrURI() {
        String uri = this.ad.getPath();
        if (uri == null || uri.trim().length() == 0) {
            uri = "/web1/remotejmx";
        }
        uri = uri + "/NotificationManager" + "?" + "id" + "=" + this.mgr.getId();
        return uri;
    }

    private void connect() throws IOException {
        if (this.connected) {
            return;
        }
        this.connect(null, false);
    }

    private void connect(String cmd, boolean disconnect) throws IOException {
        try {
            String uri = this.notifMgrUri;
            if (cmd != null) {
                uri = uri + "&" + "cmd" + "=" + "close";
            }
            System.setProperty("sun.net.client.defaultConnectTimeout", Integer.toString(2000));
            URLConnection conn = this.ad.openConnection(uri);
            InputStream inStream = conn.getInputStream();
            if (!disconnect) {
                this.mConnection = conn;
                this.in = inStream;
                this.connected = true;
                this.nReconnected = 0;
            } else {
                this.disconnect(conn, inStream);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw ioe;
        }
    }

    public boolean reinit() throws IOException {
        if (this.connected) {
            return true;
        }
        this.timedout = false;
        try {
            this.connect();
        }
        catch (IOException ioe) {
            this.timedout = true;
            throw ioe;
        }
        this.nReconnected = 0;
        this.receiveThr = new Thread(this);
        this.receiveThr.start();
        return true;
    }

    public boolean hasTimedout() {
        return this.timedout;
    }

    public void run() {
        while (!this.isExiting()) {
            try {
                this.connect();
                this.readNotification();
            }
            catch (IOException ioe) {
                if (this.isExiting()) break;
                ioe.printStackTrace();
                if (ioe instanceof SocketTimeoutException) {
                    this.timedout = true;
                    break;
                }
                if (this.isDisconnected(ioe)) {
                    this.connected = false;
                    ++this.nReconnected;
                    if (this.nReconnected <= 3) continue;
                    this.timedout = true;
                    break;
                }
                if (!this.isExiting()) continue;
                break;
            }
        }
    }

    private boolean isDisconnected(IOException ioe) {
        return ioe instanceof ClosedChannelException || ioe instanceof SocketException || ioe instanceof ConnectException || ioe instanceof ConnectIOException || ioe instanceof EOFException;
    }

    private void disconnect() throws IOException {
        this.disconnect(this.mConnection, this.in);
    }

    private void disconnect(URLConnection conn, InputStream in) throws IOException {
        if (conn instanceof HttpURLConnection) {
            ((HttpURLConnection)conn).disconnect();
        } else {
            in.close();
        }
    }

    public void exit() throws Exception {
        this.exit = true;
        this.sendCloseMessage();
        this.disconnect();
        this.receiveThr.join();
    }

    private void sendCloseMessage() throws IOException {
        this.connect("close", true);
    }

    private boolean isExiting() {
        return this.exit;
    }

    private void readNotification() throws IOException {
        Object obj = null;
        try {
            this.objIn = new ObjectInputStream(this.in);
            obj = this.objIn.readObject();
        }
        catch (IOException ioe) {
            String msg = ioe.getMessage();
            if (msg != null && msg.indexOf("EOF") != -1) {
                throw new EOFException(msg);
            }
            throw ioe;
        }
        catch (ClassNotFoundException notfound) {
            return;
        }
        NotificationWrapper wrapr = (NotificationWrapper)obj;
        if (wrapr.getType() == 1) {
            return;
        }
        this.mgr.raiseEvent(wrapr);
    }
}

