/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.config;

import com.sun.appserv.management.util.misc.GSetUtil;
import com.sun.appserv.management.util.misc.MapUtil;
import com.sun.enterprise.management.config.ConfigFactory;
import com.sun.enterprise.management.config.ConfigFactoryCallback;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.management.AttributeList;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SSLConfigFactory
extends ConfigFactory {
    private static final String CREATE_SSL = "createSsl";
    private static final String[] CREATE_SSL_SIG = new String[]{AttributeList.class.getName()};
    private static final String REMOVE_SSL = "removeSsl";
    private static final String[] REMOVE_SSL_SIG = null;
    private static final String CERT_NICKNAME_KEY = "cert-nickname";
    private final Set<String> LEGAL_OPTIONAL_KEYS = GSetUtil.newUnmodifiableStringSet("ClientAuthEnabled", "SSL2Ciphers", "SSL3TLSCiphers", "SSL3Enabled", "SSL2Enabled", "TLSEnabled", "TLSRollbackEnabled", "ssl3-tls-ciphers");
    private static final Map<String, String> OVERRIDES = Collections.unmodifiableMap(MapUtil.newMap(new String[]{"Name", "cert-nickname"}));

    public SSLConfigFactory(ConfigFactoryCallback callbacks) {
        super(callbacks);
    }

    @Override
    protected Set<String> getLegalOptionalCreateKeys() {
        return this.LEGAL_OPTIONAL_KEYS;
    }

    @Override
    protected Map<String, String> getParamNameOverrides() {
        return OVERRIDES;
    }

    public ObjectName create(String certNickname, Map<String, String> optional) {
        Map<String, String> params = this.initParams(certNickname, null, optional);
        ObjectName amxName = this.createChild(params);
        return amxName;
    }

    @Override
    protected ObjectName createOldChildConfig(AttributeList attrs) {
        ObjectName oldObjectName = (ObjectName)this.getCallbacks().getDelegate().invoke(CREATE_SSL, new Object[]{attrs}, CREATE_SSL_SIG);
        return oldObjectName;
    }

    @Override
    public void internalRemove(ObjectName sslConfigObjectName) {
        this.getCallbacks().getDelegate().invoke(REMOVE_SSL, null, REMOVE_SSL_SIG);
        this.getCallbacks().sendConfigRemovedNotification(sslConfigObjectName);
    }
}

