/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.offline;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OfflineDottedNamesRegistry {
    private Map<String, ObjectName> mPrefixToObjectName = new HashMap<String, ObjectName>();
    private Map<ObjectName, String> mObjectNameToPrefix = new HashMap<ObjectName, String>();
    private Map<ObjectName, Set<String>> mLegalAttributes = new HashMap<ObjectName, Set<String>>();

    public synchronized void addMapping(ObjectName objectName, String prefix, Set<String> legalAttributes) {
        if (objectName == null || prefix == null) {
            throw new IllegalArgumentException("null");
        }
        if (this.mObjectNameToPrefix.containsKey(objectName)) {
            throw new IllegalArgumentException("Already registered: " + objectName);
        }
        this.mObjectNameToPrefix.put(objectName, prefix);
        this.mPrefixToObjectName.put(prefix, objectName);
        this.mLegalAttributes.put(objectName, Collections.unmodifiableSet(legalAttributes));
    }

    public synchronized void removeMapping(ObjectName objectName) {
        String prefix = this.mObjectNameToPrefix.get(objectName);
        if (prefix != null) {
            this.mObjectNameToPrefix.remove(objectName);
            this.mLegalAttributes.remove(objectName);
            this.mPrefixToObjectName.remove(prefix);
        }
    }

    public String getPrefix(ObjectName objectName) {
        return this.mObjectNameToPrefix.get(objectName);
    }

    public ObjectName getObjectName(String prefix) {
        return this.mPrefixToObjectName.get(prefix);
    }

    public Set<String> getLegalAttributes(ObjectName objectName) {
        return this.mLegalAttributes.get(objectName);
    }

    public Set<ObjectName> getObjectNames() {
        HashSet<ObjectName> result = new HashSet<ObjectName>();
        result.addAll(this.mObjectNameToPrefix.keySet());
        return result;
    }

    public Set<String> getPrefixes() {
        HashSet<String> result = new HashSet<String>();
        result.addAll(this.mObjectNameToPrefix.values());
        return result;
    }
}

