/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.certconversion;

import com.sun.enterprise.tools.upgrade.common.BaseModule;
import com.sun.enterprise.tools.upgrade.common.CommonInfoModel;
import com.sun.enterprise.tools.upgrade.common.UpgradeUtils;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CertificateTransfer
implements BaseModule {
    private StringManager stringManager = StringManager.getManager((String)"com.sun.enterprise.tools.upgrade.certconversion");
    private Logger logger = CommonInfoModel.getDefaultLogger();
    private Vector recoveryList = new Vector();
    private UpgradeUtils utils;
    private String JAVA_HOME = System.getProperty("com.sun.aas.java.home");
    private CommonInfoModel cim;
    private String targetJksPath;
    private String sourceJksPath;
    private String targetCaJksPath;
    private String sourceCaJksPath;
    private String targetNssPath;
    private String sourceNssPath;
    private String targetCaNssPath;
    private String sourceCaNssPath;
    private static String JKS_CERTS = "keystore.jks";
    private static String CA_JKS_CERTS = "cacerts.jks";
    private static String NSS_CERTS = "key3.db";
    private static String CA_NSS_CERTS = "cert8.db";
    private static String CA_70_CERTS = "cert7.db";

    public String getName() {
        return this.stringManager.getString("enterprise.tools.upgrade.certconversion.moduleName");
    }

    public boolean upgrade(CommonInfoModel cmi) {
        this.cim = cmi;
        this.logger.log(Level.INFO, this.stringManager.getString("enterprise.tools.upgrade.certconversion.start_certificate_migration", (Object)cmi.getCurrentDomain()));
        this.targetJksPath = this.cim.getTargetJKSKeyStorePath();
        this.sourceJksPath = this.cim.getSourceJKSKeyStorePath();
        this.targetCaJksPath = this.cim.getTargetTrustedJKSKeyStorePath();
        this.sourceCaJksPath = this.cim.getSourceTrustedJKSKeyStorePath();
        String sourceConfigPath = this.cim.getSourceDomainPath() + File.separator + "config";
        String targetConfigPath = this.cim.getTargetConfig();
        this.targetNssPath = targetConfigPath + File.separator + NSS_CERTS;
        this.sourceNssPath = sourceConfigPath + File.separator + NSS_CERTS;
        this.targetCaNssPath = targetConfigPath + File.separator + CA_NSS_CERTS;
        this.sourceCaNssPath = this.cim.getSourceVersionAndEdition().equals("as7xpe") ? sourceConfigPath + File.separator + CA_70_CERTS : sourceConfigPath + File.separator + CA_NSS_CERTS;
        this.utils = UpgradeUtils.getUpgradeUtils(this.cim);
        String tv = this.cim.getTargetVersionAndEdition();
        String sv = this.cim.getSourceVersionAndEdition();
        if (sv.equals("as80pe") || sv.equals("as81pe")) {
            if (tv.equals("as90pe")) {
                return this.jksToJks();
            }
            if (tv.equals("as90ee")) {
                return this.jksToNss();
            }
        }
        if (this.cim.getSourceVersion().equals("7x") || sv.equals("as81ee")) {
            if (tv.equals("as90pe")) {
                return this.nssToJks();
            }
            if (tv.equals("as90ee")) {
                return this.nssToNss();
            }
        }
        return false;
    }

    private void configureJks() {
        String securityFile = this.JAVA_HOME + File.separator + "lib" + File.separator + "security" + File.separator + "java.security";
        File security = this.getSecurityFile();
        if (!security.exists()) {
            this.logger.warning(this.stringManager.getString("enterprise.tools.upgrade.certconversion.errorConfiguringJKS"));
            return;
        }
    }

    private void configureNss() {
        File security = this.getSecurityFile();
        if (!security.exists()) {
            this.logger.warning(this.stringManager.getString("enterprise.tools.upgrade.certconversion.errorConfiguringNSS"));
            return;
        }
    }

    private boolean jksToNss() {
        this.configureJks();
        return this.copyJksCerts();
    }

    private boolean nssToJks() {
        this.configureNss();
        return this.copyNssCerts();
    }

    private boolean jksToJks() {
        this.backupJksCerts();
        return this.copyJksCerts();
    }

    private boolean nssToNss() {
        this.backupNssCerts();
        return this.copyNssCerts();
    }

    private boolean copyJksCerts() {
        try {
            this.utils.copyFile(this.sourceJksPath, this.targetJksPath);
            this.utils.copyFile(this.sourceCaJksPath, this.targetCaJksPath);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, this.stringManager.getString("enterprise.tools.upgrade.certconversion.could_not_migrate_certificates", (Object)e));
            return false;
        }
        return true;
    }

    private boolean backupJksCerts() {
        try {
            this.backup(this.targetJksPath);
            this.backup(this.targetCaJksPath);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, this.stringManager.getString("enterprise.tools.upgrade.certconversion.could_not_migrate_certificates", (Object)e));
            return false;
        }
        return true;
    }

    private boolean copyNssCerts() {
        try {
            this.utils.copyFile(this.sourceNssPath, this.targetNssPath);
            this.utils.copyFile(this.sourceCaNssPath, this.targetCaNssPath);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, this.stringManager.getString("enterprise.tools.upgrade.certconversion.could_not_migrate_certificates", (Object)e));
            return false;
        }
        return true;
    }

    private boolean backupNssCerts() {
        try {
            this.backup(this.targetNssPath);
            this.backup(this.targetCaNssPath);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, this.stringManager.getString("enterprise.tools.upgrade.certconversion.could_not_migrate_certificates", (Object)e));
            return false;
        }
        return true;
    }

    private void backup(String filePath) throws IOException {
        String backupFilePath = filePath + ".bak";
        this.utils.copyFile(filePath, backupFilePath);
        this.recoveryList.add(filePath);
    }

    public void recovery(CommonInfoModel commonInfo) {
        Enumeration e = this.recoveryList.elements();
        while (e.hasMoreElements()) {
            String recoverPath = (String)e.nextElement();
            String backupPath = recoverPath + ".bak";
            try {
                this.utils.copyFile(backupPath, recoverPath);
                new File(backupPath).delete();
            }
            catch (IOException ioe) {
                this.logger.log(Level.SEVERE, this.stringManager.getString("enterprise.tools.upgrade.certconversion.could_not_migrate_certificates", (Object)ioe.getMessage()), new Object[]{recoverPath, ioe});
            }
        }
    }

    private File getSecurityFile() {
        String securityFile = this.JAVA_HOME + File.separator + "lib" + File.separator + "security" + File.separator + "java.security";
        return new File(securityFile);
    }
}

