/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.common;

import com.sun.enterprise.tools.upgrade.common.CommonInfoModel;
import com.sun.enterprise.tools.upgrade.common.InteractiveInput;
import com.sun.enterprise.tools.upgrade.common.arguments.ARG_help;
import com.sun.enterprise.tools.upgrade.common.arguments.ParsedArgument;
import com.sun.enterprise.tools.upgrade.logging.LogService;
import com.sun.enterprise.util.i18n.StringManager;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ArgsParser {
    public static final String SOURCE = "source";
    public static final String SOURCE_SHORT = "s";
    public static final String TARGET = "target";
    public static final String TARGET_SHORT = "t";
    public static final String DOMAIN = "domain";
    public static final String DOMAIN_SHORT = "d";
    public static final String NSSPWD = "nsspwd";
    public static final String NSSPWDFILE = "nsspwdfile";
    public static final String NSSPWDFILE_SHORT = "n";
    public static final String TARGETNSSPWD = "targetnsspwd";
    public static final String TARGETNSSPWDFILE = "targetnsspwdfile";
    public static final String TARGETNSSPWDFILE_SHORT = "e";
    public static final String JKSPWD = "jkspwd";
    public static final String JKSPWDFILE = "jkspwdfile";
    public static final String JKSPWDFILE_SHORT = "j";
    public static final String CAPWD = "capwd";
    public static final String CAPWDFILE = "capwdfile";
    public static final String CAPWDFILE_SHORT = "p";
    public static final String ADMINUSER = "adminuser";
    public static final String ADMINUSER_SHORT = "a";
    public static final String ADMINPASSWORD = "adminpassword";
    public static final String ADMINPASSWORD_SHORT = "w";
    public static final String MASTERPASSWORD = "masterpassword";
    public static final String MASTERPASSWORD_SHORT = "m";
    public static final String CLINSTANCEINFO = "clinstancefiles";
    public static final String CLINSTANCEINFO_SHORT = "i";
    private static Logger _logger = LogService.getLogger("com.sun.enterprise.tools.upgrade");
    private String[] arguments;
    private CommonInfoModel commonInfo;
    private HashMap interactiveMap;
    private StringManager sm = StringManager.getManager((String)"com.sun.enterprise.tools.upgrade.cli");

    public ArgsParser(String[] args, CommonInfoModel infoModel, HashMap hMap) {
        this.commonInfo = infoModel;
        this.interactiveMap = hMap;
        this.arguments = args;
    }

    public ArgsParser(String[] args, CommonInfoModel infoModel) {
        this(args, infoModel, new HashMap());
    }

    public HashMap parse() {
        return this.parse(null);
    }

    public HashMap parse(InteractiveInput interactiveParser) {
        String cmd = null;
        Vector<String> parameters = new Vector<String>();
        Vector<ParsedArgument> instructions = new Vector<ParsedArgument>();
        Class instructionHandler = null;
        for (int i = 0; i < this.arguments.length; ++i) {
            String delimeters;
            if (!this.arguments[i].startsWith("-")) continue;
            String rawArg = this.arguments[i];
            String argument = rawArg.substring(rawArg.lastIndexOf("-") + 1, rawArg.length());
            StringTokenizer st = new StringTokenizer(argument, delimeters = "=", false);
            if (st.hasMoreTokens()) {
                cmd = st.nextToken();
                if (cmd.equals("?")) {
                    cmd = "h";
                }
                instructionHandler = this.getHandler(cmd);
                parameters = new Vector();
            }
            if (st.hasMoreTokens()) {
                parameters.add(st.nextToken());
            }
            while (i + 1 < this.arguments.length && !this.arguments[i + 1].startsWith("-")) {
                parameters.add(this.arguments[++i]);
            }
            if (instructionHandler != null) {
                this.interactiveMap.put(cmd, parameters);
                instructions.addElement(new ParsedArgument(instructionHandler, cmd, parameters, this.commonInfo, this.interactiveMap));
                continue;
            }
            String msg = this.sm.getString("enterprise.tools.upgrade.cli.invalid_option", (Object)rawArg);
            if (cmd.equals(ADMINPASSWORD_SHORT) || cmd.equals(ADMINPASSWORD)) {
                msg = msg + "\n" + this.sm.getString("enterprise.tools.upgrade.cli.deprecated_option", (Object)rawArg) + " " + this.sm.getString("enterprise.tools.upgrade.cli.deprecated_option.adminpassword");
            }
            this.helpUsage(msg);
            System.exit(1);
        }
        Enumeration e = instructions.elements();
        while (e.hasMoreElements()) {
            ParsedArgument pi = (ParsedArgument)e.nextElement();
            instructionHandler = pi.getHandler();
            try {
                Class[] parameterTypes = new Class[]{pi.getClass()};
                Constructor constructor = instructionHandler.getConstructor(parameterTypes);
                constructor.newInstance(pi);
            }
            catch (Exception ex) {
                _logger.log(Level.INFO, this.sm.getString("enterprise.tools.upgrade.cli.invalid_option", (Object)pi.getMneumonic()), ex);
                System.exit(1);
            }
        }
        if (interactiveParser != null) {
            interactiveParser.collectMissingArguments(this.interactiveMap);
        }
        return this.interactiveMap;
    }

    private Class getHandler(String cmd) {
        Class<?> instructionHandler = null;
        try {
            instructionHandler = cmd.equals(ADMINPASSWORD_SHORT) || cmd.equals(ADMINPASSWORD) ? null : Class.forName("com.sun.enterprise.tools.upgrade.common.arguments.ARG_" + cmd);
            return instructionHandler;
        }
        catch (ClassNotFoundException cnf) {
        }
        catch (Exception e1) {
            _logger.log(Level.INFO, this.sm.getString("enterprise.tools.upgrade.cli.invalid_option", (Object)e1), e1);
        }
        return null;
    }

    public void helpUsage(String str) {
        System.out.println("\n" + str + "\n");
        this.helpUsage();
    }

    public void helpUsage() {
        this.commonInfo.recover();
        new ARG_help(new ParsedArgument(null, null, null, this.commonInfo, null));
    }
}

