/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.jato.model.object;

import com.iplanet.jato.Log;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.model.object.KeyPath;
import com.iplanet.jato.model.object.ObjectPath;
import com.iplanet.jato.model.object.Path;
import com.iplanet.jato.model.object.PathContext;
import com.iplanet.jato.model.object.PathEvaluatorException;
import com.iplanet.jato.util.ClassUtil;
import com.iplanet.jato.util.TypeConverter;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PathEvaluator {
    private static boolean toggleTrace = false;
    public static final boolean TRACE = true;
    private long _epoch = System.currentTimeMillis();
    private Object _object = null;
    private PathContext _pathContext = null;
    private String _key = null;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$String;

    public PathEvaluator(PathContext ctx, Object obj, String key) {
        if (PathEvaluator.isTrace()) {
            this.log("constructor", "context=" + ctx.getName() + ";objType=" + (null == obj ? "null" : obj.getClass().getName()) + ";key=" + (null == key ? "null" : key));
        }
        this._pathContext = ctx;
        this._key = key;
        this.setObject(obj);
    }

    public PathEvaluator(PathContext ctx, Object obj) {
        this(ctx, obj, null);
    }

    protected void setObject(Object obj) {
        if (null == obj) {
            throw new IllegalArgumentException("object param may not be null");
        }
        this._object = obj;
    }

    protected Class getJavaType(ObjectPath path) {
        try {
            return this._pathContext.getJavaType(new KeyPath(this.getKey(), path));
        }
        catch (Exception ex) {
            if (PathEvaluator.isTrace()) {
                this.log("getJavaType", "ObjectPath=" + path + " exception=" + ex);
            }
            return null;
        }
    }

    protected Class getJavaType(String path) {
        return this.getJavaType(new Path(path));
    }

    public Object getObject() {
        return this._object;
    }

    public String getKey() {
        return this._key;
    }

    protected static int getBracePosition(char[] arr, int currPosition, char pushChar, char popChar) {
        int count = 0;
        int len = arr.length;
        while (currPosition < len && count != -1) {
            if (arr[currPosition] == popChar) {
                --count;
            } else if (arr[currPosition] == pushChar) {
                ++count;
            }
            ++currPosition;
        }
        return count == -1 ? --currPosition : -1;
    }

    protected static String createGetterName(String fieldName, boolean isFlag) {
        return (isFlag ? "is" : "get") + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
    }

    protected static String createSetterName(String fieldName) {
        return "set" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
    }

    protected Object getFieldValue(Object obj, String fieldName) {
        Class<?> clzz = obj.getClass();
        try {
            return clzz.getMethod(PathEvaluator.createGetterName(fieldName, false), new Class[0]).invoke(obj, null);
        }
        catch (Exception ex) {
            try {
                return clzz.getMethod(PathEvaluator.createGetterName(fieldName, true), new Class[0]).invoke(obj, null);
            }
            catch (Exception ex2) {
                if (PathEvaluator.isTrace()) {
                    this.log("getFieldValue", "unable to find or invoke getter for fieldName=" + fieldName);
                }
                try {
                    Field field = clzz.getField(fieldName);
                    return field.get(obj);
                }
                catch (Exception ex3) {
                    throw new PathEvaluatorException("PathEvaluator.getFieldValue(Object, String): fieldName ('" + fieldName + "') not found on '" + obj.getClass().getName() + "' object.", ex3);
                }
            }
        }
    }

    protected Class[] getParameterTypes(Object[] params) {
        if (params == null) {
            return new Class[0];
        }
        Class<Integer> clzz = null;
        Class[] types = new Class[params.length];
        int count = 0;
        while (count < params.length) {
            if (params[count] != null) {
                clzz = params[count].getClass();
                if (clzz == (class$java$lang$Integer == null ? PathEvaluator.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    clzz = Integer.TYPE;
                }
            } else {
                clzz = class$java$lang$String == null ? PathEvaluator.class$("java.lang.String") : class$java$lang$String;
            }
            types[count] = clzz;
            ++count;
        }
        return types;
    }

    protected Object[] getParameters(char[] paramArr, int paramStart, int paramEnd) {
        ArrayList<Object> params = new ArrayList<Object>();
        int start = -1;
        int count = paramStart;
        while (count < paramEnd) {
            switch (paramArr[count]) {
                case '\"': {
                    start = ++count;
                    while (count < paramEnd && paramArr[count] != '\"') {
                        ++count;
                    }
                    params.add(new String(paramArr, start, count - start));
                    break;
                }
                case '/': {
                    break;
                }
                case ',': {
                    break;
                }
                default: {
                    start = count;
                    while (count < paramEnd && paramArr[count] != ',') {
                        ++count;
                    }
                    params.add(new Integer(new String(paramArr, start, count - start).trim()));
                }
            }
            ++count;
        }
        return params.toArray();
    }

    protected Object getMethodValue(Object obj, String methodName, char[] paramArr, int paramStart, int paramEnd) {
        Class<?> clzz = obj.getClass();
        try {
            Object[] params = this.getParameters(paramArr, paramStart, paramEnd);
            return clzz.getMethod(methodName, this.getParameterTypes(params)).invoke(obj, params);
        }
        catch (Exception ex) {
            throw new PathEvaluatorException("Unable to get method \"" + methodName + "\". ", ex);
        }
    }

    protected void setFieldValue(Object parent, String fieldName, Class type, Object value) {
        if (parent instanceof Map) {
            ((Map)parent).put(fieldName, value);
            if (PathEvaluator.isTrace()) {
                this.log("setFieldValue", "putting value into map fieldName=" + fieldName);
            }
            return;
        }
        Class<?> clzz = parent.getClass();
        Field field = null;
        if (type == null) {
            block24: {
                try {
                    Method getter;
                    try {
                        getter = clzz.getMethod(PathEvaluator.createGetterName(fieldName, false), new Class[0]);
                    }
                    catch (Exception ex2) {
                        getter = clzz.getMethod(PathEvaluator.createGetterName(fieldName, true), new Class[0]);
                    }
                    type = getter.getReturnType();
                    if (PathEvaluator.isTrace()) {
                        this.log("setFieldValue", "return type of getter for fieldName=" + fieldName + " is " + type.getName());
                    }
                }
                catch (Exception ex) {
                    if (!PathEvaluator.isTrace()) break block24;
                    this.log("setFieldValue", "unable to find or invoke getter for fieldName=" + fieldName + " -> " + ex);
                }
            }
            if (type == null) {
                block25: {
                    try {
                        field = clzz.getField(fieldName);
                        type = field.getType();
                        if (PathEvaluator.isTrace()) {
                            this.log("setFieldValue", "type of field member for fieldName=" + fieldName + " is " + type.getName());
                        }
                    }
                    catch (Exception ex) {
                        if (!PathEvaluator.isTrace()) break block25;
                        this.log("setFieldValue", "unable to find or invoke getter for fieldName=" + fieldName + " -> " + ex);
                    }
                }
                if (type == null) {
                    if (value != null) {
                        type = value.getClass();
                    } else {
                        throw new PathEvaluatorException("PathEvaluator.setFieldValue(Object, String, Class, Object): Field ('" + fieldName + "') not found on object (" + clzz.getName() + ")!");
                    }
                }
            }
        }
        if (!type.isInstance(value)) {
            value = TypeConverter.asType(type, value);
        }
        try {
            Method setter = clzz.getMethod(PathEvaluator.createSetterName(fieldName), type);
            setter.invoke(parent, value);
            if (PathEvaluator.isTrace()) {
                this.log("setFieldValue", "found and invoked setter for fieldName=" + fieldName);
            }
            return;
        }
        catch (Exception ex) {
            if (PathEvaluator.isTrace()) {
                this.log("setFieldValue", "unable to find or invoke setter for fieldName=" + fieldName + " -> " + ex);
            }
            if (field == null) {
                try {
                    field = clzz.getField(fieldName);
                    field.set(parent, value);
                    if (PathEvaluator.isTrace()) {
                        this.log("setFieldValue", "found and assigned field member for fieldName=" + fieldName);
                    }
                    return;
                }
                catch (Exception ex2) {
                    throw new PathEvaluatorException("PathEvaluator.setFieldValue(Object, String, Class, Object): Field ('" + fieldName + "') not found on object (" + clzz.getName() + ")!", ex2);
                }
            }
            return;
        }
    }

    protected Object instantiate(Object parent, String fieldName) {
        Class<?> type;
        block17: {
            type = null;
            try {
                Method getter;
                try {
                    getter = parent.getClass().getMethod(PathEvaluator.createGetterName(fieldName, false), new Class[0]);
                }
                catch (Exception ex2) {
                    getter = parent.getClass().getMethod(PathEvaluator.createGetterName(fieldName, true), new Class[0]);
                }
                type = getter.getReturnType();
                if (PathEvaluator.isTrace() && type != null) {
                    this.log("instantiate", "found getter for fieldName=" + fieldName);
                }
            }
            catch (Exception ex) {
                if (!PathEvaluator.isTrace()) break block17;
                this.log("instantiate", "unable to find getter for fieldName=" + fieldName + " -> " + ex);
            }
        }
        if (type == null) {
            Field field = null;
            try {
                field = parent.getClass().getField(fieldName);
                if (PathEvaluator.isTrace()) {
                    this.log("instantiate", "found field member for fieldName=" + fieldName);
                }
            }
            catch (Exception ex) {
                throw new PathEvaluatorException("PathEvaluator.instantiate(Object, String): Field ('" + fieldName + "') not found on object (" + parent.getClass().getName() + ")!", ex);
            }
            if (field != null) {
                type = field.getType();
            }
            if (PathEvaluator.isTrace() && type != null) {
                this.log("instantiate", "found field");
            }
        }
        if (this._pathContext != null) {
            type = this._pathContext.getMappedJavaType(type.getName());
        }
        if (type == null) {
            if (PathEvaluator.isTrace()) {
                this.log("instantiate", "unable to instantiate " + fieldName);
            }
            return null;
        }
        Object newObject = null;
        try {
            newObject = ClassUtil.instantiate(type);
        }
        catch (InstantiationException ex) {
            throw new PathEvaluatorException(ex);
        }
        if (newObject != null) {
            this.setFieldValue(parent, fieldName, type, newObject);
        }
        return newObject;
    }

    public void setValue(ObjectPath path, Object value) {
        if (path == null) {
            throw new IllegalArgumentException("path parameter may not be null");
        }
        if (path.lastElement().indexOf(91) != -1) {
            int lastBR = path.toString().lastIndexOf(91);
            try {
                this.eval(path, true);
            }
            catch (Exception ex) {
                // empty catch block
            }
            Object arr = this.eval(new Path(path.toString().substring(0, lastBR)), true);
            if (arr == null) {
                throw new PathEvaluatorException("Unable to evaluate: " + path.toString().substring(0, lastBR));
            }
            int index = this.getIndexesFromBrackets(path.toString().toCharArray(), lastBR)[0];
            if (arr.getClass().isArray()) {
                Class<?> type = this.getJavaType(path);
                if (type == null) {
                    type = arr.getClass().getComponentType();
                }
                if (!type.isInstance(value)) {
                    value = TypeConverter.asType(type, value);
                }
                Array.set(arr, index, value);
            } else if (arr instanceof List) {
                Class type = this.getJavaType(path);
                if (type == null) {
                    throw new PathEvaluatorException("Unable to determine component type for List at path: " + path);
                }
                if (!type.isInstance(value)) {
                    value = TypeConverter.asType(type, value);
                }
                ((List)arr).set(index, value);
            } else {
                throw new PathEvaluatorException("Object before brackets in the following path is not an indexable type: " + path.toString());
            }
            return;
        }
        Object parent = this.eval(path.getParent(), true);
        if (parent == null) {
            throw new PathEvaluatorException("Unable to create parent for: " + path);
        }
        this.setFieldValue(parent, path.lastElement(), null, value);
    }

    protected Object eval(ObjectPath path, boolean extend) {
        if (path == null) {
            throw new IllegalArgumentException("path parameter may not be null");
        }
        return this.eval(this.getObject(), path.toString().toCharArray(), 0, extend);
    }

    public Object eval(ObjectPath path) {
        return this.eval(path, false);
    }

    public static Object ensureArraySize(Object arr, int length) {
        if (arr == null) {
            return null;
        }
        if (!arr.getClass().isArray()) {
            throw new IllegalArgumentException("\"arr\" must be an array, instead received: " + arr.getClass().getName());
        }
        int currLen = Array.getLength(arr);
        if (currLen >= length) {
            return arr;
        }
        Object newArr = Array.newInstance(arr.getClass().getComponentType(), length);
        int count = 0;
        while (count < currLen) {
            Array.set(newArr, count, Array.get(arr, count));
            ++count;
        }
        return newArr;
    }

    public static List ensureListSize(List list, int length) {
        if (list == null) {
            return null;
        }
        if (!(list instanceof List)) {
            throw new IllegalArgumentException("\"list\" must be a List, instead received: " + list.getClass().getName());
        }
        int currLen = list.size();
        if (currLen >= length) {
            return list;
        }
        int count = currLen;
        while (count < length) {
            list.add(null);
            ++count;
        }
        return list;
    }

    protected Object evalArray(Object parent, String fieldName, Object obj, int[] indexes, boolean extend) {
        if (obj == null) {
            throw new PathEvaluatorException("Cannot dereference a null value (obj cannot be null)!");
        }
        int index = -1;
        int numIndexes = indexes.length;
        boolean isArray = false;
        int currLen = -1;
        int count = 0;
        while (count < numIndexes) {
            if (obj == null) {
                throw new PathEvaluatorException("Cannot dereference a null value (obj cannot be null)!");
            }
            isArray = obj.getClass().isArray();
            if (!isArray && !(obj instanceof List)) {
                throw new PathEvaluatorException("Attempt to dereference a non-array object: " + obj.getClass().getName());
            }
            index = indexes[count];
            int n = currLen = isArray ? Array.getLength(obj) : ((List)obj).size();
            if (index < 0 || index >= currLen) {
                if (!extend) {
                    throw new PathEvaluatorException("Index (" + index + ") out of bounds!");
                }
                Object object = obj = isArray ? PathEvaluator.ensureArraySize(obj, index + 1) : PathEvaluator.ensureListSize((List)obj, index + 1);
                if (count == 0) {
                    if (parent == null) {
                        this.setObject(obj);
                    }
                    this.setFieldValue(parent, fieldName, null, obj);
                } else if (parent.getClass().isArray()) {
                    Array.set(parent, indexes[count - 1], obj);
                } else {
                    ((List)parent).set(indexes[count - 1], obj);
                }
            }
            parent = obj;
            if (isArray) {
                if ((obj = Array.get(obj, index)) == null && (extend || count + 1 < numIndexes)) {
                    Class type = parent.getClass().getComponentType();
                    if (this._pathContext != null) {
                        type = this._pathContext.getMappedJavaType(type.getName());
                    }
                    try {
                        obj = ClassUtil.instantiate(type);
                    }
                    catch (InstantiationException ex) {
                        throw new PathEvaluatorException(ex);
                    }
                    Array.set(parent, index, obj);
                }
            } else if ((obj = ((List)obj).get(index)) == null && (extend || count + 1 < numIndexes)) {
                throw new PathEvaluatorException("Unable to access KeyPathMap to determine type to instantiate for List, please report this as a bug!");
            }
            ++count;
        }
        return obj;
    }

    protected int[] getIndexesFromBrackets(char[] path, int start) {
        if (PathEvaluator.isTrace()) {
            this.log("getIndexesFromBrackets", "path=" + new String(path) + " start=" + start);
        }
        int curr = start;
        int end = path.length;
        while (curr < end && path[curr] != '/') {
            ++curr;
        }
        end = curr;
        if (PathEvaluator.isTrace()) {
            this.log("getIndexesFromBrackets", "end=" + end);
        }
        int currIndex = 0;
        curr = start;
        while (curr < end) {
            if (path[curr] == '[') {
                ++currIndex;
                ++curr;
            }
            ++curr;
        }
        int[] indexes = new int[currIndex];
        if (PathEvaluator.isTrace()) {
            this.log("getIndexesFromBrackets", "dimension=" + currIndex);
        }
        currIndex = 0;
        curr = start;
        while (curr < end) {
            if (Character.isWhitespace(path[curr])) {
                throw new PathEvaluatorException("Unexpected whitespace in partial path expression '" + new String(path) + "'");
            }
            if (path[curr] != '[') {
                throw new PathEvaluatorException("Expected '[' but found '" + path[curr] + "' in path: '" + new String(path) + "'");
            }
            int endBracket = PathEvaluator.getBracePosition(path, curr + 1, '[', ']');
            if (endBracket == -1) {
                throw new PathEvaluatorException("Unable to find matching ']' in path: " + new String(path));
            }
            if (PathEvaluator.isTrace()) {
                this.log("getIndexesFromBrackets", "LOOP curr=" + curr + " endBracket=" + endBracket);
            }
            int index = -1;
            if (endBracket - curr == 1) {
                if (this._pathContext == null) {
                    throw new PathEvaluatorException("No path context supplied!  Unable to evaluate [] in path: " + new String(path));
                }
                try {
                    index = this._pathContext.getIndex(new KeyPath(this.getKey(), new String(path, 0, endBracket + 1)));
                }
                catch (ModelControlException mce) {
                    throw new PathEvaluatorException(mce);
                }
            }
            try {
                index = Integer.decode(new String(path, curr + 1, endBracket - (curr + 1)));
            }
            catch (NumberFormatException nfe) {
                throw new PathEvaluatorException("whole number expected as index [n] in path: " + new String(path), nfe);
            }
            indexes[currIndex++] = index;
            curr = endBracket;
            ++curr;
        }
        return indexes;
    }

    protected Object eval(Object obj, char[] path, int curr, boolean extend) {
        if (obj == null) {
            throw new PathEvaluatorException("PathEvaluator.eval(Object, char[], int): Object to traverse not set!");
        }
        if (PathEvaluator.isTrace()) {
            this.log("eval", "path=" + new String(path) + " position=" + curr + " extend=" + extend);
        }
        if (path.length == 1 && curr == 0 && path[0] == '/') {
            if (PathEvaluator.isTrace()) {
                this.log("eval", " [/] special case");
            }
            return obj;
        }
        int len = path.length;
        if (curr >= len) {
            if (PathEvaluator.isTrace()) {
                this.log("eval", " done evaluating path");
            }
            return obj;
        }
        if (path[curr] != '/') {
            throw new PathEvaluatorException("PathEvaluator.eval(Object, char[], int): '/' expected, but found: " + new String(path) + " element '" + curr + "'");
        }
        int[] braceQueue = new int[len - curr];
        int braceCount = 0;
        int endBrace = -1;
        int startIndex = ++curr;
        int endingBaseIndex = -1;
        while (curr < len && path[curr] != '/') {
            if (curr < endBrace) {
                ++curr;
                continue;
            }
            switch (path[curr]) {
                case '(': {
                    if (PathEvaluator.isTrace()) {
                        this.log("eval", " found ObjectPath.OPEN_PAREN");
                    }
                    braceQueue[braceCount++] = curr;
                    braceQueue[braceCount++] = endBrace = PathEvaluator.getBracePosition(path, curr + 1, '(', ')');
                    if (endBrace != -1) break;
                    throw new PathEvaluatorException("PathEvaluator.eval(Object, char [], int): matching ')' not found in: " + new String(path));
                }
                case '[': {
                    if (PathEvaluator.isTrace()) {
                        this.log("eval", " found ObjectPath.OPEN_BRACKET");
                    }
                    braceQueue[braceCount++] = curr;
                    braceQueue[braceCount++] = endBrace = PathEvaluator.getBracePosition(path, curr + 1, '[', ']');
                    if (endBrace != -1) break;
                    throw new PathEvaluatorException("PathEvaluator.eval(Object, char [], int): matching ']' not found in: " + new String(path));
                }
            }
            ++curr;
        }
        endingBaseIndex = braceCount == 0 ? curr : braceQueue[0];
        int currBrace = 0;
        if (curr <= startIndex) {
            if (PathEvaluator.isTrace()) {
                this.log("eval", " [/] special case SHOULD HAVE FIRED ALREADY");
            }
            return obj;
        }
        String basename = new String(path, startIndex, endingBaseIndex - startIndex);
        Object nextObject = obj;
        if (basename.length() > 0) {
            if (obj instanceof Map) {
                nextObject = ((Map)obj).get(basename);
            } else if (braceCount > 0 && path[braceQueue[0]] == '(') {
                currBrace += 2;
                nextObject = this.getMethodValue(obj, basename, path, braceQueue[0] + 1, braceQueue[1]);
            } else {
                nextObject = this.getFieldValue(obj, basename);
            }
        } else if (startIndex == 1) {
            obj = null;
        } else {
            String parentPath = new String(path, 0, startIndex);
            obj = this.eval(this.getObject(), parentPath.toCharArray(), 0, false);
        }
        if (nextObject == null) {
            if (!extend && curr >= len) {
                return null;
            }
            String currPath = new String(path, 0, curr);
            Class foundType = this.getJavaType(currPath);
            if (foundType == null && currBrace < braceCount) {
                currPath = new String(path, 0, endingBaseIndex - startIndex);
                foundType = this.getJavaType(currPath);
            }
            if (foundType != null) {
                try {
                    nextObject = ClassUtil.instantiate(foundType);
                }
                catch (InstantiationException ex) {
                    throw new PathEvaluatorException(ex);
                }
            } else {
                nextObject = this.instantiate(obj, basename);
            }
            if (nextObject == null) {
                return null;
            }
            this.setFieldValue(obj, basename, null, nextObject);
        }
        if (currBrace < braceCount) {
            int[] indexes = this.getIndexesFromBrackets(path, braceQueue[currBrace]);
            nextObject = this.evalArray(obj, basename, nextObject, indexes, extend);
        }
        return nextObject == null ? null : this.eval(nextObject, path, curr, extend);
    }

    public static boolean isTrace() {
        return toggleTrace;
    }

    public static void setTrace(boolean flag) {
        toggleTrace = flag;
    }

    protected void log(String context, String msg) {
        if (!PathEvaluator.isTrace()) {
            return;
        }
        String info = "PathEvaluator [" + (System.currentTimeMillis() - this._epoch) + "," + context + "] ";
        Log.log(8, info + msg);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        TRACE = true;
    }
}

