/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.jato.view.command;

import com.iplanet.jato.command.Command;
import com.iplanet.jato.command.CommandEvent;
import com.iplanet.jato.command.CommandException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ViewBase;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.ViewInvocation;
import com.iplanet.jato.view.event.ViewCommandEvent;
import java.util.Map;

public class GotoViewBeanCommand
implements Command {
    public static final String PARAM_TARGET_VIEWBEAN_CLASSNAME = "TargetViewBeanClassName";

    public void execute(CommandEvent event) throws CommandException {
        Map map = event.getParameters();
        String targetViewBeanClassname = (String)map.get(PARAM_TARGET_VIEWBEAN_CLASSNAME);
        ViewBean viewbean = null;
        if (targetViewBeanClassname == null || targetViewBeanClassname.trim().length() == 0) {
            try {
                ViewInvocation invo = ((ViewCommandEvent)event).getInvocation();
                ContainerView cView = (ContainerView)((Object)invo.getTargetRequestHandler());
                viewbean = ViewBase.getRootView(cView);
                targetViewBeanClassname = viewbean.getClass().getName();
            }
            catch (Exception e) {
                throw new CommandException("Null or blank parameter \"TargetViewBeanClassName\" and failure finding current root view", e);
            }
        }
        if (null == viewbean) {
            try {
                viewbean = event.getRequestContext().getViewBeanManager().getViewBean(targetViewBeanClassname);
            }
            catch (ClassNotFoundException cnfe) {
                throw new CommandException("Unable to access or find ViewBean [" + targetViewBeanClassname + "]", cnfe);
            }
        }
        try {
            viewbean.forwardTo(event.getRequestContext());
        }
        catch (Exception e) {
            if (e instanceof CommandException) {
                throw (CommandException)e;
            }
            throw new CommandException("Error executing GotoViewBeanCommand", e);
        }
    }

    static {
        PARAM_TARGET_VIEWBEAN_CLASSNAME = PARAM_TARGET_VIEWBEAN_CLASSNAME;
    }
}

