/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.exceptions;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import oracle.toplink.essentials.exceptions.i18n.ExceptionMessageGenerator;
import oracle.toplink.essentials.internal.helper.Helper;
import oracle.toplink.essentials.internal.helper.JavaPlatform;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.sessions.DatabaseLogin;

public abstract class TopLinkException
extends RuntimeException {
    protected transient AbstractSession session;
    protected Throwable internalException;
    protected static Boolean shouldPrintInternalException = null;
    protected String indentationString = "";
    protected int errorCode;
    protected static final String CR = System.getProperty("line.separator");
    protected boolean hasBeenLogged = false;

    public TopLinkException() {
        this("");
    }

    public TopLinkException(String theMessage) {
        super(theMessage);
    }

    public TopLinkException(String message, Throwable internalException) {
        this(message);
        this.setInternalException(internalException);
    }

    protected static String cr() {
        return Helper.cr();
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getIndentationString() {
        return this.indentationString;
    }

    public Throwable getInternalException() {
        return this.internalException;
    }

    public String getMessage() {
        StringWriter writer = new StringWriter(100);
        if (this.getInternalException() == null || !super.getMessage().equals(this.getInternalException().toString())) {
            writer.write(TopLinkException.cr());
            writer.write(this.getIndentationString());
            writer.write(ExceptionMessageGenerator.getHeader("DescriptionHeader"));
            writer.write(super.getMessage());
        }
        if (this.getInternalException() != null) {
            writer.write(TopLinkException.cr());
            writer.write(this.getIndentationString());
            writer.write(ExceptionMessageGenerator.getHeader("InternalExceptionHeader"));
            writer.write(this.getInternalException().toString());
            if (this.getInternalException() instanceof InvocationTargetException && ((InvocationTargetException)this.getInternalException()).getTargetException() != null) {
                writer.write(TopLinkException.cr());
                writer.write(this.getIndentationString());
                writer.write(ExceptionMessageGenerator.getHeader("TargetInvocationExceptionHeader"));
                writer.write(((InvocationTargetException)this.getInternalException()).getTargetException().toString());
            }
        }
        return writer.toString();
    }

    public AbstractSession getSession() {
        return this.session;
    }

    public boolean hasBeenLogged() {
        return this.hasBeenLogged;
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public void printStackTrace(PrintStream outStream) {
        this.printStackTrace(new PrintWriter(outStream));
    }

    public void printStackTrace(PrintWriter writer) {
        writer.write(ExceptionMessageGenerator.getHeader("LocalExceptionStackHeader"));
        writer.write(TopLinkException.cr());
        super.printStackTrace(writer);
        if (this.getInternalException() != null && TopLinkException.shouldPrintInternalException()) {
            writer.write(ExceptionMessageGenerator.getHeader("InternalExceptionStackHeader"));
            writer.write(TopLinkException.cr());
            this.getInternalException().printStackTrace(writer);
            if (this.getInternalException() instanceof InvocationTargetException && ((InvocationTargetException)this.getInternalException()).getTargetException() != null) {
                writer.write(ExceptionMessageGenerator.getHeader("TargetInvocationExceptionStackHeader"));
                writer.write(TopLinkException.cr());
                ((InvocationTargetException)this.getInternalException()).getTargetException().printStackTrace(writer);
            }
        }
        writer.flush();
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public void setHasBeenLogged(boolean logged) {
        this.hasBeenLogged = logged;
    }

    public void setIndentationString(String indentationString) {
        this.indentationString = indentationString;
    }

    public void setInternalException(Throwable anException) {
        this.internalException = anException;
        JavaPlatform.setExceptionCause(this, anException);
    }

    public void setSession(AbstractSession session) {
        this.session = session;
    }

    public static void setShouldPrintInternalException(boolean printException) {
        shouldPrintInternalException = new Boolean(printException);
    }

    public static boolean shouldPrintInternalException() {
        if (shouldPrintInternalException == null) {
            shouldPrintInternalException = new Boolean(JavaPlatform.shouldPrintInternalException());
        }
        return shouldPrintInternalException;
    }

    public String toString() {
        return this.getIndentationString() + ExceptionMessageGenerator.getHeader("ExceptionHeader") + this.getErrorCode() + "] (" + DatabaseLogin.getVersion() + "): " + this.getClass().getName() + this.getMessage();
    }
}

