/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.identitymaps;

import java.util.Vector;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.internal.identitymaps.CacheKey;
import oracle.toplink.essentials.internal.identitymaps.FullIdentityMap;
import oracle.toplink.essentials.internal.identitymaps.LinkedCacheKey;

public class CacheIdentityMap
extends FullIdentityMap {
    protected LinkedCacheKey first = new LinkedCacheKey(new Vector(2), null, null, 0L);
    protected LinkedCacheKey last = new LinkedCacheKey(new Vector(2), null, null, 0L);

    public CacheIdentityMap(int size) {
        super(size);
        this.first.setNext(this.last);
        this.last.setPrevious(this.first);
    }

    public CacheKey createCacheKey(Vector primaryKey, Object object, Object writeLockValue, long readTime) {
        return new LinkedCacheKey(primaryKey, object, writeLockValue, readTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ensureFixedSize() {
        LinkedCacheKey linkedCacheKey = this.first;
        synchronized (linkedCacheKey) {
            while (this.getMaxSize() > 0 && this.getSize() > this.getMaxSize()) {
                this.remove(this.last.getPrevious());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CacheKey getCacheKey(Vector primaryKeys) {
        LinkedCacheKey cacheKey = (LinkedCacheKey)super.getCacheKey(primaryKeys);
        if (cacheKey != null) {
            LinkedCacheKey linkedCacheKey = this.first;
            synchronized (linkedCacheKey) {
                this.removeLink(cacheKey);
                this.insertLink(cacheKey);
            }
        }
        return cacheKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LinkedCacheKey insertLink(LinkedCacheKey key) {
        if (key == null) {
            return key;
        }
        LinkedCacheKey linkedCacheKey = this.first;
        synchronized (linkedCacheKey) {
            this.first.getNext().setPrevious(key);
            key.setNext(this.first.getNext());
            key.setPrevious(this.first);
            this.first.setNext(key);
        }
        return key;
    }

    protected void put(CacheKey cacheKey) {
        super.put(cacheKey);
        this.insertLink((LinkedCacheKey)cacheKey);
        this.ensureFixedSize();
    }

    public Object remove(CacheKey key) {
        super.remove(key);
        if (key == null) {
            CacheKey aKey;
            Class<?> cacheItemClass = null;
            if (!this.getCacheKeys().isEmpty() && (aKey = (CacheKey)this.getCacheKeys().keys().nextElement()) != null && aKey.getObject() != null) {
                cacheItemClass = aKey.getObject().getClass();
            }
            throw ValidationException.nullCacheKeyFoundOnRemoval(this, cacheItemClass);
        }
        return this.removeLink((LinkedCacheKey)key).getObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LinkedCacheKey removeLink(LinkedCacheKey key) {
        if (key == null) {
            return key;
        }
        LinkedCacheKey linkedCacheKey = this.first;
        synchronized (linkedCacheKey) {
            if (key.getPrevious() == null || key.getNext() == null) {
                return key;
            }
            key.getPrevious().setNext(key.getNext());
            key.getNext().setPrevious(key.getPrevious());
            key.setNext(null);
            key.setPrevious(null);
        }
        return key;
    }

    public synchronized void updateMaxSize(int maxSize) {
        this.setMaxSize(maxSize);
        this.ensureFixedSize();
    }
}

