/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands;

import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.util.misc.ExceptionUtil;
import com.sun.enterprise.cli.commands.S1ASCommand;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.RuntimeOperationsException;

public class AMXListResourcesCommand
extends S1ASCommand {
    public static final String DOMAIN_CONFIG_OBJECT_NAME = "amx:j2eeType=X-DomainConfig,name=na";
    public static final String SERVER_CONFIG_OBJECT_NAME = "amx:j2eeType=X-StandaloneServerConfig,name=";
    public static final String CLUSTER_CONFIG_OBJECT_NAME = "amx:j2eeType=X-ClusterConfig,name=";
    public static final String TARGET_NAME = "target";

    public boolean validateOptions() throws CommandValidationException {
        return super.validateOptions();
    }

    public void runCommand() throws CommandException, CommandValidationException {
        if (!this.validateOptions()) {
            throw new CommandValidationException("Validation is false");
        }
        MBeanServerConnection mbsc = this.getMBeanServerConnection(this.getHost(), this.getPort(), this.getUser(), this.getPassword());
        Vector vTargetName = this.getOperands();
        String targetName = vTargetName.size() > 0 ? (String)vTargetName.get(0) : null;
        ObjectName targetON = targetName != null && !targetName.equals("domain") ? this.getTargetConfigObjectName(mbsc, targetName) : null;
        Object[] params = this.getParamsInfo();
        String operationName = this.getOperationName();
        String[] types = this.getTypesInfo();
        String j2eeType = (String)((Vector)this.getProperty("params")).get(0);
        try {
            Object resources = mbsc.invoke(Util.newObjectName((String)DOMAIN_CONFIG_OBJECT_NAME), operationName, params, types);
            Map candidates = (Map)resources;
            if (targetON != null) {
                candidates = this.getResourcesFromTarget(mbsc, targetON, candidates);
            }
            this.displayMap("", candidates);
            CLILogger.getInstance().printDetailMessage(this.getLocalizedString("CommandSuccessful", new Object[]{this.name}));
        }
        catch (Exception e) {
            this.displayExceptionMessage(e);
        }
    }

    private Map getResourcesFromTarget(MBeanServerConnection mbsc, ObjectName targetON, Map candidates) throws Exception {
        Object resourceRefs = mbsc.invoke(targetON, "getContaineeObjectNameMap", new Object[]{new String("X-ResourceRefConfig")}, new String[]{"java.lang.String"});
        Set resourceKeySet = ((Map)resourceRefs).keySet();
        Iterator resourceKeyIter = resourceKeySet.iterator();
        HashMap resMap = new HashMap();
        while (resourceKeyIter.hasNext()) {
            String valueName = (String)resourceKeyIter.next();
            CLILogger.getInstance().printDebugMessage("Candidate = " + valueName);
            if (!candidates.containsKey(valueName)) continue;
            resMap.put(valueName, candidates.get(valueName));
        }
        return resMap;
    }

    public void displayExceptionMessage(Exception e) throws CommandException {
        Throwable rootException = ExceptionUtil.getRootCause((Throwable)e);
        if (rootException.getLocalizedMessage() != null) {
            CLILogger.getInstance().printDetailMessage(rootException.getLocalizedMessage());
        }
        throw new CommandException(this.getLocalizedString("CommandUnSuccessful", new Object[]{this.name}), e);
    }

    private ObjectName getTargetConfigObjectName(MBeanServerConnection mbsc, String targetName) throws CommandException {
        try {
            ObjectName scON = Util.newObjectName((String)(SERVER_CONFIG_OBJECT_NAME + targetName));
            if (!mbsc.isRegistered(scON)) {
                scON = Util.newObjectName((String)(CLUSTER_CONFIG_OBJECT_NAME + targetName));
            }
            if (!mbsc.isRegistered(scON)) {
                throw new CommandException(this.getLocalizedString("InvalidTargetName"));
            }
            return scON;
        }
        catch (RuntimeOperationsException roe) {
            throw new CommandException(roe);
        }
        catch (IOException ioe) {
            throw new CommandException(ioe);
        }
    }

    private void displayMap(String msg, Map m) {
        Set keySet = m.keySet();
        if (keySet.isEmpty()) {
            CLILogger.getInstance().printDetailMessage(this.getLocalizedString("NoElementsToList"));
            return;
        }
        for (String valueName : keySet) {
            CLILogger.getInstance().printMessage(msg + " " + valueName);
        }
    }
}

