/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands;

import com.sun.enterprise.cli.commands.S1ASCommand;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.deployment.backend.DeploymentStatus;
import com.sun.enterprise.deployment.client.DeploymentFacility;
import com.sun.enterprise.deployment.client.DeploymentFacilityFactory;
import com.sun.enterprise.deployment.client.JESProgressObject;
import com.sun.enterprise.deployment.client.ServerConnectionIdentifier;
import java.util.Map;
import java.util.Properties;
import javax.enterprise.deploy.spi.Target;

public class UndeployCommand
extends S1ASCommand {
    private static final String CASCADE_OPTION = "cascade";
    private static final String DROPTABLES_OPTION = "droptables";
    private static final String TARGET_OPTION = "target";

    public void runCommand() throws CommandException, CommandValidationException {
        this.validateOptions();
        DeploymentFacility df = DeploymentFacilityFactory.getDeploymentFacility();
        ServerConnectionIdentifier conn = this.createServerConnectionIdentifier(this.getHost(), this.getPort(), this.getUser(), this.getPassword());
        df.connect(conn);
        String targetName = this.getOption(TARGET_OPTION);
        Map deployOptions = this.createDeploymentProperties();
        JESProgressObject progressObject = null;
        try {
            if (df.isConnected()) {
                CLILogger.getInstance().printDebugMessage("Calling the undeploy with DeployOptions");
                Target[] targets = df.createTargets(new String[]{targetName});
                if (targets == null) {
                    throw new CommandException(this.getLocalizedString("InvalidTarget", new Object[]{targetName}));
                }
                progressObject = df.undeploy(targets, this.getComponentName(), deployOptions);
            } else {
                CLILogger.getInstance().printError(this.getLocalizedString("CouldNotConnectToDAS"));
            }
        }
        catch (Exception e) {
            if (e.getLocalizedMessage() != null) {
                CLILogger.getInstance().printDetailMessage(e.getLocalizedMessage());
            }
            throw new CommandException(this.getLocalizedString("CommandUnSuccessful", new Object[]{this.name}), e);
        }
        DeploymentStatus status = df.waitFor(progressObject);
        String statusString = status.getStageStatusMessage();
        if (status != null && status.getStatus() == 0) {
            throw new CommandException(this.getLocalizedString("CommandUnSuccessfulWithMsg", new Object[]{this.name, statusString}));
        }
        if (status != null && status.getStatus() == 1) {
            CLILogger.getInstance().printDetailMessage(this.getLocalizedString("CommandSuccessfulWithMsg", new Object[]{this.name, statusString}));
        } else {
            CLILogger.getInstance().printDetailMessage(this.getLocalizedString("CommandSuccessful", new Object[]{this.name}));
        }
    }

    public boolean validateOptions() throws CommandValidationException {
        return super.validateOptions();
    }

    private String getComponentName() {
        return (String)this.getOperands().get(0);
    }

    private Map createDeploymentProperties() {
        Properties props = new Properties();
        String cascadeOption = this.getOption(CASCADE_OPTION);
        String dropTablesOption = this.getOption(DROPTABLES_OPTION);
        String target = this.getOption(TARGET_OPTION);
        if (props != null) {
            props.put(TARGET_OPTION, target);
        }
        props.put("name", this.getComponentName());
        if (cascadeOption != null) {
            props.put(CASCADE_OPTION, cascadeOption);
        }
        if (dropTablesOption != null) {
            props.put("CmpInfo.DROP_TABLES", dropTablesOption);
        }
        return props;
    }
}

