/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.framework;

import com.sun.enterprise.cli.framework.CLIEntityResolver;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.cli.framework.LocalStringsManager;
import com.sun.enterprise.cli.framework.LocalStringsManagerFactory;
import com.sun.enterprise.cli.framework.ValidCommand;
import com.sun.enterprise.cli.framework.ValidCommandsList;
import com.sun.enterprise.cli.framework.ValidOption;
import com.sun.org.apache.xerces.internal.parsers.DOMParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CLIDescriptorsReader {
    public static int DONT_SERIALIZE = 0;
    public static int SERIALIZE_COMMANDS_TO_FILES = 1;
    public static int SERIALIZE_COMMANDS_TO_FILE = 2;
    public static String SERIALIZED_DESCRIPTOR_FILE = ".CLIDescriptors";
    public static String SERIALIZED_COMMANDS_DEFAULT_DIR = "cli";
    public static String ENVIRONMENT_PREFIX = "environment-prefix";
    public static String ENVIRONMENT_FILENAME = "environment-filename";
    private static CLIDescriptorsReader cliDescriptorsReader;
    private String serializeDir = SERIALIZED_COMMANDS_DEFAULT_DIR;
    private int serializeDescriptors = DONT_SERIALIZE;
    private ValidCommandsList commandsList = null;
    private HashMap validOptions = null;
    private HashMap replaceOptions = null;
    private Vector descriptors = null;
    private Vector properties = null;
    private String defaultCommand = null;
    private String helpClass = null;
    private static String DESCRIPTOR_FILE_NAME;

    protected CLIDescriptorsReader() {
        this.initialize();
    }

    protected CLIDescriptorsReader(URL descriptor) {
        this.setDescriptor(descriptor);
        this.initialize();
    }

    protected CLIDescriptorsReader(Vector descriptors) {
        this.descriptors = descriptors;
        this.initialize();
    }

    private void initialize() {
        this.commandsList = new ValidCommandsList();
        this.validOptions = new HashMap();
        this.replaceOptions = new HashMap();
        this.properties = new Vector();
    }

    public static CLIDescriptorsReader getInstance() {
        if (cliDescriptorsReader == null) {
            cliDescriptorsReader = new CLIDescriptorsReader();
        }
        return cliDescriptorsReader;
    }

    public ValidCommand getCommand(String commandName) throws CommandValidationException {
        ValidCommand command = null;
        command = this.commandsList == null || this.commandsList.size() == 0 ? this.getCommandFromFileOrDescriptor(commandName) : this.commandsList.getValidCommand(commandName);
        return command;
    }

    public String getDefaultCommand() {
        return this.defaultCommand;
    }

    public String getHelpClass() {
        return this.helpClass;
    }

    public ValidCommandsList getCommandsList() throws CommandValidationException {
        if (this.commandsList == null || this.commandsList.size() == 0) {
            this.loadAllCommandsFromFilesOrDescriptors();
        }
        return this.commandsList;
    }

    public Iterator getProperties() throws CommandValidationException {
        return this.properties.iterator();
    }

    private ValidCommand getCommandFromFileOrDescriptor(String commandName) throws CommandValidationException {
        ValidCommand command = null;
        if (this.serializeDescriptors == SERIALIZE_COMMANDS_TO_FILES && (command = this.getSerializedCommand(commandName)) != null) {
            return command;
        }
        int saveSerializedDescriptor = this.getSerializeDescriptorsProperty();
        this.setSerializeDescriptorsProperty(DONT_SERIALIZE);
        this.loadAllCommandsFromFilesOrDescriptors();
        this.setSerializeDescriptorsProperty(saveSerializedDescriptor);
        if (commandName != null) {
            return this.commandsList.getValidCommand(commandName);
        }
        if (this.defaultCommand != null) {
            return this.commandsList.getValidCommand(this.defaultCommand);
        }
        throw new CommandValidationException(LocalStringsManagerFactory.getFrameworkLocalStringsManager().getString("CommandNotSpecified", null));
    }

    private ValidCommand getSerializedCommand(String commandName) throws CommandValidationException {
        ValidCommand command = null;
        String encodedCommandName = null;
        try {
            encodedCommandName = URLEncoder.encode(commandName, "UTF-8");
        }
        catch (UnsupportedEncodingException ue) {
            encodedCommandName = commandName;
        }
        InputStream in = CLIDescriptorsReader.class.getClassLoader().getResourceAsStream(this.serializeDir + "/." + encodedCommandName);
        if (in == null) {
            return null;
        }
        command = this.getSerializedCommand(in);
        return command;
    }

    private ValidCommand getSerializedCommand(InputStream commandFile) throws CommandValidationException {
        try {
            ValidCommand command = null;
            ObjectInputStream in = new ObjectInputStream(commandFile);
            this.defaultCommand = (String)in.readObject();
            this.helpClass = (String)in.readObject();
            this.properties = (Vector)in.readObject();
            command = (ValidCommand)in.readObject();
            CLILogger.getInstance().printDebugMessage("++++++++++++++++++++++++++++ Command loaded from file and it is " + command);
            return command;
        }
        catch (Exception e) {
            throw new CommandValidationException(e);
        }
    }

    private void loadAllCommandsFromFilesOrDescriptors() throws CommandValidationException {
        if (this.serializeDescriptors == DONT_SERIALIZE) {
            this.readDescriptors();
        } else if (this.serializeDescriptors == SERIALIZE_COMMANDS_TO_FILES) {
            this.loadCommandsFromMultipleFiles();
        } else if (this.serializeDescriptors == SERIALIZE_COMMANDS_TO_FILE) {
            this.loadCommandsFromSingleFile();
        }
    }

    private void loadCommandsFromMultipleFiles() throws CommandValidationException {
        File commandsDir = new File(this.serializeDir);
        if (commandsDir != null && commandsDir.exists() && this.getSerializedCommandsFileList(commandsDir).length > 0) {
            this.getDescriptors();
            if (this.descriptors == null) {
                LocalStringsManager lsm = LocalStringsManagerFactory.getFrameworkLocalStringsManager();
                throw new CommandValidationException(lsm.getString("NoDescriptorsDefined"));
            }
            boolean isSerializedCommandsLatest = true;
            for (int i = 0; i < this.descriptors.size() && isSerializedCommandsLatest; ++i) {
                URL descriptorURL = (URL)this.descriptors.get(i);
                File descriptorFile = this.getDescriptorFile(descriptorURL);
                if (descriptorFile == null || !descriptorFile.exists() || descriptorFile.lastModified() <= commandsDir.lastModified()) continue;
                isSerializedCommandsLatest = false;
                break;
            }
            if (isSerializedCommandsLatest) {
                if (!this.loadSerializedCommands()) {
                    this.readDescriptors();
                }
            } else {
                this.readDescriptors();
            }
        } else {
            this.readDescriptors();
        }
    }

    private void loadCommandsFromSingleFile() throws CommandValidationException {
        File serializedDescriptorFile = this.getSerializedDescriptorFile();
        if (serializedDescriptorFile.exists()) {
            CLILogger.getInstance().printDebugMessage("Yes the file exists");
        }
        if (serializedDescriptorFile == null || !serializedDescriptorFile.exists()) {
            this.readDescriptors();
            return;
        }
        this.getDescriptors();
        if (this.descriptors == null) {
            LocalStringsManager lsm = LocalStringsManagerFactory.getFrameworkLocalStringsManager();
            throw new CommandValidationException(lsm.getString("NoDescriptorsDefined"));
        }
        boolean isSerializedDescriptorLatest = true;
        for (int i = 0; i < this.descriptors.size() && isSerializedDescriptorLatest; ++i) {
            URL descriptorURL = (URL)this.descriptors.get(i);
            File descriptorFile = this.getDescriptorFile(descriptorURL);
            if (descriptorFile == null || !descriptorFile.exists() || descriptorFile.lastModified() <= serializedDescriptorFile.lastModified()) continue;
            isSerializedDescriptorLatest = false;
            break;
        }
        if (isSerializedDescriptorLatest) {
            this.loadSerializedDescriptorFile();
        } else {
            this.readDescriptors();
        }
    }

    private void readDescriptors() throws CommandValidationException {
        this.commandsList.removeAllCommands();
        try {
            DOMParser parser = new DOMParser();
            parser.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", true);
            parser.setFeature("http://xml.org/sax/features/validation", true);
            parser.setFeature("http://xml.org/sax/features/namespaces", true);
            parser.setFeature("http://apache.org/xml/features/validation/schema", true);
            parser.setFeature("http://apache.org/xml/features/dom/include-ignorable-whitespace", false);
            parser.setEntityResolver(new CLIEntityResolver());
            if (this.descriptors == null) {
                this.getDescriptors();
                if (this.descriptors == null) {
                    LocalStringsManager lsm = LocalStringsManagerFactory.getFrameworkLocalStringsManager();
                    throw new CommandValidationException(lsm.getString("NoDescriptorsDefined"));
                }
            }
            for (int i = 0; i < this.descriptors.size(); ++i) {
                URL descriptorURL = (URL)this.descriptors.get(i);
                parser.parse(new InputSource(descriptorURL.toString()));
                Document document = parser.getDocument();
                this.generateOptionsAndCommands(document);
            }
            this.replaceOptionsInCommandsList(this.replaceOptions);
            if (this.serializeDescriptors == SERIALIZE_COMMANDS_TO_FILES) {
                this.saveCommandsAsMultipleFiles();
            } else if (this.serializeDescriptors == SERIALIZE_COMMANDS_TO_FILE) {
                this.saveCommandsAsSingleFile();
            }
        }
        catch (SAXException sxe) {
            Exception x = sxe;
            if (sxe.getException() != null) {
                x = sxe.getException();
            }
            throw new CommandValidationException(x);
        }
        catch (IOException ioe) {
            throw new CommandValidationException(ioe);
        }
    }

    private String[] getSerializedCommandsFileList(File commandsDir) {
        String[] commandFiles = commandsDir.list(new FilenameFilter(){

            public boolean accept(File parentDir, String name) {
                return name.startsWith(".");
            }
        });
        return commandFiles;
    }

    private File getSerializedDescriptorFile() {
        File file = null;
        try {
            file = new File(this.serializeDir + "/" + SERIALIZED_DESCRIPTOR_FILE);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return file;
    }

    private File getDescriptorFile(URL descriptor) {
        File file = null;
        try {
            file = new File(descriptor.getFile());
            if (!file.exists()) {
                file = null;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return file;
    }

    private boolean loadSerializedCommands() throws CommandValidationException {
        File commandsDir = new File(this.serializeDir);
        if (commandsDir == null || !commandsDir.exists() || this.getSerializedCommandsFileList(commandsDir).length <= 0) {
            return false;
        }
        String[] commandFiles = this.getSerializedCommandsFileList(commandsDir);
        boolean loaded = true;
        for (int i = 0; i < commandFiles.length && loaded; ++i) {
            InputStream in = CLIDescriptorsReader.class.getClassLoader().getResourceAsStream(this.serializeDir + "/." + commandFiles[i]);
            try {
                ValidCommand command = this.getSerializedCommand(in);
                if (command != null) {
                    this.commandsList.addCommand(command);
                    continue;
                }
                loaded = false;
                continue;
            }
            catch (CommandValidationException e) {
                loaded = false;
                break;
            }
        }
        return loaded;
    }

    private void loadSerializedDescriptorFile() {
        try {
            File fileName = this.getSerializedDescriptorFile();
            ObjectInputStream in = new ObjectInputStream(new FileInputStream(fileName));
            this.defaultCommand = (String)in.readObject();
            this.helpClass = (String)in.readObject();
            this.properties = (Vector)in.readObject();
            this.commandsList = (ValidCommandsList)in.readObject();
            CLILogger.getInstance().printDebugMessage("++++++++++++++++++++++++++++ Commands loaded from file");
        }
        catch (FileNotFoundException fnfe) {
        }
        catch (IOException ioe) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private Vector getDescriptors() throws CommandValidationException {
        if (this.descriptors != null) {
            return this.descriptors;
        }
        try {
            Enumeration<URL> urls;
            String descriptor_file_name = System.getProperty("DESCRIPTOR_FILE");
            if (descriptor_file_name == null) {
                descriptor_file_name = DESCRIPTOR_FILE_NAME;
            }
            if ((urls = CLIDescriptorsReader.class.getClassLoader().getResources(descriptor_file_name)) == null || !urls.hasMoreElements()) {
                return this.descriptors;
            }
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                this.setDescriptor(url);
            }
        }
        catch (IOException ioe) {
            LocalStringsManager lsm = LocalStringsManagerFactory.getFrameworkLocalStringsManager();
            CLILogger.getInstance().printMessage(lsm.getString("CouldNotLoadDescriptor"));
        }
        return this.descriptors;
    }

    public void setDescriptor(URL descriptor) {
        if (descriptor != null) {
            if (this.descriptors == null) {
                this.descriptors = new Vector();
            }
            this.descriptors.add(descriptor);
            Collections.reverse(this.descriptors);
        }
    }

    public void setDescriptors(Vector descriptors) {
        this.descriptors = descriptors;
    }

    private void generateOptionsAndCommands(Document document) {
        if (document != null) {
            for (Node nextKid = document.getDocumentElement().getFirstChild(); nextKid != null; nextKid = nextKid.getNextSibling()) {
                String grandKidNodeName;
                Node grandKid;
                String nodeName = nextKid.getNodeName();
                if (nodeName.equalsIgnoreCase("CommandProperties")) {
                    Properties props = new Properties();
                    for (Node grandKid2 = nextKid.getFirstChild(); grandKid2 != null; grandKid2 = grandKid2.getNextSibling()) {
                        String grandKidNodeName2 = grandKid2.getNodeName();
                        if (!grandKidNodeName2.equalsIgnoreCase("CommandProperty")) continue;
                        NamedNodeMap nodeMap = grandKid2.getAttributes();
                        String nameAttr = nodeMap.getNamedItem("name").getNodeValue();
                        String valueAttr = nodeMap.getNamedItem("value").getNodeValue();
                        props.setProperty(nameAttr, valueAttr);
                    }
                    NamedNodeMap commandPropertiesAttribute = nextKid.getAttributes();
                    if (commandPropertiesAttribute != null && commandPropertiesAttribute.getNamedItem("defaultcommand") != null) {
                        this.defaultCommand = commandPropertiesAttribute.getNamedItem("defaultcommand").getNodeValue();
                    }
                    if (commandPropertiesAttribute != null && commandPropertiesAttribute.getNamedItem("helpclass") != null) {
                        this.helpClass = commandPropertiesAttribute.getNamedItem("helpclass").getNodeValue();
                    }
                    this.properties.add(props);
                    continue;
                }
                if (nodeName.equalsIgnoreCase("Options")) {
                    for (grandKid = nextKid.getFirstChild(); grandKid != null; grandKid = grandKid.getNextSibling()) {
                        ValidOption option;
                        grandKidNodeName = grandKid.getNodeName();
                        if (grandKidNodeName.equalsIgnoreCase("Option")) {
                            option = this.generateOption(document, grandKid);
                            this.validOptions.put(option.getName(), option);
                            continue;
                        }
                        if (!grandKidNodeName.equalsIgnoreCase("ReplaceOption")) continue;
                        option = this.generateOption(document, grandKid);
                        this.replaceOptions.put(option.getName(), option);
                    }
                    continue;
                }
                if (!nodeName.equalsIgnoreCase("Commands")) continue;
                for (grandKid = nextKid.getFirstChild(); grandKid != null; grandKid = grandKid.getNextSibling()) {
                    grandKidNodeName = grandKid.getNodeName();
                    if (!grandKidNodeName.equalsIgnoreCase("Command")) continue;
                    ValidCommand command = this.generateCommand(document, grandKid);
                    this.commandsList.addCommand(command);
                }
            }
        }
    }

    private ValidOption generateOption(Document document, Node grandKid) {
        ValidOption option = new ValidOption();
        NamedNodeMap nodeMap = grandKid.getAttributes();
        String nameAttr = nodeMap.getNamedItem("name").getNodeValue();
        String typeAttr = nodeMap.getNamedItem("type").getNodeValue();
        boolean valueReqdAttr = Boolean.valueOf(nodeMap.getNamedItem("value-required").getNodeValue());
        Node defaultAttrNode = nodeMap.getNamedItem("default");
        String defaultAttr = null;
        if (defaultAttrNode != null) {
            defaultAttr = defaultAttrNode.getNodeValue();
        }
        option.setName(nameAttr);
        option.setType(typeAttr);
        option.setRequired(valueReqdAttr ? 1 : 2);
        option.setDefaultValue(defaultAttr);
        for (Node nextGrandKid = grandKid.getFirstChild(); nextGrandKid != null; nextGrandKid = nextGrandKid.getNextSibling()) {
            String grandKidName = nextGrandKid.getNodeName();
            if (!grandKidName.equalsIgnoreCase("shortoption")) continue;
            String shortOption = nextGrandKid.getFirstChild().getNodeValue();
            if ((shortOption = shortOption.trim()) == null) continue;
            option.setShortName(shortOption);
        }
        return option;
    }

    private ValidCommand generateCommand(Document document, Node grandKid) {
        ValidCommand command = new ValidCommand();
        NamedNodeMap nodeMap = grandKid.getAttributes();
        String nameAttr = nodeMap.getNamedItem("name").getNodeValue();
        String classNameAttr = nodeMap.getNamedItem("classname").getNodeValue();
        String numberOfOperandsAttr = nodeMap.getNamedItem("numberofoperands").getNodeValue();
        String defaultOperandAttr = null;
        if (nodeMap.getNamedItem("defaultoperand") != null) {
            defaultOperandAttr = nodeMap.getNamedItem("defaultoperand").getNodeValue();
        }
        Node usageTextNode = nodeMap.getNamedItem("usage-text");
        String usageTextAttr = null;
        if (usageTextNode != null) {
            usageTextAttr = usageTextNode.getNodeValue();
        }
        command.setName(nameAttr);
        command.setNumberOfOperands(numberOfOperandsAttr);
        command.setDefaultOperand(defaultOperandAttr);
        command.setClassName(classNameAttr);
        command.setUsageText(usageTextAttr);
        for (Node nextGrandKid = grandKid.getFirstChild(); nextGrandKid != null; nextGrandKid = nextGrandKid.getNextSibling()) {
            String deprecatedOption;
            String grandKidName = nextGrandKid.getNodeName();
            if (grandKidName.equalsIgnoreCase("ValidOption")) {
                ValidOption option;
                NamedNodeMap validOptionNodeMap = nextGrandKid.getAttributes();
                String validOption = validOptionNodeMap.getNamedItem("name").getNodeValue();
                deprecatedOption = null;
                if (validOptionNodeMap.getNamedItem("deprecatedoption") != null) {
                    deprecatedOption = validOptionNodeMap.getNamedItem("deprecatedoption").getNodeValue();
                }
                String defaultValue = null;
                if (validOptionNodeMap.getNamedItem("defaultvalue") != null) {
                    defaultValue = validOptionNodeMap.getNamedItem("defaultvalue").getNodeValue();
                }
                if ((option = this.findOption(validOption)) == null) {
                    CLILogger.getInstance().printDebugMessage("Valid option (" + validOption + ")is not found in xml : " + command.getName());
                    return command;
                }
                ValidOption newOption = new ValidOption(option);
                if (deprecatedOption != null) {
                    newOption.setDeprecatedOption(deprecatedOption);
                }
                if (defaultValue != null) {
                    newOption.setDefaultValue(defaultValue);
                }
                command.addValidOption(newOption);
                continue;
            }
            if (grandKidName.equalsIgnoreCase("RequiredOption")) {
                ValidOption option;
                NamedNodeMap reqdOptionNodeMap = nextGrandKid.getAttributes();
                String reqdOption = reqdOptionNodeMap.getNamedItem("name").getNodeValue();
                deprecatedOption = null;
                if (reqdOptionNodeMap.getNamedItem("deprecatedoption") != null) {
                    deprecatedOption = reqdOptionNodeMap.getNamedItem("deprecatedoption").getNodeValue();
                }
                if ((option = this.findOption(reqdOption)) == null) {
                    CLILogger.getInstance().printDebugMessage("Required option (" + reqdOption + ")is not found in xml : " + command.getName());
                    return command;
                }
                if (deprecatedOption != null) {
                    option.setDeprecatedOption(deprecatedOption);
                }
                command.addRequiredOption(new ValidOption(option));
                continue;
            }
            if (grandKidName.equalsIgnoreCase("DeprecatedOption")) {
                String deprecatedOption2 = nextGrandKid.getFirstChild().getNodeValue();
                ValidOption option = this.findOption(deprecatedOption2);
                if (option == null) {
                    CLILogger.getInstance().printDebugMessage("Deprecated option (" + deprecatedOption2 + ")is not found in xml : " + command.getName());
                    return command;
                }
                command.addDeprecatedOption(option);
                continue;
            }
            if (!grandKidName.equalsIgnoreCase("properties")) continue;
            for (Node nextGreatGrandKid = nextGrandKid.getFirstChild(); nextGreatGrandKid != null; nextGreatGrandKid = nextGreatGrandKid.getNextSibling()) {
                String greatGrandKidName = nextGreatGrandKid.getNodeName();
                if (!greatGrandKidName.equalsIgnoreCase("property")) continue;
                nodeMap = nextGreatGrandKid.getAttributes();
                String propertyNameAttr = nodeMap.getNamedItem("name").getNodeValue();
                Vector<String> values = new Vector<String>();
                for (Node nextGreatGreatGrandKid = nextGreatGrandKid.getFirstChild(); nextGreatGreatGrandKid != null; nextGreatGreatGrandKid = nextGreatGreatGrandKid.getNextSibling()) {
                    String greatGreatGrandKidName = nextGreatGreatGrandKid.getNodeName();
                    if (!greatGreatGrandKidName.equalsIgnoreCase("value")) continue;
                    String value = null;
                    if (nextGreatGreatGrandKid.getFirstChild() != null) {
                        value = nextGreatGreatGrandKid.getFirstChild().getNodeValue();
                    }
                    values.add(value);
                }
                command.setProperty(propertyNameAttr, values);
            }
        }
        return command;
    }

    private ValidOption findOption(String optionStr) {
        ValidOption option = null;
        option = (ValidOption)this.validOptions.get(optionStr);
        return option;
    }

    private void saveCommandsAsMultipleFiles() throws CommandValidationException {
        Iterator commands = this.commandsList.getCommands();
        while (commands.hasNext()) {
            try {
                ValidCommand command = (ValidCommand)commands.next();
                File file = new File(this.serializeDir);
                if (!file.exists()) {
                    file.mkdir();
                }
                String encodedCommandName = null;
                try {
                    encodedCommandName = URLEncoder.encode(command.getName(), "UTF-8");
                }
                catch (UnsupportedEncodingException ue) {
                    encodedCommandName = command.getName();
                }
                ObjectOutputStream os = new ObjectOutputStream(new FileOutputStream(this.serializeDir + "/." + encodedCommandName));
                os.writeObject(this.defaultCommand);
                os.writeObject(this.helpClass);
                os.writeObject(this.properties);
                os.writeObject(command);
            }
            catch (Exception e) {
                LocalStringsManager lsm = LocalStringsManagerFactory.getFrameworkLocalStringsManager();
                CLILogger.getInstance().printWarning(lsm.getString("CouldNotWriteCommandToFile", new Object[]{e.getMessage()}));
            }
        }
    }

    private void saveCommandsAsSingleFile() throws CommandValidationException {
        try {
            ObjectOutputStream os = new ObjectOutputStream(new FileOutputStream(this.serializeDir + "/" + SERIALIZED_DESCRIPTOR_FILE));
            os.writeObject(this.defaultCommand);
            os.writeObject(this.helpClass);
            os.writeObject(this.properties);
            os.writeObject(this.commandsList);
        }
        catch (Exception e) {
            LocalStringsManager lsm = LocalStringsManagerFactory.getFrameworkLocalStringsManager();
            CLILogger.getInstance().printWarning(lsm.getString("CouldNotWriteComponentToFile", new Object[]{e.getMessage()}));
        }
    }

    private int getSerializeDescriptorsProperty() {
        return this.serializeDescriptors;
    }

    public void setSerializeDescriptorsProperty(int serializeDescriptors) {
        if (serializeDescriptors <= 2 && serializeDescriptors >= 0) {
            this.serializeDescriptors = serializeDescriptors;
        }
    }

    public String getSerializeDir() {
        return this.serializeDir;
    }

    private void setSerializeDir(String serializeDir) throws CommandValidationException {
        try {
            File file = new File(serializeDir);
            if (file.exists()) {
                this.serializeDir = serializeDir;
            } else {
                LocalStringsManager lsm = LocalStringsManagerFactory.getFrameworkLocalStringsManager();
                CLILogger.getInstance().printWarning(lsm.getString("InvalidFilePath", new Object[]{serializeDir}));
            }
        }
        catch (NullPointerException npe) {
            LocalStringsManager lsm = LocalStringsManagerFactory.getFrameworkLocalStringsManager();
            throw new CommandValidationException(lsm.getString("CouldNoSetSerializeDirectory"), npe);
        }
    }

    private void replaceOptionsInCommandsList(HashMap replaceOptions) {
        for (String replaceOptionName : replaceOptions.keySet()) {
            Iterator commands = this.commandsList.getCommands();
            while (commands.hasNext()) {
                ValidCommand command = (ValidCommand)commands.next();
                if (!command.hasValidOption(replaceOptionName) && !command.hasRequiredOption(replaceOptionName) && !command.hasDeprecatedOption(replaceOptionName)) continue;
                command.replaceAllOptions((ValidOption)replaceOptions.get(replaceOptionName));
            }
        }
    }

    public String getEnvironmentPrefix() {
        if (this.properties != null) {
            for (int i = 0; i < this.properties.size(); ++i) {
                Properties props = (Properties)this.properties.get(i);
                String prefix = props.getProperty(ENVIRONMENT_PREFIX);
                if (prefix == null) continue;
                return prefix;
            }
        }
        return null;
    }

    public String getEnvironmentFileName() {
        if (this.properties != null) {
            for (int i = 0; i < this.properties.size(); ++i) {
                Properties props = (Properties)this.properties.get(i);
                String file = props.getProperty(ENVIRONMENT_FILENAME);
                if (file == null) continue;
                return file;
            }
        }
        return ".cliprefs";
    }

    public static void main(String[] args) {
        try {
            CLIDescriptorsReader cliDescriptorsReader = CLIDescriptorsReader.getInstance();
            cliDescriptorsReader.setSerializeDescriptorsProperty(SERIALIZE_COMMANDS_TO_FILES);
            Iterator iterator = cliDescriptorsReader.getCommandsList().getCommands();
        }
        catch (CommandValidationException cve) {
            System.out.println(cve.getLocalizedMessage());
        }
    }

    static {
        DESCRIPTOR_FILE_NAME = "CLIDescriptor.xml";
    }
}

