/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.framework;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;

public class CLIManFileFinder {
    private static final String[] sections = new String[]{"1", "1m", "2", "2m", "3", "3m", "4", "4m", "5", "5m", "6", "6m", "7", "7m", "8", "8m", "9", "9m"};
    private static final String HELPDIR = "help";

    public Reader getCommandManFile(String commandName) {
        return this.getCommandManFile(commandName, Locale.getDefault());
    }

    public Reader getCommandManFile(String commandName, Locale currentLocale) {
        return this.getCommandManFile(commandName, currentLocale, this.getClass().getClassLoader());
    }

    public Reader getCommandManFile(String commandName, Locale locale, ClassLoader classLoader) {
        if (commandName.length() == 0) {
            throw new IllegalArgumentException("Command name cannot be empty");
        }
        InputStream s = null;
        Iterator it = this.getPossibleLocations(commandName, locale);
        while (s == null && it.hasNext()) {
            s = classLoader.getResourceAsStream((String)it.next());
        }
        return s == null ? (InputStreamReader)null : new InputStreamReader(s);
    }

    Iterator getPossibleLocations(final String commandName, final Locale locale) {
        return new Iterator(){
            final String[] locales;
            int i;
            int j;
            {
                this.locales = CLIManFileFinder.this.getLocaleLocations(locale);
                this.i = 0;
                this.j = 0;
            }

            public boolean hasNext() {
                return this.i < this.locales.length && this.j < sections.length;
            }

            public Object next() throws NoSuchElementException {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                String result = CLIManFileFinder.HELPDIR + this.locales[this.i] + "/" + commandName + "." + sections[this.j++];
                if (this.j == sections.length) {
                    ++this.i;
                    if (this.i < this.locales.length) {
                        this.j = 0;
                    }
                }
                return result;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    String[] getLocaleLocations(Locale locale) {
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        ArrayList<String> l = new ArrayList<String>();
        l.add("");
        if (language != null && language.length() > 0) {
            l.add("/" + language);
            if (country != null && country.length() > 0) {
                l.add("/" + language + "/" + country);
                if (variant != null && variant.length() > 0) {
                    l.add("/" + language + "/" + country + "/" + variant);
                }
            }
        }
        Collections.reverse(l);
        return l.toArray(new String[0]);
    }
}

