/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.framework;

import com.sun.enterprise.cli.framework.CLIDescriptorsReader;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CliUtil;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.cli.framework.ICommandEnvironment;
import com.sun.enterprise.cli.framework.LocalStringsManager;
import com.sun.enterprise.cli.framework.LocalStringsManagerFactory;
import java.util.HashMap;
import java.util.Map;

public class CommandEnvironment
implements ICommandEnvironment {
    private static CommandEnvironment commandEnvironment;
    private static final String ENVIRONMENT_PREFIX = "AS_ADMIN_";
    private HashMap environments = (HashMap)this.getSystemEnvironment();

    protected CommandEnvironment() {
    }

    private Map getSystemEnvironmentNative() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            CLIDescriptorsReader cdr = CLIDescriptorsReader.getInstance();
            String envPrefix = cdr.getEnvironmentPrefix();
            envPrefix = envPrefix == null ? ENVIRONMENT_PREFIX : envPrefix;
            String[] strArray = new CliUtil().getEnv(envPrefix);
            for (int ii = 0; ii < strArray.length; ++ii) {
                int index = strArray[ii].indexOf("=");
                String sOptionName = strArray[ii].substring(envPrefix.length(), index).toLowerCase();
                hashMap.put(sOptionName.replace('_', '-'), strArray[ii].substring(index + 1));
            }
        }
        catch (UnsatisfiedLinkError e) {
            CLILogger.getInstance().printDebugMessage(e.getLocalizedMessage());
            CLILogger.getInstance().printWarning(this.getLocalizedString("UnableToReadEnv"));
        }
        return hashMap;
    }

    private Map getSystemEnvironment() {
        CLIDescriptorsReader cdr = CLIDescriptorsReader.getInstance();
        String sPrefix = cdr.getEnvironmentPrefix();
        sPrefix = sPrefix == null ? ENVIRONMENT_PREFIX : sPrefix;
        Map<String, String> mEnv = System.getenv();
        HashMap<String, String> hmEnv = new HashMap<String, String>();
        for (String sEnvKey : mEnv.keySet()) {
            if (!sEnvKey.startsWith(sPrefix)) continue;
            String sOptionName = sEnvKey.substring(sPrefix.length()).toLowerCase();
            hmEnv.put(sOptionName.replace('_', '-'), mEnv.get(sEnvKey));
        }
        return hmEnv;
    }

    public static CommandEnvironment getInstance() {
        if (commandEnvironment == null) {
            commandEnvironment = new CommandEnvironment();
        }
        return commandEnvironment;
    }

    public void setEnvironment(String name, String value) {
        if (this.environments.containsKey(name)) {
            this.environments.remove(name);
        }
        this.environments.put(name, value);
    }

    public Object removeEnvironment(String name) {
        return this.environments.remove(name);
    }

    public Object getEnvironmentValue(String key) {
        return this.environments.get(key);
    }

    public HashMap getEnvironments() {
        return this.environments;
    }

    public String toString() {
        String description = "";
        for (String environKey : this.environments.keySet()) {
            description = description + " " + environKey + " = " + (String)this.environments.get(environKey);
        }
        return description;
    }

    public int getNumEnvironments() {
        return this.environments.size();
    }

    private String getLocalizedString(String key) {
        try {
            LocalStringsManager lsm = LocalStringsManagerFactory.getFrameworkLocalStringsManager();
            return lsm.getString(key);
        }
        catch (CommandValidationException cve) {
            return LocalStringsManager.DEFAULT_STRING_VALUE;
        }
    }
}

