/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.ejb.ejbqlc;

import com.sun.jdo.spi.persistence.support.ejb.ejbqlc.EJBQLAST;
import com.sun.jdo.spi.persistence.support.ejb.ejbqlc.ErrorMsg;
import com.sun.jdo.spi.persistence.support.ejb.ejbqlc.IdentificationVariable;
import com.sun.jdo.spi.persistence.support.ejb.ejbqlc.ParameterSupport;
import com.sun.jdo.spi.persistence.support.ejb.ejbqlc.SemanticTokenTypes;
import com.sun.jdo.spi.persistence.support.ejb.ejbqlc.SymbolTable;
import com.sun.jdo.spi.persistence.support.ejb.ejbqlc.TypeSupport;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Set;
import persistence.antlr.ASTPair;
import persistence.antlr.NoViableAltException;
import persistence.antlr.RecognitionException;
import persistence.antlr.TreeParser;
import persistence.antlr.collections.AST;
import persistence.antlr.collections.impl.BitSet;

public class Semantic
extends TreeParser
implements SemanticTokenTypes {
    protected SymbolTable symtab;
    protected TypeSupport typeSupport;
    protected ParameterSupport paramSupport;
    protected Method method;
    protected int resultTypeMapping;
    protected boolean finderNotSelector;
    protected boolean isAggregate = false;
    protected String ejbName;
    protected static final ResourceBundle msgs = I18NHelper.loadBundle(Semantic.class);
    public static final String[] _tokenNames = new String[]{"<0>", "EOF", "<2>", "NULL_TREE_LOOKAHEAD", "\"select\"", "\"from\"", "\"where\"", "\"distinct\"", "\"object\"", "\"null\"", "\"true\"", "\"false\"", "\"not\"", "\"and\"", "\"or\"", "\"between\"", "\"like\"", "\"in\"", "\"as\"", "\"unknown\"", "\"empty\"", "\"member\"", "\"of\"", "\"is\"", "\"escape\"", "\"concat\"", "\"substring\"", "\"locate\"", "\"length\"", "\"abs\"", "\"sqrt\"", "\"mod\"", "\"avg\"", "\"max\"", "\"min\"", "\"sum\"", "\"count\"", "\"order\"", "\"by\"", "\"asc\"", "\"desc\"", "EQUAL", "NOT_EQUAL", "GE", "GT", "LE", "LT", "PLUS", "MINUS", "STAR", "DIV", "STRING_LITERAL", "INT_LITERAL", "LONG_LITERAL", "FLOAT_LITERAL", "DOUBLE_LITERAL", "an identifier", "DOT", "INPUT_PARAMETER", "LPAREN", "RPAREN", "COMMA", "WS", "HEX_DIGIT", "EXPONENT", "FLOAT_SUFFIX", "UNICODE_DIGIT", "UNICODE_STR", "NEWLINE", "ESC", "FLOATINGPOINT_SUFFIX", "UNICODE_ESCAPE", "QUERY", "RANGE", "CMP_FIELD_ACCESS", "SINGLE_CMR_FIELD_ACCESS", "COLLECTION_CMR_FIELD_ACCESS", "IDENTIFICATION_VAR", "IDENTIFICATION_VAR_DECL", "ABSTRACT_SCHEMA_NAME", "CMP_FIELD", "SINGLE_CMR_FIELD", "COLLECTION_CMR_FIELD", "UNARY_MINUS", "UNARY_PLUS", "NOT_BETWEEN", "NOT_LIKE", "NOT_IN", "NOT_NULL", "NOT_EMPTY", "NOT_MEMBER"};
    public static final BitSet _tokenSet_0 = new BitSet(Semantic.mk_tokenSet_0());

    public void init(TypeSupport typeSupport, ParameterSupport paramSupport, Method method, int resultTypeMapping, boolean finderNotSelector, String ejbName) {
        this.symtab = new SymbolTable();
        this.typeSupport = typeSupport;
        this.paramSupport = paramSupport;
        this.method = method;
        this.resultTypeMapping = resultTypeMapping;
        this.finderNotSelector = finderNotSelector;
        this.ejbName = ejbName;
    }

    public void reportError(RecognitionException ex) {
        ErrorMsg.fatal(I18NHelper.getMessage(msgs, "ERR_SemanticError"), ex);
    }

    public void reportError(String s) {
        ErrorMsg.fatal(I18NHelper.getMessage(msgs, "ERR_SemanticError") + s);
    }

    private void checkFinderReturnType(Class returnType, Object selectClauseTypeInfo) {
        String selectClauseTypeName = TypeSupport.getTypeName(selectClauseTypeInfo);
        Object returnTypeInfo = this.typeSupport.getTypeInfo(returnType);
        if (returnType != Collection.class && returnType != Enumeration.class && !this.typeSupport.isRemoteInterfaceOfEjb(returnTypeInfo, this.ejbName) && !this.typeSupport.isLocalInterfaceOfEjb(returnTypeInfo, this.ejbName)) {
            ErrorMsg.error(I18NHelper.getMessage(msgs, "EXC_InvalidFinderReturnType", returnType.getName()));
        }
        if (!selectClauseTypeName.equals(this.ejbName)) {
            ErrorMsg.error(I18NHelper.getMessage(msgs, "EXC_InvalidFinderSelectClauseType", selectClauseTypeName));
        }
    }

    private boolean isCompatibleSelectorSelectorReturnType(Object returnTypeInfo, Object selectClauseTypeInfo) {
        if (this.isAggregate) {
            return this.getCommonOperandType(selectClauseTypeInfo, returnTypeInfo) != TypeSupport.errorType;
        }
        return this.typeSupport.isCompatibleWith(selectClauseTypeInfo, returnTypeInfo);
    }

    private void checkSelectorReturnType(Class returnType, Object selectClauseTypeInfo) {
        String selectClauseTypeName = TypeSupport.getTypeName(selectClauseTypeInfo);
        Object returnTypeInfo = this.typeSupport.getTypeInfo(returnType);
        if (returnType != Collection.class && returnType != Set.class && !this.isCompatibleSelectorSelectorReturnType(returnTypeInfo, selectClauseTypeInfo)) {
            ErrorMsg.error(I18NHelper.getMessage(msgs, "EXC_InvalidSelectorReturnType", TypeSupport.getTypeName(returnTypeInfo), selectClauseTypeName));
        }
    }

    private void checkFinderResultTypeMapping() {
        if (this.resultTypeMapping != 2) {
            ErrorMsg.error(I18NHelper.getMessage(msgs, "EXC_InvalidResultTypeMappingForFinder"));
        }
    }

    private void checkSelectorResultTypeMapping(Class returnType, Object selectClauseTypeInfo) {
        Object returnTypeInfo = this.typeSupport.getTypeInfo(returnType);
        if (this.typeSupport.isCollectionType(returnTypeInfo) && this.typeSupport.isEjbName(selectClauseTypeInfo)) {
            if (this.resultTypeMapping == 1) {
                if (!this.typeSupport.hasRemoteInterface(selectClauseTypeInfo)) {
                    ErrorMsg.error(I18NHelper.getMessage(msgs, "EXC_InvalidRemoteResultTypeMappingForMultiSelector", selectClauseTypeInfo));
                }
            } else if (!this.typeSupport.hasLocalInterface(selectClauseTypeInfo)) {
                ErrorMsg.error(I18NHelper.getMessage(msgs, "EXC_InvalidLocalResultTypeMappingForMultiSelector", selectClauseTypeInfo));
            }
        } else if (this.typeSupport.isRemoteInterface(returnTypeInfo)) {
            if (this.resultTypeMapping != 1) {
                ErrorMsg.error(I18NHelper.getMessage(msgs, "EXC_InvalidLocalResultTypeMappingForSingleSelector"));
            }
        } else if (this.typeSupport.isLocalInterface(returnTypeInfo)) {
            if (this.resultTypeMapping == 1) {
                ErrorMsg.error(I18NHelper.getMessage(msgs, "EXC_InvalidRemoteResultTypeMappingForSingleSelector"));
            }
        } else if (this.resultTypeMapping != 2) {
            ErrorMsg.error(I18NHelper.getMessage(msgs, "EXC_InvalidResultTypeMappingForSelector", selectClauseTypeInfo));
        }
    }

    private void checkSelectOrderbyClause(EJBQLAST select, EJBQLAST orderby) {
        if (orderby == null) {
            return;
        }
        AST selectReturnAST = select.getFirstChild();
        if (selectReturnAST.getType() == 7) {
            selectReturnAST = selectReturnAST.getNextSibling();
        }
        if (selectReturnAST.getType() == 74) {
            StringBuffer buf = new StringBuffer();
            this.genPathExpression(selectReturnAST, buf);
            String selectReturnPathExpr = buf.toString();
            AST sibling = orderby.getFirstChild();
            while (sibling != null) {
                buf.setLength(0);
                this.genPathExpression(sibling, buf);
                String siblingPathExpr = buf.toString();
                if (!selectReturnPathExpr.equals(siblingPathExpr)) {
                    ErrorMsg.error(I18NHelper.getMessage(msgs, "EXC_InvalidOrderbyItemForCMPSelect", siblingPathExpr));
                }
                sibling = sibling.getNextSibling().getNextSibling();
            }
        } else {
            AST abstractSchemaAST = null;
            if (selectReturnAST.getType() == 75) {
                abstractSchemaAST = selectReturnAST;
            } else if (selectReturnAST.getType() == 8) {
                abstractSchemaAST = selectReturnAST.getFirstChild();
            } else {
                ErrorMsg.error(I18NHelper.getMessage(msgs, "EXC_InvalidAggregateOrderby"));
            }
            StringBuffer buf = new StringBuffer();
            this.genPathExpression(abstractSchemaAST, buf);
            String abstractSchemaExpr = buf.toString();
            AST sibling = orderby.getFirstChild();
            while (sibling != null) {
                buf.setLength(0);
                this.genPathExpression(sibling.getFirstChild(), buf);
                String siblingRootExpr = buf.toString();
                if (!abstractSchemaExpr.equals(siblingRootExpr)) {
                    buf.setLength(0);
                    this.genPathExpression(sibling, buf);
                    ErrorMsg.error(I18NHelper.getMessage(msgs, "EXC_InvalidOrderbyItem", buf.toString()));
                }
                sibling = sibling.getNextSibling().getNextSibling();
            }
        }
    }

    private void genPathExpression(AST ast, StringBuffer buf) {
        if (ast == null) {
            return;
        }
        switch (ast.getType()) {
            case 74: 
            case 75: 
            case 76: {
                AST left = ast.getFirstChild();
                AST right = left.getNextSibling();
                this.genPathExpression(left, buf);
                buf.append('.');
                this.genPathExpression(right, buf);
                break;
            }
            default: {
                buf.append(ast.getText());
            }
        }
    }

    private Object analyseConditionalExpr(EJBQLAST op, EJBQLAST leftAST, EJBQLAST rightAST) {
        Object right;
        Object left;
        block6: {
            block5: {
                left = leftAST.getTypeInfo();
                right = rightAST.getTypeInfo();
                if (TypeSupport.isErrorType(left)) break block5;
                if (!TypeSupport.isErrorType(right)) break block6;
            }
            return TypeSupport.errorType;
        }
        if (TypeSupport.isBooleanType(left)) {
            if (TypeSupport.isBooleanType(right)) {
                Object common = TypeSupport.booleanType;
                return common;
            }
        }
        ErrorMsg.error(op.getLine(), op.getColumn(), I18NHelper.getMessage(msgs, "EXC_InvalidArguments", op.getText()));
        return TypeSupport.errorType;
    }

    private Object analyseEqualityExpr(EJBQLAST op, EJBQLAST leftAST, EJBQLAST rightAST) {
        Object right;
        Object left;
        block14: {
            block13: {
                left = leftAST.getTypeInfo();
                right = rightAST.getTypeInfo();
                if (TypeSupport.isErrorType(left)) break block13;
                if (!TypeSupport.isErrorType(right)) break block14;
            }
            return TypeSupport.errorType;
        }
        if (this.isLiteral(leftAST)) {
            ErrorMsg.error(leftAST.getLine(), leftAST.getColumn(), I18NHelper.getMessage(msgs, "EXC_InvalidLHSLiteral", leftAST.getText(), op.getText()));
            return TypeSupport.errorType;
        }
        if (this.isInputParameter(leftAST)) {
            ErrorMsg.error(leftAST.getLine(), leftAST.getColumn(), I18NHelper.getMessage(msgs, "EXC_InvalidLHSParameter", leftAST.getText(), op.getText()));
            return TypeSupport.errorType;
        }
        if (TypeSupport.isNumberType(left)) {
            if (TypeSupport.isNumberType(right)) {
                return TypeSupport.booleanType;
            }
        }
        if (TypeSupport.isStringType(left)) {
            if (TypeSupport.isStringType(right)) {
                return TypeSupport.booleanType;
            }
        }
        if (this.typeSupport.isDateTimeType(left) && this.typeSupport.isDateTimeType(right)) {
            return TypeSupport.booleanType;
        }
        if (this.isEntityBeanValue(leftAST) && this.isEntityBeanValue(rightAST) && (this.typeSupport.isCompatibleWith(left, right) || this.typeSupport.isCompatibleWith(right, left))) {
            String leftEjbName = (String)leftAST.getTypeInfo();
            return this.analyseParameterEjbName(rightAST, leftEjbName);
        }
        if (TypeSupport.isBooleanType(left)) {
            if (TypeSupport.isBooleanType(right)) {
                return TypeSupport.booleanType;
            }
        }
        ErrorMsg.error(op.getLine(), op.getColumn(), I18NHelper.getMessage(msgs, "EXC_InvalidArguments", op.getText()));
        return TypeSupport.errorType;
    }

    private Object analyseRelationalExpr(EJBQLAST op, EJBQLAST leftAST, EJBQLAST rightAST) {
        block12: {
            block11: {
                Object right;
                Object left;
                block10: {
                    block9: {
                        block8: {
                            left = leftAST.getTypeInfo();
                            right = rightAST.getTypeInfo();
                            if (TypeSupport.isErrorType(left)) break block8;
                            if (!TypeSupport.isErrorType(right)) break block9;
                        }
                        return TypeSupport.errorType;
                    }
                    if (this.isLiteral(leftAST)) {
                        ErrorMsg.error(leftAST.getLine(), leftAST.getColumn(), I18NHelper.getMessage(msgs, "EXC_InvalidLHSLiteral", leftAST.getText(), op.getText()));
                        return TypeSupport.errorType;
                    }
                    if (this.isInputParameter(leftAST)) {
                        ErrorMsg.error(leftAST.getLine(), leftAST.getColumn(), I18NHelper.getMessage(msgs, "EXC_InvalidLHSParameter", leftAST.getText(), op.getText()));
                        return TypeSupport.errorType;
                    }
                    if (!TypeSupport.isNumberType(left)) break block10;
                    if (TypeSupport.isNumberType(right)) break block11;
                }
                if (this.typeSupport.isDateTimeType(left) && this.typeSupport.isDateTimeType(right)) break block11;
                if (!TypeSupport.isStringType(left)) break block12;
                if (!TypeSupport.isStringType(right)) break block12;
            }
            return TypeSupport.booleanType;
        }
        ErrorMsg.error(op.getLine(), op.getColumn(), I18NHelper.getMessage(msgs, "EXC_InvalidArguments", op.getText()));
        return TypeSupport.errorType;
    }

    private Object analyseBinaryArithmeticExpr(EJBQLAST op, EJBQLAST leftAST, EJBQLAST rightAST) {
        Object right;
        Object left;
        block7: {
            block6: {
                left = leftAST.getTypeInfo();
                right = rightAST.getTypeInfo();
                if (TypeSupport.isErrorType(left)) break block6;
                if (!TypeSupport.isErrorType(right)) break block7;
            }
            return TypeSupport.errorType;
        }
        if (TypeSupport.isNumberType(left)) {
            if (TypeSupport.isNumberType(right)) {
                Object common = this.getCommonOperandType(left, right);
                if (!TypeSupport.isErrorType(common)) {
                    return common;
                }
            }
        }
        ErrorMsg.error(op.getLine(), op.getColumn(), I18NHelper.getMessage(msgs, "EXC_InvalidArguments", op.getText()));
        return TypeSupport.errorType;
    }

    private Object getCommonOperandType(Object left, Object right) {
        block16: {
            block17: {
                block19: {
                    block18: {
                        block15: {
                            if (!TypeSupport.isNumberType(left)) break block15;
                            if (!TypeSupport.isNumberType(right)) break block15;
                            boolean wrapper = false;
                            if (TypeSupport.bigDecimalType.equals(left)) {
                                return left;
                            }
                            if (TypeSupport.bigDecimalType.equals(right)) {
                                return right;
                            }
                            if (TypeSupport.bigIntegerType.equals(left)) {
                                return TypeSupport.isFloatingPointType(right) ? TypeSupport.bigDecimalType : left;
                            }
                            if (TypeSupport.bigIntegerType.equals(right)) {
                                return TypeSupport.isFloatingPointType(left) ? TypeSupport.bigDecimalType : right;
                            }
                            if (TypeSupport.isNumericWrapperType(left)) {
                                left = TypeSupport.getPrimitiveType(left);
                                wrapper = true;
                            }
                            if (TypeSupport.isNumericWrapperType(right)) {
                                right = TypeSupport.getPrimitiveType(right);
                                wrapper = true;
                            }
                            if (TypeSupport.isNumericType(left)) {
                                if (TypeSupport.isNumericType(right)) {
                                    Object promotedType = TypeSupport.binaryNumericPromotion(left, right);
                                    if (wrapper) {
                                        promotedType = TypeSupport.getWrapperType(promotedType);
                                    }
                                    return promotedType;
                                }
                            }
                            break block16;
                        }
                        if (!TypeSupport.isBooleanType(left)) break block17;
                        if (!TypeSupport.isBooleanType(right)) break block17;
                        if (left.equals(TypeSupport.booleanClassType)) break block18;
                        if (!right.equals(TypeSupport.booleanClassType)) break block19;
                    }
                    return TypeSupport.booleanClassType;
                }
                return TypeSupport.booleanType;
            }
            if (this.typeSupport.isCompatibleWith(left, right)) {
                return right;
            }
            if (this.typeSupport.isCompatibleWith(right, left)) {
                return left;
            }
        }
        return TypeSupport.errorType;
    }

    private Object analyseUnaryArithmeticExpr(EJBQLAST op, EJBQLAST argAST) {
        Object arg = argAST.getTypeInfo();
        if (TypeSupport.isErrorType(arg)) {
            return arg;
        }
        if (TypeSupport.isNumberType(arg)) {
            boolean wrapper = false;
            if (TypeSupport.isNumericWrapperType(arg)) {
                arg = TypeSupport.getPrimitiveType(arg);
                wrapper = true;
            }
            Object promotedType = TypeSupport.unaryNumericPromotion(arg);
            if (wrapper) {
                promotedType = TypeSupport.getWrapperType(promotedType);
            }
            return promotedType;
        }
        ErrorMsg.error(op.getLine(), op.getColumn(), I18NHelper.getMessage(msgs, "EXC_InvalidArguments", op.getText()));
        return TypeSupport.errorType;
    }

    private Object analyseCollectionValuedCMRField(EJBQLAST fieldAccess) {
        if (fieldAccess.getType() != 76) {
            ErrorMsg.fatal(I18NHelper.getMessage(msgs, "ERR_InvalidPathExpr"));
            return TypeSupport.errorType;
        }
        EJBQLAST classExpr = (EJBQLAST)fieldAccess.getFirstChild();
        EJBQLAST field = (EJBQLAST)classExpr.getNextSibling();
        Object fieldInfo = this.typeSupport.getFieldInfo(classExpr.getTypeInfo(), field.getText());
        return this.typeSupport.getElementType(fieldInfo);
    }

    private Object analyseMemberExpr(EJBQLAST op, EJBQLAST value, EJBQLAST col) {
        Object elementTypeInfo;
        Object valueTypeInfo;
        block5: {
            block4: {
                valueTypeInfo = value.getTypeInfo();
                elementTypeInfo = this.analyseCollectionValuedCMRField(col);
                if (TypeSupport.isErrorType(valueTypeInfo)) break block4;
                if (!TypeSupport.isErrorType(elementTypeInfo)) break block5;
            }
            return TypeSupport.errorType;
        }
        if (this.typeSupport.isCompatibleWith(valueTypeInfo, elementTypeInfo) || this.typeSupport.isCompatibleWith(elementTypeInfo, valueTypeInfo)) {
            return this.analyseParameterEjbName(value, (String)elementTypeInfo);
        }
        ErrorMsg.error(op.getLine(), op.getColumn(), I18NHelper.getMessage(msgs, "EXC_CollectionElementTypeMismatch", TypeSupport.getTypeName(elementTypeInfo), TypeSupport.getTypeName(valueTypeInfo)));
        return TypeSupport.errorType;
    }

    private Object analyseInCollectionElement(EJBQLAST elementAST, Object valueTypeInfo) {
        Object elementTypeInfo;
        block5: {
            block4: {
                elementTypeInfo = elementAST.getTypeInfo();
                if (TypeSupport.isErrorType(valueTypeInfo)) break block4;
                if (!TypeSupport.isErrorType(elementTypeInfo)) break block5;
            }
            return TypeSupport.errorType;
        }
        Object common = this.getCommonOperandType(elementTypeInfo, valueTypeInfo);
        if (!TypeSupport.isErrorType(common) && elementTypeInfo.equals(common)) {
            return common;
        }
        ErrorMsg.error(elementAST.getLine(), elementAST.getColumn(), I18NHelper.getMessage(msgs, "EXC_CollectionElementTypeMismatch", TypeSupport.getTypeName(valueTypeInfo), TypeSupport.getTypeName(elementTypeInfo)));
        return TypeSupport.errorType;
    }

    private Object analyseParameterEjbName(EJBQLAST paramAST, String ejbName) {
        if (this.isInputParameter(paramAST)) {
            String paramName = paramAST.getText();
            String paramEjbName = this.paramSupport.getParameterEjbName(paramName);
            if (paramEjbName != null && !paramEjbName.equals(ejbName)) {
                ErrorMsg.error(paramAST.getLine(), paramAST.getColumn(), I18NHelper.getMessage(msgs, "EXC_MultipleEJBNameParameter", paramName, ejbName, paramEjbName));
                return TypeSupport.errorType;
            }
            this.paramSupport.setParameterEjbName(paramName, ejbName);
        }
        return TypeSupport.booleanType;
    }

    private boolean isEntityBeanValue(EJBQLAST ast) {
        switch (ast.getType()) {
            case 75: 
            case 77: {
                return true;
            }
            case 58: {
                Object typeInfo = ast.getTypeInfo();
                return this.typeSupport.isEjbOrInterfaceName(typeInfo);
            }
        }
        return false;
    }

    private boolean isLiteral(EJBQLAST ast) {
        int tokenType = ast.getType();
        return tokenType == 52 || tokenType == 53 || tokenType == 51 || tokenType == 54 || tokenType == 55 || tokenType == 10 || tokenType == 11;
    }

    private boolean isInputParameter(EJBQLAST ast) {
        return ast.getType() == 58;
    }

    private boolean isStringExpr(EJBQLAST expr) {
        Object exprType = expr.getTypeInfo();
        if (TypeSupport.isErrorType(exprType)) {
            return true;
        }
        if (!TypeSupport.isStringType(exprType)) {
            ErrorMsg.error(expr.getLine(), expr.getColumn(), I18NHelper.getMessage(msgs, "EXC_StringExprExpected", TypeSupport.getTypeName(exprType)));
            return false;
        }
        return true;
    }

    private boolean isIntExpr(EJBQLAST expr) {
        Object exprType = expr.getTypeInfo();
        if (TypeSupport.isErrorType(exprType)) {
            return true;
        }
        if (!TypeSupport.isIntType(exprType)) {
            ErrorMsg.error(expr.getLine(), expr.getColumn(), I18NHelper.getMessage(msgs, "EXC_IntExprExpected", TypeSupport.getTypeName(exprType)));
            return false;
        }
        return true;
    }

    private boolean isDoubleExpr(EJBQLAST expr) {
        Object exprType = expr.getTypeInfo();
        if (TypeSupport.isErrorType(exprType)) {
            return true;
        }
        if (!TypeSupport.isDoubleType(exprType)) {
            ErrorMsg.error(expr.getLine(), expr.getColumn(), I18NHelper.getMessage(msgs, "EXC_DoubleExprExpected", TypeSupport.getTypeName(exprType)));
            return false;
        }
        return true;
    }

    private boolean isNumberExpr(EJBQLAST expr) {
        Object exprType = expr.getTypeInfo();
        if (TypeSupport.isErrorType(exprType)) {
            return true;
        }
        if (!TypeSupport.isNumberType(exprType)) {
            ErrorMsg.error(expr.getLine(), expr.getColumn(), I18NHelper.getMessage(msgs, "EXC_NumberExprExpected", TypeSupport.getTypeName(exprType)));
            return false;
        }
        return true;
    }

    private boolean isNumberOrStringExpr(EJBQLAST expr) {
        Object exprType = expr.getTypeInfo();
        if (TypeSupport.isErrorType(exprType)) {
            return true;
        }
        if (!TypeSupport.isNumberType(exprType)) {
            if (!TypeSupport.isStringType(exprType)) {
                ErrorMsg.error(expr.getLine(), expr.getColumn(), I18NHelper.getMessage(msgs, "EXC_NumberOrStringExprExpected", TypeSupport.getTypeName(exprType)));
                return false;
            }
        }
        return true;
    }

    private Object checkAbstractSchemaType(EJBQLAST ident) {
        String name = ident.getText();
        Object typeInfo = this.typeSupport.getTypeInfoForAbstractSchema(name);
        if (typeInfo == null) {
            ErrorMsg.error(ident.getLine(), ident.getColumn(), I18NHelper.getMessage(msgs, "EXC_AbstractSchemNameExpected", name));
            typeInfo = TypeSupport.errorType;
        }
        return typeInfo;
    }

    private boolean isSingleCharacterStringLiteral(String text) {
        int i = 0;
        int length = text.length();
        if (length == 0) {
            return false;
        }
        if (text.charAt(i) == '\\') {
            if (++i == length) {
                return true;
            }
            if (text.charAt(i) == 'u') {
                i += 5;
            } else if ('0' <= text.charAt(i) && text.charAt(i) <= '3') {
                if (++i < length && this.isOctalDigit(text.charAt(i)) && ++i < length && this.isOctalDigit(text.charAt(i))) {
                    ++i;
                }
            } else if (this.isOctalDigit(text.charAt(i))) {
                if (++i < length && this.isOctalDigit(text.charAt(i))) {
                    ++i;
                }
            } else {
                ++i;
            }
        } else if (text.charAt(i) == '\'') {
            if (++i < length && text.charAt(i) == '\'') {
                ++i;
            }
        } else {
            ++i;
        }
        return i == length;
    }

    private boolean isOctalDigit(char c) {
        return '0' <= c && c <= '7';
    }

    public Semantic() {
        this.tokenNames = _tokenNames;
    }

    public final void query(AST _t) throws RecognitionException {
        EJBQLAST query_AST_in = _t == ASTNULL ? null : (EJBQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        EJBQLAST query_AST = null;
        EJBQLAST s_AST = null;
        EJBQLAST s = null;
        EJBQLAST o_AST = null;
        EJBQLAST o = null;
        AST __t2 = _t;
        EJBQLAST tmp1_AST = null;
        EJBQLAST tmp1_AST_in = null;
        tmp1_AST = (EJBQLAST)this.astFactory.create((AST)((EJBQLAST)_t));
        tmp1_AST_in = (EJBQLAST)_t;
        this.astFactory.addASTChild(currentAST, (AST)tmp1_AST);
        ASTPair __currentAST2 = currentAST.copy();
        currentAST.root = currentAST.child;
        currentAST.child = null;
        this.match(_t, 72);
        _t = _t.getFirstChild();
        this.fromClause(_t);
        _t = this._retTree;
        this.astFactory.addASTChild(currentAST, this.returnAST);
        s = _t == ASTNULL ? null : (EJBQLAST)_t;
        this.selectClause(_t);
        _t = this._retTree;
        s_AST = (EJBQLAST)this.returnAST;
        this.astFactory.addASTChild(currentAST, this.returnAST);
        this.whereClause(_t);
        _t = this._retTree;
        this.astFactory.addASTChild(currentAST, this.returnAST);
        o = _t == ASTNULL ? null : (EJBQLAST)_t;
        this.orderbyClause(_t);
        _t = this._retTree;
        o_AST = (EJBQLAST)this.returnAST;
        this.astFactory.addASTChild(currentAST, this.returnAST);
        currentAST = __currentAST2;
        _t = __t2;
        _t = _t.getNextSibling();
        this.checkSelectOrderbyClause(s_AST, o_AST);
        query_AST = (EJBQLAST)currentAST.root;
        this.returnAST = query_AST;
        this._retTree = _t;
    }

    public final void fromClause(AST _t) throws RecognitionException {
        EJBQLAST fromClause_AST_in = _t == ASTNULL ? null : (EJBQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        EJBQLAST fromClause_AST = null;
        AST __t4 = _t;
        EJBQLAST tmp2_AST = null;
        EJBQLAST tmp2_AST_in = null;
        tmp2_AST = (EJBQLAST)this.astFactory.create((AST)((EJBQLAST)_t));
        tmp2_AST_in = (EJBQLAST)_t;
        this.astFactory.addASTChild(currentAST, (AST)tmp2_AST);
        ASTPair __currentAST4 = currentAST.copy();
        currentAST.root = currentAST.child;
        currentAST.child = null;
        this.match(_t, 5);
        _t = _t.getFirstChild();
        int _cnt6 = 0;
        while (true) {
            if (_t == null) {
                _t = ASTNULL;
            }
            if (_t.getType() != 17 && _t.getType() != 73) {
                if (_cnt6 >= 1) break;
                throw new NoViableAltException(_t);
            }
            this.identificationVarDecl(_t);
            _t = this._retTree;
            this.astFactory.addASTChild(currentAST, this.returnAST);
            ++_cnt6;
        }
        currentAST = __currentAST4;
        _t = __t4;
        _t = _t.getNextSibling();
        fromClause_AST = (EJBQLAST)currentAST.root;
        this.returnAST = fromClause_AST;
        this._retTree = _t;
    }

    public final void selectClause(AST _t) throws RecognitionException {
        EJBQLAST selectClause_AST_in = _t == ASTNULL ? null : (EJBQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        EJBQLAST selectClause_AST = null;
        EJBQLAST p_AST = null;
        EJBQLAST p = null;
        AST __t13 = _t;
        EJBQLAST tmp3_AST = null;
        EJBQLAST tmp3_AST_in = null;
        tmp3_AST = (EJBQLAST)this.astFactory.create((AST)((EJBQLAST)_t));
        tmp3_AST_in = (EJBQLAST)_t;
        this.astFactory.addASTChild(currentAST, (AST)tmp3_AST);
        ASTPair __currentAST13 = currentAST.copy();
        currentAST.root = currentAST.child;
        currentAST.child = null;
        this.match(_t, 4);
        _t = _t.getFirstChild();
        this.distinct(_t);
        _t = this._retTree;
        this.astFactory.addASTChild(currentAST, this.returnAST);
        p = _t == ASTNULL ? null : (EJBQLAST)_t;
        this.projection(_t);
        _t = this._retTree;
        p_AST = (EJBQLAST)this.returnAST;
        this.astFactory.addASTChild(currentAST, this.returnAST);
        currentAST = __currentAST13;
        _t = __t13;
        _t = _t.getNextSibling();
        Object selectClauseTypeInfo = p_AST.getTypeInfo();
        Class<?> returnType = this.method.getReturnType();
        if (this.finderNotSelector) {
            this.checkFinderReturnType(returnType, selectClauseTypeInfo);
            this.checkFinderResultTypeMapping();
        } else {
            this.checkSelectorReturnType(returnType, selectClauseTypeInfo);
            this.checkSelectorResultTypeMapping(returnType, selectClauseTypeInfo);
        }
        selectClause_AST = (EJBQLAST)currentAST.root;
        this.returnAST = selectClause_AST;
        this._retTree = _t;
    }

    public final void whereClause(AST _t) throws RecognitionException {
        EJBQLAST whereClause_AST_in = _t == ASTNULL ? null : (EJBQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        EJBQLAST whereClause_AST = null;
        EJBQLAST e_AST = null;
        EJBQLAST e = null;
        AST __t29 = _t;
        EJBQLAST tmp4_AST = null;
        EJBQLAST tmp4_AST_in = null;
        tmp4_AST = (EJBQLAST)this.astFactory.create((AST)((EJBQLAST)_t));
        tmp4_AST_in = (EJBQLAST)_t;
        this.astFactory.addASTChild(currentAST, (AST)tmp4_AST);
        ASTPair __currentAST29 = currentAST.copy();
        currentAST.root = currentAST.child;
        currentAST.child = null;
        this.match(_t, 6);
        _t = _t.getFirstChild();
        e = _t == ASTNULL ? null : (EJBQLAST)_t;
        this.expression(_t);
        _t = this._retTree;
        e_AST = (EJBQLAST)this.returnAST;
        this.astFactory.addASTChild(currentAST, this.returnAST);
        currentAST = __currentAST29;
        _t = __t29;
        _t = _t.getNextSibling();
        Object typeInfo = e_AST.getTypeInfo();
        if (!TypeSupport.isBooleanType(typeInfo)) {
            ErrorMsg.error(e_AST.getLine(), e_AST.getColumn(), I18NHelper.getMessage(msgs, "EXC_BooleanWhereClauseExpected", TypeSupport.getTypeName(typeInfo)));
        }
        whereClause_AST = (EJBQLAST)currentAST.root;
        this.returnAST = whereClause_AST;
        this._retTree = _t;
    }

    public final void orderbyClause(AST _t) throws RecognitionException {
        EJBQLAST orderbyClause_AST_in = _t == ASTNULL ? null : (EJBQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        EJBQLAST orderbyClause_AST = null;
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 37: {
                AST __t31 = _t;
                EJBQLAST tmp5_AST = null;
                EJBQLAST tmp5_AST_in = null;
                tmp5_AST = (EJBQLAST)this.astFactory.create((AST)((EJBQLAST)_t));
                tmp5_AST_in = (EJBQLAST)_t;
                this.astFactory.addASTChild(currentAST, (AST)tmp5_AST);
                ASTPair __currentAST31 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 37);
                _t = _t.getFirstChild();
                int _cnt33 = 0;
                while (true) {
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    if (_t.getType() != 57) {
                        if (_cnt33 >= 1) break;
                        throw new NoViableAltException(_t);
                    }
                    this.orderbyItem(_t);
                    _t = this._retTree;
                    this.astFactory.addASTChild(currentAST, this.returnAST);
                    ++_cnt33;
                }
                currentAST = __currentAST31;
                _t = __t31;
                _t = _t.getNextSibling();
                orderbyClause_AST = (EJBQLAST)currentAST.root;
                break;
            }
            case 3: {
                orderbyClause_AST = (EJBQLAST)currentAST.root;
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        this.returnAST = orderbyClause_AST;
        this._retTree = _t;
    }

    public final void identificationVarDecl(AST _t) throws RecognitionException {
        EJBQLAST identificationVarDecl_AST_in = _t == ASTNULL ? null : (EJBQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        EJBQLAST identificationVarDecl_AST = null;
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 17: {
                this.collectionMemberDecl(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                identificationVarDecl_AST = (EJBQLAST)currentAST.root;
                break;
            }
            case 73: {
                this.rangeVarDecl(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                identificationVarDecl_AST = (EJBQLAST)currentAST.root;
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        this.returnAST = identificationVarDecl_AST;
        this._retTree = _t;
    }

    public final void collectionMemberDecl(AST _t) throws RecognitionException {
        EJBQLAST collectionMemberDecl_AST_in = _t == ASTNULL ? null : (EJBQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        EJBQLAST collectionMemberDecl_AST = null;
        EJBQLAST p_AST = null;
        EJBQLAST p = null;
        EJBQLAST var = null;
        EJBQLAST var_AST = null;
        AST __t9 = _t;
        EJBQLAST tmp6_AST = null;
        EJBQLAST tmp6_AST_in = null;
        tmp6_AST = (EJBQLAST)this.astFactory.create((AST)((EJBQLAST)_t));
        tmp6_AST_in = (EJBQLAST)_t;
        this.astFactory.addASTChild(currentAST, (AST)tmp6_AST);
        ASTPair __currentAST9 = currentAST.copy();
        currentAST.root = currentAST.child;
        currentAST.child = null;
        this.match(_t, 17);
        _t = _t.getFirstChild();
        p = _t == ASTNULL ? null : (EJBQLAST)_t;
        this.collectionValuedPathExpression(_t);
        _t = this._retTree;
        p_AST = (EJBQLAST)this.returnAST;
        this.astFactory.addASTChild(currentAST, this.returnAST);
        var = (EJBQLAST)_t;
        Object var_AST_in = null;
        var_AST = (EJBQLAST)this.astFactory.create((AST)var);
        this.astFactory.addASTChild(currentAST, (AST)var_AST);
        this.match(_t, 56);
        _t = _t.getNextSibling();
        currentAST = __currentAST9;
        _t = __t9;
        _t = _t.getNextSibling();
        Object typeInfo = this.analyseCollectionValuedCMRField(p_AST);
        String name = var_AST.getText();
        IdentificationVariable identVar = new IdentificationVariable(name, typeInfo);
        if (this.symtab.declare(name, identVar) != null) {
            ErrorMsg.error(var_AST.getLine(), var_AST.getColumn(), I18NHelper.getMessage(msgs, "EXC_MultipleDeclaration", name));
        }
        var_AST.setType(78);
        var_AST.setTypeInfo(typeInfo);
        collectionMemberDecl_AST = (EJBQLAST)currentAST.root;
        this.returnAST = collectionMemberDecl_AST;
        this._retTree = _t;
    }

    public final void rangeVarDecl(AST _t) throws RecognitionException {
        EJBQLAST rangeVarDecl_AST_in = _t == ASTNULL ? null : (EJBQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        EJBQLAST rangeVarDecl_AST = null;
        EJBQLAST abstractSchemaName = null;
        EJBQLAST abstractSchemaName_AST = null;
        EJBQLAST var = null;
        EJBQLAST var_AST = null;
        AST __t11 = _t;
        EJBQLAST tmp7_AST = null;
        EJBQLAST tmp7_AST_in = null;
        tmp7_AST = (EJBQLAST)this.astFactory.create((AST)((EJBQLAST)_t));
        tmp7_AST_in = (EJBQLAST)_t;
        this.astFactory.addASTChild(currentAST, (AST)tmp7_AST);
        ASTPair __currentAST11 = currentAST.copy();
        currentAST.root = currentAST.child;
        currentAST.child = null;
        this.match(_t, 73);
        _t = _t.getFirstChild();
        abstractSchemaName = (EJBQLAST)_t;
        Object abstractSchemaName_AST_in = null;
        abstractSchemaName_AST = (EJBQLAST)this.astFactory.create((AST)abstractSchemaName);
        this.astFactory.addASTChild(currentAST, (AST)abstractSchemaName_AST);
        this.match(_t, 79);
        _t = _t.getNextSibling();
        var = (EJBQLAST)_t;
        Object var_AST_in = null;
        var_AST = (EJBQLAST)this.astFactory.create((AST)var);
        this.astFactory.addASTChild(currentAST, (AST)var_AST);
        this.match(_t, 56);
        _t = _t.getNextSibling();
        currentAST = __currentAST11;
        _t = __t11;
        _t = _t.getNextSibling();
        Object typeInfo = this.checkAbstractSchemaType(abstractSchemaName_AST);
        abstractSchemaName_AST.setTypeInfo(typeInfo);
        String name = var_AST.getText();
        IdentificationVariable identVar = new IdentificationVariable(name, typeInfo);
        if (this.symtab.declare(name, identVar) != null) {
            ErrorMsg.error(var_AST.getLine(), var_AST.getColumn(), I18NHelper.getMessage(msgs, "EXC_MultipleDeclaration", name));
        }
        var_AST.setType(78);
        var_AST.setTypeInfo(typeInfo);
        rangeVarDecl_AST = (EJBQLAST)currentAST.root;
        this.returnAST = rangeVarDecl_AST;
        this._retTree = _t;
    }

    public final void collectionValuedPathExpression(AST _t) throws RecognitionException {
        EJBQLAST collectionValuedPathExpression_AST_in = _t == ASTNULL ? null : (EJBQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        EJBQLAST collectionValuedPathExpression_AST = null;
        EJBQLAST p_AST = null;
        EJBQLAST p = null;
        p = _t == ASTNULL ? null : (EJBQLAST)_t;
        this.pathExpression(_t);
        _t = this._retTree;
        p_AST = (EJBQLAST)this.returnAST;
        this.astFactory.addASTChild(currentAST, this.returnAST);
        int fieldTokenType = p_AST.getType();
        if (fieldTokenType != 76) {
            EJBQLAST classExpr = (EJBQLAST)p_AST.getFirstChild();
            EJBQLAST field = (EJBQLAST)classExpr.getNextSibling();
            ErrorMsg.error(field.getLine(), field.getColumn(), I18NHelper.getMessage(msgs, "EXC_CollectionValuedCMRFieldExpected", field.getText(), TypeSupport.getTypeName(field.getTypeInfo())));
            p_AST.setType(76);
        }
        collectionValuedPathExpression_AST = (EJBQLAST)currentAST.root;
        this.returnAST = collectionValuedPathExpression_AST;
        this._retTree = _t;
    }

    public final void distinct(AST _t) throws RecognitionException {
        EJBQLAST distinct_AST_in = _t == ASTNULL ? null : (EJBQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        EJBQLAST distinct_AST = null;
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 7: {
                EJBQLAST tmp8_AST = null;
                EJBQLAST tmp8_AST_in = null;
                tmp8_AST = (EJBQLAST)this.astFactory.create((AST)((EJBQLAST)_t));
                tmp8_AST_in = (EJBQLAST)_t;
                this.astFactory.addASTChild(currentAST, (AST)tmp8_AST);
                this.match(_t, 7);
                _t = _t.getNextSibling();
                distinct_AST = (EJBQLAST)currentAST.root;
                break;
            }
            case 8: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 57: {
                distinct_AST = (EJBQLAST)currentAST.root;
                if (!this.finderNotSelector && this.method.getReturnType() == Set.class) {
                    distinct_AST = (EJBQLAST)this.astFactory.create(7, "distinct");
                }
                currentAST.root = distinct_AST;
                currentAST.child = distinct_AST != null && distinct_AST.getFirstChild() != null ? distinct_AST.getFirstChild() : distinct_AST;
                currentAST.advanceChildToEnd();
                distinct_AST = (EJBQLAST)currentAST.root;
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        this.returnAST = distinct_AST;
        this._retTree = _t;
    }

    /*
     * Unable to fully structure code
     */
    public final void projection(AST _t) throws RecognitionException {
        projection_AST_in = _t == Semantic.ASTNULL ? null : (EJBQLAST)_t;
        this.returnAST = null;
        currentAST = new ASTPair();
        projection_AST = null;
        o = null;
        o_AST = null;
        var = null;
        var_AST = null;
        sum = null;
        sum_AST = null;
        sumExpr_AST = null;
        sumExpr = null;
        avg = null;
        avg_AST = null;
        avgExpr_AST = null;
        avgExpr = null;
        min = null;
        min_AST = null;
        minExpr_AST = null;
        minExpr = null;
        max = null;
        max_AST = null;
        maxExpr_AST = null;
        maxExpr = null;
        c = null;
        c_AST = null;
        if (_t == null) {
            _t = Semantic.ASTNULL;
        }
        switch (_t.getType()) {
            case 57: {
                this.singleValuedPathExpression(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                projection_AST = (EJBQLAST)currentAST.root;
                break;
            }
            case 8: {
                __t16 = _t;
                o = _t == Semantic.ASTNULL ? null : (EJBQLAST)_t;
                o_AST_in = null;
                o_AST = (EJBQLAST)this.astFactory.create((AST)o);
                this.astFactory.addASTChild(currentAST, (AST)o_AST);
                __currentAST16 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 8);
                _t = _t.getFirstChild();
                var = (EJBQLAST)_t;
                var_AST_in = null;
                var_AST = (EJBQLAST)this.astFactory.create((AST)var);
                this.astFactory.addASTChild(currentAST, (AST)var_AST);
                this.match(_t, 56);
                _t = _t.getNextSibling();
                currentAST = __currentAST16;
                _t = __t16;
                _t = _t.getNextSibling();
                name = var_AST.getText();
                decl = this.symtab.getDeclaration(name);
                typeInfo = null;
                if (decl != null && decl instanceof IdentificationVariable) {
                    var_AST.setType(77);
                    typeInfo = ((IdentificationVariable)decl).getTypeInfo();
                } else {
                    ErrorMsg.error(var_AST.getLine(), var_AST.getColumn(), I18NHelper.getMessage(Semantic.msgs, "EXC_IdentificationVariableExcepted", name));
                }
                var_AST.setTypeInfo(typeInfo);
                o_AST.setTypeInfo(typeInfo);
                projection_AST = (EJBQLAST)currentAST.root;
                break;
            }
            case 35: {
                __t17 = _t;
                sum = _t == Semantic.ASTNULL ? null : (EJBQLAST)_t;
                sum_AST_in = null;
                sum_AST = (EJBQLAST)this.astFactory.create((AST)sum);
                this.astFactory.addASTChild(currentAST, (AST)sum_AST);
                __currentAST17 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 35);
                _t = _t.getFirstChild();
                if (_t == null) {
                    _t = Semantic.ASTNULL;
                }
                switch (_t.getType()) {
                    case 7: {
                        tmp9_AST = null;
                        tmp9_AST_in = null;
                        tmp9_AST = (EJBQLAST)this.astFactory.create((AST)((EJBQLAST)_t));
                        tmp9_AST_in = (EJBQLAST)_t;
                        this.astFactory.addASTChild(currentAST, (AST)tmp9_AST);
                        this.match(_t, 7);
                        _t = _t.getNextSibling();
                        break;
                    }
                    case 57: {
                        break;
                    }
                    default: {
                        throw new NoViableAltException(_t);
                    }
                }
                sumExpr = _t == Semantic.ASTNULL ? null : (EJBQLAST)_t;
                this.cmpPathExpression(_t);
                _t = this._retTree;
                sumExpr_AST = (EJBQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST17;
                _t = __t17;
                _t = _t.getNextSibling();
                typeInfo = sumExpr_AST.getTypeInfo();
                if (!TypeSupport.isNumberType(typeInfo)) ** GOTO lbl109
                if (!TypeSupport.isCharType(typeInfo)) ** GOTO lbl110
lbl109:
                // 2 sources

                ErrorMsg.error(sumExpr_AST.getLine(), sumExpr_AST.getColumn(), I18NHelper.getMessage(Semantic.msgs, "EXC_NumberExprExpected", TypeSupport.getTypeName(typeInfo)));
lbl110:
                // 2 sources

                sum_AST.setTypeInfo(this.typeSupport.getSumReturnType(typeInfo));
                this.isAggregate = true;
                projection_AST = (EJBQLAST)currentAST.root;
                break;
            }
            case 32: {
                __t19 = _t;
                avg = _t == Semantic.ASTNULL ? null : (EJBQLAST)_t;
                avg_AST_in = null;
                avg_AST = (EJBQLAST)this.astFactory.create((AST)avg);
                this.astFactory.addASTChild(currentAST, (AST)avg_AST);
                __currentAST19 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 32);
                _t = _t.getFirstChild();
                if (_t == null) {
                    _t = Semantic.ASTNULL;
                }
                switch (_t.getType()) {
                    case 7: {
                        tmp10_AST = null;
                        tmp10_AST_in = null;
                        tmp10_AST = (EJBQLAST)this.astFactory.create((AST)((EJBQLAST)_t));
                        tmp10_AST_in = (EJBQLAST)_t;
                        this.astFactory.addASTChild(currentAST, (AST)tmp10_AST);
                        this.match(_t, 7);
                        _t = _t.getNextSibling();
                        break;
                    }
                    case 57: {
                        break;
                    }
                    default: {
                        throw new NoViableAltException(_t);
                    }
                }
                avgExpr = _t == Semantic.ASTNULL ? null : (EJBQLAST)_t;
                this.cmpPathExpression(_t);
                _t = this._retTree;
                avgExpr_AST = (EJBQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST19;
                _t = __t19;
                _t = _t.getNextSibling();
                typeInfo = avgExpr_AST.getTypeInfo();
                if (!TypeSupport.isNumberType(typeInfo)) ** GOTO lbl155
                if (!TypeSupport.isCharType(typeInfo)) ** GOTO lbl156
lbl155:
                // 2 sources

                ErrorMsg.error(avgExpr_AST.getLine(), avgExpr_AST.getColumn(), I18NHelper.getMessage(Semantic.msgs, "EXC_NumberExprExpected", TypeSupport.getTypeName(typeInfo)));
lbl156:
                // 2 sources

                avg_AST.setTypeInfo(this.typeSupport.getAvgReturnType(typeInfo));
                this.isAggregate = true;
                projection_AST = (EJBQLAST)currentAST.root;
                break;
            }
            case 34: {
                __t21 = _t;
                min = _t == Semantic.ASTNULL ? null : (EJBQLAST)_t;
                min_AST_in = null;
                min_AST = (EJBQLAST)this.astFactory.create((AST)min);
                this.astFactory.addASTChild(currentAST, (AST)min_AST);
                __currentAST21 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 34);
                _t = _t.getFirstChild();
                if (_t == null) {
                    _t = Semantic.ASTNULL;
                }
                switch (_t.getType()) {
                    case 7: {
                        tmp11_AST = null;
                        tmp11_AST_in = null;
                        tmp11_AST = (EJBQLAST)this.astFactory.create((AST)((EJBQLAST)_t));
                        tmp11_AST_in = (EJBQLAST)_t;
                        this.astFactory.addASTChild(currentAST, (AST)tmp11_AST);
                        this.match(_t, 7);
                        _t = _t.getNextSibling();
                        break;
                    }
                    case 57: {
                        break;
                    }
                    default: {
                        throw new NoViableAltException(_t);
                    }
                }
                minExpr = _t == Semantic.ASTNULL ? null : (EJBQLAST)_t;
                this.cmpPathExpression(_t);
                _t = this._retTree;
                minExpr_AST = (EJBQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST21;
                _t = __t21;
                _t = _t.getNextSibling();
                typeInfo = minExpr_AST.getTypeInfo();
                if (!this.typeSupport.isOrderableType(typeInfo)) {
                    ErrorMsg.error(minExpr_AST.getLine(), minExpr_AST.getColumn(), I18NHelper.getMessage(Semantic.msgs, "EXC_OrderableExpected", TypeSupport.getTypeName(typeInfo)));
                }
                min_AST.setTypeInfo(this.typeSupport.getMinMaxReturnType(typeInfo));
                this.isAggregate = true;
                projection_AST = (EJBQLAST)currentAST.root;
                break;
            }
            case 33: {
                __t23 = _t;
                max = _t == Semantic.ASTNULL ? null : (EJBQLAST)_t;
                max_AST_in = null;
                max_AST = (EJBQLAST)this.astFactory.create((AST)max);
                this.astFactory.addASTChild(currentAST, (AST)max_AST);
                __currentAST23 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 33);
                _t = _t.getFirstChild();
                if (_t == null) {
                    _t = Semantic.ASTNULL;
                }
                switch (_t.getType()) {
                    case 7: {
                        tmp12_AST = null;
                        tmp12_AST_in = null;
                        tmp12_AST = (EJBQLAST)this.astFactory.create((AST)((EJBQLAST)_t));
                        tmp12_AST_in = (EJBQLAST)_t;
                        this.astFactory.addASTChild(currentAST, (AST)tmp12_AST);
                        this.match(_t, 7);
                        _t = _t.getNextSibling();
                        break;
                    }
                    case 57: {
                        break;
                    }
                    default: {
                        throw new NoViableAltException(_t);
                    }
                }
                maxExpr = _t == Semantic.ASTNULL ? null : (EJBQLAST)_t;
                this.cmpPathExpression(_t);
                _t = this._retTree;
                maxExpr_AST = (EJBQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST23;
                _t = __t23;
                _t = _t.getNextSibling();
                typeInfo = maxExpr_AST.getTypeInfo();
                if (!this.typeSupport.isOrderableType(typeInfo)) {
                    ErrorMsg.error(maxExpr_AST.getLine(), maxExpr_AST.getColumn(), I18NHelper.getMessage(Semantic.msgs, "EXC_OrderableExpected", TypeSupport.getTypeName(typeInfo)));
                }
                max_AST.setTypeInfo(this.typeSupport.getMinMaxReturnType(typeInfo));
                this.isAggregate = true;
                projection_AST = (EJBQLAST)currentAST.root;
                break;
            }
            case 36: {
                __t25 = _t;
                c = _t == Semantic.ASTNULL ? null : (EJBQLAST)_t;
                c_AST_in = null;
                c_AST = (EJBQLAST)this.astFactory.create((AST)c);
                this.astFactory.addASTChild(currentAST, (AST)c_AST);
                __currentAST25 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 36);
                _t = _t.getFirstChild();
                if (_t == null) {
                    _t = Semantic.ASTNULL;
                }
                switch (_t.getType()) {
                    case 7: {
                        tmp13_AST = null;
                        tmp13_AST_in = null;
                        tmp13_AST = (EJBQLAST)this.astFactory.create((AST)((EJBQLAST)_t));
                        tmp13_AST_in = (EJBQLAST)_t;
                        this.astFactory.addASTChild(currentAST, (AST)tmp13_AST);
                        this.match(_t, 7);
                        _t = _t.getNextSibling();
                        break;
                    }
                    case 56: 
                    case 57: {
                        break;
                    }
                    default: {
                        throw new NoViableAltException(_t);
                    }
                }
                this.countExpr(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST25;
                _t = __t25;
                _t = _t.getNextSibling();
                c_AST.setTypeInfo(TypeSupport.longClassType);
                this.isAggregate = true;
                projection_AST = (EJBQLAST)currentAST.root;
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        this.returnAST = projection_AST;
        this._retTree = _t;
    }

    public final void singleValuedPathExpression(AST _t) throws RecognitionException {
        EJBQLAST singleValuedPathExpression_AST_in = _t == ASTNULL ? null : (EJBQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        EJBQLAST singleValuedPathExpression_AST = null;
        EJBQLAST p_AST = null;
        EJBQLAST p = null;
        p = _t == ASTNULL ? null : (EJBQLAST)_t;
        this.pathExpression(_t);
        _t = this._retTree;
        p_AST = (EJBQLAST)this.returnAST;
        this.astFactory.addASTChild(currentAST, this.returnAST);
        int fieldTokenType = p_AST.getType();
        if (fieldTokenType != 75 && fieldTokenType != 74) {
            EJBQLAST classExpr = (EJBQLAST)p_AST.getFirstChild();
            EJBQLAST field = (EJBQLAST)classExpr.getNextSibling();
            ErrorMsg.error(field.getLine(), field.getColumn(), I18NHelper.getMessage(msgs, "EXC_SingleValuedCMROrCMPFieldExpected", field.getText(), TypeSupport.getTypeName(field.getTypeInfo())));
            p_AST.setType(75);
        }
        singleValuedPathExpression_AST = (EJBQLAST)currentAST.root;
        this.returnAST = singleValuedPathExpression_AST;
        this._retTree = _t;
    }

    public final void cmpPathExpression(AST _t) throws RecognitionException {
        EJBQLAST cmpPathExpression_AST_in = _t == ASTNULL ? null : (EJBQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        EJBQLAST cmpPathExpression_AST = null;
        EJBQLAST p_AST = null;
        EJBQLAST p = null;
        p = _t == ASTNULL ? null : (EJBQLAST)_t;
        this.pathExpression(_t);
        _t = this._retTree;
        p_AST = (EJBQLAST)this.returnAST;
        this.astFactory.addASTChild(currentAST, this.returnAST);
        int fieldTokenType = p_AST.getType();
        if (fieldTokenType != 74) {
            EJBQLAST classExpr = (EJBQLAST)p_AST.getFirstChild();
            EJBQLAST field = (EJBQLAST)classExpr.getNextSibling();
            ErrorMsg.error(field.getLine(), field.getColumn(), I18NHelper.getMessage(msgs, "EXC_CMPFieldExpected", field.getText(), TypeSupport.getTypeName(field.getTypeInfo())));
            p_AST.setType(74);
        }
        cmpPathExpression_AST = (EJBQLAST)currentAST.root;
        this.returnAST = cmpPathExpression_AST;
        this._retTree = _t;
    }

    public final void countExpr(AST _t) throws RecognitionException {
        EJBQLAST countExpr_AST_in = _t == ASTNULL ? null : (EJBQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        EJBQLAST countExpr_AST = null;
        EJBQLAST v = null;
        EJBQLAST v_AST = null;
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 56: {
                v = (EJBQLAST)_t;
                Object v_AST_in = null;
                v_AST = (EJBQLAST)this.astFactory.create((AST)v);
                this.astFactory.addASTChild(currentAST, (AST)v_AST);
                this.match(_t, 56);
                _t = _t.getNextSibling();
                String name = v_AST.getText();
                Object decl = this.symtab.getDeclaration(name);
                Object typeInfo = null;
                if (decl != null && decl instanceof IdentificationVariable) {
                    v_AST.setType(77);
                    typeInfo = ((IdentificationVariable)decl).getTypeInfo();
                } else {
                    ErrorMsg.error(v_AST.getLine(), v_AST.getColumn(), I18NHelper.getMessage(msgs, "EXC_IdentificationVariableExcepted", name));
                }
                v_AST.setTypeInfo(typeInfo);
                countExpr_AST = (EJBQLAST)currentAST.root;
                break;
            }
            case 57: {
                this.singleValuedPathExpression(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                countExpr_AST = (EJBQLAST)currentAST.root;
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        this.returnAST = countExpr_AST;
        this._retTree = _t;
    }

    public final void expression(AST _t) throws RecognitionException {
        EJBQLAST expression_AST_in = _t == ASTNULL ? null : (EJBQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        EJBQLAST expression_AST = null;
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 13: 
            case 14: {
                this.conditionalExpr(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                expression_AST = (EJBQLAST)currentAST.root;
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                this.relationalExpr(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                expression_AST = (EJBQLAST)currentAST.root;
                break;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                this.binaryArithmeticExpr(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                expression_AST = (EJBQLAST)currentAST.root;
                break;
            }
            case 12: 
            case 83: 
            case 84: {
                this.unaryExpr(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                expression_AST = (EJBQLAST)currentAST.root;
                break;
            }
            case 15: 
            case 85: {
                this.betweenExpr(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                expression_AST = (EJBQLAST)currentAST.root;
                break;
            }
            case 16: 
            case 86: {
                this.likeExpr(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                expression_AST = (EJBQLAST)currentAST.root;
                break;
            }
            case 17: 
            case 87: {
                this.inExpr(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                expression_AST = (EJBQLAST)currentAST.root;
                break;
            }
            case 9: 
            case 88: {
                this.nullComparisonExpr(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                expression_AST = (EJBQLAST)currentAST.root;
                break;
            }
            case 20: 
            case 89: {
                this.emptyCollectionComparisonExpr(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                expression_AST = (EJBQLAST)currentAST.root;
                break;
            }
            case 21: 
            case 90: {
                this.collectionMemberExpr(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                expression_AST = (EJBQLAST)currentAST.root;
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                this.function(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                expression_AST = (EJBQLAST)currentAST.root;
                break;
            }
            case 10: 
            case 11: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                this.primary(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                expression_AST = (EJBQLAST)currentAST.root;
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        this.returnAST = expression_AST;
        this._retTree = _t;
    }

    public final void orderbyItem(AST _t) throws RecognitionException {
        EJBQLAST orderbyItem_AST_in = _t == ASTNULL ? null : (EJBQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        EJBQLAST orderbyItem_AST = null;
        EJBQLAST expr_AST = null;
        EJBQLAST expr = null;
        expr = _t == ASTNULL ? null : (EJBQLAST)_t;
        this.cmpPathExpression(_t);
        _t = this._retTree;
        expr_AST = (EJBQLAST)this.returnAST;
        this.astFactory.addASTChild(currentAST, this.returnAST);
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 39: {
                EJBQLAST tmp14_AST = null;
                EJBQLAST tmp14_AST_in = null;
                tmp14_AST = (EJBQLAST)this.astFactory.create((AST)((EJBQLAST)_t));
                tmp14_AST_in = (EJBQLAST)_t;
                this.astFactory.addASTChild(currentAST, (AST)tmp14_AST);
                this.match(_t, 39);
                _t = _t.getNextSibling();
                break;
            }
            case 40: {
                EJBQLAST tmp15_AST = null;
                EJBQLAST tmp15_AST_in = null;
                tmp15_AST = (EJBQLAST)this.astFactory.create((AST)((EJBQLAST)_t));
                tmp15_AST_in = (EJBQLAST)_t;
                this.astFactory.addASTChild(currentAST, (AST)tmp15_AST);
                this.match(_t, 40);
                _t = _t.getNextSibling();
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        Object typeInfo = expr_AST.getTypeInfo();
        if (!this.typeSupport.isOrderableType(typeInfo)) {
            ErrorMsg.error(expr_AST.getLine(), expr_AST.getColumn(), I18NHelper.getMessage(msgs, "EXC_OrderableOrderbyClauseExpected", TypeSupport.getTypeName(typeInfo)));
        }
        orderbyItem_AST = (EJBQLAST)currentAST.root;
        this.returnAST = orderbyItem_AST;
        this._retTree = _t;
    }

    public final void conditionalExpr(AST _t) throws RecognitionException {
        EJBQLAST conditionalExpr_AST_in = _t == ASTNULL ? null : (EJBQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        EJBQLAST conditionalExpr_AST = null;
        EJBQLAST op1 = null;
        EJBQLAST op1_AST = null;
        EJBQLAST left1_AST = null;
        EJBQLAST left1 = null;
        EJBQLAST right1_AST = null;
        EJBQLAST right1 = null;
        EJBQLAST op2 = null;
        EJBQLAST op2_AST = null;
        EJBQLAST left2_AST = null;
        EJBQLAST left2 = null;
        EJBQLAST right2_AST = null;
        EJBQLAST right2 = null;
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 13: {
                AST __t38 = _t;
                op1 = _t == ASTNULL ? null : (EJBQLAST)_t;
                Object op1_AST_in = null;
                op1_AST = (EJBQLAST)this.astFactory.create((AST)op1);
                this.astFactory.addASTChild(currentAST, (AST)op1_AST);
                ASTPair __currentAST38 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 13);
                _t = _t.getFirstChild();
                left1 = _t == ASTNULL ? null : (EJBQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                left1_AST = (EJBQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                right1 = _t == ASTNULL ? null : (EJBQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                right1_AST = (EJBQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST38;
                _t = __t38;
                _t = _t.getNextSibling();
                op1_AST.setTypeInfo(this.analyseConditionalExpr(op1_AST, left1_AST, right1_AST));
                conditionalExpr_AST = (EJBQLAST)currentAST.root;
                break;
            }
            case 14: {
                AST __t39 = _t;
                op2 = _t == ASTNULL ? null : (EJBQLAST)_t;
                Object op2_AST_in = null;
                op2_AST = (EJBQLAST)this.astFactory.create((AST)op2);
                this.astFactory.addASTChild(currentAST, (AST)op2_AST);
                ASTPair __currentAST39 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 14);
                _t = _t.getFirstChild();
                left2 = _t == ASTNULL ? null : (EJBQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                left2_AST = (EJBQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                right2 = _t == ASTNULL ? null : (EJBQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                right2_AST = (EJBQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST39;
                _t = __t39;
                _t = _t.getNextSibling();
                op2_AST.setTypeInfo(this.analyseConditionalExpr(op2_AST, left2_AST, right2_AST));
                conditionalExpr_AST = (EJBQLAST)currentAST.root;
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        this.returnAST = conditionalExpr_AST;
        this._retTree = _t;
    }

    public final void relationalExpr(AST _t) throws RecognitionException {
        EJBQLAST relationalExpr_AST_in = _t == ASTNULL ? null : (EJBQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        EJBQLAST relationalExpr_AST = null;
        EJBQLAST op1 = null;
        EJBQLAST op1_AST = null;
        EJBQLAST left1_AST = null;
        EJBQLAST left1 = null;
        EJBQLAST right1_AST = null;
        EJBQLAST right1 = null;
        EJBQLAST op2 = null;
        EJBQLAST op2_AST = null;
        EJBQLAST left2_AST = null;
        EJBQLAST left2 = null;
        EJBQLAST right2_AST = null;
        EJBQLAST right2 = null;
        EJBQLAST op3 = null;
        EJBQLAST op3_AST = null;
        EJBQLAST left3_AST = null;
        EJBQLAST left3 = null;
        EJBQLAST right3_AST = null;
        EJBQLAST right3 = null;
        EJBQLAST op4 = null;
        EJBQLAST op4_AST = null;
        EJBQLAST left4_AST = null;
        EJBQLAST left4 = null;
        EJBQLAST right4_AST = null;
        EJBQLAST right4 = null;
        EJBQLAST op5 = null;
        EJBQLAST op5_AST = null;
        EJBQLAST left5_AST = null;
        EJBQLAST left5 = null;
        EJBQLAST right5_AST = null;
        EJBQLAST right5 = null;
        EJBQLAST op6 = null;
        EJBQLAST op6_AST = null;
        EJBQLAST left6_AST = null;
        EJBQLAST left6 = null;
        EJBQLAST right6_AST = null;
        EJBQLAST right6 = null;
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 41: {
                AST __t41 = _t;
                op1 = _t == ASTNULL ? null : (EJBQLAST)_t;
                Object op1_AST_in = null;
                op1_AST = (EJBQLAST)this.astFactory.create((AST)op1);
                this.astFactory.addASTChild(currentAST, (AST)op1_AST);
                ASTPair __currentAST41 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 41);
                _t = _t.getFirstChild();
                left1 = _t == ASTNULL ? null : (EJBQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                left1_AST = (EJBQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                right1 = _t == ASTNULL ? null : (EJBQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                right1_AST = (EJBQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST41;
                _t = __t41;
                _t = _t.getNextSibling();
                op1_AST.setTypeInfo(this.analyseEqualityExpr(op1_AST, left1_AST, right1_AST));
                relationalExpr_AST = (EJBQLAST)currentAST.root;
                break;
            }
            case 42: {
                AST __t42 = _t;
                op2 = _t == ASTNULL ? null : (EJBQLAST)_t;
                Object op2_AST_in = null;
                op2_AST = (EJBQLAST)this.astFactory.create((AST)op2);
                this.astFactory.addASTChild(currentAST, (AST)op2_AST);
                ASTPair __currentAST42 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 42);
                _t = _t.getFirstChild();
                left2 = _t == ASTNULL ? null : (EJBQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                left2_AST = (EJBQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                right2 = _t == ASTNULL ? null : (EJBQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                right2_AST = (EJBQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST42;
                _t = __t42;
                _t = _t.getNextSibling();
                op2_AST.setTypeInfo(this.analyseEqualityExpr(op2_AST, left2_AST, right2_AST));
                relationalExpr_AST = (EJBQLAST)currentAST.root;
                break;
            }
            case 46: {
                AST __t43 = _t;
                op3 = _t == ASTNULL ? null : (EJBQLAST)_t;
                Object op3_AST_in = null;
                op3_AST = (EJBQLAST)this.astFactory.create((AST)op3);
                this.astFactory.addASTChild(currentAST, (AST)op3_AST);
                ASTPair __currentAST43 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 46);
                _t = _t.getFirstChild();
                left3 = _t == ASTNULL ? null : (EJBQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                left3_AST = (EJBQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                right3 = _t == ASTNULL ? null : (EJBQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                right3_AST = (EJBQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST43;
                _t = __t43;
                _t = _t.getNextSibling();
                op3_AST.setTypeInfo(this.analyseRelationalExpr(op3_AST, left3_AST, right3_AST));
                relationalExpr_AST = (EJBQLAST)currentAST.root;
                break;
            }
            case 45: {
                AST __t44 = _t;
                op4 = _t == ASTNULL ? null : (EJBQLAST)_t;
                Object op4_AST_in = null;
                op4_AST = (EJBQLAST)this.astFactory.create((AST)op4);
                this.astFactory.addASTChild(currentAST, (AST)op4_AST);
                ASTPair __currentAST44 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 45);
                _t = _t.getFirstChild();
                left4 = _t == ASTNULL ? null : (EJBQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                left4_AST = (EJBQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                right4 = _t == ASTNULL ? null : (EJBQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                right4_AST = (EJBQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST44;
                _t = __t44;
                _t = _t.getNextSibling();
                op4_AST.setTypeInfo(this.analyseRelationalExpr(op4_AST, left4_AST, right4_AST));
                relationalExpr_AST = (EJBQLAST)currentAST.root;
                break;
            }
            case 44: {
                AST __t45 = _t;
                op5 = _t == ASTNULL ? null : (EJBQLAST)_t;
                Object op5_AST_in = null;
                op5_AST = (EJBQLAST)this.astFactory.create((AST)op5);
                this.astFactory.addASTChild(currentAST, (AST)op5_AST);
                ASTPair __currentAST45 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 44);
                _t = _t.getFirstChild();
                left5 = _t == ASTNULL ? null : (EJBQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                left5_AST = (EJBQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                right5 = _t == ASTNULL ? null : (EJBQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                right5_AST = (EJBQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST45;
                _t = __t45;
                _t = _t.getNextSibling();
                op5_AST.setTypeInfo(this.analyseRelationalExpr(op5_AST, left5_AST, right5_AST));
                relationalExpr_AST = (EJBQLAST)currentAST.root;
                break;
            }
            case 43: {
                AST __t46 = _t;
                op6 = _t == ASTNULL ? null : (EJBQLAST)_t;
                Object op6_AST_in = null;
                op6_AST = (EJBQLAST)this.astFactory.create((AST)op6);
                this.astFactory.addASTChild(currentAST, (AST)op6_AST);
                ASTPair __currentAST46 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 43);
                _t = _t.getFirstChild();
                left6 = _t == ASTNULL ? null : (EJBQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                left6_AST = (EJBQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                right6 = _t == ASTNULL ? null : (EJBQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                right6_AST = (EJBQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST46;
                _t = __t46;
                _t = _t.getNextSibling();
                op6_AST.setTypeInfo(this.analyseRelationalExpr(op6_AST, left6_AST, right6_AST));
                relationalExpr_AST = (EJBQLAST)currentAST.root;
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        this.returnAST = relationalExpr_AST;
        this._retTree = _t;
    }

    public final void binaryArithmeticExpr(AST _t) throws RecognitionException {
        EJBQLAST binaryArithmeticExpr_AST_in = _t == ASTNULL ? null : (EJBQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        EJBQLAST binaryArithmeticExpr_AST = null;
        EJBQLAST op1 = null;
        EJBQLAST op1_AST = null;
        EJBQLAST left1_AST = null;
        EJBQLAST left1 = null;
        EJBQLAST right1_AST = null;
        EJBQLAST right1 = null;
        EJBQLAST op2 = null;
        EJBQLAST op2_AST = null;
        EJBQLAST left2_AST = null;
        EJBQLAST left2 = null;
        EJBQLAST right2_AST = null;
        EJBQLAST right2 = null;
        EJBQLAST op3 = null;
        EJBQLAST op3_AST = null;
        EJBQLAST left3_AST = null;
        EJBQLAST left3 = null;
        EJBQLAST right3_AST = null;
        EJBQLAST right3 = null;
        EJBQLAST op4 = null;
        EJBQLAST op4_AST = null;
        EJBQLAST left4_AST = null;
        EJBQLAST left4 = null;
        EJBQLAST right4_AST = null;
        EJBQLAST right4 = null;
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 47: {
                AST __t48 = _t;
                op1 = _t == ASTNULL ? null : (EJBQLAST)_t;
                Object op1_AST_in = null;
                op1_AST = (EJBQLAST)this.astFactory.create((AST)op1);
                this.astFactory.addASTChild(currentAST, (AST)op1_AST);
                ASTPair __currentAST48 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 47);
                _t = _t.getFirstChild();
                left1 = _t == ASTNULL ? null : (EJBQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                left1_AST = (EJBQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                right1 = _t == ASTNULL ? null : (EJBQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                right1_AST = (EJBQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST48;
                _t = __t48;
                _t = _t.getNextSibling();
                op1_AST.setTypeInfo(this.analyseBinaryArithmeticExpr(op1_AST, left1_AST, right1_AST));
                binaryArithmeticExpr_AST = (EJBQLAST)currentAST.root;
                break;
            }
            case 48: {
                AST __t49 = _t;
                op2 = _t == ASTNULL ? null : (EJBQLAST)_t;
                Object op2_AST_in = null;
                op2_AST = (EJBQLAST)this.astFactory.create((AST)op2);
                this.astFactory.addASTChild(currentAST, (AST)op2_AST);
                ASTPair __currentAST49 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 48);
                _t = _t.getFirstChild();
                left2 = _t == ASTNULL ? null : (EJBQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                left2_AST = (EJBQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                right2 = _t == ASTNULL ? null : (EJBQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                right2_AST = (EJBQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST49;
                _t = __t49;
                _t = _t.getNextSibling();
                op2_AST.setTypeInfo(this.analyseBinaryArithmeticExpr(op2_AST, left2_AST, right2_AST));
                binaryArithmeticExpr_AST = (EJBQLAST)currentAST.root;
                break;
            }
            case 49: {
                AST __t50 = _t;
                op3 = _t == ASTNULL ? null : (EJBQLAST)_t;
                Object op3_AST_in = null;
                op3_AST = (EJBQLAST)this.astFactory.create((AST)op3);
                this.astFactory.addASTChild(currentAST, (AST)op3_AST);
                ASTPair __currentAST50 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 49);
                _t = _t.getFirstChild();
                left3 = _t == ASTNULL ? null : (EJBQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                left3_AST = (EJBQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                right3 = _t == ASTNULL ? null : (EJBQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                right3_AST = (EJBQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST50;
                _t = __t50;
                _t = _t.getNextSibling();
                op3_AST.setTypeInfo(this.analyseBinaryArithmeticExpr(op3_AST, left3_AST, right3_AST));
                binaryArithmeticExpr_AST = (EJBQLAST)currentAST.root;
                break;
            }
            case 50: {
                AST __t51 = _t;
                op4 = _t == ASTNULL ? null : (EJBQLAST)_t;
                Object op4_AST_in = null;
                op4_AST = (EJBQLAST)this.astFactory.create((AST)op4);
                this.astFactory.addASTChild(currentAST, (AST)op4_AST);
                ASTPair __currentAST51 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 50);
                _t = _t.getFirstChild();
                left4 = _t == ASTNULL ? null : (EJBQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                left4_AST = (EJBQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                right4 = _t == ASTNULL ? null : (EJBQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                right4_AST = (EJBQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST51;
                _t = __t51;
                _t = _t.getNextSibling();
                op4_AST.setTypeInfo(this.analyseBinaryArithmeticExpr(op4_AST, left4_AST, right4_AST));
                binaryArithmeticExpr_AST = (EJBQLAST)currentAST.root;
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        this.returnAST = binaryArithmeticExpr_AST;
        this._retTree = _t;
    }

    public final void unaryExpr(AST _t) throws RecognitionException {
        EJBQLAST unaryExpr_AST_in = _t == ASTNULL ? null : (EJBQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        EJBQLAST unaryExpr_AST = null;
        EJBQLAST op1 = null;
        EJBQLAST op1_AST = null;
        EJBQLAST arg1_AST = null;
        EJBQLAST arg1 = null;
        EJBQLAST op2 = null;
        EJBQLAST op2_AST = null;
        EJBQLAST arg2_AST = null;
        EJBQLAST arg2 = null;
        EJBQLAST op3 = null;
        EJBQLAST op3_AST = null;
        EJBQLAST arg3_AST = null;
        EJBQLAST arg3 = null;
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 84: {
                AST __t53 = _t;
                op1 = _t == ASTNULL ? null : (EJBQLAST)_t;
                Object op1_AST_in = null;
                op1_AST = (EJBQLAST)this.astFactory.create((AST)op1);
                this.astFactory.addASTChild(currentAST, (AST)op1_AST);
                ASTPair __currentAST53 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 84);
                _t = _t.getFirstChild();
                arg1 = _t == ASTNULL ? null : (EJBQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                arg1_AST = (EJBQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST53;
                _t = __t53;
                _t = _t.getNextSibling();
                op1_AST.setTypeInfo(this.analyseUnaryArithmeticExpr(op1_AST, arg1_AST));
                unaryExpr_AST = (EJBQLAST)currentAST.root;
                break;
            }
            case 83: {
                AST __t54 = _t;
                op2 = _t == ASTNULL ? null : (EJBQLAST)_t;
                Object op2_AST_in = null;
                op2_AST = (EJBQLAST)this.astFactory.create((AST)op2);
                this.astFactory.addASTChild(currentAST, (AST)op2_AST);
                ASTPair __currentAST54 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 83);
                _t = _t.getFirstChild();
                arg2 = _t == ASTNULL ? null : (EJBQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                arg2_AST = (EJBQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST54;
                _t = __t54;
                _t = _t.getNextSibling();
                op2_AST.setTypeInfo(this.analyseUnaryArithmeticExpr(op2_AST, arg2_AST));
                unaryExpr_AST = (EJBQLAST)currentAST.root;
                break;
            }
            case 12: {
                AST __t55 = _t;
                op3 = _t == ASTNULL ? null : (EJBQLAST)_t;
                Object op3_AST_in = null;
                op3_AST = (EJBQLAST)this.astFactory.create((AST)op3);
                this.astFactory.addASTChild(currentAST, (AST)op3_AST);
                ASTPair __currentAST55 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 12);
                _t = _t.getFirstChild();
                arg3 = _t == ASTNULL ? null : (EJBQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                arg3_AST = (EJBQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST55;
                _t = __t55;
                _t = _t.getNextSibling();
                Object typeInfo = TypeSupport.errorType;
                Object arg = arg3_AST.getTypeInfo();
                if (TypeSupport.isErrorType(arg)) {
                    typeInfo = TypeSupport.errorType;
                } else if (TypeSupport.isBooleanType(arg)) {
                    typeInfo = arg;
                } else {
                    ErrorMsg.error(op3_AST.getLine(), op3_AST.getColumn(), I18NHelper.getMessage(msgs, "EXC_InvalidArguments", op3_AST.getText()));
                }
                op3_AST.setTypeInfo(typeInfo);
                unaryExpr_AST = (EJBQLAST)currentAST.root;
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        this.returnAST = unaryExpr_AST;
        this._retTree = _t;
    }

    public final void betweenExpr(AST _t) throws RecognitionException {
        EJBQLAST betweenExpr_AST_in = _t == ASTNULL ? null : (EJBQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        EJBQLAST betweenExpr_AST = null;
        EJBQLAST op1 = null;
        EJBQLAST op1_AST = null;
        EJBQLAST expr1_AST = null;
        EJBQLAST expr1 = null;
        EJBQLAST lower1_AST = null;
        EJBQLAST lower1 = null;
        EJBQLAST upper1_AST = null;
        EJBQLAST upper1 = null;
        EJBQLAST op2 = null;
        EJBQLAST op2_AST = null;
        EJBQLAST expr2_AST = null;
        EJBQLAST expr2 = null;
        EJBQLAST lower2_AST = null;
        EJBQLAST lower2 = null;
        EJBQLAST upper2_AST = null;
        EJBQLAST upper2 = null;
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 15: {
                AST __t57 = _t;
                op1 = _t == ASTNULL ? null : (EJBQLAST)_t;
                Object op1_AST_in = null;
                op1_AST = (EJBQLAST)this.astFactory.create((AST)op1);
                this.astFactory.addASTChild(currentAST, (AST)op1_AST);
                ASTPair __currentAST57 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 15);
                _t = _t.getFirstChild();
                expr1 = _t == ASTNULL ? null : (EJBQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                expr1_AST = (EJBQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                lower1 = _t == ASTNULL ? null : (EJBQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                lower1_AST = (EJBQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                upper1 = _t == ASTNULL ? null : (EJBQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                upper1_AST = (EJBQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST57;
                _t = __t57;
                _t = _t.getNextSibling();
                op1_AST.setTypeInfo(this.isNumberExpr(expr1_AST) && this.isNumberExpr(lower1_AST) && this.isNumberExpr(upper1_AST) ? TypeSupport.booleanType : TypeSupport.errorType);
                betweenExpr_AST = (EJBQLAST)currentAST.root;
                break;
            }
            case 85: {
                AST __t58 = _t;
                op2 = _t == ASTNULL ? null : (EJBQLAST)_t;
                Object op2_AST_in = null;
                op2_AST = (EJBQLAST)this.astFactory.create((AST)op2);
                this.astFactory.addASTChild(currentAST, (AST)op2_AST);
                ASTPair __currentAST58 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 85);
                _t = _t.getFirstChild();
                expr2 = _t == ASTNULL ? null : (EJBQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                expr2_AST = (EJBQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                lower2 = _t == ASTNULL ? null : (EJBQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                lower2_AST = (EJBQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                upper2 = _t == ASTNULL ? null : (EJBQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                upper2_AST = (EJBQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST58;
                _t = __t58;
                _t = _t.getNextSibling();
                op2_AST.setTypeInfo(this.isNumberExpr(expr2_AST) && this.isNumberExpr(lower2_AST) && this.isNumberExpr(upper2_AST) ? TypeSupport.booleanType : TypeSupport.errorType);
                betweenExpr_AST = (EJBQLAST)currentAST.root;
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        this.returnAST = betweenExpr_AST;
        this._retTree = _t;
    }

    public final void likeExpr(AST _t) throws RecognitionException {
        EJBQLAST likeExpr_AST_in = _t == ASTNULL ? null : (EJBQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        EJBQLAST likeExpr_AST = null;
        EJBQLAST op1 = null;
        EJBQLAST op1_AST = null;
        EJBQLAST expr1_AST = null;
        EJBQLAST expr1 = null;
        EJBQLAST op2 = null;
        EJBQLAST op2_AST = null;
        EJBQLAST expr2_AST = null;
        EJBQLAST expr2 = null;
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 16: {
                AST __t60 = _t;
                op1 = _t == ASTNULL ? null : (EJBQLAST)_t;
                Object op1_AST_in = null;
                op1_AST = (EJBQLAST)this.astFactory.create((AST)op1);
                this.astFactory.addASTChild(currentAST, (AST)op1_AST);
                ASTPair __currentAST60 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 16);
                _t = _t.getFirstChild();
                expr1 = _t == ASTNULL ? null : (EJBQLAST)_t;
                this.cmpPathExpression(_t);
                _t = this._retTree;
                expr1_AST = (EJBQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                this.pattern(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                this.escape(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST60;
                _t = __t60;
                _t = _t.getNextSibling();
                op1_AST.setTypeInfo(this.isStringExpr(expr1_AST) ? TypeSupport.booleanType : TypeSupport.errorType);
                likeExpr_AST = (EJBQLAST)currentAST.root;
                break;
            }
            case 86: {
                AST __t61 = _t;
                op2 = _t == ASTNULL ? null : (EJBQLAST)_t;
                Object op2_AST_in = null;
                op2_AST = (EJBQLAST)this.astFactory.create((AST)op2);
                this.astFactory.addASTChild(currentAST, (AST)op2_AST);
                ASTPair __currentAST61 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 86);
                _t = _t.getFirstChild();
                expr2 = _t == ASTNULL ? null : (EJBQLAST)_t;
                this.cmpPathExpression(_t);
                _t = this._retTree;
                expr2_AST = (EJBQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                this.pattern(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                this.escape(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST61;
                _t = __t61;
                _t = _t.getNextSibling();
                op2_AST.setTypeInfo(this.isStringExpr(expr2_AST) ? TypeSupport.booleanType : TypeSupport.errorType);
                likeExpr_AST = (EJBQLAST)currentAST.root;
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        this.returnAST = likeExpr_AST;
        this._retTree = _t;
    }

    public final void inExpr(AST _t) throws RecognitionException {
        EJBQLAST inExpr_AST_in = _t == ASTNULL ? null : (EJBQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        EJBQLAST inExpr_AST = null;
        EJBQLAST op1 = null;
        EJBQLAST op1_AST = null;
        EJBQLAST expr1_AST = null;
        EJBQLAST expr1 = null;
        EJBQLAST op2 = null;
        EJBQLAST op2_AST = null;
        EJBQLAST expr2_AST = null;
        EJBQLAST expr2 = null;
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 17: {
                AST __t67 = _t;
                op1 = _t == ASTNULL ? null : (EJBQLAST)_t;
                Object op1_AST_in = null;
                op1_AST = (EJBQLAST)this.astFactory.create((AST)op1);
                this.astFactory.addASTChild(currentAST, (AST)op1_AST);
                ASTPair __currentAST67 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 17);
                _t = _t.getFirstChild();
                expr1 = _t == ASTNULL ? null : (EJBQLAST)_t;
                this.cmpPathExpression(_t);
                _t = this._retTree;
                expr1_AST = (EJBQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                this.inCollection(_t, expr1_AST.getTypeInfo());
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST67;
                _t = __t67;
                _t = _t.getNextSibling();
                op1_AST.setTypeInfo(this.isNumberOrStringExpr(expr1_AST) ? TypeSupport.booleanType : TypeSupport.errorType);
                inExpr_AST = (EJBQLAST)currentAST.root;
                break;
            }
            case 87: {
                AST __t68 = _t;
                op2 = _t == ASTNULL ? null : (EJBQLAST)_t;
                Object op2_AST_in = null;
                op2_AST = (EJBQLAST)this.astFactory.create((AST)op2);
                this.astFactory.addASTChild(currentAST, (AST)op2_AST);
                ASTPair __currentAST68 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 87);
                _t = _t.getFirstChild();
                expr2 = _t == ASTNULL ? null : (EJBQLAST)_t;
                this.cmpPathExpression(_t);
                _t = this._retTree;
                expr2_AST = (EJBQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                this.inCollection(_t, expr2_AST.getTypeInfo());
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST68;
                _t = __t68;
                _t = _t.getNextSibling();
                op2_AST.setTypeInfo(this.isNumberOrStringExpr(expr2_AST) ? TypeSupport.booleanType : TypeSupport.errorType);
                inExpr_AST = (EJBQLAST)currentAST.root;
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        this.returnAST = inExpr_AST;
        this._retTree = _t;
    }

    public final void nullComparisonExpr(AST _t) throws RecognitionException {
        EJBQLAST nullComparisonExpr_AST_in = _t == ASTNULL ? null : (EJBQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        EJBQLAST nullComparisonExpr_AST = null;
        EJBQLAST op1 = null;
        EJBQLAST op1_AST = null;
        Object expr1_AST = null;
        Object expr1 = null;
        EJBQLAST op2 = null;
        EJBQLAST op2_AST = null;
        Object expr2_AST = null;
        Object expr2 = null;
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 9: {
                AST __t70 = _t;
                op1 = _t == ASTNULL ? null : (EJBQLAST)_t;
                Object op1_AST_in = null;
                op1_AST = (EJBQLAST)this.astFactory.create((AST)op1);
                this.astFactory.addASTChild(currentAST, (AST)op1_AST);
                ASTPair __currentAST70 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 9);
                _t = _t.getFirstChild();
                if (_t == null) {
                    _t = ASTNULL;
                }
                switch (_t.getType()) {
                    case 57: {
                        this.singleValuedPathExpression(_t);
                        _t = this._retTree;
                        this.astFactory.addASTChild(currentAST, this.returnAST);
                        break;
                    }
                    case 58: {
                        this.inputParameter(_t);
                        _t = this._retTree;
                        this.astFactory.addASTChild(currentAST, this.returnAST);
                        break;
                    }
                    default: {
                        throw new NoViableAltException(_t);
                    }
                }
                currentAST = __currentAST70;
                _t = __t70;
                _t = _t.getNextSibling();
                op1_AST.setTypeInfo(TypeSupport.booleanType);
                nullComparisonExpr_AST = (EJBQLAST)currentAST.root;
                break;
            }
            case 88: {
                AST __t72 = _t;
                op2 = _t == ASTNULL ? null : (EJBQLAST)_t;
                Object op2_AST_in = null;
                op2_AST = (EJBQLAST)this.astFactory.create((AST)op2);
                this.astFactory.addASTChild(currentAST, (AST)op2_AST);
                ASTPair __currentAST72 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 88);
                _t = _t.getFirstChild();
                if (_t == null) {
                    _t = ASTNULL;
                }
                switch (_t.getType()) {
                    case 57: {
                        this.singleValuedPathExpression(_t);
                        _t = this._retTree;
                        this.astFactory.addASTChild(currentAST, this.returnAST);
                        break;
                    }
                    case 58: {
                        this.inputParameter(_t);
                        _t = this._retTree;
                        this.astFactory.addASTChild(currentAST, this.returnAST);
                        break;
                    }
                    default: {
                        throw new NoViableAltException(_t);
                    }
                }
                currentAST = __currentAST72;
                _t = __t72;
                _t = _t.getNextSibling();
                op2_AST.setTypeInfo(TypeSupport.booleanType);
                nullComparisonExpr_AST = (EJBQLAST)currentAST.root;
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        this.returnAST = nullComparisonExpr_AST;
        this._retTree = _t;
    }

    public final void emptyCollectionComparisonExpr(AST _t) throws RecognitionException {
        EJBQLAST emptyCollectionComparisonExpr_AST_in = _t == ASTNULL ? null : (EJBQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        EJBQLAST emptyCollectionComparisonExpr_AST = null;
        EJBQLAST op1 = null;
        EJBQLAST op1_AST = null;
        EJBQLAST col1_AST = null;
        EJBQLAST col1 = null;
        EJBQLAST op2 = null;
        EJBQLAST op2_AST = null;
        EJBQLAST col2_AST = null;
        EJBQLAST col2 = null;
        Object elementTypeInfo = null;
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 20: {
                AST __t75 = _t;
                op1 = _t == ASTNULL ? null : (EJBQLAST)_t;
                Object op1_AST_in = null;
                op1_AST = (EJBQLAST)this.astFactory.create((AST)op1);
                this.astFactory.addASTChild(currentAST, (AST)op1_AST);
                ASTPair __currentAST75 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 20);
                _t = _t.getFirstChild();
                col1 = _t == ASTNULL ? null : (EJBQLAST)_t;
                this.collectionValuedPathExpression(_t);
                _t = this._retTree;
                col1_AST = (EJBQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST75;
                _t = __t75;
                _t = _t.getNextSibling();
                elementTypeInfo = this.analyseCollectionValuedCMRField(col1_AST);
                op1_AST.setTypeInfo(TypeSupport.isErrorType(elementTypeInfo) ? TypeSupport.errorType : TypeSupport.booleanType);
                emptyCollectionComparisonExpr_AST = (EJBQLAST)currentAST.root;
                break;
            }
            case 89: {
                AST __t76 = _t;
                op2 = _t == ASTNULL ? null : (EJBQLAST)_t;
                Object op2_AST_in = null;
                op2_AST = (EJBQLAST)this.astFactory.create((AST)op2);
                this.astFactory.addASTChild(currentAST, (AST)op2_AST);
                ASTPair __currentAST76 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 89);
                _t = _t.getFirstChild();
                col2 = _t == ASTNULL ? null : (EJBQLAST)_t;
                this.collectionValuedPathExpression(_t);
                _t = this._retTree;
                col2_AST = (EJBQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST76;
                _t = __t76;
                _t = _t.getNextSibling();
                elementTypeInfo = this.analyseCollectionValuedCMRField(col2_AST);
                op2_AST.setTypeInfo(TypeSupport.isErrorType(elementTypeInfo) ? TypeSupport.errorType : TypeSupport.booleanType);
                emptyCollectionComparisonExpr_AST = (EJBQLAST)currentAST.root;
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        this.returnAST = emptyCollectionComparisonExpr_AST;
        this._retTree = _t;
    }

    public final void collectionMemberExpr(AST _t) throws RecognitionException {
        EJBQLAST collectionMemberExpr_AST_in = _t == ASTNULL ? null : (EJBQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        EJBQLAST collectionMemberExpr_AST = null;
        EJBQLAST op1 = null;
        EJBQLAST op1_AST = null;
        EJBQLAST value1_AST = null;
        EJBQLAST value1 = null;
        EJBQLAST col1_AST = null;
        EJBQLAST col1 = null;
        EJBQLAST op2 = null;
        EJBQLAST op2_AST = null;
        EJBQLAST value2_AST = null;
        EJBQLAST value2 = null;
        EJBQLAST col2_AST = null;
        EJBQLAST col2 = null;
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 21: {
                AST __t78 = _t;
                op1 = _t == ASTNULL ? null : (EJBQLAST)_t;
                Object op1_AST_in = null;
                op1_AST = (EJBQLAST)this.astFactory.create((AST)op1);
                this.astFactory.addASTChild(currentAST, (AST)op1_AST);
                ASTPair __currentAST78 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 21);
                _t = _t.getFirstChild();
                value1 = _t == ASTNULL ? null : (EJBQLAST)_t;
                this.member(_t);
                _t = this._retTree;
                value1_AST = (EJBQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                col1 = _t == ASTNULL ? null : (EJBQLAST)_t;
                this.collectionValuedPathExpression(_t);
                _t = this._retTree;
                col1_AST = (EJBQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST78;
                _t = __t78;
                _t = _t.getNextSibling();
                op1_AST.setTypeInfo(this.analyseMemberExpr(op1_AST, value1_AST, col1_AST));
                collectionMemberExpr_AST = (EJBQLAST)currentAST.root;
                break;
            }
            case 90: {
                AST __t79 = _t;
                op2 = _t == ASTNULL ? null : (EJBQLAST)_t;
                Object op2_AST_in = null;
                op2_AST = (EJBQLAST)this.astFactory.create((AST)op2);
                this.astFactory.addASTChild(currentAST, (AST)op2_AST);
                ASTPair __currentAST79 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 90);
                _t = _t.getFirstChild();
                value2 = _t == ASTNULL ? null : (EJBQLAST)_t;
                this.member(_t);
                _t = this._retTree;
                value2_AST = (EJBQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                col2 = _t == ASTNULL ? null : (EJBQLAST)_t;
                this.collectionValuedPathExpression(_t);
                _t = this._retTree;
                col2_AST = (EJBQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST79;
                _t = __t79;
                _t = _t.getNextSibling();
                op2_AST.setTypeInfo(this.analyseMemberExpr(op2_AST, value2_AST, col2_AST));
                collectionMemberExpr_AST = (EJBQLAST)currentAST.root;
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        this.returnAST = collectionMemberExpr_AST;
        this._retTree = _t;
    }

    public final void function(AST _t) throws RecognitionException {
        EJBQLAST function_AST_in = _t == ASTNULL ? null : (EJBQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        EJBQLAST function_AST = null;
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 25: {
                this.concat(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                function_AST = (EJBQLAST)currentAST.root;
                break;
            }
            case 26: {
                this.substring(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                function_AST = (EJBQLAST)currentAST.root;
                break;
            }
            case 28: {
                this.length(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                function_AST = (EJBQLAST)currentAST.root;
                break;
            }
            case 27: {
                this.locate(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                function_AST = (EJBQLAST)currentAST.root;
                break;
            }
            case 29: {
                this.abs(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                function_AST = (EJBQLAST)currentAST.root;
                break;
            }
            case 30: {
                this.sqrt(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                function_AST = (EJBQLAST)currentAST.root;
                break;
            }
            case 31: {
                this.mod(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                function_AST = (EJBQLAST)currentAST.root;
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        this.returnAST = function_AST;
        this._retTree = _t;
    }

    public final void primary(AST _t) throws RecognitionException {
        EJBQLAST primary_AST_in = _t == ASTNULL ? null : (EJBQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        EJBQLAST primary_AST = null;
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 10: 
            case 11: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                this.literal(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                primary_AST = (EJBQLAST)currentAST.root;
                break;
            }
            case 57: {
                this.singleValuedPathExpression(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                primary_AST = (EJBQLAST)currentAST.root;
                break;
            }
            case 56: {
                this.identificationVariable(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                primary_AST = (EJBQLAST)currentAST.root;
                break;
            }
            case 58: {
                this.inputParameter(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                primary_AST = (EJBQLAST)currentAST.root;
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        this.returnAST = primary_AST;
        this._retTree = _t;
    }

    public final void pattern(AST _t) throws RecognitionException {
        EJBQLAST pattern_AST_in = _t == ASTNULL ? null : (EJBQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        EJBQLAST pattern_AST = null;
        EJBQLAST p_AST = null;
        EJBQLAST p = null;
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 51: {
                EJBQLAST tmp16_AST = null;
                EJBQLAST tmp16_AST_in = null;
                tmp16_AST = (EJBQLAST)this.astFactory.create((AST)((EJBQLAST)_t));
                tmp16_AST_in = (EJBQLAST)_t;
                this.astFactory.addASTChild(currentAST, (AST)tmp16_AST);
                this.match(_t, 51);
                _t = _t.getNextSibling();
                pattern_AST = (EJBQLAST)currentAST.root;
                break;
            }
            case 58: {
                p = _t == ASTNULL ? null : (EJBQLAST)_t;
                this.inputParameter(_t);
                _t = this._retTree;
                p_AST = (EJBQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                if (!TypeSupport.isStringType(p_AST.getTypeInfo())) {
                    ErrorMsg.error(p_AST.getLine(), p_AST.getColumn(), I18NHelper.getMessage(msgs, "EXC_InvalidPatternDefinition", p_AST.getText()));
                }
                pattern_AST = (EJBQLAST)currentAST.root;
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        this.returnAST = pattern_AST;
        this._retTree = _t;
    }

    public final void escape(AST _t) throws RecognitionException {
        EJBQLAST escape_AST_in = _t == ASTNULL ? null : (EJBQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        EJBQLAST escape_AST = null;
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 24: {
                AST __t64 = _t;
                EJBQLAST tmp17_AST = null;
                EJBQLAST tmp17_AST_in = null;
                tmp17_AST = (EJBQLAST)this.astFactory.create((AST)((EJBQLAST)_t));
                tmp17_AST_in = (EJBQLAST)_t;
                this.astFactory.addASTChild(currentAST, (AST)tmp17_AST);
                ASTPair __currentAST64 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 24);
                _t = _t.getFirstChild();
                this.escapeCharacter(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST64;
                _t = __t64;
                _t = _t.getNextSibling();
                escape_AST = (EJBQLAST)currentAST.root;
                break;
            }
            case 3: {
                escape_AST = (EJBQLAST)currentAST.root;
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        this.returnAST = escape_AST;
        this._retTree = _t;
    }

    public final void inputParameter(AST _t) throws RecognitionException {
        EJBQLAST inputParameter_AST_in = _t == ASTNULL ? null : (EJBQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        EJBQLAST inputParameter_AST = null;
        EJBQLAST param = null;
        EJBQLAST param_AST = null;
        param = (EJBQLAST)_t;
        Object param_AST_in = null;
        param_AST = (EJBQLAST)this.astFactory.create((AST)param);
        this.astFactory.addASTChild(currentAST, (AST)param_AST);
        this.match(_t, 58);
        _t = _t.getNextSibling();
        Object typeInfo = this.typeSupport.getTypeInfo(this.paramSupport.getParameterType(param_AST.getText()));
        param_AST.setTypeInfo(typeInfo);
        inputParameter_AST = (EJBQLAST)currentAST.root;
        this.returnAST = inputParameter_AST;
        this._retTree = _t;
    }

    public final void escapeCharacter(AST _t) throws RecognitionException {
        EJBQLAST escapeCharacter_AST_in = _t == ASTNULL ? null : (EJBQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        EJBQLAST escapeCharacter_AST = null;
        EJBQLAST s = null;
        EJBQLAST s_AST = null;
        EJBQLAST p_AST = null;
        EJBQLAST p = null;
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 51: {
                s = (EJBQLAST)_t;
                Object s_AST_in = null;
                s_AST = (EJBQLAST)this.astFactory.create((AST)s);
                this.astFactory.addASTChild(currentAST, (AST)s_AST);
                this.match(_t, 51);
                _t = _t.getNextSibling();
                String literal = s_AST.getText();
                if (!this.isSingleCharacterStringLiteral(s_AST.getText())) {
                    ErrorMsg.error(s_AST.getLine(), s_AST.getColumn(), I18NHelper.getMessage(msgs, "EXC_InvalidEscapeDefinition", s_AST.getText()));
                }
                escapeCharacter_AST = (EJBQLAST)currentAST.root;
                break;
            }
            case 58: {
                p = _t == ASTNULL ? null : (EJBQLAST)_t;
                this.inputParameter(_t);
                _t = this._retTree;
                p_AST = (EJBQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                Object paramType = p_AST.getTypeInfo();
                if (!TypeSupport.isCharType(paramType)) {
                    ErrorMsg.error(p_AST.getLine(), p_AST.getColumn(), I18NHelper.getMessage(msgs, "EXC_InvalidEscapeParameterDefinition", p_AST.getText()));
                }
                escapeCharacter_AST = (EJBQLAST)currentAST.root;
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        this.returnAST = escapeCharacter_AST;
        this._retTree = _t;
    }

    public final void inCollection(AST _t, Object valueExprTypeInfo) throws RecognitionException {
        EJBQLAST inCollection_AST_in = _t == ASTNULL ? null : (EJBQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        EJBQLAST inCollection_AST = null;
        int _cnt109 = 0;
        while (true) {
            if (_t == null) {
                _t = ASTNULL;
            }
            if (!_tokenSet_0.member(_t.getType())) {
                if (_cnt109 >= 1) break;
                throw new NoViableAltException(_t);
            }
            this.inCollectionElement(_t, valueExprTypeInfo);
            _t = this._retTree;
            this.astFactory.addASTChild(currentAST, this.returnAST);
            ++_cnt109;
        }
        inCollection_AST = (EJBQLAST)currentAST.root;
        this.returnAST = inCollection_AST;
        this._retTree = _t;
    }

    public final void member(AST _t) throws RecognitionException {
        EJBQLAST member_AST_in = _t == ASTNULL ? null : (EJBQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        EJBQLAST member_AST = null;
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 56: {
                this.identificationVariable(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                member_AST = (EJBQLAST)currentAST.root;
                break;
            }
            case 58: {
                this.inputParameter(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                member_AST = (EJBQLAST)currentAST.root;
                break;
            }
            case 57: {
                this.singleValuedCmrPathExpression(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                member_AST = (EJBQLAST)currentAST.root;
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        this.returnAST = member_AST;
        this._retTree = _t;
    }

    public final void identificationVariable(AST _t) throws RecognitionException {
        EJBQLAST identificationVariable_AST_in = _t == ASTNULL ? null : (EJBQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        EJBQLAST identificationVariable_AST = null;
        EJBQLAST i = null;
        EJBQLAST i_AST = null;
        i = (EJBQLAST)_t;
        Object i_AST_in = null;
        i_AST = (EJBQLAST)this.astFactory.create((AST)i);
        this.astFactory.addASTChild(currentAST, (AST)i_AST);
        this.match(_t, 56);
        _t = _t.getNextSibling();
        String name = i_AST.getText();
        Object decl = this.symtab.getDeclaration(name);
        if (decl != null && decl instanceof IdentificationVariable) {
            i_AST.setType(77);
            i_AST.setTypeInfo(((IdentificationVariable)decl).getTypeInfo());
        } else {
            i_AST.setTypeInfo(TypeSupport.errorType);
            ErrorMsg.error(i_AST.getLine(), i_AST.getColumn(), I18NHelper.getMessage(msgs, "EXC_UndefinedIdentifier", name));
        }
        identificationVariable_AST = (EJBQLAST)currentAST.root;
        this.returnAST = identificationVariable_AST;
        this._retTree = _t;
    }

    public final void singleValuedCmrPathExpression(AST _t) throws RecognitionException {
        EJBQLAST singleValuedCmrPathExpression_AST_in = _t == ASTNULL ? null : (EJBQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        EJBQLAST singleValuedCmrPathExpression_AST = null;
        EJBQLAST p_AST = null;
        EJBQLAST p = null;
        p = _t == ASTNULL ? null : (EJBQLAST)_t;
        this.pathExpression(_t);
        _t = this._retTree;
        p_AST = (EJBQLAST)this.returnAST;
        this.astFactory.addASTChild(currentAST, this.returnAST);
        int fieldTokenType = p_AST.getType();
        if (fieldTokenType != 75) {
            EJBQLAST classExpr = (EJBQLAST)p_AST.getFirstChild();
            EJBQLAST field = (EJBQLAST)classExpr.getNextSibling();
            ErrorMsg.error(field.getLine(), field.getColumn(), I18NHelper.getMessage(msgs, "EXC_SingleValuedCMRFieldExpected", field.getText(), TypeSupport.getTypeName(field.getTypeInfo())));
            p_AST.setType(76);
        }
        singleValuedCmrPathExpression_AST = (EJBQLAST)currentAST.root;
        this.returnAST = singleValuedCmrPathExpression_AST;
        this._retTree = _t;
    }

    public final void concat(AST _t) throws RecognitionException {
        EJBQLAST concat_AST_in = _t == ASTNULL ? null : (EJBQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        EJBQLAST concat_AST = null;
        EJBQLAST op = null;
        EJBQLAST op_AST = null;
        EJBQLAST arg1_AST = null;
        EJBQLAST arg1 = null;
        EJBQLAST arg2_AST = null;
        EJBQLAST arg2 = null;
        AST __t83 = _t;
        op = _t == ASTNULL ? null : (EJBQLAST)_t;
        Object op_AST_in = null;
        op_AST = (EJBQLAST)this.astFactory.create((AST)op);
        this.astFactory.addASTChild(currentAST, (AST)op_AST);
        ASTPair __currentAST83 = currentAST.copy();
        currentAST.root = currentAST.child;
        currentAST.child = null;
        this.match(_t, 25);
        _t = _t.getFirstChild();
        arg1 = _t == ASTNULL ? null : (EJBQLAST)_t;
        this.expression(_t);
        _t = this._retTree;
        arg1_AST = (EJBQLAST)this.returnAST;
        this.astFactory.addASTChild(currentAST, this.returnAST);
        arg2 = _t == ASTNULL ? null : (EJBQLAST)_t;
        this.expression(_t);
        _t = this._retTree;
        arg2_AST = (EJBQLAST)this.returnAST;
        this.astFactory.addASTChild(currentAST, this.returnAST);
        currentAST = __currentAST83;
        _t = __t83;
        _t = _t.getNextSibling();
        op_AST.setTypeInfo(this.isStringExpr(arg1_AST) && this.isStringExpr(arg2_AST) ? TypeSupport.stringType : TypeSupport.errorType);
        concat_AST = (EJBQLAST)currentAST.root;
        this.returnAST = concat_AST;
        this._retTree = _t;
    }

    public final void substring(AST _t) throws RecognitionException {
        EJBQLAST substring_AST_in = _t == ASTNULL ? null : (EJBQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        EJBQLAST substring_AST = null;
        EJBQLAST op = null;
        EJBQLAST op_AST = null;
        EJBQLAST arg1_AST = null;
        EJBQLAST arg1 = null;
        EJBQLAST arg2_AST = null;
        EJBQLAST arg2 = null;
        EJBQLAST arg3_AST = null;
        EJBQLAST arg3 = null;
        AST __t85 = _t;
        op = _t == ASTNULL ? null : (EJBQLAST)_t;
        Object op_AST_in = null;
        op_AST = (EJBQLAST)this.astFactory.create((AST)op);
        this.astFactory.addASTChild(currentAST, (AST)op_AST);
        ASTPair __currentAST85 = currentAST.copy();
        currentAST.root = currentAST.child;
        currentAST.child = null;
        this.match(_t, 26);
        _t = _t.getFirstChild();
        arg1 = _t == ASTNULL ? null : (EJBQLAST)_t;
        this.expression(_t);
        _t = this._retTree;
        arg1_AST = (EJBQLAST)this.returnAST;
        this.astFactory.addASTChild(currentAST, this.returnAST);
        arg2 = _t == ASTNULL ? null : (EJBQLAST)_t;
        this.expression(_t);
        _t = this._retTree;
        arg2_AST = (EJBQLAST)this.returnAST;
        this.astFactory.addASTChild(currentAST, this.returnAST);
        arg3 = _t == ASTNULL ? null : (EJBQLAST)_t;
        this.expression(_t);
        _t = this._retTree;
        arg3_AST = (EJBQLAST)this.returnAST;
        this.astFactory.addASTChild(currentAST, this.returnAST);
        currentAST = __currentAST85;
        _t = __t85;
        _t = _t.getNextSibling();
        op_AST.setTypeInfo(this.isStringExpr(arg1_AST) && this.isIntExpr(arg2_AST) && this.isIntExpr(arg3_AST) ? TypeSupport.stringType : TypeSupport.errorType);
        substring_AST = (EJBQLAST)currentAST.root;
        this.returnAST = substring_AST;
        this._retTree = _t;
    }

    public final void length(AST _t) throws RecognitionException {
        EJBQLAST length_AST_in = _t == ASTNULL ? null : (EJBQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        EJBQLAST length_AST = null;
        EJBQLAST op = null;
        EJBQLAST op_AST = null;
        EJBQLAST arg_AST = null;
        EJBQLAST arg = null;
        AST __t87 = _t;
        op = _t == ASTNULL ? null : (EJBQLAST)_t;
        Object op_AST_in = null;
        op_AST = (EJBQLAST)this.astFactory.create((AST)op);
        this.astFactory.addASTChild(currentAST, (AST)op_AST);
        ASTPair __currentAST87 = currentAST.copy();
        currentAST.root = currentAST.child;
        currentAST.child = null;
        this.match(_t, 28);
        _t = _t.getFirstChild();
        arg = _t == ASTNULL ? null : (EJBQLAST)_t;
        this.expression(_t);
        _t = this._retTree;
        arg_AST = (EJBQLAST)this.returnAST;
        this.astFactory.addASTChild(currentAST, this.returnAST);
        currentAST = __currentAST87;
        _t = __t87;
        _t = _t.getNextSibling();
        op_AST.setTypeInfo(this.isStringExpr(arg_AST) ? TypeSupport.intType : TypeSupport.errorType);
        length_AST = (EJBQLAST)currentAST.root;
        this.returnAST = length_AST;
        this._retTree = _t;
    }

    public final void locate(AST _t) throws RecognitionException {
        EJBQLAST locate_AST_in = _t == ASTNULL ? null : (EJBQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        EJBQLAST locate_AST = null;
        EJBQLAST op = null;
        EJBQLAST op_AST = null;
        EJBQLAST arg1_AST = null;
        EJBQLAST arg1 = null;
        EJBQLAST arg2_AST = null;
        EJBQLAST arg2 = null;
        EJBQLAST arg3_AST = null;
        EJBQLAST arg3 = null;
        AST __t89 = _t;
        op = _t == ASTNULL ? null : (EJBQLAST)_t;
        Object op_AST_in = null;
        op_AST = (EJBQLAST)this.astFactory.create((AST)op);
        this.astFactory.addASTChild(currentAST, (AST)op_AST);
        ASTPair __currentAST89 = currentAST.copy();
        currentAST.root = currentAST.child;
        currentAST.child = null;
        this.match(_t, 27);
        _t = _t.getFirstChild();
        arg1 = _t == ASTNULL ? null : (EJBQLAST)_t;
        this.expression(_t);
        _t = this._retTree;
        arg1_AST = (EJBQLAST)this.returnAST;
        this.astFactory.addASTChild(currentAST, this.returnAST);
        arg2 = _t == ASTNULL ? null : (EJBQLAST)_t;
        this.expression(_t);
        _t = this._retTree;
        arg2_AST = (EJBQLAST)this.returnAST;
        this.astFactory.addASTChild(currentAST, this.returnAST);
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: {
                arg3 = _t == ASTNULL ? null : (EJBQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                arg3_AST = (EJBQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        currentAST = __currentAST89;
        _t = __t89;
        _t = _t.getNextSibling();
        op_AST.setTypeInfo(this.isStringExpr(arg1_AST) && this.isStringExpr(arg2_AST) && (arg3_AST == null || this.isIntExpr(arg3_AST)) ? TypeSupport.intType : TypeSupport.errorType);
        locate_AST = (EJBQLAST)currentAST.root;
        this.returnAST = locate_AST;
        this._retTree = _t;
    }

    public final void abs(AST _t) throws RecognitionException {
        EJBQLAST abs_AST_in = _t == ASTNULL ? null : (EJBQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        EJBQLAST abs_AST = null;
        EJBQLAST op = null;
        EJBQLAST op_AST = null;
        EJBQLAST expr_AST = null;
        EJBQLAST expr = null;
        AST __t92 = _t;
        op = _t == ASTNULL ? null : (EJBQLAST)_t;
        Object op_AST_in = null;
        op_AST = (EJBQLAST)this.astFactory.create((AST)op);
        this.astFactory.addASTChild(currentAST, (AST)op_AST);
        ASTPair __currentAST92 = currentAST.copy();
        currentAST.root = currentAST.child;
        currentAST.child = null;
        this.match(_t, 29);
        _t = _t.getFirstChild();
        expr = _t == ASTNULL ? null : (EJBQLAST)_t;
        this.expression(_t);
        _t = this._retTree;
        expr_AST = (EJBQLAST)this.returnAST;
        this.astFactory.addASTChild(currentAST, this.returnAST);
        currentAST = __currentAST92;
        _t = __t92;
        _t = _t.getNextSibling();
        op_AST.setTypeInfo(this.isNumberExpr(expr_AST) ? expr_AST.getTypeInfo() : TypeSupport.errorType);
        abs_AST = (EJBQLAST)currentAST.root;
        this.returnAST = abs_AST;
        this._retTree = _t;
    }

    public final void sqrt(AST _t) throws RecognitionException {
        EJBQLAST sqrt_AST_in = _t == ASTNULL ? null : (EJBQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        EJBQLAST sqrt_AST = null;
        EJBQLAST op = null;
        EJBQLAST op_AST = null;
        EJBQLAST expr_AST = null;
        EJBQLAST expr = null;
        AST __t94 = _t;
        op = _t == ASTNULL ? null : (EJBQLAST)_t;
        Object op_AST_in = null;
        op_AST = (EJBQLAST)this.astFactory.create((AST)op);
        this.astFactory.addASTChild(currentAST, (AST)op_AST);
        ASTPair __currentAST94 = currentAST.copy();
        currentAST.root = currentAST.child;
        currentAST.child = null;
        this.match(_t, 30);
        _t = _t.getFirstChild();
        expr = _t == ASTNULL ? null : (EJBQLAST)_t;
        this.expression(_t);
        _t = this._retTree;
        expr_AST = (EJBQLAST)this.returnAST;
        this.astFactory.addASTChild(currentAST, this.returnAST);
        currentAST = __currentAST94;
        _t = __t94;
        _t = _t.getNextSibling();
        op_AST.setTypeInfo(this.isDoubleExpr(expr_AST) ? expr_AST.getTypeInfo() : TypeSupport.errorType);
        sqrt_AST = (EJBQLAST)currentAST.root;
        this.returnAST = sqrt_AST;
        this._retTree = _t;
    }

    public final void mod(AST _t) throws RecognitionException {
        EJBQLAST mod_AST_in = _t == ASTNULL ? null : (EJBQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        EJBQLAST mod_AST = null;
        EJBQLAST op = null;
        EJBQLAST op_AST = null;
        EJBQLAST arg1_AST = null;
        EJBQLAST arg1 = null;
        EJBQLAST arg2_AST = null;
        EJBQLAST arg2 = null;
        AST __t96 = _t;
        op = _t == ASTNULL ? null : (EJBQLAST)_t;
        Object op_AST_in = null;
        op_AST = (EJBQLAST)this.astFactory.create((AST)op);
        this.astFactory.addASTChild(currentAST, (AST)op_AST);
        ASTPair __currentAST96 = currentAST.copy();
        currentAST.root = currentAST.child;
        currentAST.child = null;
        this.match(_t, 31);
        _t = _t.getFirstChild();
        arg1 = _t == ASTNULL ? null : (EJBQLAST)_t;
        this.expression(_t);
        _t = this._retTree;
        arg1_AST = (EJBQLAST)this.returnAST;
        this.astFactory.addASTChild(currentAST, this.returnAST);
        arg2 = _t == ASTNULL ? null : (EJBQLAST)_t;
        this.expression(_t);
        _t = this._retTree;
        arg2_AST = (EJBQLAST)this.returnAST;
        this.astFactory.addASTChild(currentAST, this.returnAST);
        currentAST = __currentAST96;
        _t = __t96;
        _t = _t.getNextSibling();
        op_AST.setTypeInfo(this.isIntExpr(arg1_AST) && this.isIntExpr(arg2_AST) ? TypeSupport.intType : TypeSupport.errorType);
        mod_AST = (EJBQLAST)currentAST.root;
        this.returnAST = mod_AST;
        this._retTree = _t;
    }

    public final void literal(AST _t) throws RecognitionException {
        EJBQLAST literal_AST_in = _t == ASTNULL ? null : (EJBQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        EJBQLAST literal_AST = null;
        EJBQLAST b1 = null;
        EJBQLAST b1_AST = null;
        EJBQLAST b2 = null;
        EJBQLAST b2_AST = null;
        EJBQLAST s = null;
        EJBQLAST s_AST = null;
        EJBQLAST i = null;
        EJBQLAST i_AST = null;
        EJBQLAST l = null;
        EJBQLAST l_AST = null;
        EJBQLAST f = null;
        EJBQLAST f_AST = null;
        EJBQLAST d = null;
        EJBQLAST d_AST = null;
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 10: {
                b1 = (EJBQLAST)_t;
                Object b1_AST_in = null;
                b1_AST = (EJBQLAST)this.astFactory.create((AST)b1);
                this.astFactory.addASTChild(currentAST, (AST)b1_AST);
                this.match(_t, 10);
                _t = _t.getNextSibling();
                b1_AST.setTypeInfo(TypeSupport.booleanType);
                literal_AST = (EJBQLAST)currentAST.root;
                break;
            }
            case 11: {
                b2 = (EJBQLAST)_t;
                Object b2_AST_in = null;
                b2_AST = (EJBQLAST)this.astFactory.create((AST)b2);
                this.astFactory.addASTChild(currentAST, (AST)b2_AST);
                this.match(_t, 11);
                _t = _t.getNextSibling();
                b2_AST.setTypeInfo(TypeSupport.booleanType);
                literal_AST = (EJBQLAST)currentAST.root;
                break;
            }
            case 51: {
                s = (EJBQLAST)_t;
                Object s_AST_in = null;
                s_AST = (EJBQLAST)this.astFactory.create((AST)s);
                this.astFactory.addASTChild(currentAST, (AST)s_AST);
                this.match(_t, 51);
                _t = _t.getNextSibling();
                s_AST.setTypeInfo(TypeSupport.stringType);
                literal_AST = (EJBQLAST)currentAST.root;
                break;
            }
            case 52: {
                i = (EJBQLAST)_t;
                Object i_AST_in = null;
                i_AST = (EJBQLAST)this.astFactory.create((AST)i);
                this.astFactory.addASTChild(currentAST, (AST)i_AST);
                this.match(_t, 52);
                _t = _t.getNextSibling();
                i_AST.setTypeInfo(TypeSupport.intType);
                literal_AST = (EJBQLAST)currentAST.root;
                break;
            }
            case 53: {
                l = (EJBQLAST)_t;
                Object l_AST_in = null;
                l_AST = (EJBQLAST)this.astFactory.create((AST)l);
                this.astFactory.addASTChild(currentAST, (AST)l_AST);
                this.match(_t, 53);
                _t = _t.getNextSibling();
                l_AST.setTypeInfo(TypeSupport.longType);
                literal_AST = (EJBQLAST)currentAST.root;
                break;
            }
            case 54: {
                f = (EJBQLAST)_t;
                Object f_AST_in = null;
                f_AST = (EJBQLAST)this.astFactory.create((AST)f);
                this.astFactory.addASTChild(currentAST, (AST)f_AST);
                this.match(_t, 54);
                _t = _t.getNextSibling();
                f_AST.setTypeInfo(TypeSupport.floatType);
                literal_AST = (EJBQLAST)currentAST.root;
                break;
            }
            case 55: {
                d = (EJBQLAST)_t;
                Object d_AST_in = null;
                d_AST = (EJBQLAST)this.astFactory.create((AST)d);
                this.astFactory.addASTChild(currentAST, (AST)d_AST);
                this.match(_t, 55);
                _t = _t.getNextSibling();
                d_AST.setTypeInfo(TypeSupport.doubleType);
                literal_AST = (EJBQLAST)currentAST.root;
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        this.returnAST = literal_AST;
        this._retTree = _t;
    }

    public final void pathExpression(AST _t) throws RecognitionException {
        EJBQLAST pathExpression_AST_in = _t == ASTNULL ? null : (EJBQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        EJBQLAST pathExpression_AST = null;
        EJBQLAST dot = null;
        EJBQLAST dot_AST = null;
        EJBQLAST o_AST = null;
        EJBQLAST o = null;
        EJBQLAST i = null;
        EJBQLAST i_AST = null;
        AST __t100 = _t;
        dot = _t == ASTNULL ? null : (EJBQLAST)_t;
        Object dot_AST_in = null;
        dot_AST = (EJBQLAST)this.astFactory.create((AST)dot);
        this.astFactory.addASTChild(currentAST, (AST)dot_AST);
        ASTPair __currentAST100 = currentAST.copy();
        currentAST.root = currentAST.child;
        currentAST.child = null;
        this.match(_t, 57);
        _t = _t.getFirstChild();
        o = _t == ASTNULL ? null : (EJBQLAST)_t;
        this.objectDenoter(_t);
        _t = this._retTree;
        o_AST = (EJBQLAST)this.returnAST;
        this.astFactory.addASTChild(currentAST, this.returnAST);
        i = (EJBQLAST)_t;
        Object i_AST_in = null;
        i_AST = (EJBQLAST)this.astFactory.create((AST)i);
        this.astFactory.addASTChild(currentAST, (AST)i_AST);
        this.match(_t, 56);
        _t = _t.getNextSibling();
        currentAST = __currentAST100;
        _t = __t100;
        _t = _t.getNextSibling();
        String fieldName = i_AST.getText();
        Object typeInfo = o_AST.getTypeInfo();
        Object fieldTypeInfo = this.typeSupport.getFieldType(typeInfo, fieldName);
        if (fieldTypeInfo == null) {
            ErrorMsg.error(i_AST.getLine(), i_AST.getColumn(), I18NHelper.getMessage(msgs, "EXC_UnknownField", fieldName, this.typeSupport.getAbstractSchemaForTypeInfo(typeInfo)));
            fieldTypeInfo = TypeSupport.errorType;
        } else {
            Object fieldInfo = this.typeSupport.getFieldInfo(typeInfo, fieldName);
            if (fieldInfo == null) {
                ErrorMsg.fatal(I18NHelper.getMessage(msgs, "ERR_MissingFieldInfo", fieldName, TypeSupport.getTypeName(typeInfo)));
            }
            if (!this.typeSupport.isRelationship(fieldInfo)) {
                i_AST.setType(80);
                dot_AST.setType(74);
            } else if (this.typeSupport.isCollectionType(fieldTypeInfo)) {
                i_AST.setType(82);
                dot_AST.setType(76);
            } else {
                i_AST.setType(81);
                dot_AST.setType(75);
            }
        }
        dot_AST.setTypeInfo(fieldTypeInfo);
        i_AST.setTypeInfo(fieldTypeInfo);
        pathExpression_AST = (EJBQLAST)currentAST.root;
        this.returnAST = pathExpression_AST;
        this._retTree = _t;
    }

    public final void objectDenoter(AST _t) throws RecognitionException {
        EJBQLAST objectDenoter_AST_in = _t == ASTNULL ? null : (EJBQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        EJBQLAST objectDenoter_AST = null;
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 56: {
                this.identificationVariable(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                objectDenoter_AST = (EJBQLAST)currentAST.root;
                break;
            }
            case 57: {
                this.singleValuedCmrPathExpression(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                objectDenoter_AST = (EJBQLAST)currentAST.root;
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        this.returnAST = objectDenoter_AST;
        this._retTree = _t;
    }

    public final void inCollectionElement(AST _t, Object valueExprTypeInfo) throws RecognitionException {
        EJBQLAST inCollectionElement_AST_in = _t == ASTNULL ? null : (EJBQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        EJBQLAST inCollectionElement_AST = null;
        EJBQLAST l_AST = null;
        EJBQLAST l = null;
        EJBQLAST i_AST = null;
        EJBQLAST i = null;
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 10: 
            case 11: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                l = _t == ASTNULL ? null : (EJBQLAST)_t;
                this.literal(_t);
                _t = this._retTree;
                l_AST = (EJBQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                l.setTypeInfo(this.analyseInCollectionElement(l_AST, valueExprTypeInfo));
                inCollectionElement_AST = (EJBQLAST)currentAST.root;
                break;
            }
            case 58: {
                i = _t == ASTNULL ? null : (EJBQLAST)_t;
                this.inputParameter(_t);
                _t = this._retTree;
                i_AST = (EJBQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                i.setTypeInfo(this.analyseInCollectionElement(i_AST, valueExprTypeInfo));
                inCollectionElement_AST = (EJBQLAST)currentAST.root;
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        this.returnAST = inCollectionElement_AST;
        this._retTree = _t;
    }

    private static final long[] mk_tokenSet_0() {
        long[] data = new long[]{358036170375957504L, 0L};
        return data;
    }
}

