/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.renderkit.html_basic.HtmlBasicRenderer;
import com.sun.faces.util.MessageUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class GridRenderer
extends HtmlBasicRenderer {
    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (context == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "context"));
        }
        if (component == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "component"));
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Begin encoding component " + component.getId());
        }
        if (!component.isRendered()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("End encoding component " + component.getId() + " since " + "rendered attribute is set to false ");
            }
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("table", component);
        this.writeIdAttributeIfNecessary(context, writer, component);
        String styleClass = (String)component.getAttributes().get("styleClass");
        if (styleClass != null) {
            writer.writeAttribute("class", (Object)styleClass, "styleClass");
        }
        RenderKitUtils.renderPassThruAttributes(context, writer, component);
        writer.writeText((Object)"\n", component, null);
        UIComponent caption = this.getFacet(component, "caption");
        if (caption != null) {
            String captionClass = (String)component.getAttributes().get("captionClass");
            String captionStyle = (String)component.getAttributes().get("captionStyle");
            writer.startElement("caption", component);
            if (captionClass != null) {
                writer.writeAttribute("class", (Object)captionClass, "captionClass");
            }
            if (captionStyle != null) {
                writer.writeAttribute("style", (Object)captionStyle, "captionStyle");
            }
            this.encodeRecursive(context, caption);
            writer.endElement("caption");
        }
        UIComponent header = this.getFacet(component, "header");
        String headerClass = (String)component.getAttributes().get("headerClass");
        if (header != null) {
            writer.startElement("thead", component);
            writer.writeText((Object)"\n", component, null);
            writer.startElement("tr", header);
            writer.startElement("th", header);
            if (headerClass != null) {
                writer.writeAttribute("class", (Object)headerClass, "headerClass");
            }
            writer.writeAttribute("colspan", (Object)("" + this.getColumnCount(component)), null);
            writer.writeAttribute("scope", (Object)"colgroup", null);
            this.encodeRecursive(context, header);
            writer.endElement("th");
            writer.endElement("tr");
            writer.writeText((Object)"\n", component, null);
            writer.endElement("thead");
            writer.writeText((Object)"\n", component, null);
        }
        UIComponent footer = this.getFacet(component, "footer");
        String footerClass = (String)component.getAttributes().get("footerClass");
        if (footer != null) {
            writer.startElement("tfoot", component);
            writer.writeText((Object)"\n", component, null);
            writer.startElement("tr", footer);
            writer.startElement("td", footer);
            if (footerClass != null) {
                writer.writeAttribute("class", (Object)footerClass, "footerClass");
            }
            writer.writeAttribute("colspan", (Object)("" + this.getColumnCount(component)), null);
            this.encodeRecursive(context, footer);
            writer.endElement("td");
            writer.endElement("tr");
            writer.writeText((Object)"\n", component, null);
            writer.endElement("tfoot");
            writer.writeText((Object)"\n", component, null);
        }
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        if (context == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "context"));
        }
        if (component == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "component"));
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Begin encoding children " + component.getId());
        }
        if (!component.isRendered()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("End encoding component " + component.getId() + " since " + "rendered attribute is set to false ");
            }
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        int columns = this.getColumnCount(component);
        String[] columnClasses = this.getColumnClasses(component);
        int columnStyle = 0;
        int columnStyles = columnClasses.length;
        String[] rowClasses = this.getRowClasses(component);
        int rowStyle = 0;
        int rowStyles = rowClasses.length;
        boolean open = false;
        Iterator<UIComponent> kids = null;
        int i = 0;
        writer.startElement("tbody", component);
        writer.writeText((Object)"\n", component, null);
        kids = this.getChildren(component);
        if (null != kids) {
            while (kids.hasNext()) {
                UIComponent child = kids.next();
                if (i % columns == 0) {
                    if (open) {
                        writer.endElement("tr");
                        writer.writeText((Object)"\n", component, null);
                        open = false;
                    }
                    writer.startElement("tr", component);
                    if (rowStyles > 0) {
                        writer.writeAttribute("class", (Object)rowClasses[rowStyle++], "rowClasses");
                        if (rowStyle >= rowStyles) {
                            rowStyle = 0;
                        }
                    }
                    writer.writeText((Object)"\n", component, null);
                    open = true;
                    columnStyle = 0;
                }
                writer.startElement("td", component);
                if (columnStyles > 0) {
                    try {
                        writer.writeAttribute("class", (Object)columnClasses[columnStyle++], "columns");
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        // empty catch block
                    }
                    if (columnStyle >= columnStyles) {
                        columnStyle = 0;
                    }
                }
                this.encodeRecursive(context, child);
                writer.endElement("td");
                writer.writeText((Object)"\n", component, null);
                ++i;
            }
        }
        if (open) {
            writer.endElement("tr");
            writer.writeText((Object)"\n", component, null);
        }
        writer.endElement("tbody");
        writer.writeText((Object)"\n", component, null);
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "End encoding children " + component.getId());
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (context == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "context"));
        }
        if (component == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "component"));
        }
        if (!component.isRendered()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("End encoding component " + component.getId() + " since " + "rendered attribute is set to false ");
            }
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        writer.endElement("table");
        writer.writeText((Object)"\n", component, null);
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "End encoding component " + component.getId());
        }
    }

    public boolean getRendersChildren() {
        return true;
    }

    private String[] getColumnClasses(UIComponent component) {
        String values = (String)component.getAttributes().get("columnClasses");
        if (values == null) {
            return new String[0];
        }
        values = values.trim();
        ArrayList<String> list = new ArrayList<String>();
        while (values.length() > 0) {
            int comma = values.indexOf(",");
            if (comma >= 0) {
                list.add(values.substring(0, comma).trim());
                values = values.substring(comma + 1);
                continue;
            }
            list.add(values.trim());
            values = "";
        }
        String[] results = new String[list.size()];
        return list.toArray(results);
    }

    private int getColumnCount(UIComponent component) {
        Object value = component.getAttributes().get("columns");
        int count = value != null && value instanceof Integer ? (Integer)value : 2;
        if (count < 1) {
            count = 1;
        }
        return count;
    }

    private String[] getRowClasses(UIComponent component) {
        String values = (String)component.getAttributes().get("rowClasses");
        if (values == null) {
            return new String[0];
        }
        values = values.trim();
        ArrayList<String> list = new ArrayList<String>();
        while (values.length() > 0) {
            int comma = values.indexOf(",");
            if (comma >= 0) {
                list.add(values.substring(0, comma).trim());
                values = values.substring(comma + 1);
                continue;
            }
            list.add(values.trim());
            values = "";
        }
        String[] results = new String[list.size()];
        return list.toArray(results);
    }
}

