/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.taglib.jsf_core;

import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.Util;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.ValueChangeListener;
import javax.faces.webapp.UIComponentClassicTagBase;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;

public class ValueChangeListenerTag
extends TagSupport {
    private static final long serialVersionUID = -212845116876281363L;
    private static final Logger logger = Util.getLogger("javax.enterprise.resource.webcontainer.jsf.taglib");
    private ValueExpression type = null;
    private ValueExpression binding = null;

    public void setType(ValueExpression type) {
        this.type = type;
    }

    public void setBinding(ValueExpression binding) {
        this.binding = binding;
    }

    public int doStartTag() throws JspException {
        ValueChangeListener handler = null;
        UIComponentClassicTagBase tag = UIComponentClassicTagBase.getParentUIComponentClassicTagBase((PageContext)this.pageContext);
        if (tag == null) {
            throw new JspException(MessageUtils.getExceptionMessageString("com.sun.faces.NOT_NESTED_IN_FACES_TAG_ERROR", new Object[0]));
        }
        if (!tag.getCreated()) {
            return 0;
        }
        UIComponent component = tag.getComponentInstance();
        if (component == null) {
            throw new JspException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_COMPONENT_ERROR", new Object[0]));
        }
        if (!(component instanceof EditableValueHolder)) {
            Object[] params = new Object[]{"valueChangeListener", "javax.faces.component.EditableValueHolder"};
            throw new JspException(MessageUtils.getExceptionMessageString("com.sun.faces.NOT_NESTED_IN_TYPE_TAG_ERROR", params));
        }
        FacesContext context = FacesContext.getCurrentInstance();
        if (this.binding != null) {
            try {
                handler = (ValueChangeListener)this.binding.getValue(context.getELContext());
                if (handler != null) {
                    ((EditableValueHolder)component).addValueChangeListener(handler);
                    return 0;
                }
            }
            catch (ELException e) {
                throw new JspException((Throwable)e);
            }
        }
        if (this.type != null && (handler = this.createValueChangeListener(context)) != null && this.binding != null) {
            try {
                this.binding.setValue(context.getELContext(), (Object)handler);
            }
            catch (ELException e) {
                throw new JspException((Throwable)e);
            }
        }
        if (handler != null) {
            ((EditableValueHolder)component).addValueChangeListener(handler);
        } else if (logger.isLoggable(Level.FINE)) {
            if (this.binding == null && this.type == null) {
                logger.fine("'handler' was not created because both 'binding' and 'type' were null.");
            } else {
                logger.fine("'handler' was not created.");
            }
        }
        return 0;
    }

    public void release() {
        this.type = null;
    }

    protected ValueChangeListener createValueChangeListener(FacesContext context) throws JspException {
        try {
            String className = this.type.getValue(context.getELContext()).toString();
            Class clazz = Util.loadClass(className, (Object)this);
            return (ValueChangeListener)clazz.newInstance();
        }
        catch (Exception e) {
            throw new JspException((Throwable)e);
        }
    }
}

