/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.util;

import com.sun.faces.util.Util;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReflectionUtils {
    private static final Map<ClassLoader, ConcurrentMap<String, MetaData>> REFLECTION_CACHE = new WeakHashMap<ClassLoader, ConcurrentMap<String, MetaData>>();

    private ReflectionUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCache(ClassLoader loader) {
        Map<ClassLoader, ConcurrentMap<String, MetaData>> map = REFLECTION_CACHE;
        synchronized (map) {
            REFLECTION_CACHE.remove(loader);
        }
    }

    public static Constructor lookupConstructor(Class<?> clazz, Class<?> ... params) {
        ClassLoader loader = Util.getCurrentLoader(clazz);
        if (loader == null) {
            return null;
        }
        return ReflectionUtils.getMetaData(loader, clazz).lookupConstructor(params);
    }

    public static Method lookupMethod(Class<?> clazz, String methodName, Class<?> ... params) {
        ClassLoader loader = Util.getCurrentLoader(clazz);
        if (loader == null) {
            return null;
        }
        return ReflectionUtils.getMetaData(loader, clazz).lookupMethod(methodName, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MetaData getMetaData(ClassLoader loader, Class<?> clazz) {
        MetaData meta;
        ConcurrentMap<String, MetaData> cache = REFLECTION_CACHE.get(loader);
        if (cache == null) {
            Map<ClassLoader, ConcurrentMap<String, MetaData>> map = REFLECTION_CACHE;
            synchronized (map) {
                cache = REFLECTION_CACHE.get(loader);
                if (cache == null) {
                    cache = new ConcurrentHashMap<String, MetaData>();
                    REFLECTION_CACHE.put(loader, cache);
                }
            }
        }
        if ((meta = (MetaData)cache.get(clazz.getName())) == null) {
            meta = new MetaData(clazz);
            cache.put(clazz.getName(), meta);
        }
        return meta;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MetaData {
        Map<Integer, Constructor> constructors;
        Map<String, HashMap<Integer, Method>> methods;

        public MetaData(Class<?> clazz) {
            Constructor<?>[] ctors = clazz.getConstructors();
            this.constructors = new HashMap<Integer, Constructor>(ctors.length, 1.0f);
            int len = ctors.length;
            for (int i = 0; i < len; ++i) {
                this.constructors.put(MetaData.getKey(ctors[i].getParameterTypes()), ctors[i]);
            }
            Method[] meths = clazz.getMethods();
            this.methods = new HashMap<String, HashMap<Integer, Method>>(meths.length, 1.0f);
            int len2 = meths.length;
            for (int i = 0; i < len2; ++i) {
                String name = meths[i].getName();
                HashMap<Integer, Method> methodsMap = this.methods.get(name);
                if (methodsMap == null) {
                    methodsMap = new HashMap(4, 1.0f);
                    this.methods.put(name, methodsMap);
                }
                methodsMap.put(MetaData.getKey(meths[i].getParameterTypes()), meths[i]);
            }
        }

        public Constructor lookupConstructor(Class<?> ... params) {
            return this.constructors.get(MetaData.getKey(params));
        }

        public Method lookupMethod(String name, Class<?> ... params) {
            Map methodsMap = this.methods.get(name);
            return (Method)methodsMap.get(MetaData.getKey(params));
        }

        private static Integer getKey(Class<?> ... params) {
            return Arrays.deepHashCode(params);
        }
    }
}

