/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.jato.model;

import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.model.TreeModel;

public abstract class TreeModelBase
implements TreeModel {
    private String name;
    private int traversalType = 0;
    private int nodeLevel = -1;
    private Object currentNode = null;
    private boolean iterationComplete = false;

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public abstract String getNodeName() throws ModelControlException;

    public abstract String getNodeType() throws ModelControlException;

    public abstract String getNodeID();

    public abstract boolean isParentNode();

    public abstract boolean isChildNode();

    public int getNodeLevel() {
        return this.nodeLevel;
    }

    protected void setNodeLevel(int value) {
        this.nodeLevel = value;
    }

    protected void incrementNodeLevel() {
        ++this.nodeLevel;
    }

    protected void decrementNodeLevel() {
        --this.nodeLevel;
    }

    public int getTraversalType() throws ModelControlException {
        return this.traversalType;
    }

    public void setTraversalType(int value) throws ModelControlException {
        this.traversalType = value;
    }

    public abstract void beforeRoot() throws ModelControlException;

    public abstract void root() throws ModelControlException;

    public boolean nextNode() throws ModelControlException {
        return this.nextNode(0);
    }

    public boolean nextNode(int nextNode) throws ModelControlException {
        if (this.isIterationComplete()) {
            if (this.getNodeLevel() == -1) {
                return false;
            }
            throw new Error("The implementation indicates that it found the iteration is complete, but the node level is not equal to the UNDEFINED_NODE_LEVEL constant.  This probably represents a programming error in the model implementation.");
        }
        if (this.getNodeLevel() == -1) {
            this.root();
            return true;
        }
        boolean result = false;
        switch (this.getTraversalType()) {
            case 0: {
                result = true;
                if (nextNode != 1 && this.firstChild() || this.nextSibling()) break;
                boolean foundSibling = false;
                while (this.parent()) {
                    if (!this.nextSibling()) continue;
                    foundSibling = true;
                    break;
                }
                if (foundSibling) break;
                this.setNodeLevel(-1);
                this.setIterationComplete(true);
                result = false;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Breadth-first traversal not currently supported");
            }
        }
        return result;
    }

    public abstract boolean firstChild() throws ModelControlException;

    public abstract boolean parent() throws ModelControlException;

    public abstract boolean nextSibling() throws ModelControlException;

    protected Object getCurrentNode() {
        return this.currentNode;
    }

    protected void setCurrentNode(Object value) {
        this.currentNode = value;
    }

    protected void clearCurrentNode() {
        this.setCurrentNode(null);
        this.setNodeLevel(-1);
    }

    public boolean isIterationComplete() {
        return this.iterationComplete;
    }

    protected void setIterationComplete(boolean value) {
        this.iterationComplete = value;
    }
}

