/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.jato.model.object;

import com.iplanet.jato.model.object.ObjectPath;
import com.iplanet.jato.model.object.Path;

public class KeyPath {
    private String _key = null;
    private ObjectPath _path = null;
    public static final String KEY_PATH_SEPARATOR = ":";

    public KeyPath(String key, ObjectPath path) {
        if (key != null && key.trim().length() != 0) {
            this._key = key.trim();
        }
        this._path = path != null ? path : new Path(null);
    }

    public KeyPath(String key, String path) {
        if (key != null && key.trim().length() != 0) {
            this._key = key.trim();
        }
        this._path = new Path(path);
    }

    public KeyPath(String combined) {
        String key = null;
        String path = null;
        if (combined != null && combined.trim().length() != 0) {
            int position = (combined = combined.trim()).indexOf(KEY_PATH_SEPARATOR);
            if (position == -1) {
                if (combined.startsWith("/")) {
                    path = combined;
                } else {
                    key = combined;
                }
            } else {
                key = combined.substring(0, position);
                path = combined.substring(position + 1);
            }
        }
        if (key != null && key.trim().length() != 0) {
            this._key = key.trim();
        }
        this._path = new Path(path);
    }

    public String getKey() {
        return this._key;
    }

    public ObjectPath getPath() {
        return this._path;
    }

    public String toString() {
        if (this.getKey() != null) {
            if (!this.getPath().isRoot()) {
                return this.getKey() + KEY_PATH_SEPARATOR + this.getPath();
            }
            return this.getKey();
        }
        return this.getPath().toString();
    }

    public KeyPath getUnindexedKeyPath() {
        if (!this.getPath().isIndexed()) {
            return this;
        }
        String path = this.getPath().toString();
        return new KeyPath(this.getKey(), path.substring(0, path.length() - 2));
    }

    static {
        KEY_PATH_SEPARATOR = KEY_PATH_SEPARATOR;
    }
}

