/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.jato.taglib.html;

import com.iplanet.jato.ClientSession;
import com.iplanet.jato.taglib.TagBase;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.ViewBean;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;

public class FormTag
extends TagBase {
    public int doStartTag() throws JspException {
        this.reset();
        ViewBean viewBean = this.getParentViewBean();
        if (viewBean.getRequestContext() == null) {
            throw new JspException("This JSP cannot be accessed directly and must be referenced only through the controller servlet (request context is null)");
        }
        NonSyncStringBuffer buffer = new NonSyncStringBuffer(64);
        this.generateStartTagContent(buffer);
        this.writeOutput(buffer);
        return 1;
    }

    public int doEndTag() throws JspException {
        NonSyncStringBuffer buffer = new NonSyncStringBuffer(256);
        this.generateEndTagContent(buffer);
        this.writeOutput(buffer);
        return 6;
    }

    protected void generateStartTagContent(NonSyncStringBuffer buffer) throws JspException {
        ViewBean viewBean = this.getParentViewBean();
        buffer.append("<form name=\"").append(this.getName()).append("\"");
        if (this.getMethod() != null) {
            buffer.append(" method=\"").append(this.getMethod()).append("\"");
        } else {
            buffer.append(" method=\"post\"");
        }
        buffer.append(" action=\"").append(((HttpServletResponse)this.pageContext.getResponse()).encodeURL(viewBean.getModuleURL() + "/" + viewBean.getRequestInvocationName())).append("\"");
        if (this.getTarget() != null) {
            buffer.append(" target=\"").append(this.getTarget()).append("\"");
        }
        if (this.getEncType() != null) {
            buffer.append(" enctype=\"").append(this.getEncType()).append("\"");
        }
        if (this.getAccept() != null) {
            buffer.append(" accept=\"").append(this.getAccept()).append("\"");
        }
        if (this.getAcceptCharset() != null) {
            buffer.append(" accept-charset=\"").append(this.getAcceptCharset()).append("\"");
        }
        if (this.getOnReset() != null) {
            buffer.append(" onReset=\"").append(this.getOnReset()).append("\"");
        }
        if (this.getOnSubmit() != null) {
            buffer.append(" onSubmit=\"").append(this.getOnSubmit()).append("\"");
        }
        this.appendStyleAttributes(buffer);
        buffer.append(">");
    }

    protected void generateEndTagContent(NonSyncStringBuffer buffer) throws JspException {
        ViewBean viewBean = this.getParentViewBean();
        if (this.getDefaultCommandChild() != null) {
            buffer.append("\n<input type=\"hidden\" name=\"").append("jato.defaultCommand").append("\" value=\"").append(this.getDefaultCommandChild()).append("\">");
        }
        buffer.append("\n<input type=\"hidden\" name=\"").append("jato.pageSession").append("\" value=\"").append(viewBean.getPageSessionAttributeString(false)).append("\">");
        try {
            ClientSession clientSession = viewBean.getRequestContext().getClientSession();
            if (clientSession.hasAttributes()) {
                buffer.append("\n<input type=\"hidden\" name=\"").append("jato.clientSession").append("\" value=\"").append(clientSession.getEncodedString()).append("\">");
            }
        }
        catch (IOException e) {
            throw new JspException("Error serializing client session", (Throwable)e);
        }
        buffer.append("\n</form>");
    }

    public String getMethod() {
        return (String)this.getValue("method");
    }

    public void setMethod(String value) {
        this.setValue("method", value);
    }

    public String getTarget() {
        return (String)this.getValue("target");
    }

    public void setTarget(String value) {
        this.setValue("target", value);
    }

    public String getDefaultCommandChild() {
        return (String)this.getValue("defaultCommandChild");
    }

    public void setDefaultCommandChild(String value) {
        this.setValue("defaultCommandChild", value);
    }

    public String getAccept() {
        return (String)this.getValue("accept");
    }

    public void setAccept(String value) {
        this.setValue("accept", value);
    }

    public String getAcceptCharset() {
        return (String)this.getValue("acceptCharset");
    }

    public void setAcceptCharset(String value) {
        this.setValue("acceptCharset", value);
    }

    public String getEncType() {
        return (String)this.getValue("encType");
    }

    public void setEncType(String value) {
        this.setValue("encType", value);
    }

    public String getOnReset() {
        return (String)this.getValue("onReset");
    }

    public void setOnReset(String value) {
        this.setValue("onReset", value);
    }

    public String getOnSubmit() {
        return (String)this.getValue("onSubmit");
    }

    public void setOnSubmit(String value) {
        this.setValue("onSubmit", value);
    }
}

