/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.jato.util;

import com.iplanet.jato.util.NonSyncStringBuffer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;

public class StringTokenizer2
implements Enumeration,
Iterator {
    private String text;
    private String delimiter;
    private boolean returnDelimiterTokens = false;
    private List parsedTokens = new ArrayList();
    private int tokenIndex = 0;

    public StringTokenizer2(String text, String delimiter) {
        this(text, delimiter, false);
    }

    public StringTokenizer2(String text, String delimiter, boolean returnTokens) {
        this(text, delimiter, returnTokens, false);
    }

    public StringTokenizer2(String text, String delimiter, boolean returnTokens, boolean ignoreCase) {
        this.text = text;
        this.delimiter = delimiter;
        this.returnDelimiterTokens = returnTokens;
        this.parse(ignoreCase);
    }

    private void parse(boolean ignoreCase) {
        String matchText = null;
        String matchDelim = null;
        if (ignoreCase) {
            matchText = this.text.toUpperCase();
            matchDelim = this.delimiter.toUpperCase();
        } else {
            matchText = this.text;
            matchDelim = this.delimiter;
        }
        int startIndex = 0;
        int endIndex = matchText.indexOf(matchDelim, startIndex);
        while (endIndex != -1) {
            String token = this.text.substring(startIndex, endIndex);
            this.parsedTokens.add(token);
            if (this.returnDelimiterTokens) {
                this.parsedTokens.add(this.delimiter);
            }
            startIndex = endIndex + this.delimiter.length();
            endIndex = matchText.indexOf(matchDelim, startIndex);
        }
        this.parsedTokens.add(this.text.substring(startIndex));
    }

    public boolean hasNext() {
        return this.hasMoreTokens();
    }

    public Object next() {
        return this.nextToken();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public boolean hasMoreTokens() {
        return this.tokenIndex < this.parsedTokens.size();
    }

    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    public int countTokens() {
        return this.parsedTokens.size();
    }

    public String nextToken() {
        return (String)this.parsedTokens.get(this.tokenIndex++);
    }

    public Object nextElement() {
        return this.nextToken();
    }

    public static String replace(String str, String findValue, String replaceValue) {
        StringTokenizer2 tok = new StringTokenizer2(str, findValue, false);
        String result = "";
        int i = 0;
        while (i < tok.countTokens() - 1) {
            result = result + tok.nextToken() + replaceValue;
            ++i;
        }
        result = result + tok.nextToken();
        return result;
    }

    public static String replace(String str, String findValue, String replaceValue, boolean ignoreCase) {
        StringTokenizer2 tok = new StringTokenizer2(str, findValue, false, ignoreCase);
        NonSyncStringBuffer result = new NonSyncStringBuffer(str.length());
        int i = 0;
        while (i < tok.countTokens() - 1) {
            result.append(tok.nextToken()).append(replaceValue);
            ++i;
        }
        result.append(tok.nextToken());
        return result.toString();
    }

    public static String[] tokenize(String str, String findValue) {
        return StringTokenizer2.tokenize(str, findValue, false);
    }

    public static String[] tokenize(String str, String findValue, boolean trim) {
        return StringTokenizer2.tokenize(str, findValue, trim, false);
    }

    public static String[] tokenize(String str, String findValue, boolean trim, boolean ignoreCase) {
        StringTokenizer2 tok = new StringTokenizer2(str, findValue, false, ignoreCase);
        LinkedList<String> result = new LinkedList<String>();
        int i = 0;
        while (i < tok.countTokens()) {
            if (trim) {
                result.add(tok.nextToken().trim());
            } else {
                result.add(tok.nextToken());
            }
            ++i;
        }
        return result.toArray(new String[result.size()]);
    }

    public static String[] tokenizeLines(String string) {
        StringTokenizer tok = new StringTokenizer(string, "\n\r", true);
        LinkedList<String> result = new LinkedList<String>();
        String previousToken = null;
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            if (token.equals("\r")) continue;
            if (token.equals("\n")) {
                if (previousToken != null) {
                    result.add(previousToken);
                } else {
                    result.add("");
                }
                previousToken = null;
                continue;
            }
            previousToken = token;
        }
        if (previousToken != null) {
            result.add(previousToken);
        }
        return result.toArray(new String[result.size()]);
    }
}

