/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.jato.view;

import com.iplanet.jato.model.ValidationException;
import com.iplanet.jato.util.validation.ValidationError;
import com.iplanet.jato.util.validation.Validator;
import com.iplanet.jato.view.BasicDisplayField;
import com.iplanet.jato.view.TiledView;
import com.iplanet.jato.view.TreeView;
import com.iplanet.jato.view.ValidatingView;
import com.iplanet.jato.view.View;
import java.util.LinkedList;

public class ValidatingDisplayField
extends BasicDisplayField
implements ValidatingView {
    private Validator validator;
    private Object validationFailureMessage;
    private Object[] invalidValues;
    private ValidationError[] errors;
    private boolean showFailureMessage = true;
    static /* synthetic */ Class class$com$iplanet$jato$view$TiledView;
    static /* synthetic */ Class class$com$iplanet$jato$view$TreeView;

    public ValidatingDisplayField(View parent, String name) {
        super(parent, name);
        while (parent != null) {
            if (parent instanceof TiledView || parent instanceof TreeView) {
                throw new IllegalArgumentException("This component cannot be placed inside a container of type " + (class$com$iplanet$jato$view$TiledView == null ? (class$com$iplanet$jato$view$TiledView = ValidatingDisplayField.class$("com.iplanet.jato.view.TiledView")) : class$com$iplanet$jato$view$TiledView).getName() + " or " + (class$com$iplanet$jato$view$TreeView == null ? (class$com$iplanet$jato$view$TreeView = ValidatingDisplayField.class$("com.iplanet.jato.view.TreeView")) : class$com$iplanet$jato$view$TreeView).getName());
            }
            parent = parent.getParent();
        }
    }

    public Validator getValidator() {
        return this.validator;
    }

    public void setValidator(Validator value) {
        this.validator = value;
    }

    public boolean isShowValidationFailureMessage() {
        return this.showFailureMessage;
    }

    public void setShowValidationFailureMessage(boolean value) {
        this.showFailureMessage = value;
    }

    public ValidationError[] getValidationErrors() {
        return this.errors;
    }

    protected void setValidationErrors(ValidationError[] values) {
        this.errors = values;
    }

    public void clearValidationErrors() {
        this.setValidationErrors(new ValidationError[0]);
        this.invalidValues = new Object[0];
    }

    public boolean isValid() {
        if (this.getValidationErrors() != null) {
            return this.getValidationErrors().length == 0;
        }
        return true;
    }

    public Object getValidationFailureMessage() {
        return this.validationFailureMessage;
    }

    public void setValidationFailureMessage(Object value) {
        this.validationFailureMessage = value;
    }

    public Object getValue() {
        if (!this.isValid()) {
            return this.getInvalidValue();
        }
        return super.getValue();
    }

    public Object[] getValues() {
        if (!this.isValid()) {
            return this.getInvalidValues();
        }
        return super.getValues();
    }

    public Object getInvalidValue() {
        if (this.getInvalidValues() != null && this.getInvalidValues().length > 0) {
            return this.getInvalidValues()[0];
        }
        return null;
    }

    public Object[] getInvalidValues() {
        return this.invalidValues;
    }

    public void setValue(Object value) {
        if (value != null && this.getValidator() != null) {
            this.clearValidationErrors();
            if (this.getValidator().validate(value)) {
                try {
                    super.setValue(value);
                    this.invalidValues = null;
                }
                catch (ValidationException e) {
                    this.invalidValues = new Object[]{value};
                    this.setValidationErrors(new ValidationError[]{new ValidationError(this, "Validation exception setting value on model: " + e, value)});
                }
            } else {
                this.invalidValues = new Object[]{value};
                String message = this.getValidationFailureMessage() != null ? this.getValidationFailureMessage().toString() : "Invalid value";
                ValidationError error = new ValidationError(this, message, value);
                this.setValidationErrors(new ValidationError[]{error});
            }
        } else {
            super.setValue(value);
        }
    }

    public void setValues(Object[] values) {
        if (values != null && this.getValidator() != null) {
            LinkedList<ValidationError> validationErrors = new LinkedList<ValidationError>();
            this.clearValidationErrors();
            boolean failed = false;
            int i = 0;
            while (i < values.length) {
                if (!this.getValidator().validate(values[i])) {
                    failed = true;
                    String message = this.getValidationFailureMessage() != null ? this.getValidationFailureMessage().toString() : "Invalid value";
                    validationErrors.add(new ValidationError(this, message, values[i]));
                }
                ++i;
            }
            if (!failed) {
                try {
                    super.setValues(values);
                    this.invalidValues = new Object[0];
                }
                catch (ValidationException e) {
                    this.invalidValues = values;
                    validationErrors.add(new ValidationError(this, "Exception setting value \"on model: " + e, values));
                }
            } else {
                this.invalidValues = values;
            }
            this.setValidationErrors(validationErrors.toArray(new ValidationError[validationErrors.size()]));
        } else {
            super.setValues(values);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

