/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.jato.view.command;

import com.iplanet.jato.command.CommandEvent;
import com.iplanet.jato.command.CommandException;
import com.iplanet.jato.model.DatasetModelExecutionContextImpl;
import com.iplanet.jato.model.ExecutingModel;
import com.iplanet.jato.model.ModelReference;
import com.iplanet.jato.model.ModelReferenceException;
import com.iplanet.jato.view.command.GotoViewBeanCommand;
import java.util.Map;

public class ExecuteAndForwardCommand
extends GotoViewBeanCommand {
    public static final String PARAM_MODEL_OPERATION_NAME = "ModelOperationName";
    public static final String PARAM_EXECUTING_MODEL_REFERENCE = "ExecutingModelReference";

    protected boolean isAllowForward() {
        return true;
    }

    public void execute(CommandEvent event) throws CommandException {
        try {
            Map map = event.getParameters();
            ModelReference modelRef = (ModelReference)map.get(PARAM_EXECUTING_MODEL_REFERENCE);
            if (modelRef == null) {
                throw new CommandException("Null parameter \"ExecutingModelReference\"");
            }
            ExecutingModel model = (ExecutingModel)modelRef.getModel();
            if (null == model) {
                throw new CommandException("Null model from ModelReference");
            }
            String modelOperationName = (String)map.get(PARAM_MODEL_OPERATION_NAME);
            model.execute(new DatasetModelExecutionContextImpl(modelOperationName));
        }
        catch (ClassCastException cce) {
            throw new CommandException("Provided ModelReference does not dereference an ExecutingModel", cce);
        }
        catch (ModelReferenceException mre) {
            throw new CommandException("Failure acquiring Model from ModelReference", mre);
        }
        catch (Exception e) {
            if (e instanceof CommandException) {
                throw (CommandException)e;
            }
            throw new CommandException("Error executing model", e);
        }
        if (this.isAllowForward()) {
            super.execute(event);
        }
    }

    static {
        PARAM_MODEL_OPERATION_NAME = PARAM_MODEL_OPERATION_NAME;
        PARAM_EXECUTING_MODEL_REFERENCE = PARAM_EXECUTING_MODEL_REFERENCE;
    }
}

