/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.management.client;

import com.sun.appserv.management.client.AdminRMISSLClientSocketFactoryEnv;
import com.sun.appserv.management.client.AdminRMISSLClientSocketFactoryEnvImpl;
import com.sun.appserv.management.client.TrustAnyTrustManager;
import com.sun.appserv.management.client.TrustStoreTrustManager;
import java.io.IOException;
import java.io.Serializable;
import java.net.Socket;
import java.rmi.server.RMIClientSocketFactory;
import java.util.logging.Logger;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class AdminRMISSLClientSocketFactory
implements RMIClientSocketFactory,
Serializable {
    static final long serialVersionUID = 5096547838871926785L;
    private transient SSLSocketFactory mFactory = null;
    private transient MyEnvImpl mEnvImpl = new MyEnvImpl();

    private static TrustManager[] getTrustAny() {
        TrustManager[] trustManagers = new TrustManager[]{TrustAnyTrustManager.getInstance()};
        return trustManagers;
    }

    private synchronized AdminRMISSLClientSocketFactoryEnv getEnv() {
        return AdminRMISSLClientSocketFactoryEnvImpl.getInstance();
    }

    private final void trace(Object o) {
        if (this.getEnv().getTrace()) {
            String name = this.getClass().getName();
            Logger.getLogger(name).info(this.toString() + ": " + o.toString());
        }
    }

    private static char[] toCharArray(String s) {
        return s == null ? null : s.toCharArray();
    }

    private final SSLSocketFactory createSocketFactory(AdminRMISSLClientSocketFactoryEnv env) throws IOException {
        SSLSocketFactory factory = null;
        try {
            TrustManager[] trustManagers = env.getTrustManagers();
            SSLContext sslContext = SSLContext.getInstance("TLSv1");
            sslContext.init(null, trustManagers, null);
            factory = sslContext.getSocketFactory();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw (IOException)new IOException().initCause(e);
        }
        return factory;
    }

    public synchronized Socket createSocket(String host, int port) throws IOException {
        String target = host + ":" + port;
        this.trace("createSocket: " + target);
        AdminRMISSLClientSocketFactoryEnv env = this.getEnv();
        if (this.mFactory == null) {
            this.mFactory = this.createSocketFactory(env);
            this.trace("createSocket: created socket factory");
        }
        SSLSocket sslSocket = (SSLSocket)this.mFactory.createSocket(host, port);
        HandshakeCompletedListener listener = env.getHandshakeCompletedListener();
        if (listener != null) {
            this.trace("createSocket: added HandshakeCompletedListener: " + listener);
            sslSocket.addHandshakeCompletedListener(listener);
        }
        this.trace("created socket: " + target);
        return sslSocket;
    }

    private final class MyEnvImpl
    implements AdminRMISSLClientSocketFactoryEnv {
        private transient boolean mTrace = false;

        private MyEnvImpl() {
        }

        public TrustManager[] getTrustManagers() {
            TrustStoreTrustManager mgr = TrustStoreTrustManager.getSystemInstance();
            return new TrustManager[]{mgr};
        }

        public HandshakeCompletedListener getHandshakeCompletedListener() {
            return null;
        }

        public void setTrace(boolean trace) {
            this.mTrace = trace;
        }

        public boolean getTrace() {
            return this.mTrace;
        }

        public Object getValue(String key) {
            return null;
        }
    }
}

