/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.guiframework.event.handlers;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.ViewBeanManager;
import com.iplanet.jato.view.ViewBean;
import com.sun.enterprise.tools.guiframework.exception.FrameworkException;
import com.sun.enterprise.tools.guiframework.view.DescriptorViewManager;
import com.sun.enterprise.tools.guiframework.view.HandlerContext;
import java.io.Serializable;
import java.util.List;

public class SessionHandlers {
    public static final String VIEW_BEAN = "viewBean";
    public static final String NAME = "name";
    public static final String VIEW_ID = "viewID";
    public static final String KEY = "key";
    public static final String VALUE = "value";

    public void getPageSessionValue(RequestContext reqCtx, HandlerContext handlerCtx) {
        String name = (String)handlerCtx.getInputValue(NAME);
        if (name == null) {
            throw new FrameworkException("'name' specifying the PageSession name must be provided!");
        }
        ViewBean vb = (ViewBean)handlerCtx.getInputValue(VIEW_BEAN);
        if (vb == null) {
            vb = this.getViewBean(reqCtx, handlerCtx);
        }
        handlerCtx.setOutputValue(VALUE, vb.getPageSessionAttribute(name));
    }

    private ViewBean getViewBean(RequestContext reqCtx, HandlerContext handlerCtx) {
        Object viewID = handlerCtx.getInputValue(VIEW_ID);
        if (viewID == null) {
            throw new IllegalArgumentException("The parameter map did not contain viewID!");
        }
        ViewBeanManager vm = reqCtx.getViewBeanManager();
        ViewBean vb = null;
        String topName = viewID instanceof List ? ((List)viewID).get(0).toString() : viewID.toString();
        try {
            vb = vm.getViewBean(topName);
        }
        catch (ClassCastException ex) {
            vb = (ViewBean)((DescriptorViewManager)vm).getView(null, topName);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        if (vb == null) {
            throw new RuntimeException("Unable to obtain the view for mapping!");
        }
        return vb;
    }

    public void setPageSessionValue(RequestContext reqCtx, HandlerContext handlerCtx) {
        String name = (String)handlerCtx.getInputValue(NAME);
        if (name == null) {
            throw new FrameworkException("'name' specifying the PageSession name must be provided!");
        }
        ViewBean vb = (ViewBean)handlerCtx.getInputValue(VIEW_BEAN);
        if (vb == null) {
            vb = this.getViewBean(reqCtx, handlerCtx);
        }
        Object value = handlerCtx.getInputValue(VALUE);
        vb.setPageSessionAttribute(name, (Serializable)value);
    }

    public void getSessionValue(RequestContext reqCtx, HandlerContext handlerCtx) {
        Object key = handlerCtx.getInputValue(KEY);
        if (key == null) {
            throw new IllegalArgumentException("The parameter map did not contain a key!");
        }
        handlerCtx.setOutputValue(VALUE, reqCtx.getRequest().getSession().getAttribute(key.toString()));
    }

    public void setSessionValue(RequestContext reqCtx, HandlerContext handlerCtx) {
        Object value = handlerCtx.getInputValue(VALUE);
        Object key = handlerCtx.getInputValue(KEY);
        if (key == null) {
            throw new IllegalArgumentException("The parameter map did not contain a key!");
        }
        reqCtx.getRequest().getSession().setAttribute(key.toString(), value);
    }
}

