/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dbschema.jdbcimpl.wizard;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.ResourceBundle;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.modules.dbschema.ColumnElement;
import org.netbeans.modules.dbschema.SchemaElement;
import org.netbeans.modules.dbschema.TableElement;
import org.netbeans.modules.dbschema.jdbcimpl.ConnectionProvider;
import org.netbeans.modules.dbschema.jdbcimpl.DBschemaDataObject;
import org.netbeans.modules.dbschema.jdbcimpl.SchemaElementImpl;
import org.netbeans.modules.dbschema.jdbcimpl.wizard.DBSchemaTablesPanel;
import org.netbeans.modules.dbschema.jdbcimpl.wizard.DBSchemaWizardData;
import org.netbeans.modules.dbschema.jdbcimpl.wizard.ProgressFrame;
import org.openide.ErrorManager;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class RecaptureSchema {
    private static final boolean debug = Boolean.getBoolean("org.netbeans.modules.dbschema.recapture.debug");
    ResourceBundle bundle = NbBundle.getBundle((String)"org.netbeans.modules.dbschema.jdbcimpl.resources.Bundle");
    private DBSchemaWizardData data;
    private Node dbSchemaNode;

    public RecaptureSchema(Node node) {
        this.dbSchemaNode = node;
        this.data = new DBSchemaWizardData();
        this.data.setExistingConn(true);
    }

    public void start() throws ClassNotFoundException, SQLException {
        boolean bl;
        final DBschemaDataObject dBschemaDataObject = (DBschemaDataObject)this.dbSchemaNode.getCookie(DBschemaDataObject.class);
        final SchemaElement schemaElement = dBschemaDataObject.getSchema();
        if (debug) {
            System.out.println("[dbschema] url='" + schemaElement.getUrl() + "'");
        }
        final FileObject fileObject = dBschemaDataObject.getPrimaryFile();
        TableElement[] tableElementArray = schemaElement.getTables();
        final LinkedList<String> linkedList = new LinkedList<String>();
        final LinkedList<String> linkedList2 = new LinkedList<String>();
        for (bl = false; bl < tableElementArray.length; bl += 1) {
            TableElement tableElement = tableElementArray[bl];
            if (tableElement.isTable()) {
                if (debug) {
                    System.out.println("[dbschema] adding table='" + tableElement.getName() + "'");
                }
                linkedList.add(tableElement.getName().getName());
                continue;
            }
            if (debug) {
                System.out.println("[dbschema] adding view='" + tableElement.getName() + "'");
            }
            linkedList2.add(tableElement.getName().getName());
        }
        bl = this.data.isConnected();
        final boolean bl2 = this.data.isExistingConn();
        final DatabaseConnection databaseConnection = this.data.getDatabaseConnection();
        String string = schemaElement.getUrl();
        if (debug) {
            System.out.println("[dbschema] conned='" + bl + "'");
            System.out.println("[dbschema] ec='" + bl2 + "'");
            System.out.println("[dbschema] NEW dbIdentName='" + string + "'");
        }
        ConnectionProvider connectionProvider = this.createConnectionProvider(this.data, schemaElement.getUrl());
        try {
            final ConnectionProvider connectionProvider2 = connectionProvider;
            if (connectionProvider2 == null) {
                throw new SQLException(this.bundle.getString("EXC_ConnectionNotEstablished"));
            }
            if (debug) {
                System.out.println("[dbschema] c.getConnection()='" + connectionProvider2.getConnection() + "'");
            }
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    try {
                        StatusDisplayer.getDefault().setStatusText(RecaptureSchema.this.bundle.getString("CreatingDatabaseSchema"));
                        ProgressFrame progressFrame = new ProgressFrame();
                        SchemaElementImpl schemaElementImpl = new SchemaElementImpl(connectionProvider2);
                        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(this, progressFrame, schemaElementImpl){
                            private final /* synthetic */ ProgressFrame val$pf;
                            private final /* synthetic */ SchemaElementImpl val$sei;
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                                this.val$pf = progressFrame;
                                this.val$sei = schemaElementImpl;
                            }

                            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                                if (propertyChangeEvent.getPropertyName().equals("totalCount")) {
                                    this.val$pf.setMaximum((Integer)propertyChangeEvent.getNewValue());
                                    return;
                                }
                                if (propertyChangeEvent.getPropertyName().equals("progress")) {
                                    this.val$pf.setValue((Integer)propertyChangeEvent.getNewValue());
                                    return;
                                }
                                if (propertyChangeEvent.getPropertyName().equals("tableName")) {
                                    String string = MessageFormat.format(1.access$000(this.this$1).bundle.getString("CapturingTable"), ((String)propertyChangeEvent.getNewValue()).toUpperCase());
                                    this.val$pf.setMessage(string);
                                    return;
                                }
                                if (propertyChangeEvent.getPropertyName().equals("FKt")) {
                                    String string = MessageFormat.format(1.access$000(this.this$1).bundle.getString("CaptureFK"), ((String)propertyChangeEvent.getNewValue()).toUpperCase(), 1.access$000(this.this$1).bundle.getString("CaptureFKtable"));
                                    this.val$pf.setMessage(string);
                                    return;
                                }
                                if (propertyChangeEvent.getPropertyName().equals("FKv")) {
                                    String string = MessageFormat.format(1.access$000(this.this$1).bundle.getString("CaptureFK"), ((String)propertyChangeEvent.getNewValue()).toUpperCase(), 1.access$000(this.this$1).bundle.getString("CaptureFKview"));
                                    this.val$pf.setMessage(string);
                                    return;
                                }
                                if (propertyChangeEvent.getPropertyName().equals("viewName")) {
                                    String string = MessageFormat.format(1.access$000(this.this$1).bundle.getString("CapturingView"), ((String)propertyChangeEvent.getNewValue()).toUpperCase());
                                    this.val$pf.setMessage(string);
                                    return;
                                }
                                if (propertyChangeEvent.getPropertyName().equals("cancel")) {
                                    this.val$sei.setStop(true);
                                    StatusDisplayer.getDefault().setStatusText("");
                                    return;
                                }
                            }
                        };
                        progressFrame.propertySupport.addPropertyChangeListener(propertyChangeListener);
                        progressFrame.setVisible(true);
                        schemaElementImpl.propertySupport.addPropertyChangeListener(propertyChangeListener);
                        SchemaElement schemaElement2 = new SchemaElement(schemaElementImpl);
                        schemaElement2.setName(schemaElement.getName());
                        schemaElementImpl.initTables(connectionProvider2, linkedList, linkedList2, false);
                        progressFrame.finishProgress();
                        if (!schemaElementImpl.isStop()) {
                            fileObject.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(this, schemaElement2, progressFrame){
                                private final /* synthetic */ SchemaElement val$se;
                                private final /* synthetic */ ProgressFrame val$pf;
                                private final /* synthetic */ 1 this$1;
                                {
                                    this.this$1 = var1_1;
                                    this.val$se = schemaElement;
                                    this.val$pf = progressFrame;
                                }

                                public void run() throws IOException {
                                    if (RecaptureSchema.access$100()) {
                                        System.out.println("SchemaElement: " + RecaptureSchema.access$200(1.access$000(this.this$1), this.val$se));
                                    }
                                    FileLock fileLock = 1.access$300(this.this$1).lock();
                                    OutputStream outputStream = 1.access$300(this.this$1).getOutputStream(fileLock);
                                    if (outputStream == null) {
                                        throw new IOException("Unable to open output stream");
                                    }
                                    this.val$pf.setMessage(1.access$000(this.this$1).bundle.getString("SavingDatabaseSchema"));
                                    StatusDisplayer.getDefault().setStatusText(1.access$000(this.this$1).bundle.getString("SavingDatabaseSchema"));
                                    this.val$se.save(outputStream);
                                    fileLock.releaseLock();
                                }
                            });
                            SchemaElement.addToCache(schemaElement2);
                            dBschemaDataObject.setSchemaElementImpl(schemaElementImpl);
                            dBschemaDataObject.setSchema(schemaElement2);
                            progressFrame.setMessage(RecaptureSchema.this.bundle.getString("SchemaSaved"));
                            StatusDisplayer.getDefault().setStatusText(RecaptureSchema.this.bundle.getString("SchemaSaved"));
                            progressFrame.setVisible(false);
                            progressFrame.dispose();
                        }
                        if (bl) {
                            if (bl2) {
                                ConnectionManager.getDefault().disconnect(databaseConnection);
                            } else {
                                connectionProvider2.closeConnection();
                            }
                        }
                    }
                    catch (Exception exception) {
                        ErrorManager.getDefault().notify((Throwable)exception);
                    }
                }

                static /* synthetic */ RecaptureSchema access$000(1 var0) {
                    return var0.RecaptureSchema.this;
                }

                static /* synthetic */ FileObject access$300(1 var0) {
                    return var0.fileObject;
                }
            }, 0);
        }
        catch (Exception exception) {
            String string2 = MessageFormat.format(this.bundle.getString("UnableToCreateSchema"), exception.getMessage());
            StatusDisplayer.getDefault().setStatusText(string2);
            if (debug) {
                ErrorManager.getDefault().notify(1, (Throwable)exception);
            }
            try {
                if (connectionProvider != null) {
                    connectionProvider.closeConnection();
                }
                if (this.data.isConnected()) {
                    if (this.data.isExistingConn()) {
                        ConnectionManager.getDefault().disconnect(this.data.getDatabaseConnection());
                    } else {
                        connectionProvider.closeConnection();
                    }
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
    }

    private String dumpSe(SchemaElement schemaElement) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("name " + schemaElement.getName());
        stringBuffer.append("\n");
        stringBuffer.append("driver " + schemaElement.getDriverName());
        stringBuffer.append("\n");
        stringBuffer.append("username " + schemaElement.getUsername());
        stringBuffer.append("\n");
        TableElement[] tableElementArray = schemaElement.getTables();
        stringBuffer.append("tables count " + tableElementArray.length);
        stringBuffer.append("\n");
        for (int i = 0; i < tableElementArray.length; ++i) {
            stringBuffer.append("    table " + tableElementArray[i].getName());
            stringBuffer.append("\n");
            ColumnElement[] columnElementArray = tableElementArray[i].getColumns();
            for (int j = 0; j < columnElementArray.length; ++j) {
                stringBuffer.append("        column " + columnElementArray[j].getName());
                stringBuffer.append("\n");
            }
        }
        return stringBuffer.toString();
    }

    public ConnectionProvider createConnectionProvider(DBSchemaWizardData dBSchemaWizardData, String string) throws SQLException {
        DatabaseConnection databaseConnection = this.findDatabaseConnection(string);
        if (databaseConnection == null) {
            if (debug) {
                System.out.println("[dbschema-ccp] not found dbconn='" + databaseConnection + "'");
            }
            return null;
        }
        if (debug) {
            System.out.println("[dbschema-ccp] found dbconn='" + databaseConnection.getDatabaseURL() + "'");
        }
        dBSchemaWizardData.setDatabaseConnection(databaseConnection);
        ConnectionHandler connectionHandler = new ConnectionHandler(dBSchemaWizardData);
        if (connectionHandler.ensureConnection()) {
            databaseConnection = dBSchemaWizardData.getDatabaseConnection();
            if (debug) {
                System.out.println("[dbschema-ccp] connection ensured ='" + databaseConnection.getDatabaseURL() + "'");
            }
            ConnectionProvider connectionProvider = new ConnectionProvider(databaseConnection.getJDBCConnection(), databaseConnection.getDriverClass());
            connectionProvider.setSchema(databaseConnection.getSchema());
            return connectionProvider;
        }
        if (debug) {
            System.out.println("[dbschema-ccp] connection not ensured, returning null");
        }
        return null;
    }

    private DatabaseConnection findDatabaseConnection(String string) {
        DatabaseConnection[] databaseConnectionArray = ConnectionManager.getDefault().getConnections();
        for (int i = 0; i < databaseConnectionArray.length; ++i) {
            if (!string.equals(databaseConnectionArray[i].getDatabaseURL())) continue;
            return databaseConnectionArray[i];
        }
        return null;
    }

    static /* synthetic */ boolean access$100() {
        return debug;
    }

    static /* synthetic */ String access$200(RecaptureSchema recaptureSchema, SchemaElement schemaElement) {
        return recaptureSchema.dumpSe(schemaElement);
    }

    private static class ConnectionHandler
    extends DBSchemaTablesPanel {
        public ConnectionHandler(DBSchemaWizardData dBSchemaWizardData) {
            super(dBSchemaWizardData, new ArrayList());
        }

        public boolean ensureConnection() {
            return this.init();
        }
    }
}

