/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.orbutil.newtimer;

import com.sun.corba.ee.spi.orbutil.newtimer.Controllable;
import com.sun.corba.ee.spi.orbutil.newtimer.LogEventHandler;
import com.sun.corba.ee.spi.orbutil.newtimer.NamedBase;
import com.sun.corba.ee.spi.orbutil.newtimer.Timer;
import com.sun.corba.ee.spi.orbutil.newtimer.TimerEvent;
import com.sun.corba.ee.spi.orbutil.newtimer.TimerFactory;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogEventHandlerImpl
extends NamedBase
implements LogEventHandler {
    private static final int DEFAULT_SIZE = 1000;
    private static final int DEFAULT_INCREMENT = 1000;
    private long[] data;
    private int size;
    private int increment;
    private int nextFree;
    private TimerFactory factory;

    LogEventHandlerImpl(TimerFactory factory, String name) {
        super(factory, name);
        this.initData(1000, 1000);
    }

    @Override
    public synchronized Iterator<TimerEvent> iterator() {
        final int limit = this.nextFree;
        return new Iterator<TimerEvent>(){
            private int current = 0;
            private TimerEvent entry = null;

            @Override
            public boolean hasNext() {
                return this.current < limit;
            }

            @Override
            public TimerEvent next() {
                if (this.hasNext()) {
                    long elem = LogEventHandlerImpl.this.data[this.current];
                    TimerEvent.TimerEventType etype = (elem & 1L) == 1L ? TimerEvent.TimerEventType.ENTER : TimerEvent.TimerEventType.EXIT;
                    int id = (int)(elem >> 2);
                    Controllable con = LogEventHandlerImpl.this.factory().getControllable(id);
                    if (!(con instanceof Timer)) {
                        throw new IllegalStateException("Controllable id must be Timer");
                    }
                    Timer timer = (Timer)Timer.class.cast(con);
                    if (this.entry == null) {
                        this.entry = new TimerEvent(timer, etype, LogEventHandlerImpl.this.data[this.current + 1]);
                    } else {
                        this.entry.update(timer, etype, LogEventHandlerImpl.this.data[this.current + 1]);
                    }
                    this.current += 2;
                    return this.entry;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private void initData(int size, int increment) {
        this.size = 2 * size;
        this.increment = 2 * increment;
        this.data = new long[this.size];
        this.nextFree = 0;
    }

    @Override
    public void notify(TimerEvent event) {
        int id = 2 * event.timer().id() + (event.type() == TimerEvent.TimerEventType.ENTER ? 0 : 1);
        this.log(id, event.time());
    }

    private synchronized void log(int id, long time) {
        if (this.data.length - this.nextFree < 2) {
            int newSize = this.data.length + 2 * this.increment;
            long[] newData = new long[newSize];
            System.arraycopy(this.data, 0, newData, 0, this.data.length);
            this.data = newData;
        }
        int index = this.nextFree;
        this.nextFree += 2;
        this.data[index] = id;
        this.data[index + 1] = time;
    }

    @Override
    public synchronized void clear() {
        this.initData(this.size, this.increment);
    }
}

