/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.protocol;

import com.sun.corba.ee.impl.logging.POASystemException;
import com.sun.corba.ee.impl.protocol.LocalClientRequestDispatcherBase;
import com.sun.corba.ee.spi.ior.IOR;
import com.sun.corba.ee.spi.oa.OADestroyed;
import com.sun.corba.ee.spi.oa.OAInvocationInfo;
import com.sun.corba.ee.spi.oa.ObjectAdapter;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.protocol.ForwardException;

public abstract class ServantCacheLocalCRDBase
extends LocalClientRequestDispatcherBase {
    private OAInvocationInfo cachedInfo;
    protected POASystemException wrapper;

    protected ServantCacheLocalCRDBase(ORB orb, int scid, IOR ior) {
        super(orb, scid, ior);
        this.wrapper = POASystemException.get(orb, "rpc.protocol");
    }

    protected synchronized void clear() {
        this.cachedInfo = null;
    }

    protected synchronized OAInvocationInfo getCachedInfo() {
        if (!this.servantIsLocal) {
            throw this.wrapper.servantMustBeLocal();
        }
        if (this.cachedInfo == null) {
            this.updateCachedInfo();
        }
        return this.cachedInfo;
    }

    private void updateCachedInfo() {
        ObjectAdapter oa = this.oaf.find(this.oaid);
        this.cachedInfo = oa.makeInvocationInfo(this.objectId);
        this.orb.pushInvocationInfo(this.cachedInfo);
        try {
            oa.enter();
            try {
                oa.getInvocationServant(this.cachedInfo);
            }
            catch (ForwardException freq) {
                throw this.wrapper.illegalForwardRequest(freq);
            }
            finally {
                oa.returnServant();
                oa.exit();
                this.orb.popInvocationInfo();
            }
        }
        catch (OADestroyed oades) {
            this.orb.popInvocationInfo();
            this.updateCachedInfo();
        }
    }
}

