/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.resolver;

import com.sun.corba.ee.impl.encoding.EncapsInputStream;
import com.sun.corba.ee.impl.logging.OMGSystemException;
import com.sun.corba.ee.impl.logging.ORBUtilSystemException;
import com.sun.corba.ee.impl.naming.namingutil.CorbalocURL;
import com.sun.corba.ee.impl.naming.namingutil.CorbanameURL;
import com.sun.corba.ee.impl.naming.namingutil.IIOPEndpointInfo;
import com.sun.corba.ee.impl.naming.namingutil.INSURL;
import com.sun.corba.ee.impl.naming.namingutil.INSURLHandler;
import com.sun.corba.ee.impl.orbutil.ORBUtility;
import com.sun.corba.ee.spi.ior.IOR;
import com.sun.corba.ee.spi.ior.IORFactories;
import com.sun.corba.ee.spi.ior.IORTemplate;
import com.sun.corba.ee.spi.ior.ObjectKey;
import com.sun.corba.ee.spi.ior.iiop.AlternateIIOPAddressComponent;
import com.sun.corba.ee.spi.ior.iiop.GIOPVersion;
import com.sun.corba.ee.spi.ior.iiop.IIOPAddress;
import com.sun.corba.ee.spi.ior.iiop.IIOPFactories;
import com.sun.corba.ee.spi.ior.iiop.IIOPProfileTemplate;
import com.sun.corba.ee.spi.orb.Operation;
import com.sun.corba.ee.spi.resolver.Resolver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;

public class INSURLOperationImpl
implements Operation {
    com.sun.corba.ee.spi.orb.ORB orb;
    ORBUtilSystemException wrapper;
    OMGSystemException omgWrapper;
    Resolver bootstrapResolver;
    private NamingContextExt rootNamingContextExt;
    private java.lang.Object rootContextCacheLock = new java.lang.Object();
    private INSURLHandler insURLHandler = INSURLHandler.getINSURLHandler();
    private static final int NIBBLES_PER_BYTE = 2;
    private static final int UN_SHIFT = 4;

    public INSURLOperationImpl(com.sun.corba.ee.spi.orb.ORB orb, Resolver bootstrapResolver) {
        this.orb = orb;
        this.wrapper = ORBUtilSystemException.get(orb, "orb.resolver");
        this.omgWrapper = OMGSystemException.get(orb, "orb.resolver");
        this.bootstrapResolver = bootstrapResolver;
    }

    private Object getIORFromString(String str) {
        if ((str.length() & 1) == 1) {
            throw this.wrapper.badStringifiedIorLen();
        }
        byte[] buf = new byte[(str.length() - "IOR:".length()) / 2];
        int j = 0;
        for (int i = "IOR:".length(); i < str.length(); i += 2) {
            buf[j] = (byte)(ORBUtility.hexOf(str.charAt(i)) << 4 & 0xF0);
            int n = j++;
            buf[n] = (byte)(buf[n] | (byte)(ORBUtility.hexOf(str.charAt(i + 1)) & 0xF));
        }
        EncapsInputStream s = new EncapsInputStream((ORB)((java.lang.Object)this.orb), buf, buf.length, this.orb.getORBData().getGIOPVersion());
        s.consumeEndian();
        return s.read_Object();
    }

    public java.lang.Object operate(java.lang.Object arg) {
        if (arg instanceof String) {
            String str = (String)arg;
            if (str.startsWith("IOR:")) {
                return this.getIORFromString(str);
            }
            INSURL insURL = this.insURLHandler.parseURL(str);
            if (insURL == null) {
                throw this.omgWrapper.soBadSchemeName();
            }
            return this.resolveINSURL(insURL);
        }
        throw this.wrapper.stringExpected();
    }

    private Object resolveINSURL(INSURL theURLObject) {
        if (theURLObject.isCorbanameURL()) {
            return this.resolveCorbaname((CorbanameURL)theURLObject);
        }
        return this.resolveCorbaloc((CorbalocURL)theURLObject);
    }

    private Object resolveCorbaloc(CorbalocURL theCorbaLocObject) {
        Object result = null;
        result = theCorbaLocObject.getRIRFlag() ? this.bootstrapResolver.resolve(theCorbaLocObject.getKeyString()) : this.getIORUsingCorbaloc(theCorbaLocObject);
        return result;
    }

    private Object resolveCorbaname(CorbanameURL theCorbaName) {
        java.lang.Object result = null;
        try {
            NamingContextExt theNamingContext = null;
            if (theCorbaName.getRIRFlag()) {
                theNamingContext = this.getDefaultRootNamingContext();
            } else {
                Object corbalocResult = this.getIORUsingCorbaloc(theCorbaName);
                if (corbalocResult == null) {
                    return null;
                }
                theNamingContext = NamingContextExtHelper.narrow((Object)corbalocResult);
            }
            String StringifiedName = theCorbaName.getStringifiedName();
            if (StringifiedName == null) {
                return theNamingContext;
            }
            return theNamingContext.resolve_str(StringifiedName);
        }
        catch (Exception e) {
            this.clearRootNamingContextCache();
            throw this.omgWrapper.soBadSchemaSpecific(e);
        }
    }

    private Object getIORUsingCorbaloc(INSURL corbalocObject) {
        HashMap<GIOPVersion, IIOPProfileTemplate> profileMap = new HashMap<GIOPVersion, IIOPProfileTemplate>();
        ArrayList<IIOPProfileTemplate> profileList1_0 = new ArrayList<IIOPProfileTemplate>();
        List theEndpointInfo = corbalocObject.getEndpointInfo();
        String theKeyString = corbalocObject.getKeyString();
        if (theKeyString == null) {
            return null;
        }
        ObjectKey key = this.orb.getObjectKeyFactory().create(theKeyString.getBytes());
        IORTemplate iortemp = IORFactories.makeIORTemplate(key.getTemplate());
        for (IIOPEndpointInfo element : theEndpointInfo) {
            IIOPAddress addr = IIOPFactories.makeIIOPAddress(this.orb, element.getHost(), element.getPort());
            GIOPVersion giopVersion = GIOPVersion.getInstance((byte)element.getMajor(), (byte)element.getMinor());
            IIOPProfileTemplate profileTemplate = null;
            if (giopVersion.equals(GIOPVersion.V1_0)) {
                profileTemplate = IIOPFactories.makeIIOPProfileTemplate(this.orb, giopVersion, addr);
                profileList1_0.add(profileTemplate);
                continue;
            }
            if (profileMap.get(giopVersion) == null) {
                profileTemplate = IIOPFactories.makeIIOPProfileTemplate(this.orb, giopVersion, addr);
                profileMap.put(giopVersion, profileTemplate);
                continue;
            }
            profileTemplate = (IIOPProfileTemplate)profileMap.get(giopVersion);
            AlternateIIOPAddressComponent iiopAddressComponent = IIOPFactories.makeAlternateIIOPAddressComponent(addr);
            profileTemplate.add(iiopAddressComponent);
        }
        GIOPVersion giopVersion = this.orb.getORBData().getGIOPVersion();
        IIOPProfileTemplate pTemplate = (IIOPProfileTemplate)profileMap.get(giopVersion);
        if (pTemplate != null) {
            iortemp.add(pTemplate);
            profileMap.remove(giopVersion);
        }
        Comparator comp = new Comparator(){

            public int compare(java.lang.Object o1, java.lang.Object o2) {
                GIOPVersion gv1 = (GIOPVersion)o1;
                GIOPVersion gv2 = (GIOPVersion)o2;
                return gv1.lessThan(gv2) ? 1 : (gv1.equals(gv2) ? 0 : -1);
            }
        };
        ArrayList list = new ArrayList(profileMap.keySet());
        Collections.sort(list, comp);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            IIOPProfileTemplate pt = (IIOPProfileTemplate)profileMap.get(iter.next());
            iortemp.add(pt);
        }
        iortemp.addAll(profileList1_0);
        IOR ior = iortemp.makeIOR(this.orb, "", key.getId());
        return ORBUtility.makeObjectReference(ior);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NamingContextExt getDefaultRootNamingContext() {
        java.lang.Object object = this.rootContextCacheLock;
        synchronized (object) {
            if (this.rootNamingContextExt == null) {
                try {
                    this.rootNamingContextExt = NamingContextExtHelper.narrow((Object)this.orb.getLocalResolver().resolve("NameService"));
                }
                catch (Exception e) {
                    this.rootNamingContextExt = null;
                }
            }
        }
        return this.rootNamingContextExt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearRootNamingContextCache() {
        java.lang.Object object = this.rootContextCacheLock;
        synchronized (object) {
            this.rootNamingContextExt = null;
        }
    }
}

