/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.org.objectweb.asm.util;

import com.sun.corba.ee.org.objectweb.asm.AnnotationVisitor;
import com.sun.corba.ee.org.objectweb.asm.Attribute;
import com.sun.corba.ee.org.objectweb.asm.Type;
import com.sun.corba.ee.org.objectweb.asm.util.ASMifierAnnotationVisitor;
import com.sun.corba.ee.org.objectweb.asm.util.AbstractVisitor;
import com.sun.corba.ee.org.objectweb.asm.util.attrs.ASMifiable;
import java.util.HashMap;

public class ASMifierAbstractVisitor
extends AbstractVisitor {
    protected String name;
    HashMap labelNames;

    protected ASMifierAbstractVisitor(String name) {
        this.name = name;
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        this.buf.setLength(0);
        this.buf.append("{\n").append("av0 = ").append(this.name).append(".visitAnnotation(");
        this.appendConstant(desc);
        this.buf.append(", ").append(visible).append(");\n");
        this.text.add(this.buf.toString());
        ASMifierAnnotationVisitor av = new ASMifierAnnotationVisitor(0);
        this.text.add(av.getText());
        this.text.add("}\n");
        return av;
    }

    public void visitAttribute(Attribute attr) {
        this.buf.setLength(0);
        if (attr instanceof ASMifiable) {
            this.buf.append("{\n");
            this.buf.append("// ATTRIBUTE\n");
            ((ASMifiable)((Object)attr)).asmify(this.buf, "attr", this.labelNames);
            this.buf.append(this.name).append(".visitAttribute(attr);\n");
            this.buf.append("}\n");
        } else {
            this.buf.append("// WARNING! skipped a non standard attribute of type \"");
            this.buf.append(attr.type).append("\"\n");
        }
        this.text.add(this.buf.toString());
    }

    public void visitEnd() {
        this.buf.setLength(0);
        this.buf.append(this.name).append(".visitEnd();\n");
        this.text.add(this.buf.toString());
    }

    void appendConstant(Object cst) {
        ASMifierAbstractVisitor.appendConstant(this.buf, cst);
    }

    static void appendConstant(StringBuffer buf, Object cst) {
        if (cst == null) {
            buf.append("null");
        } else if (cst instanceof String) {
            ASMifierAbstractVisitor.appendString(buf, (String)cst);
        } else if (cst instanceof Type) {
            buf.append("Type.getType(\"");
            buf.append(((Type)cst).getDescriptor());
            buf.append("\")");
        } else if (cst instanceof Byte) {
            buf.append("new Byte((byte)").append(cst).append(")");
        } else if (cst instanceof Boolean) {
            buf.append("new Boolean(").append(cst).append(")");
        } else if (cst instanceof Short) {
            buf.append("new Short((short)").append(cst).append(")");
        } else if (cst instanceof Character) {
            char c = ((Character)cst).charValue();
            buf.append("new Character((char)").append((int)c).append(")");
        } else if (cst instanceof Integer) {
            buf.append("new Integer(").append(cst).append(")");
        } else if (cst instanceof Float) {
            buf.append("new Float(\"").append(cst).append("\")");
        } else if (cst instanceof Long) {
            buf.append("new Long(").append(cst).append("L)");
        } else if (cst instanceof Double) {
            buf.append("new Double(\"").append(cst).append("\")");
        } else if (cst instanceof byte[]) {
            byte[] v = (byte[])cst;
            buf.append("new byte[] {");
            for (int i = 0; i < v.length; ++i) {
                buf.append(i == 0 ? "" : ",").append(v[i]);
            }
            buf.append("}");
        } else if (cst instanceof boolean[]) {
            boolean[] v = (boolean[])cst;
            buf.append("new boolean[] {");
            for (int i = 0; i < v.length; ++i) {
                buf.append(i == 0 ? "" : ",").append(v[i]);
            }
            buf.append("}");
        } else if (cst instanceof short[]) {
            short[] v = (short[])cst;
            buf.append("new short[] {");
            for (int i = 0; i < v.length; ++i) {
                buf.append(i == 0 ? "" : ",").append("(short)").append(v[i]);
            }
            buf.append("}");
        } else if (cst instanceof char[]) {
            char[] v = (char[])cst;
            buf.append("new char[] {");
            for (int i = 0; i < v.length; ++i) {
                buf.append(i == 0 ? "" : ",").append("(char)").append((int)v[i]);
            }
            buf.append("}");
        } else if (cst instanceof int[]) {
            int[] v = (int[])cst;
            buf.append("new int[] {");
            for (int i = 0; i < v.length; ++i) {
                buf.append(i == 0 ? "" : ",").append(v[i]);
            }
            buf.append("}");
        } else if (cst instanceof long[]) {
            long[] v = (long[])cst;
            buf.append("new long[] {");
            for (int i = 0; i < v.length; ++i) {
                buf.append(i == 0 ? "" : ",").append(v[i]).append("L");
            }
            buf.append("}");
        } else if (cst instanceof float[]) {
            float[] v = (float[])cst;
            buf.append("new float[] {");
            for (int i = 0; i < v.length; ++i) {
                buf.append(i == 0 ? "" : ",").append(v[i]).append("f");
            }
            buf.append("}");
        } else if (cst instanceof double[]) {
            double[] v = (double[])cst;
            buf.append("new double[] {");
            for (int i = 0; i < v.length; ++i) {
                buf.append(i == 0 ? "" : ",").append(v[i]).append("d");
            }
            buf.append("}");
        }
    }
}

