/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.event;

import com.sun.enterprise.admin.event.AdminEvent;
import com.sun.enterprise.admin.event.AdminEventListenerException;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class AdminEventResult
implements Serializable {
    private static final Class SERIALIZABLE = Serializable.class;
    public static final String RESTART_NEEDED = "restart";
    public static final String RUNTIME_EXCEPTION = "runtime_exception";
    public static final String RUNTIME_ERROR = "runtime_error";
    public static final String TRANSMISSION_ERROR = "transmission_error";
    public static final String LISTENER_ERROR = "listener_error";
    public static final String CONFIG_SNAPSHOT_ERROR = "config_snapshot_error";
    public static final String MBEAN_NOT_FOUND = "mbean_not_found";
    public static final String MBEAN_ATTR_NOT_FOUND = "mbean_attr_not_found";
    public static final String SUCCESS = "success";
    public static final String MIXED_RESULT = "mixed_result";
    public static final String ERROR = "Event did not reach any recipient";
    private static HashMap resultList = new HashMap();
    private long eventId;
    private String resultCode;
    private HashMap resultCodes = new HashMap();
    private HashMap allMessages = new HashMap();
    private HashMap allExceptions = new HashMap();
    private HashMap allAttributes = new HashMap();
    private AdminEventListenerException firstAle = null;
    private Throwable firstThr = null;
    private static StringManager localStrings = StringManager.getManager(AdminEventResult.class);

    public AdminEventResult(long eventId) {
        this.eventId = eventId;
        this.resultCode = SUCCESS;
    }

    public long getEventId() {
        return this.eventId;
    }

    public String getResultCode() {
        return this.resultCode;
    }

    public HashMap getResultCodes() {
        return this.resultCodes;
    }

    public HashMap getMessages() {
        return this.allMessages;
    }

    public Collection getMessages(String target) {
        return (Collection)this.allMessages.get(target);
    }

    public HashMap getExceptions() {
        return this.allExceptions;
    }

    public Collection getExceptions(String target) {
        return (Collection)this.allExceptions.get(target);
    }

    public void setResultCode(String resultCode) {
        if (!RESTART_NEEDED.equals(this.resultCode)) {
            this.resultCode = resultCode;
        }
    }

    public String getAllResultCodesAsString() {
        StringBuffer sb = new StringBuffer();
        Set resultCodeSet = this.resultCodes.entrySet();
        Iterator iter = resultCodeSet.iterator();
        while (iter != null && iter.hasNext()) {
            Map.Entry nextMapEntry = iter.next();
            sb.append(localStrings.getString("admin.event.target_string"));
            sb.append(nextMapEntry.getKey());
            sb.append("            ");
            sb.append(localStrings.getString("admin.event.result_code_string"));
            sb.append(nextMapEntry.getValue());
            sb.append("            ");
        }
        return sb.toString();
    }

    public String getAllMessagesAsString() {
        StringBuffer sb = new StringBuffer();
        Set messageSet = this.allMessages.entrySet();
        Iterator iter = messageSet.iterator();
        while (iter != null && iter.hasNext()) {
            Map.Entry nextMapEntry = iter.next();
            sb.append(localStrings.getString("admin.event.target_string"));
            sb.append(nextMapEntry.getKey());
            sb.append("            ");
            Collection msgCol = (Collection)nextMapEntry.getValue();
            Iterator msgs = null;
            if (msgCol != null) {
                msgs = msgCol.iterator();
            }
            int msgCount = 0;
            if (msgs == null) continue;
            while (msgs.hasNext()) {
                sb.append(localStrings.getString("admin.event.msg_string", new Integer(++msgCount).toString()));
                String msg = (String)msgs.next();
                sb.append(msg);
                sb.append("            ");
            }
        }
        Set exceptionSet = this.allExceptions.entrySet();
        iter = exceptionSet.iterator();
        while (iter != null && iter.hasNext()) {
            Map.Entry nextMapEntry = iter.next();
            Collection excsCol = (Collection)nextMapEntry.getValue();
            Iterator excs = null;
            if (excsCol != null) {
                excs = excsCol.iterator();
            }
            if (excs == null) continue;
            sb.append(localStrings.getString("admin.event.target_string"));
            sb.append(nextMapEntry.getKey());
            sb.append("            ");
            int excCount = 0;
            while (excs.hasNext()) {
                Throwable tt = (Throwable)excs.next();
                ++excCount;
                if (tt == null) continue;
                sb.append(localStrings.getString("admin.event.exp_string", new Integer(excCount).toString()));
                String nextStr = tt.getMessage();
                sb.append(nextStr);
                sb.append(System.getProperty("line.separator"));
                StringWriter sw = new StringWriter();
                tt.printStackTrace(new PrintWriter(sw));
                sb.append(sw.toString());
                sb.append(System.getProperty("line.separator"));
            }
        }
        return sb.toString();
    }

    public void addMessage(String target, String message) {
        ArrayList<String> msgs = (ArrayList<String>)this.allMessages.get(target);
        if (msgs == null) {
            msgs = new ArrayList<String>();
            this.allMessages.put(target, msgs);
        }
        msgs.add(message);
    }

    public void addException(String target, Throwable tt) {
        ArrayList<Throwable> excs = (ArrayList<Throwable>)this.allExceptions.get(target);
        if (excs == null) {
            excs = new ArrayList<Throwable>();
            this.allExceptions.put(target, excs);
        }
        excs.add(tt);
        if (this.firstAle == null && tt instanceof AdminEventListenerException) {
            this.firstAle = (AdminEventListenerException)tt;
        }
        if (this.firstThr == null) {
            this.firstThr = tt;
        }
    }

    public AdminEventListenerException getFirstAdminEventListenerException() {
        return this.firstAle;
    }

    public Throwable getFirstThrowable() {
        return this.firstThr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addAttribute(String target, String name, Object value) {
        this.attributeCheck(name, value);
        HashMap hashMap = this.allAttributes;
        synchronized (hashMap) {
            HashMap<String, Object> attributes = (HashMap<String, Object>)this.allAttributes.get(target);
            if (attributes == null) {
                attributes = new HashMap<String, Object>();
                this.allAttributes.put(target, attributes);
            }
            attributes.put(name, value);
        }
    }

    void attributeCheck(String name, Object value) {
        if (name == null) {
            String msg = localStrings.getString("admin.event.null_attribute_name");
            throw new IllegalArgumentException(msg);
        }
        if (value != null && !SERIALIZABLE.isInstance(value)) {
            String msg = localStrings.getString("admin.event.value_not_serializable");
            throw new IllegalArgumentException(msg);
        }
    }

    public HashMap getAttributes(String target) {
        return (HashMap)this.allAttributes.get(target);
    }

    public Set getAttributeNames(String target) {
        HashMap h = (HashMap)this.allAttributes.get(target);
        if (h != null) {
            return h.keySet();
        }
        return null;
    }

    public Object getAttribute(String target, String name) {
        if (name == null) {
            String msg = localStrings.getString("admin.event.null_attribute_name");
            throw new IllegalArgumentException(msg);
        }
        HashMap attributes = (HashMap)this.allAttributes.get(target);
        if (attributes != null) {
            return attributes.get(name);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAttribute(String target, String name) {
        if (name == null) {
            String msg = localStrings.getString("admin.event.null_attribute_name");
            throw new IllegalArgumentException(msg);
        }
        HashMap hashMap = this.allAttributes;
        synchronized (hashMap) {
            HashMap attributes = (HashMap)this.allAttributes.get(target);
            if (attributes != null) {
                attributes.remove(name);
            }
        }
    }

    public static AdminEventResult getAdminEventResult(AdminEvent event) {
        AdminEventResult result = (AdminEventResult)resultList.get(event);
        if (result == null) {
            result = new AdminEventResult(event.getSequenceNumber());
            resultList.put(event, result);
        }
        return result;
    }

    static void clearAdminEventResultFromCache(AdminEvent event) {
        resultList.remove(event);
    }

    public void addEventResult(String target, AdminEventResult eventResult) {
        if (eventResult == null) {
            return;
        }
        this.allMessages.put(target, eventResult.getMessages().get(target));
        this.allExceptions.put(target, eventResult.getExceptions().get(target));
        this.allAttributes.put(target, eventResult.getAttributes(target));
        if (this.resultCodes == null) {
            this.resultCodes = new HashMap();
            this.resultCodes.put(target, eventResult.getResultCode());
        }
    }
}

