/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.mbeans;

import com.sun.enterprise.admin.common.MBeanServerFactory;
import com.sun.enterprise.admin.config.BaseConfigMBean;
import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.admin.target.Target;
import com.sun.enterprise.admin.target.TargetBuilder;
import com.sun.enterprise.admin.target.TargetType;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.logging.Logger;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class TransactionServiceManagerMBean
extends BaseConfigMBean {
    private static final TargetType[] VALID_TARGET_TYPES = new TargetType[]{TargetType.UNCLUSTERED_SERVER, TargetType.DAS, TargetType.SERVER};
    private static final StringManager _strMgr = StringManager.getManager(TransactionServiceManagerMBean.class);
    public static final Logger _logger = Logger.getLogger("javax.enterprise.system.tools.admin");

    public void freeze(String serverName) throws Exception {
        this.finest("freeze called for target: " + serverName);
        this.validateServerName(serverName);
        try {
            this.getMBS().invoke(this.getTransactionServiceObjectName(serverName), "freeze", null, null);
        }
        catch (InstanceNotFoundException e) {
            throw new MBeanException(e, _strMgr.getString("admin.mbeans.server_not_running", new Object[]{serverName}));
        }
    }

    public void unfreeze(String serverName) throws Exception {
        this.finest("unfreeze called for target: " + serverName);
        this.validateServerName(serverName);
        try {
            this.getMBS().invoke(this.getTransactionServiceObjectName(serverName), "unfreeze", null, null);
        }
        catch (InstanceNotFoundException e) {
            throw new MBeanException(e, _strMgr.getString("admin.mbeans.server_not_running", new Object[]{serverName}));
        }
    }

    public void rollback(String[] txids, String serverName) throws Exception {
        this.finest("rollback called for target: " + serverName);
        this.validateServerName(serverName);
        try {
            this.getMBS().invoke(this.getTransactionServiceObjectName(serverName), "rollback", new Object[]{txids}, new String[]{"[Ljava.lang.String;"});
        }
        catch (InstanceNotFoundException e) {
            throw new MBeanException(e, _strMgr.getString("admin.mbeans.server_not_running", new Object[]{serverName}));
        }
    }

    private MBeanServer getMBS() {
        return MBeanServerFactory.getMBeanServer();
    }

    private ObjectName getTransactionServiceObjectName(String server) throws Exception {
        return new ObjectName(this.getDomainName() + ":type=TransactionService,J2EEServer=" + server + ",category=runtime");
    }

    private void validateServerName(String server) throws Exception {
        this.finest("validating the target " + server);
        Target target = TargetBuilder.INSTANCE.createTarget(VALID_TARGET_TYPES, server, this.getConfigContext());
        this.finest("Target is valid: " + server);
    }

    protected ConfigContext getConfigContext() {
        ConfigContext result = super.getConfigContext();
        if (result == null) {
            result = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
        }
        return result;
    }

    private void finest(String s) {
        _logger.finest("TransactionServiceManagerMBean: " + s);
    }
}

