/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.selfmanagement.event;

import com.sun.enterprise.admin.selfmanagement.event.Event;
import com.sun.enterprise.admin.selfmanagement.event.TraceEventNotificationFilter;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MalformedObjectNameException;
import javax.management.NotificationFilter;
import javax.management.ObjectName;

public class TraceEvent
implements Event {
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.selfmanagement");
    private static StringManager sm = StringManager.getManager(TraceEvent.class);
    private static ObjectName objName = null;
    private static String defaultDescription = sm.getString("selfmgmt_event.trace_event_description");
    private TraceEventNotificationFilter lfilter = null;
    private String description = null;
    private String type = null;

    public TraceEvent(String type, TraceEventNotificationFilter lfilter, String description) {
        this.type = type;
        this.lfilter = lfilter;
        this.description = description != null ? description : defaultDescription;
    }

    public ObjectName getObjectName() {
        return objName;
    }

    public String getType() {
        return this.type;
    }

    public NotificationFilter getNotificationFilter() {
        return this.lfilter;
    }

    public String getDescription() {
        return this.description;
    }

    public void destroy() {
    }

    static ObjectName getTraceImplObjectName() {
        if (objName != null) {
            return objName;
        }
        try {
            objName = new ObjectName("com.sun.appserver.selfmanagement", "eventname", "trace");
        }
        catch (MalformedObjectNameException mex) {
            _logger.log(Level.WARNING, "smgt.internal_error", mex);
        }
        return objName;
    }

    public static boolean isValidType(String type) {
        return "*".equals(type) || "trace.request_start".equals(type) || "trace.request_end".equals(type) || "trace.web_component_method_entry".equals(type) || "trace.web_component_method_exit".equals(type) || "trace.ejb_component_method_entry".equals(type) || "trace.ejb_component_method_exit".equals(type);
    }
}

