/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.util;

import com.sun.enterprise.admin.util.NOOPHandler;
import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XMLAlterUtil {
    private static boolean bDebug = false;

    public static void main(String[] args) {
        try {
            if (args.length != 4) {
                System.out.println("Proper Usage: java XMLAlterUtil BASE_DOCUMENT_TO_CHANGE BASE_DOCUMENT_DTD CHANGES_DOCUMENT OUTPUT_DOCUMENT");
                System.exit(1);
            }
            String baseXML = args[0];
            String baseDTD = args[1];
            String changeXML = args[2];
            String outXML = args[3];
            if (System.getProperty("Debug") != null) {
                bDebug = true;
            }
            XMLAlterUtil xau = new XMLAlterUtil();
            if (bDebug) {
                System.out.println("parsing - " + baseXML);
            }
            Document baseDoc = null;
            baseDoc = baseDTD.equals("null") ? xau.readDOM(baseXML) : xau.readDOM(baseXML, baseDTD);
            if (bDebug) {
                System.out.println("parsing - " + changeXML);
            }
            Document changeDoc = xau.readDOM(changeXML);
            xau.alterDOM(baseDoc, changeDoc);
            DocumentType baseDocType = baseDoc.getDoctype();
            String doctype_system = null;
            String doctype_public = null;
            if (baseDocType != null) {
                doctype_system = baseDocType.getSystemId();
                doctype_public = baseDocType.getPublicId();
            }
            xau.writeDOM(baseDoc, outXML, doctype_system, doctype_public);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void alterDOM(Document baseDoc, Document changeDoc) throws Exception {
        Element baseRoot = baseDoc.getDocumentElement();
        Element changeRoot = changeDoc.getDocumentElement();
        NodeList nl = changeRoot.getElementsByTagName("alteration");
        boolean matched = false;
        if (bDebug) {
            System.out.println("\n** Base Root Node Name is '" + baseRoot.getNodeName() + "' **");
        }
        block0: for (int ii = 0; ii < nl.getLength(); ++ii) {
            Element cElement = (Element)nl.item(ii);
            matched = false;
            String elementName = cElement.getAttribute("elementName");
            String type = cElement.getAttribute("type");
            String dnType = cElement.getAttribute("dnType");
            String dnName = cElement.getAttribute("dnName");
            String dnValue = cElement.getAttribute("dnValue");
            String dnModifier = cElement.getAttribute("dnModifier");
            if (bDebug) {
                System.out.println("\n** Trying to match an element '" + elementName + "' with dnType='" + dnType + "', dnName='" + dnName + "' and dnValue='" + dnValue + "'");
            }
            NodeList bnl = elementName.equals(baseRoot.getNodeName()) ? baseDoc.getElementsByTagName(elementName) : baseRoot.getElementsByTagName(elementName);
            if (bDebug) {
                System.out.println("\n\tFound " + bnl.getLength() + " elements to match to.");
            }
            for (int jj = 0; jj < bnl.getLength(); ++jj) {
                if (bnl.item(jj) instanceof Element) {
                    Element bElement = (Element)bnl.item(jj);
                    if (dnType.equals("attribute")) {
                        String bAttrValue = bElement.getAttribute(dnName);
                        if (this.matchValue(bAttrValue, dnValue, dnModifier)) {
                            if (bDebug) {
                                System.out.println("\n\tFound match on Attibute! Executing alteration...");
                            }
                            matched = true;
                            this.executeAlteration(bElement, cElement);
                        }
                    } else if (dnType.equals("text")) {
                        NodeList bnlx = bElement.getChildNodes();
                        for (int mm = 0; mm < bnlx.getLength(); ++mm) {
                            if (!(bnlx.item(mm) instanceof Text)) continue;
                            if (bDebug) {
                                System.out.println("Text - '" + bnlx.item(mm).getNodeValue() + "'");
                            }
                            if (!this.matchValue(bnlx.item(mm).getNodeValue(), dnValue, dnModifier)) continue;
                            if (bDebug) {
                                System.out.println("\n\tFound match on Text! Executing alteration...");
                            }
                            matched = true;
                            this.executeAlteration(bElement, cElement);
                        }
                    } else if (dnType.equals("")) {
                        if (bDebug) {
                            System.out.println("\n\tMatch on All! Executing alteration...");
                        }
                        matched = true;
                        this.executeAlteration(bElement, cElement);
                    }
                }
                if (type.equals("FIRST_OCCURRENCE") && matched) continue block0;
            }
        }
    }

    public boolean matchValue(String targetString, String dnValue, String dnModifier) {
        boolean bRet = false;
        bRet = dnModifier.equals("startsWith") ? targetString.startsWith(dnValue) : (dnModifier.equals("endsWith") ? targetString.endsWith(dnValue) : (dnModifier.equals("contains") ? targetString.indexOf(dnValue) >= 0 : targetString.equals(dnValue)));
        return bRet;
    }

    public void executeAlteration(Element bElement, Element cElement) throws Exception {
        NodeList nlx = cElement.getChildNodes();
        block2: for (int kk = 0; kk < nlx.getLength(); ++kk) {
            if (!(nlx.item(kk) instanceof Element)) continue;
            Element cElementx = (Element)nlx.item(kk);
            if (bDebug) {
                System.out.println("\n\t* Performing Action - " + cElementx.getTagName());
            }
            if (cElementx.getTagName().equals("addAttribute") || cElementx.getTagName().equals("changeAttribute")) {
                bElement.setAttribute(cElementx.getAttribute("name"), cElementx.getAttribute("value"));
                continue;
            }
            if (cElementx.getTagName().equals("prefixAttribute") || cElementx.getTagName().equals("suffixAttribute")) {
                String attName = cElementx.getAttribute("name");
                String newValue = cElementx.getAttribute("value");
                if (bElement.hasAttribute(attName)) {
                    newValue = cElementx.getTagName().equals("prefixAttrbute") ? newValue + bElement.getAttribute(attName) : bElement.getAttribute(attName) + newValue;
                }
                if (bDebug) {
                    System.out.println("\n\t" + cElementx.getTagName() + " attribute:" + attName + " final value is " + newValue);
                }
                bElement.setAttribute(attName, newValue);
                continue;
            }
            if (cElementx.getTagName().equals("deleteAttrbute")) {
                bElement.removeAttribute(cElementx.getAttribute("name"));
                continue;
            }
            if (cElementx.getTagName().equals("removeElement")) {
                bElement.getParentNode().removeChild(bElement);
                break;
            }
            if (cElementx.getTagName().equals("addElement")) {
                Node importedNode = null;
                String docFragFile = cElementx.getAttribute("file");
                if (!docFragFile.equals("")) {
                    try {
                        Document docFrag = this.readDOM(docFragFile);
                        importedNode = bElement.getOwnerDocument().importNode(docFrag.getDocumentElement(), true);
                    }
                    catch (Exception ee) {
                        if (bDebug) {
                            System.out.println("Exception encounted when reading/inserting fragment '" + docFragFile + "'***");
                        }
                        throw ee;
                    }
                } else {
                    NodeList nlxx = cElementx.getChildNodes();
                    for (int ll = 0; ll < nlxx.getLength(); ++ll) {
                        if (!(nlxx.item(ll) instanceof Element)) continue;
                        importedNode = bElement.getOwnerDocument().importNode(nlxx.item(ll), true);
                    }
                }
                String location = cElementx.getAttribute("location");
                String dnType = cElementx.getAttribute("dnType");
                String dnName = cElementx.getAttribute("dnName");
                String eName = "null";
                Node lNode = null;
                Element lElement = null;
                Object nElement = null;
                if (bDebug) {
                    System.out.println("\n\t\tAddElement Match with location='" + location + "' with dnType='" + dnType + "' and dnName='" + dnName + "'");
                }
                if (location.equals("first")) {
                    bElement.insertBefore(importedNode, bElement.getFirstChild());
                    continue;
                }
                if (location.equals("before")) {
                    if (dnType.equals("element")) {
                        for (lNode = bElement.getFirstChild(); !(lNode == null || lNode instanceof Element && (lElement = (Element)lNode).getNodeName().equals(dnName)); lNode = lNode.getNextSibling()) {
                        }
                        bElement.insertBefore(importedNode, lNode);
                        continue;
                    }
                    throw new UnsupportedOperationException("Only addElement that has a location set to 'before' only supports a dnType of 'element'");
                }
                if (location.equals("after")) {
                    if (dnType.equals("element")) {
                        boolean loop = true;
                        for (lNode = bElement.getFirstChild(); lNode != null; lNode = lNode.getNextSibling()) {
                            if (!(lNode instanceof Element) || !(lElement = (Element)lNode).getNodeName().equals(dnName)) continue;
                            if (bDebug) {
                                System.out.println("\n\t\t\tMatch found on element for dnName='" + dnName + "', look for next element that is different");
                            }
                            for (lNode = lNode.getNextSibling(); lNode != null && (!(lNode instanceof Element) || ((Element)lNode).getNodeName().equals(dnName)); lNode = lNode.getNextSibling()) {
                            }
                            if (lNode != null && lNode instanceof Element) {
                                eName = lNode.getNodeName();
                            }
                            if (!bDebug) break;
                            System.out.println("\n\t\t\tFound last item of type '" + lElement.getNodeName() + "' with nextSibling being '" + eName + "'");
                            break;
                        }
                        bElement.insertBefore(importedNode, lNode);
                        continue;
                    }
                    throw new UnsupportedOperationException("Only addElement that has a location set to 'after' only supports a dnType of 'element'");
                }
                bElement.appendChild(importedNode);
                continue;
            }
            if (!cElementx.getTagName().equals("addTextToElement")) continue;
            System.out.println("******** in addTextTOElement **********");
            String location = cElementx.getAttribute("location");
            String dataValue = cElementx.getAttribute("value");
            NodeList nlChild = bElement.getChildNodes();
            for (int mm = 0; mm < nlChild.getLength(); ++mm) {
                if (!(nlChild.item(mm) instanceof Text)) continue;
                if (bDebug) {
                    System.out.println("addTextToElement - Text - " + dataValue + " - " + location + " - " + nlChild.item(mm).getNodeValue() + "'");
                }
                if (location.equals("before")) {
                    nlChild.item(mm).setNodeValue(dataValue + nlChild.item(mm).getNodeValue());
                    continue block2;
                }
                nlChild.item(mm).setNodeValue(nlChild.item(mm).getNodeValue() + dataValue);
                continue block2;
            }
        }
    }

    public void writeDOM(Document doc, String file, String doctype_system, String doctype_public) throws Exception {
        DOMSource domSource = new DOMSource(doc);
        StreamResult sr = new StreamResult(new File(file));
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer t = tf.newTransformer();
        t.setOutputProperty("method", "xml");
        t.setOutputProperty("indent", "no");
        if (doctype_public != null) {
            t.setOutputProperty("doctype-public", doctype_public);
        }
        if (doctype_system != null) {
            t.setOutputProperty("doctype-system", doctype_system);
        }
        t.transform(domSource, sr);
    }

    public Document readDOM(String file) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        return db.parse(file);
    }

    public Document readDOM(String file, String dtd) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        db.setEntityResolver(new NOOPHandler(dtd));
        return db.parse(file);
    }
}

