/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.appclient.jws;

import com.sun.enterprise.appclient.jws.Content;
import com.sun.enterprise.appclient.jws.ContentOrigin;
import com.sun.enterprise.appclient.jws.Util;
import java.util.Date;
import java.util.LinkedList;
import java.util.Properties;

public class DynamicContent
extends Content {
    private static final int MAX_INSTANCES = 4;
    protected static final String ALL_PERMISSIONS_JNLP_SETTING = "<security><all-permissions/></security>";
    protected static final String NO_PERMISSIONS_JNLP_SETTING = "";
    private String template;
    protected String mimeType;
    private LinkedList<Instance> instances = new LinkedList();
    private boolean requiresElevatedPermissions;

    public DynamicContent(ContentOrigin origin, String contentKey, String path, String template, String mimeType) {
        this(origin, contentKey, path, template, mimeType, false);
    }

    public DynamicContent(ContentOrigin origin, String contentKey, String path, String template, String mimeType, boolean requiresElevatedPermissions) {
        super(origin, contentKey, path);
        this.template = template;
        this.mimeType = mimeType;
        this.requiresElevatedPermissions = requiresElevatedPermissions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Instance findInstance(Properties tokenValues, boolean createIfAbsent) {
        Instance result = null;
        String textWithPlaceholdersReplaced = Util.replaceTokens(this.template, tokenValues);
        LinkedList<Instance> linkedList = this.instances;
        synchronized (linkedList) {
            for (Instance i : this.instances) {
                if (!i.textEquals(textWithPlaceholdersReplaced)) continue;
                result = i;
                break;
            }
            if (result == null && createIfAbsent) {
                result = new Instance(textWithPlaceholdersReplaced);
                this.addInstance(result);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addInstance(Instance newInstance) {
        LinkedList<Instance> linkedList = this.instances;
        synchronized (linkedList) {
            this.instances.addFirst(newInstance);
            if (this.instances.size() > 4) {
                this.instances.removeLast();
            }
        }
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getJNLPSecuritySetting() {
        return this.requiresElevatedPermissions ? ALL_PERMISSIONS_JNLP_SETTING : NO_PERMISSIONS_JNLP_SETTING;
    }

    public boolean requiresElevatedPermissions() {
        return this.requiresElevatedPermissions;
    }

    protected void clearInstances() {
        this.instances.clear();
    }

    public String toString() {
        return super.toString() + ", template=" + this.template + ", MIME type=" + this.mimeType;
    }

    public class Instance {
        private Date timestamp;
        private String text;

        private Instance(String text) {
            this.text = text;
            this.timestamp = new Date();
        }

        private boolean textEquals(String other) {
            return this.text.equals(other);
        }

        public Date getTimestamp() {
            return this.timestamp;
        }

        public String getText() {
            return this.text;
        }
    }
}

