/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.appclient.jws;

import com.sun.enterprise.appclient.jws.AppclientJWSSupportInfo;
import com.sun.enterprise.appclient.jws.Content;
import com.sun.enterprise.appclient.jws.ContentOrigin;
import com.sun.enterprise.appclient.jws.DynamicContent;
import com.sun.enterprise.appclient.jws.JWSSystemServletRequestWrapper;
import com.sun.enterprise.appclient.jws.StaticContent;
import com.sun.logging.LogDomains;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.servlets.DefaultServlet;

public class JWSSystemServlet
extends DefaultServlet {
    private static final String ARG_QUERY_PARAM_NAME = "arg";
    private static final String PROP_QUERY_PARAM_NAME = "prop";
    private static final String VMARG_QUERY_PARAM_NAME = "vmarg";
    private static final String LAST_MODIFIED_HEADER_NAME = "Last-Modified";
    private static final String DATE_HEADER_NAME = "Date";
    private static final String GET_METHOD_NAME = "GET";
    private final String lineSep = System.getProperty("line.separator");
    private AppclientJWSSupportInfo jwsInfo = null;
    private Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.deployment");

    public void init() throws ServletException {
        super.init();
        try {
            this.jwsInfo = AppclientJWSSupportInfo.getInstance();
        }
        catch (Throwable thr) {
            throw new ServletException(thr);
        }
    }

    public void service(ServletRequest request, ServletResponse response) throws ServletException {
        if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
            throw new ServletException("Expected HttpServletRequest and HttpServletResponse but received " + request.getClass().getName() + " and " + response.getClass().getName());
        }
        boolean isFine = this._logger.isLoggable(Level.FINE);
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        Content content = this.jwsInfo.getContent(req);
        if (content == null) {
            try {
                if (isFine) {
                    this._logger.fine("JWSSystemServlet: content not found for request: method=" + req.getMethod() + ", pathInfo=" + req.getPathInfo());
                }
                resp.sendError(404, req.getPathInfo());
            }
            catch (Throwable thr) {
                throw new ServletException("Error attempting to return not-found response", thr);
            }
        } else if (content instanceof StaticContent) {
            this.processStaticContent(req, resp, content);
        } else {
            this.processDynamicContent(req, resp, content);
        }
    }

    private void processStaticContent(HttpServletRequest req, HttpServletResponse resp, Content content) throws ServletException {
        try {
            StaticContent sc = (StaticContent)content;
            JWSSystemServletRequestWrapper wrappedRequest = new JWSSystemServletRequestWrapper(req, sc.getRelativeURI());
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.fine("JWSSystemServlet: serving static content: method=" + wrappedRequest.getMethod() + ", mapped path=" + wrappedRequest.getPathInfo());
            }
            super.service((HttpServletRequest)wrappedRequest, resp);
        }
        catch (Throwable thr) {
            throw new ServletException("Error processing static content for path " + content.getPath(), thr);
        }
    }

    private void processDynamicContent(HttpServletRequest req, HttpServletResponse resp, Content content) throws ServletException {
        try {
            DynamicContent dc = (DynamicContent)content;
            Properties requestPlaceholders = this.prepareRequestPlaceholders(req, dc);
            boolean isGetMethod = req.getMethod().equals(GET_METHOD_NAME);
            DynamicContent.Instance instance = dc.findInstance(requestPlaceholders, isGetMethod);
            if (instance != null) {
                String responseText = instance.getText();
                Date instanceTimestamp = instance.getTimestamp();
                resp.setDateHeader(LAST_MODIFIED_HEADER_NAME, instanceTimestamp.getTime());
                resp.setDateHeader(DATE_HEADER_NAME, System.currentTimeMillis());
                resp.setContentType(dc.getMimeType());
                resp.setStatus(200);
                if (isGetMethod) {
                    PrintWriter pw = resp.getWriter();
                    pw.println(responseText);
                    pw.flush();
                }
                if (this._logger.isLoggable(Level.FINE)) {
                    this._logger.fine("JWSSystemServlet: serving dynamic content: method=" + req.getMethod() + ", pathInfo=" + req.getPathInfo() + ", queryString=" + req.getQueryString() + ", isGetMethod=" + isGetMethod + ", content timestamp=" + instanceTimestamp + ", content=" + responseText);
                }
            } else {
                resp.setDateHeader(LAST_MODIFIED_HEADER_NAME, System.currentTimeMillis());
                resp.setDateHeader(DATE_HEADER_NAME, System.currentTimeMillis());
                resp.setContentType(dc.getMimeType());
                resp.setStatus(200);
            }
        }
        catch (Throwable thr) {
            throw new ServletException("Error processing dynamic content for path " + content.getPath(), thr);
        }
    }

    private Properties prepareRequestPlaceholders(HttpServletRequest request, DynamicContent content) throws ServletException {
        Properties answer = new Properties();
        answer.setProperty("request.scheme", request.getScheme());
        answer.setProperty("request.host", request.getLocalName());
        answer.setProperty("request.port", Integer.toString(request.getLocalPort()));
        String queryString = request.getQueryString();
        StringBuilder queryStringPropValue = new StringBuilder();
        if (queryString != null && queryString.length() > 0) {
            queryStringPropValue.append("?").append(queryString);
        }
        answer.setProperty("request.web.app.context.root", "/__JWSappclients");
        answer.setProperty("request.path", request.getPathInfo());
        answer.setProperty("request.query.string", queryStringPropValue.toString());
        answer.setProperty("security.setting", content.getJNLPSecuritySetting());
        ContentOrigin origin = content.getOrigin();
        answer.setProperty("appclient.user.code.is.signed", Boolean.toString(content.requiresElevatedPermissions()));
        this.processQueryParameters(queryString, answer);
        return answer;
    }

    private void processQueryParameters(String queryString, Properties answer) throws ServletException {
        if (queryString == null) {
            queryString = "";
        }
        String[] queryParams = null;
        try {
            queryParams = URLDecoder.decode(queryString, "UTF-8").split("&");
        }
        catch (UnsupportedEncodingException uee) {
            throw new ServletException("Error decoding query string", (Throwable)uee);
        }
        ArgQueryParams arguments = new ArgQueryParams();
        PropQueryParams properties = new PropQueryParams();
        VMArgQueryParams vmArguments = new VMArgQueryParams();
        QueryParams[] paramTypes = new QueryParams[]{arguments, properties, vmArguments};
        for (String param : queryParams) {
            for (QueryParams qpType : paramTypes) {
                if (qpType.processParameter(param)) break;
            }
        }
        answer.setProperty("request.arguments", ((QueryParams)arguments).toString());
        answer.setProperty("request.properties", ((QueryParams)properties).toString());
        answer.setProperty("request.vmargs", ((QueryParams)vmArguments).toString());
    }

    private class VMArgQueryParams
    extends QueryParams {
        private StringBuilder vmArgs;

        public VMArgQueryParams() {
            super(JWSSystemServlet.VMARG_QUERY_PARAM_NAME);
            this.vmArgs = new StringBuilder();
        }

        public void processValue(String value) {
            this.vmArgs.append(value).append(" ");
        }

        public String toString() {
            return this.vmArgs.length() > 0 ? " java-vm=args=\"" + this.vmArgs.toString() + "\"" : "";
        }
    }

    private class PropQueryParams
    extends QueryParams {
        private StringBuilder properties;

        public PropQueryParams() {
            super(JWSSystemServlet.PROP_QUERY_PARAM_NAME);
            this.properties = new StringBuilder();
        }

        public void processValue(String value) {
            if (value.length() > 0) {
                int equalsSign = value.indexOf(61);
                String propValue = "";
                if (equalsSign > 0) {
                    String propName = value.substring(0, equalsSign);
                    if (equalsSign + 1 < value.length()) {
                        propValue = value.substring(equalsSign + 1);
                    }
                    this.properties.append("<property name=\"" + propName + "\" value=\"" + propValue + "\"/>").append(JWSSystemServlet.this.lineSep);
                }
            }
        }

        public String toString() {
            return this.properties.toString();
        }
    }

    private class ArgQueryParams
    extends QueryParams {
        private StringBuilder arguments;

        public ArgQueryParams() {
            super(JWSSystemServlet.ARG_QUERY_PARAM_NAME);
            this.arguments = new StringBuilder();
        }

        public void processValue(String value) {
            if (value.length() == 0) {
                value = "#missing#";
            }
            this.arguments.append("<argument>").append(value).append("</argument>").append(JWSSystemServlet.this.lineSep);
        }

        public String toString() {
            return this.arguments.toString();
        }
    }

    private abstract class QueryParams {
        private String prefix;

        protected QueryParams(String prefix) {
            this.prefix = prefix;
        }

        private boolean handles(String prefix) {
            return prefix.equals(this.prefix);
        }

        protected abstract void processValue(String var1);

        public abstract String toString();

        public boolean processParameter(String param) {
            boolean result = false;
            int equalsSign = param.indexOf("=");
            String value = "";
            String prefix = equalsSign != -1 ? param.substring(0, equalsSign) : param;
            if (this.handles(prefix)) {
                result = true;
                if (equalsSign + 1 < param.length()) {
                    value = param.substring(equalsSign + 1);
                }
                this.processValue(value);
            }
            return result;
        }
    }
}

