/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors;

import com.sun.enterprise.config.serverbeans.ResourceAdapterConfig;
import com.sun.enterprise.connectors.ActiveResourceAdapter;
import com.sun.enterprise.connectors.PoolMetaData;
import com.sun.enterprise.connectors.authentication.RuntimeSecurityMap;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.logging.LogDomains;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.spi.ManagedConnectionFactory;

public class ConnectorRegistry {
    protected static ConnectorRegistry connectorRegistryInstance;
    protected HashMap resourceAdapters = new HashMap();
    protected HashMap factories = new HashMap();
    protected HashMap resourceAdapterConfig = new HashMap();
    static Logger _logger;

    public static ConnectorRegistry getInstance() {
        if (connectorRegistryInstance == null) {
            connectorRegistryInstance = new ConnectorRegistry();
            _logger.log(Level.FINE, "creating new connector registry");
        }
        ConnectorRegistry.logFine("returning the connector registry");
        return connectorRegistryInstance;
    }

    protected ConnectorRegistry() {
        _logger.log(Level.FINE, "initialized the connector registry");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActiveResourceAdapter(String rarModuleName, ActiveResourceAdapter rar) {
        HashMap hashMap = this.resourceAdapters;
        synchronized (hashMap) {
            this.resourceAdapters.put(rarModuleName, rar);
        }
        _logger.log(Level.FINE, "Added the active resource adapter to connector registry", rarModuleName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeActiveResourceAdapter(String rarModuleName) {
        Object o = null;
        HashMap hashMap = this.resourceAdapters;
        synchronized (hashMap) {
            o = this.resourceAdapters.remove(rarModuleName);
        }
        if (o == null) {
            ConnectorRegistry.logFine("Failed to remove the resource adapter from connector registry" + rarModuleName);
            return false;
        }
        _logger.log(Level.FINE, "removed the active resource adapter from connector registry", rarModuleName);
        return true;
    }

    public ActiveResourceAdapter getActiveResourceAdapter(String rarModuleName) {
        if (rarModuleName != null) {
            _logger.log(Level.FINE, "returning/found the resource adapter from connector registry", rarModuleName);
            return (ActiveResourceAdapter)this.resourceAdapters.get(rarModuleName);
        }
        _logger.log(Level.FINE, "Resourceadapter not found in connector registry.Returning null", rarModuleName);
        return null;
    }

    public boolean isMCFCreated(String poolName) {
        boolean created = this.factories.containsKey(poolName);
        ConnectorRegistry.logFine("isMCFCreated " + poolName + " - " + created);
        return created;
    }

    public boolean removeManagedConnectionFactory(String poolName) {
        if (this.factories.remove(poolName) == null) {
            _logger.log(Level.FINE, "Failed to remove the MCF from connector registry.", poolName);
            return false;
        }
        ConnectorRegistry.logFine("removeMCF " + poolName + " - " + !this.factories.containsKey(poolName));
        return true;
    }

    public void addManagedConnectionFactory(String poolName, PoolMetaData pmd) {
        this.factories.put(poolName, pmd);
        ConnectorRegistry.logFine("Added MCF to connector registry for: " + poolName);
    }

    public ManagedConnectionFactory getManagedConnectionFactory(String poolName) {
        if (poolName != null) {
            _logger.log(Level.FINE, "Returning the MCF from connector registry.", poolName);
            PoolMetaData pmd = (PoolMetaData)this.factories.get(poolName);
            if (pmd != null) {
                return pmd.getMCF();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRegistered(String rarModuleName) {
        _logger.log(Level.FINE, "Checking for MCF presence in connector registry.", rarModuleName);
        HashMap hashMap = this.resourceAdapters;
        synchronized (hashMap) {
            return this.resourceAdapters.containsKey(rarModuleName);
        }
    }

    public ConnectorDescriptor getDescriptor(String rarModuleName) {
        ActiveResourceAdapter ar = null;
        if (rarModuleName != null) {
            ar = (ActiveResourceAdapter)this.resourceAdapters.get(rarModuleName);
        }
        if (ar != null) {
            _logger.log(Level.FINE, "Found/returing Connector descriptor in connector registry.", rarModuleName);
            return ar.getDescriptor();
        }
        _logger.log(Level.FINE, "Couldnot find Connector descriptor in connector registry.", rarModuleName);
        return null;
    }

    public RuntimeSecurityMap getRuntimeSecurityMap(String poolName) {
        if (poolName != null) {
            _logger.log(Level.FINE, "Returing the security map from connector registry.", poolName);
            PoolMetaData pmd = (PoolMetaData)this.factories.get(poolName);
            return pmd.getRuntimeSecurityMap();
        }
        return null;
    }

    public ResourceAdapterConfig getResourceAdapterConfig(String rarName) {
        if (rarName != null) {
            _logger.log(Level.FINE, "Returing the resourceadapter Config from registry.", rarName);
            return (ResourceAdapterConfig)this.resourceAdapterConfig.get(rarName);
        }
        return null;
    }

    public void addResourceAdapterConfig(String rarName, ResourceAdapterConfig raConfig) {
        if (rarName != null) {
            _logger.log(Level.FINE, "Adding the resourceAdapter Config to connector registry.", rarName);
            this.resourceAdapterConfig.put(rarName, raConfig);
        }
    }

    public boolean removeResourceAdapterConfig(String rarName) {
        if (this.resourceAdapterConfig.remove(rarName) == null) {
            _logger.log(Level.FINE, "failed to remove the resourceAdapter config from registry.", rarName);
            return false;
        }
        _logger.log(Level.FINE, "Removed the resourceAdapter config map from registry.", rarName);
        return true;
    }

    public ActiveResourceAdapter[] getAllActiveResourceAdapters() {
        return this.resourceAdapters.values().toArray(new ActiveResourceAdapter[0]);
    }

    private static void logFine(String msg) {
        if (msg != null && _logger.isLoggable(Level.FINE)) {
            _logger.fine(msg);
        }
    }

    public PoolMetaData getPoolMetaData(String poolName) {
        return (PoolMetaData)this.factories.get(poolName);
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");
    }
}

