/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.system;

import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.AppserverClusterViewFromCacheRepository;
import com.sun.enterprise.config.serverbeans.JmsHost;
import com.sun.enterprise.config.serverbeans.JmsService;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.connectors.ConnectorRuntimeException;
import com.sun.enterprise.connectors.system.MQUrl;
import com.sun.enterprise.connectors.util.JmsRaUtil;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.ServerContext;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MQAddressList {
    static Logger logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");
    private static String myName = System.getProperty("com.sun.aas.instanceName");
    private List<MQUrl> urlList = new ArrayList<MQUrl>();
    private JmsService jmsService = null;
    private AppserverClusterViewFromCacheRepository rep = null;
    private static String nodeAgentHost = null;
    private String targetName = null;

    public MQAddressList() throws ConfigException {
        this(null);
    }

    public MQAddressList(JmsService service) throws ConfigException {
        this(service, MQAddressList.getServerName());
    }

    public MQAddressList(JmsService service, String targetName) throws ConfigException {
        this.logFine(" init" + service + "target " + targetName);
        this.jmsService = service;
        this.targetName = targetName;
        ServerContext context = ApplicationServer.getServerContext();
        Server server = context.getConfigBean();
        String domainurl = context.getServerConfigURL();
        this.rep = new AppserverClusterViewFromCacheRepository(domainurl);
        try {
            nodeAgentHost = this.rep.getNodeAgentHostName(server);
            this.logFine("na host" + nodeAgentHost);
        }
        catch (Exception e) {
            logger.log(Level.FINE, "Exception while attempting to get nodeagentHost", e.getMessage());
            logger.log(Level.FINER, e.getMessage(), e);
        }
    }

    public void setup() throws ConfigException {
        try {
            if (this.isClustered() && !this.jmsService.getType().equals("REMOTE")) {
                this.logFine("setting up for cluster " + this.targetName);
                this.setupForCluster();
            } else {
                this.logFine("setting up for SI/DAS " + this.targetName);
                if (this.isAConfig(this.targetName) || this.isDAS(this.targetName)) {
                    this.logFine("performing default setup for DAS/remote clusters");
                    this.defaultSetup();
                } else {
                    this.logFine("configuring for  Standalone server instance");
                    this.setupForStandaloneServerInstance();
                }
            }
        }
        catch (ConnectorRuntimeException ce) {
            throw new ConfigException(ce);
        }
    }

    private boolean isDAS(String targetName) throws ConfigException {
        if (this.isAConfig(targetName)) {
            return false;
        }
        return ServerHelper.isDAS(this.getAdminConfigContext(), targetName);
    }

    private boolean isAConfig(String targetName) throws ConfigException {
        return ServerHelper.isAConfig(this.getAdminConfigContext(), targetName);
    }

    private ConfigContext getAdminConfigContext() {
        return AdminService.getAdminService().getAdminContext().getAdminConfigContext();
    }

    private void setupForStandaloneServerInstance() throws ConfigException {
        if (this.jmsService.getType().equals("REMOTE")) {
            this.logFine("REMOTE Standalone server instance and hence use default setup");
            this.defaultSetup();
        } else {
            this.logFine("LOCAL/EMBEDDED Standalone server instance");
            JmsHost host = this.getResolvedJmsHostForStandaloneServerInstance(this.targetName);
            MQUrl url = this.createUrl(host);
            this.urlList.add(url);
        }
    }

    private void defaultSetup() throws ConfigException {
        this.logFine("performing defaultsetup");
        JmsHost[] hosts = this.jmsService.getJmsHost();
        for (int i = 0; i < hosts.length; ++i) {
            MQUrl url = this.createUrl(hosts[i]);
            this.urlList.add(url);
        }
    }

    private void setupForCluster() throws ConfigException {
        Map<String, JmsHost> hostMap = this.rep.getResolvedLocalJmsHostsInMyCluster(true);
        JmsHost jmsHost = hostMap.get(myName);
        MQUrl myUrl = this.createUrl(jmsHost, nodeAgentHost);
        this.urlList.add(myUrl);
        hostMap.remove(myName);
        for (JmsHost host : hostMap.values()) {
            MQUrl url = this.createUrl(host, nodeAgentHost);
            this.urlList.add(url);
        }
    }

    public String toString() {
        String s = "";
        Iterator<MQUrl> it = this.urlList.iterator();
        if (it.hasNext()) {
            s = ((Object)it.next()).toString();
        }
        while (it.hasNext()) {
            s = s + "," + ((Object)it.next()).toString();
        }
        this.logFine("toString returns :: " + s);
        return s;
    }

    public void addMQUrl(JmsHost host) {
        MQUrl url = this.createUrl(host);
        this.urlList.add(url);
    }

    public void removeMQUrl(JmsHost host) {
        MQUrl url = this.createUrl(host);
        this.urlList.remove(url);
    }

    public void updateMQUrl(JmsHost host) {
        MQUrl url = this.createUrl(host);
        this.urlList.remove(url);
        this.urlList.add(url);
    }

    private MQUrl createUrl(JmsHost host) {
        return MQAddressList.createUrl(host, this.jmsService);
    }

    private MQUrl createUrl(JmsHost host, String overridedHostName) {
        return MQAddressList.createUrl(host, this.jmsService, overridedHostName);
    }

    public static MQUrl createUrl(JmsHost host, JmsService js) {
        return MQAddressList.createUrl(host, js, null);
    }

    public static MQUrl createUrl(JmsHost host, JmsService js, String overridedHostName) {
        try {
            String name = host.getName();
            String hostName = host.getHost();
            ServerContext serverContext = ApplicationServer.getServerContext();
            Server server = serverContext.getConfigBean();
            if (overridedHostName != null && !overridedHostName.trim().equals("")) {
                hostName = overridedHostName;
            }
            String port = host.getPort();
            MQUrl url = new MQUrl(name);
            url.setHost(hostName);
            url.setPort(port);
            if (js != null) {
                String service;
                String scheme = js.getMqScheme();
                if (scheme != null && !scheme.trim().equals("")) {
                    url.setScheme(scheme);
                }
                if ((service = js.getMqService()) != null && !service.trim().equals("")) {
                    url.setService(service);
                }
            }
            return url;
        }
        catch (ConfigException ce) {
            ce.printStackTrace();
            return null;
        }
    }

    private JmsHost getResolvedJmsHostForStandaloneServerInstance(String serverName) throws ConfigException {
        this.logFine(" getresolved " + serverName);
        ConfigContext con = this.getAdminConfigContext();
        Server serverInstance = ServerHelper.getServerByName(con, serverName);
        this.logFine("serverinstace " + serverInstance);
        JmsHost jmsHost = this.getResolvedJmsHost(serverInstance);
        return jmsHost;
    }

    private JmsHost getResolvedJmsHost(Server as) throws ConfigException {
        this.logFine("getResolvedJmsHost " + as);
        return this.rep.getResolvedJmsHost(as);
    }

    private boolean isClustered() throws ConnectorRuntimeException {
        return JmsRaUtil.isClustered();
    }

    private static String getServerName() {
        String serverName = System.getProperty("com.sun.aas.instanceName");
        return serverName;
    }

    private void logFine(String s) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "MQAddressList :: " + s);
        }
    }

    public int getSize() {
        if (this.urlList != null) {
            return this.urlList.size();
        }
        return 0;
    }
}

