/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.system;

import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.admin.target.Target;
import com.sun.enterprise.admin.target.TargetBuilder;
import com.sun.enterprise.admin.target.TargetType;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.AppserverClusterViewFromCacheRepository;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.JmsHost;
import com.sun.enterprise.config.serverbeans.JmsService;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.connectors.ConnectorRegistry;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.ConnectorRuntimeException;
import com.sun.enterprise.connectors.system.ActiveJmsResourceAdapter;
import com.sun.enterprise.connectors.system.MQAddressList;
import com.sun.enterprise.connectors.system.MQJMXConnectorInfo;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.ManagerFactory;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.spi.ResourceAdapter;

public class MQJMXConnectorHelper {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");
    private static final String JMXSERVICEURLLIST = "JMXServiceURLList";
    private static final String JMXCONNECTORENV = "JMXConnectorEnv";
    private static StringManager sm = StringManager.getManager(MQJMXConnectorHelper.class);

    public static MQJMXConnectorInfo[] getMQJMXConnectorInfo(final String target) throws ConnectorRuntimeException {
        try {
            final Target tgt = MQJMXConnectorHelper.getTarget(target);
            Config config = tgt.getConfigs()[0];
            final JmsService jmsService = config.getJmsService();
            ActiveJmsResourceAdapter air = MQJMXConnectorHelper.getMQAdapter();
            final Class<?> mqRAClassName = air.getResourceAdapter().getClass();
            MQJMXConnectorInfo mqjmxForServer = (MQJMXConnectorInfo)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    if (!MQJMXConnectorHelper.isClustered(tgt)) {
                        _logger.log(Level.FINE, "Getting JMX connector for standalone target " + target);
                        return MQJMXConnectorHelper._getMQJMXConnectorInfo(tgt.getName(), jmsService, mqRAClassName);
                    }
                    _logger.log(Level.FINE, "Getting JMX connector for cluster target " + target);
                    return MQJMXConnectorHelper._getMQJMXConnectorInfoForCluster(tgt.getName(), jmsService, mqRAClassName);
                }
            });
            return new MQJMXConnectorInfo[]{mqjmxForServer};
        }
        catch (Exception e) {
            ConnectorRuntimeException cre = new ConnectorRuntimeException(e.getMessage());
            cre.initCause(e);
            throw cre;
        }
    }

    private static ActiveJmsResourceAdapter getMQAdapter() throws Exception {
        final String mqraModuleName = ConnectorRuntime.DEFAULT_JMS_ADAPTER;
        ActiveJmsResourceAdapter air = (ActiveJmsResourceAdapter)AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                ManagerFactory.getSAConnectorModulesManager().loadOneSystemApp(mqraModuleName, true);
                return (ActiveJmsResourceAdapter)ConnectorRegistry.getInstance().getActiveResourceAdapter(mqraModuleName);
            }
        });
        return air;
    }

    private static MQJMXConnectorInfo _getMQJMXConnectorInfoForCluster(String target, JmsService jmsService, Class mqRAClassName) throws ConnectorRuntimeException {
        ResourceAdapter raInstance = null;
        try {
            MQAddressList list = null;
            if (jmsService.getType().equalsIgnoreCase("REMOTE")) {
                list = MQJMXConnectorHelper.getDefaultAddressList(jmsService);
            } else {
                String domainurl = ApplicationServer.getServerContext().getServerConfigURL();
                AppserverClusterViewFromCacheRepository rep = new AppserverClusterViewFromCacheRepository(domainurl);
                Map<String, JmsHost> hostMap = rep.getResolvedLocalJmsHostsInCluster(target);
                if (hostMap.size() == 0) {
                    String msg = sm.getString("mqjmx.no_jms_hosts");
                    throw new ConnectorRuntimeException(msg);
                }
                list = new MQAddressList();
                for (JmsHost host : hostMap.values()) {
                    list.addMQUrl(host);
                }
            }
            String connectionUrl = list.toString();
            raInstance = MQJMXConnectorHelper.getConfiguredRA(mqRAClassName, connectionUrl);
        }
        catch (Exception e) {
            e.printStackTrace();
            ConnectorRuntimeException cre = new ConnectorRuntimeException(e.getMessage());
            cre.initCause(e);
            throw cre;
        }
        try {
            String jmxServiceURL = null;
            String jmxServiceURLList = null;
            Map jmxConnectorEnv = null;
            Method[] methds = raInstance.getClass().getMethods();
            for (int i = 0; i < methds.length; ++i) {
                Method m = methds[i];
                if (m.getName().equalsIgnoreCase("getJMXServiceURLList")) {
                    jmxServiceURLList = (String)m.invoke((Object)raInstance, new Object[0]);
                    if (jmxServiceURLList == null || jmxServiceURLList.trim().equals("")) continue;
                    jmxServiceURL = MQJMXConnectorHelper.getFirstJMXServiceURL(jmxServiceURLList);
                    continue;
                }
                if (!m.getName().equalsIgnoreCase("getJMXConnectorEnv")) continue;
                jmxConnectorEnv = (Map)m.invoke((Object)raInstance, new Object[0]);
            }
            MQJMXConnectorInfo mqInfo = new MQJMXConnectorInfo(target, ActiveJmsResourceAdapter.getBrokerInstanceName(jmsService), jmsService.getType(), jmxServiceURL, jmxConnectorEnv);
            return mqInfo;
        }
        catch (Exception e) {
            e.printStackTrace();
            ConnectorRuntimeException cre = new ConnectorRuntimeException(e.getMessage());
            cre.initCause(e);
            throw cre;
        }
    }

    private static MQJMXConnectorInfo _getMQJMXConnectorInfo(String targetName, JmsService jmsService, Class mqRAClassName) throws ConnectorRuntimeException {
        try {
            String connectionURL = null;
            boolean isDAS = MQJMXConnectorHelper.isDAS(targetName);
            if (isDAS) {
                MQJMXConnectorHelper.logFine(" _getMQJMXConnectorInfo - in DAS");
                _logger.log(Level.FINE, "In DAS");
                connectionURL = MQJMXConnectorHelper.getDefaultAddressList(jmsService).toString();
            } else {
                _logger.log(Level.FINE, "not in DAS");
                MQJMXConnectorHelper.logFine(" _getMQJMXConnectorInfo - NOT in DAS");
                String domainurl = ApplicationServer.getServerContext().getServerConfigURL();
                JmsService serverJmsService = MQJMXConnectorHelper.getJmsServiceOfStandaloneServerInstance(targetName);
                MQAddressList mqadList = new MQAddressList(serverJmsService, targetName);
                mqadList.setup();
                connectionURL = mqadList.toString();
            }
            MQJMXConnectorHelper.logFine(" _getMQJMXConnectorInfo - connection URL " + connectionURL);
            ResourceAdapter raInstance = MQJMXConnectorHelper.getConfiguredRA(mqRAClassName, connectionURL);
            String jmxServiceURL = null;
            String jmxServiceURLList = null;
            Map jmxConnectorEnv = null;
            Method[] methds = raInstance.getClass().getMethods();
            for (int i = 0; i < methds.length; ++i) {
                Method m = methds[i];
                if (m.getName().equalsIgnoreCase("getJMXServiceURLList")) {
                    jmxServiceURLList = (String)m.invoke((Object)raInstance, new Object[0]);
                    continue;
                }
                if (!m.getName().equalsIgnoreCase("getJMXConnectorEnv")) continue;
                jmxConnectorEnv = (Map)m.invoke((Object)raInstance, new Object[0]);
            }
            MQJMXConnectorHelper.logFine(" _getMQJMXConnectorInfo - jmxServiceURLList " + jmxServiceURLList);
            MQJMXConnectorHelper.logFine(" _getMQJMXConnectorInfo - jmxConnectorEnv " + jmxConnectorEnv);
            jmxServiceURL = MQJMXConnectorHelper.getFirstJMXServiceURL(jmxServiceURLList);
            MQJMXConnectorInfo mqInfo = new MQJMXConnectorInfo(targetName, ActiveJmsResourceAdapter.getBrokerInstanceName(jmsService), jmsService.getType(), jmxServiceURL, jmxConnectorEnv);
            return mqInfo;
        }
        catch (Exception e) {
            e.printStackTrace();
            ConnectorRuntimeException cre = new ConnectorRuntimeException(e.getMessage());
            cre.initCause(e);
            throw cre;
        }
    }

    private static boolean isDAS(String targetName) throws ConfigException {
        ConfigContext con = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
        if (MQJMXConnectorHelper.isAConfig(targetName)) {
            return false;
        }
        return ServerHelper.isDAS(con, targetName);
    }

    private static boolean isAConfig(String targetName) throws ConfigException {
        ConfigContext con = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
        return ServerHelper.isAConfig(con, targetName);
    }

    private static JmsService getJmsServiceOfStandaloneServerInstance(String targetName) throws ConfigException {
        MQJMXConnectorHelper.logFine("getJMSServiceOfSI LL " + targetName);
        ConfigContext con = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
        Config cfg = null;
        cfg = MQJMXConnectorHelper.isAConfig(targetName) ? ServerHelper.getConfigByName(con, targetName) : ServerHelper.getConfigForServer(con, targetName);
        MQJMXConnectorHelper.logFine("cfg " + cfg);
        JmsService jmsService = cfg.getJmsService();
        MQJMXConnectorHelper.logFine("jmsservice " + jmsService);
        return jmsService;
    }

    private static ResourceAdapter getConfiguredRA(Class mqRAclassname, String connectionURL) throws Exception {
        ResourceAdapter raInstance = (ResourceAdapter)mqRAclassname.newInstance();
        Method setConnectionURL = mqRAclassname.getMethod("setConnectionURL", String.class);
        setConnectionURL.invoke((Object)raInstance, connectionURL);
        MQJMXConnectorHelper.logFine(" getConfiguredRA - set connectionURL as " + connectionURL);
        return raInstance;
    }

    private static MQAddressList getDefaultAddressList(JmsService jmsService) throws ConfigException {
        MQAddressList list = new MQAddressList(jmsService);
        list.setup();
        return list;
    }

    private static String getFirstJMXServiceURL(String jmxServiceURLList) {
        if (jmxServiceURLList == null || "".equals(jmxServiceURLList)) {
            return jmxServiceURLList;
        }
        StringTokenizer tokenizer = new StringTokenizer(jmxServiceURLList, " ");
        return tokenizer.nextToken();
    }

    private static Target getTarget(String target) throws ConfigException {
        TargetType[] vaildTargetTypes = new TargetType[]{TargetType.CONFIG, TargetType.SERVER, TargetType.DOMAIN, TargetType.CLUSTER, TargetType.STANDALONE_SERVER, TargetType.UNCLUSTERED_SERVER, TargetType.STANDALONE_CLUSTER, TargetType.DAS};
        Target tgt = TargetBuilder.INSTANCE.createTarget(vaildTargetTypes, target, AdminService.getAdminService().getAdminContext().getAdminConfigContext());
        assert (tgt != null);
        return tgt;
    }

    private static boolean isClustered(Target tgt) throws ConfigException {
        return tgt.getType() == TargetType.CLUSTER;
    }

    private static void logFine(String s) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "MQJMXConnectorHelper :: " + s);
        }
    }
}

