/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.annotation.impl;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AnnotationUtils {
    private static Logger logger;
    private static String whatToLog;
    private static ResourceBundle resourceBundle;

    private AnnotationUtils() {
        resourceBundle = ResourceBundle.getBundle("LocalStrings");
    }

    public static Logger getLogger() {
        if (logger == null) {
            logger = Logger.global;
        }
        return logger;
    }

    public static void setLogger(Logger lg) {
        logger = lg;
    }

    public static void setLoggerTarget(String what) {
        whatToLog = what;
    }

    public static String getLoggerTarget() {
        return whatToLog;
    }

    public static boolean shouldLog(String what) {
        if (logger.isLoggable(Level.FINER)) {
            if (whatToLog.indexOf(what) != -1) {
                return true;
            }
            if ("*".equals(whatToLog)) {
                return true;
            }
        }
        return false;
    }

    public static String getLocalString(String key, String defaultString, Object ... arguments) {
        String value = defaultString;
        if (resourceBundle != null && resourceBundle.getString(key) != null) {
            value = resourceBundle.getString(key);
        }
        return MessageFormat.format(value, arguments);
    }

    static {
        whatToLog = "";
    }
}

