/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.annotation.impl;

import com.sun.enterprise.deployment.annotation.AnnotationInfo;
import com.sun.enterprise.deployment.annotation.AnnotationProcessorException;
import com.sun.enterprise.deployment.annotation.ErrorHandler;
import com.sun.enterprise.deployment.annotation.impl.AnnotationUtils;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultErrorHandler
implements ErrorHandler {
    Logger logger;

    public DefaultErrorHandler() {
        this.logger = AnnotationUtils.getLogger();
    }

    public DefaultErrorHandler(Logger logger) {
        this.logger = logger;
    }

    public void fine(AnnotationProcessorException ape) throws AnnotationProcessorException {
        if (this.logger.isLoggable(Level.FINE)) {
            AnnotationInfo info = ape.getLocator();
            if (info == null) {
                this.logger.fine(ape.getMessage());
            } else {
                this.logger.fine(AnnotationUtils.getLocalString("enterprise.deployment.annotation.error", "{2}\n symbol: {0}\n location: {1}\n\n", new Object[]{info.getElementType(), info.getAnnotatedElement(), ape.getMessage()}));
            }
        }
    }

    public void warning(AnnotationProcessorException ape) throws AnnotationProcessorException {
        if (this.logger.isLoggable(Level.WARNING)) {
            AnnotationInfo info = ape.getLocator();
            if (info == null) {
                this.logger.warning(ape.getMessage());
            } else {
                this.logger.warning(AnnotationUtils.getLocalString("enterprise.deployment.annotation.error", "{2}\n symbol: {0}\n location: {1}\n\n", new Object[]{info.getElementType(), info.getAnnotatedElement(), ape.getMessage()}));
            }
        }
    }

    public void error(AnnotationProcessorException ape) throws AnnotationProcessorException {
        AnnotationInfo info = ape.getLocator();
        if (info == null) {
            this.logger.severe(ape.getMessage());
        } else {
            this.logger.severe(AnnotationUtils.getLocalString("enterprise.deployment.annotation.error", "{2}\n symbol: {0} location: {1}\n\n", new Object[]{info.getElementType(), info.getAnnotatedElement(), ape.getMessage()}));
        }
    }
}

