/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.autodeploy;

import com.sun.enterprise.config.ConfigContextEvent;
import com.sun.enterprise.config.ConfigContextEventListener;
import com.sun.enterprise.deployment.autodeploy.AutoDeployController;
import com.sun.enterprise.deployment.autodeploy.AutoDeployDirectoryScanner;
import com.sun.enterprise.deployment.autodeploy.AutoDeployer;
import com.sun.enterprise.deployment.autodeploy.AutoDeploymentException;
import com.sun.enterprise.deployment.autodeploy.DirectoryScanner;
import com.sun.enterprise.deployment.backend.DeploymentLogger;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.File;
import java.util.Enumeration;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AutoDeployControllerImpl
implements AutoDeployController,
ConfigContextEventListener {
    private Vector autodeployDirs = new Vector();
    private long pollingInterval = 2L;
    private boolean verify = false;
    private boolean preJspCompilation = false;
    private Timer timer = null;
    private AutoDeployTask deployTask = null;
    public static final Logger sLogger = DeploymentLogger.get();
    private static StringManager localStrings = StringManager.getManager(AutoDeployControllerImpl.class);

    public AutoDeployControllerImpl(String autodeployDir, long pollingInterval) throws AutoDeploymentException {
        try {
            this.addAutoDeployDir(autodeployDir);
            this.setPollingInterval(pollingInterval);
        }
        catch (AutoDeploymentException ae) {
            sLogger.log(Level.SEVERE, "enterprise.deployment.backend.autoDeploymentStartFailure");
            throw ae;
        }
    }

    public AutoDeployControllerImpl(String[] autodeployDirs, long pollingInterval) throws AutoDeploymentException {
        try {
            for (int i = 0; i < autodeployDirs.length; ++i) {
                this.addAutoDeployDir(autodeployDirs[i]);
            }
            this.setPollingInterval(pollingInterval);
        }
        catch (AutoDeploymentException ae) {
            sLogger.log(Level.SEVERE, "enterprise.deployment.backend.autoDeploymentStartFailure");
            throw ae;
        }
    }

    public boolean enableAutoDeploy() {
        this.timer = new Timer();
        this.deployTask = new AutoDeployTask();
        this.timer.schedule((TimerTask)this.deployTask, 30000L, this.pollingInterval * 1000L);
        String msg = localStrings.getString("enterprise.deployment.autodeploy.autoDeployment_service_enabled");
        sLogger.log(Level.FINE, msg + System.currentTimeMillis());
        return true;
    }

    public boolean disableAutoDeploy() {
        if (this.deployTask != null) {
            this.deployTask.cancel();
        }
        if (this.timer != null) {
            this.timer.cancel();
        }
        String msg = localStrings.getString("enterprise.deployment.autodeploy.autoDeployment_service_disabled");
        sLogger.log(Level.INFO, msg);
        return true;
    }

    public String[] getAllAutoDeployDirs() {
        if (this.autodeployDirs != null && !this.autodeployDirs.isEmpty()) {
            String[] dirs = new String[this.autodeployDirs.size()];
            int i = 0;
            Enumeration list = this.autodeployDirs.elements();
            while (list.hasMoreElements()) {
                dirs[i] = ((File)list.nextElement()).getAbsolutePath();
                ++i;
            }
            return dirs;
        }
        return null;
    }

    public void addAutoDeployDir(String autodeployDir) throws AutoDeploymentException {
        String msg;
        if (!this.validateDir(autodeployDir)) {
            msg = localStrings.getString("enterprise.deployment.autodeploy.invalid_source_dir", autodeployDir);
            sLogger.log(Level.INFO, msg);
        }
        if (this.locateAlreadyExistingDir(autodeployDir) == -1) {
            this.autodeployDirs.add(new File(autodeployDir));
        } else {
            msg = localStrings.getString("enterprise.deployment.autodeploy.duplicate_source_dir", autodeployDir);
            sLogger.log(Level.WARNING, msg);
        }
    }

    public void removeAutoDeployDir(String autodeployDir) {
        int location = this.locateAlreadyExistingDir(autodeployDir);
        if (location >= 0) {
            this.autodeployDirs.remove(location);
        }
    }

    public long getPollingInterval() {
        return this.pollingInterval;
    }

    public void setPollingInterval(long pollInterval) throws AutoDeploymentException {
        if (!this.validatePollingInterval(pollInterval)) {
            String sInterval = new String("" + pollInterval);
            String sMinInterval = new String("2");
            String msg = localStrings.getString("enterprise.deployment.autodeploy.invalid_pooling_interval", sInterval, sMinInterval);
            sLogger.log(Level.INFO, msg + pollInterval);
            throw new AutoDeploymentException(msg + pollInterval);
        }
        this.pollingInterval = pollInterval;
    }

    public boolean isVerifyEnabled() {
        return this.verify;
    }

    public void setVerify(boolean verify) {
        this.verify = verify;
    }

    public boolean isPreJspCompilationEnabled() {
        return this.preJspCompilation;
    }

    public void setPreJspCompilation(boolean preJspCompilation) {
        this.preJspCompilation = preJspCompilation;
    }

    private boolean validateDir(String dir) {
        boolean valid = false;
        File autodeployDir = new File(dir);
        if (autodeployDir != null && autodeployDir.exists() && autodeployDir.isDirectory() && autodeployDir.canWrite() && autodeployDir.canRead()) {
            valid = true;
        }
        return valid;
    }

    private int locateAlreadyExistingDir(String dir) {
        int location = -1;
        String[] extingDirs = this.getAllAutoDeployDirs();
        if (extingDirs != null) {
            for (int i = 0; i < extingDirs.length; ++i) {
                if (!dir.equalsIgnoreCase(extingDirs[i])) continue;
                location = i;
                break;
            }
        }
        return location;
    }

    private boolean validatePollingInterval(long time) {
        boolean valid = false;
        if (time >= 2L) {
            valid = true;
        }
        return valid;
    }

    public void preChangeNotification(ConfigContextEvent ccce) {
    }

    public void postChangeNotification(ConfigContextEvent ccce) {
    }

    public void preAccessNotification(ConfigContextEvent ccce) {
    }

    public void postAccessNotification(ConfigContextEvent ccce) {
    }

    private class AutoDeployTask
    extends TimerTask {
        private AutoDeployer currentDeployer = null;
        private DirectoryScanner directoryScanner = null;

        private AutoDeployTask() {
        }

        public void run() {
            block7: {
                try {
                    if (sLogger.isLoggable(Level.FINEST)) {
                        String msg = localStrings.getString("enterprise.deployment.autodeploy.thread_started");
                        sLogger.log(Level.FINEST, msg + System.currentTimeMillis());
                    }
                    if (AutoDeployControllerImpl.this.autodeployDirs == null || AutoDeployControllerImpl.this.autodeployDirs.isEmpty()) break block7;
                    Enumeration list = AutoDeployControllerImpl.this.autodeployDirs.elements();
                    while (list.hasMoreElements() && (this.currentDeployer == null || !this.currentDeployer.isCancelled())) {
                        File[] sourceDirFiles;
                        File sourceDir = (File)list.nextElement();
                        if (sLogger.isLoggable(Level.FINEST)) {
                            sLogger.log(Level.FINEST, localStrings.getString("enterprise.deployment.autodeploy.processing_source_directory", sourceDir));
                        }
                        if ((sourceDirFiles = sourceDir.listFiles()).length == 1 && ".autodeploystatus".equals(sourceDirFiles[0].getName())) continue;
                        AutoDeployer deployer = this.getAutoDeployer();
                        try {
                            deployer.deployAll(sourceDir, true);
                            deployer.undeployAll(sourceDir);
                        }
                        catch (Exception ae) {
                            sLogger.log(Level.SEVERE, "enterprise.deployment.backend.autoDeploymentFailure", new Object[]{ae.getMessage()});
                        }
                        if (!deployer.isCancelled()) continue;
                        break;
                    }
                }
                catch (Exception e) {
                    this.currentDeployer = null;
                    sLogger.log(Level.SEVERE, "enterprise.deployment.backend.autoDeploymentFailure", new Object[]{e.getMessage()});
                }
            }
        }

        public boolean cancel() {
            boolean flag = false;
            if (this.currentDeployer != null) {
                this.currentDeployer.setCancel(true);
            }
            super.cancel();
            flag = true;
            return flag;
        }

        private DirectoryScanner getDirectoryScanner() {
            if (this.directoryScanner == null) {
                this.directoryScanner = new AutoDeployDirectoryScanner();
            }
            return this.directoryScanner;
        }

        private AutoDeployer getAutoDeployer() {
            if (this.currentDeployer == null) {
                this.currentDeployer = new AutoDeployer(AutoDeployControllerImpl.this.verify, AutoDeployControllerImpl.this.preJspCompilation);
            } else {
                this.currentDeployer.setVerify(AutoDeployControllerImpl.this.verify);
                this.currentDeployer.setJspPreCompilation(AutoDeployControllerImpl.this.preJspCompilation);
            }
            this.currentDeployer.setDirectoryScanner(this.getDirectoryScanner());
            return this.currentDeployer;
        }
    }
}

