/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.phasing;

import com.sun.enterprise.admin.target.Target;
import com.sun.enterprise.admin.target.TargetBuilder;
import com.sun.enterprise.admin.target.TargetType;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ApplicationHelper;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.ClusterHelper;
import com.sun.enterprise.config.serverbeans.J2eeApplication;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.config.serverbeans.WebModule;
import com.sun.enterprise.deployment.backend.IASDeploymentException;
import com.sun.enterprise.deployment.phasing.DeploymentServiceUtils;
import com.sun.enterprise.util.i18n.StringManager;

public class ApplicationConfigHelper {
    private static final String CONTEXT_ROOTS_PROPERTY_NAME = "context-roots";
    private static final StringManager _strMgr = StringManager.getManager(ApplicationConfigHelper.class);
    private ConfigContext _configContext = null;

    public ApplicationConfigHelper(ConfigContext configContext) {
        this._configContext = configContext;
    }

    private ConfigContext getConfigContext() {
        return this._configContext;
    }

    public static String[] getAppContextRoots(ConfigBean appBean) throws ConfigException, IASDeploymentException {
        if (appBean instanceof WebModule) {
            return new String[]{((WebModule)appBean).getContextRoot()};
        }
        if (appBean instanceof J2eeApplication) {
            String[] roots = appBean.getTransientProperty(CONTEXT_ROOTS_PROPERTY_NAME);
            if (roots == null) {
                String appName = ((J2eeApplication)appBean).getName();
                roots = DeploymentServiceUtils.getContextRootsForEmbeddedWebApp(appName);
                appBean.setTransientProperty(CONTEXT_ROOTS_PROPERTY_NAME, roots);
            } else if (!(roots instanceof String[])) {
                throw new ConfigException(_strMgr.getString("configRootsPropertyIsNotStringArray", ((J2eeApplication)appBean).getName()));
            }
            return roots;
        }
        return null;
    }

    public static String[] getAppContextRoots(ConfigContext ctx, String appName) throws ConfigException, IASDeploymentException {
        ConfigBean appBean = ApplicationHelper.findApplication(ctx, appName);
        if (appBean == null) {
            throw new ConfigException(_strMgr.getString("applicationElementIsNotFoundForName", appName));
        }
        return ApplicationConfigHelper.getAppContextRoots(appBean);
    }

    public static void resetAppContextRoots(ConfigBean appBean, boolean bForceToSetActualValue) throws ConfigException, IASDeploymentException {
        if (appBean instanceof J2eeApplication) {
            appBean.setTransientProperty(CONTEXT_ROOTS_PROPERTY_NAME, null);
            if (bForceToSetActualValue) {
                ApplicationConfigHelper.getAppContextRoots(appBean);
            }
        }
    }

    public static void resetAppContextRoots(ConfigContext ctx, String appName, boolean bForceToSetActualValue) throws ConfigException, IASDeploymentException {
        ConfigBean appBean = ApplicationHelper.findApplication(ctx, appName);
        if (appBean == null) {
            throw new ConfigException(_strMgr.getString("applicationElementIsNotFoundForName", appName));
        }
        ApplicationConfigHelper.resetAppContextRoots(appBean, bForceToSetActualValue);
    }

    public static String checkContextRootUniqueness(ConfigContext ctx, String appId, String targetName, String virtualServerList) throws ConfigException, IASDeploymentException {
        ConfigBean appBean = ApplicationHelper.findApplication(ctx, appId);
        if (appBean == null) {
            throw new ConfigException(_strMgr.getString("applicationElementIsNotFoundForName", appId));
        }
        Object[] ctxRoots = ApplicationConfigHelper.getAppContextRoots(appBean);
        if (ctxRoots == null || ctxRoots.length <= 0) {
            return null;
        }
        Target target = TargetBuilder.INSTANCE.createTarget(new TargetType[]{TargetType.CLUSTER, TargetType.SERVER, TargetType.DAS}, targetName, ctx);
        ApplicationRef[] refs = null;
        refs = target.getType() == TargetType.CLUSTER || target.getType() == TargetType.STANDALONE_CLUSTER ? ClusterHelper.getApplicationReferences(ctx, targetName) : ServerHelper.getApplicationReferences(ctx, targetName);
        if (refs == null) {
            return null;
        }
        for (int i = 0; i < refs.length; ++i) {
            String commonElement;
            if (!ApplicationConfigHelper.isVSListsIntersected(refs[i].getVirtualServers(), virtualServerList)) continue;
            ConfigBean appBeanToCompare = ApplicationHelper.findApplication(ctx, refs[i].getRef());
            if (appBeanToCompare == null) {
                throw new ConfigException(_strMgr.getString("applicationElementIsNotFoundForName", refs[i].getRef()));
            }
            if (appBeanToCompare == appBean || (commonElement = (String)ApplicationConfigHelper.getFirstCommonElement(ApplicationConfigHelper.getAppContextRoots(appBeanToCompare), ctxRoots)) == null) continue;
            return commonElement;
        }
        return null;
    }

    private static boolean isVSListsIntersected(String vsList1, String vsList2) {
        if (vsList1 == null || vsList2 == null || vsList1.length() == 0 || vsList2.length() == 0) {
            return true;
        }
        Object[] arr1 = vsList1.split(",");
        Object[] arr2 = vsList2.split(",");
        if (arr1.length == 0 || arr2.length == 0) {
            return true;
        }
        return ApplicationConfigHelper.getFirstCommonElement(arr1, arr2) != null;
    }

    private static Object getFirstCommonElement(Object[] arr1, Object[] arr2) {
        if (arr1 != null && arr2 != null && arr1.length != 0 && arr2.length != 0) {
            for (int i = 0; i < arr1.length; ++i) {
                for (int j = 0; j < arr2.length; ++j) {
                    if (((String)arr1[i]).startsWith("/")) {
                        arr1[i] = ((String)arr1[i]).substring(1);
                    }
                    if (((String)arr2[j]).startsWith("/")) {
                        arr2[j] = ((String)arr2[j]).substring(1);
                    }
                    if (!arr1[i].equals(arr2[j])) continue;
                    return arr1[i];
                }
            }
        }
        return null;
    }
}

